/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Bundle
implements Parcelable,
Cloneable {
    public static final Parcelable.Creator<Bundle> CREATOR;
    public static final Bundle EMPTY;
    private static final String LOG_TAG = "Bundle";
    private ClassLoader mClassLoader;
    private boolean mFdsKnown = true;
    private boolean mHasFds = false;
    Map<String, Object> mMap = null;
    Parcel mParcelledData = null;

    static {
        Bundle bundle = EMPTY = new Bundle();
        Map map = Collections.unmodifiableMap(new HashMap());
        bundle.mMap = map;
        CREATOR = new Parcelable.Creator<Bundle>(){

            @Override
            public Bundle createFromParcel(Parcel parcel) {
                return parcel.readBundle();
            }

            public Bundle[] newArray(int n) {
                return new Bundle[n];
            }
        };
    }

    public Bundle() {
        ClassLoader classLoader;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.mMap = hashMap;
        this.mClassLoader = classLoader = this.getClass().getClassLoader();
    }

    public Bundle(int n) {
        ClassLoader classLoader;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n);
        this.mMap = hashMap;
        this.mClassLoader = classLoader = this.getClass().getClassLoader();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Bundle(Bundle bundle) {
        ClassLoader classLoader;
        boolean bl;
        boolean bl2;
        if (bundle.mParcelledData != null) {
            Parcel parcel;
            Parcel parcel2 = this.mParcelledData = (parcel = Parcel.obtain());
            Parcel parcel3 = bundle.mParcelledData;
            int n = bundle.mParcelledData.dataSize();
            parcel2.appendFrom(parcel3, 0, n);
            this.mParcelledData.setDataPosition(0);
        } else {
            this.mParcelledData = null;
        }
        if (bundle.mMap != null) {
            Map<String, Object> map = bundle.mMap;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
            this.mMap = hashMap;
        } else {
            this.mMap = null;
        }
        this.mHasFds = bl2 = bundle.mHasFds;
        this.mFdsKnown = bl = bundle.mFdsKnown;
        this.mClassLoader = classLoader = bundle.mClassLoader;
    }

    Bundle(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    Bundle(Parcel parcel, int n) {
        this.readFromParcelInner(parcel, n);
    }

    public Bundle(ClassLoader classLoader) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.mMap = hashMap;
        this.mClassLoader = classLoader;
    }

    public static Bundle forPair(String string2, String string3) {
        Bundle bundle = new Bundle(1);
        bundle.putString(string2, string3);
        return bundle;
    }

    private void typeWarning(String string2, Object object, String string3, ClassCastException classCastException) {
        Bundle bundle = this;
        String string4 = string2;
        Object object2 = object;
        String string5 = string3;
        ClassCastException classCastException2 = classCastException;
        bundle.typeWarning(string4, object2, string5, "<null>", classCastException2);
    }

    private void typeWarning(String string2, Object object, String string3, Object object2, ClassCastException classCastException) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Key ");
        StringBuilder stringBuilder3 = stringBuilder.append(string2);
        StringBuilder stringBuilder4 = stringBuilder.append(" expected ");
        StringBuilder stringBuilder5 = stringBuilder.append(string3);
        StringBuilder stringBuilder6 = stringBuilder.append(" but value was a ");
        String string4 = object.getClass().getName();
        StringBuilder stringBuilder7 = stringBuilder.append(string4);
        StringBuilder stringBuilder8 = stringBuilder.append(".  The default value ");
        StringBuilder stringBuilder9 = stringBuilder.append(object2);
        StringBuilder stringBuilder10 = stringBuilder.append(" was returned.");
        String string5 = stringBuilder.toString();
        int n = Log.w(LOG_TAG, string5);
        int n2 = Log.w(LOG_TAG, "Attempt to cast generated internal exception:", classCastException);
    }

    public void clear() {
        this.unparcel();
        this.mMap.clear();
        this.mHasFds = false;
        this.mFdsKnown = true;
    }

    public Object clone() {
        return new Bundle(this);
    }

    public boolean containsKey(String string2) {
        this.unparcel();
        return this.mMap.containsKey(string2);
    }

    @Override
    public int describeContents() {
        int n = 0;
        if (this.hasFileDescriptors()) {
            n = 0 | 1;
        }
        return n;
    }

    public Object get(String string2) {
        this.unparcel();
        return this.mMap.get(string2);
    }

    public boolean getBoolean(String string2) {
        this.unparcel();
        return this.getBoolean(string2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(String string2, boolean bl) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return bl;
        }
        try {
            boolean bl2 = (Boolean)object;
            return bl2;
        }
        catch (ClassCastException classCastException) {
            Boolean bl3 = bl;
            Bundle bundle = this;
            String string3 = string2;
            bundle.typeWarning(string3, object, "Boolean", bl3, classCastException);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean[] getBooleanArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (boolean[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "byte[]", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bundle getBundle(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (Bundle)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, LOG_TAG, classCastException);
            return null;
        }
    }

    public byte getByte(String string2) {
        this.unparcel();
        return this.getByte(string2, (byte)0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Byte getByte(String string2, byte by) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return by;
        }
        try {
            return object = (Byte)object;
        }
        catch (ClassCastException classCastException) {
            Byte by2 = by;
            Bundle bundle = this;
            String string3 = string2;
            bundle.typeWarning(string3, object, "Byte", by2, classCastException);
            return by;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getByteArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (byte[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "byte[]", classCastException);
            return null;
        }
    }

    public char getChar(String string2) {
        this.unparcel();
        return this.getChar(string2, '\u0000');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char getChar(String string2, char c) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return c;
        }
        try {
            char c2 = ((Character)object).charValue();
            return c2;
        }
        catch (ClassCastException classCastException) {
            Character c3 = Character.valueOf(c);
            Bundle bundle = this;
            String string3 = string2;
            bundle.typeWarning(string3, object, "Character", c3, classCastException);
            return c;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char[] getCharArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (char[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "char[]", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getCharSequence(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (CharSequence)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "CharSequence", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence[] getCharSequenceArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (CharSequence[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "CharSequence[]", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<CharSequence> getCharSequenceArrayList(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "ArrayList<CharSequence>", classCastException);
            return null;
        }
    }

    public double getDouble(String string2) {
        this.unparcel();
        return this.getDouble(string2, 0.0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getDouble(String string2, double d) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return d;
        }
        try {
            double d2 = (Double)object;
            return d2;
        }
        catch (ClassCastException classCastException) {
            Double d3 = d;
            Bundle bundle = this;
            String string3 = string2;
            bundle.typeWarning(string3, object, "Double", d3, classCastException);
            return d;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double[] getDoubleArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (double[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "double[]", classCastException);
            return null;
        }
    }

    public float getFloat(String string2) {
        this.unparcel();
        return this.getFloat(string2, 0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFloat(String string2, float f) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return f;
        }
        try {
            float f2 = ((Float)object).floatValue();
            return f2;
        }
        catch (ClassCastException classCastException) {
            Float f3 = Float.valueOf(f);
            Bundle bundle = this;
            String string3 = string2;
            bundle.typeWarning(string3, object, "Float", f3, classCastException);
            return f;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float[] getFloatArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (float[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "float[]", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public IBinder getIBinder(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (IBinder)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "IBinder", classCastException);
            return null;
        }
    }

    public int getInt(String string2) {
        this.unparcel();
        return this.getInt(string2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(String string2, int n) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return n;
        }
        try {
            int n2 = (Integer)object;
            return n2;
        }
        catch (ClassCastException classCastException) {
            Integer n3 = n;
            Bundle bundle = this;
            String string3 = string2;
            bundle.typeWarning(string3, object, "Integer", n3, classCastException);
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getIntArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (int[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "int[]", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<Integer> getIntegerArrayList(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "ArrayList<Integer>", classCastException);
            return null;
        }
    }

    public long getLong(String string2) {
        this.unparcel();
        return this.getLong(string2, 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLong(String string2, long l) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return l;
        }
        try {
            long l2 = (Long)object;
            return l2;
        }
        catch (ClassCastException classCastException) {
            Long l3 = l;
            Bundle bundle = this;
            String string3 = string2;
            bundle.typeWarning(string3, object, "Long", l3, classCastException);
            return l;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getLongArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (long[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "long[]", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPairValue() {
        this.unparcel();
        int n = this.mMap.size();
        if (n > 1) {
            int n2 = Log.w(LOG_TAG, "getPairValue() used on Bundle with multiple pairs.");
        }
        if (n == 0) {
            return null;
        }
        Object object = this.mMap.values().iterator().next();
        try {
            return object = (String)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning("getPairValue()", object, "String", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends Parcelable> T getParcelable(String string2) {
        Object object;
        this.unparcel();
        Object object2 = this.mMap.get(string2);
        if (object2 == null) {
            object = null;
            return (T)object;
        }
        try {
            object = object2 = (Parcelable)object2;
            return (T)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object2, "Parcelable", classCastException);
            object = null;
            return (T)object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parcelable[] getParcelableArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (Parcelable[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Parcelable[]", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends Parcelable> ArrayList<T> getParcelableArrayList(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "ArrayList", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Serializable getSerializable(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (Serializable)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "Serializable", classCastException);
            return null;
        }
    }

    public short getShort(String string2) {
        this.unparcel();
        return this.getShort(string2, (short)0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short getShort(String string2, short s) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return s;
        }
        try {
            short s2 = (Short)object;
            return s2;
        }
        catch (ClassCastException classCastException) {
            Short s3 = s;
            Bundle bundle = this;
            String string3 = string2;
            bundle.typeWarning(string3, object, "Short", s3, classCastException);
            return s;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short[] getShortArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (short[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "short[]", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends Parcelable> SparseArray<T> getSparseParcelableArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (SparseArray)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "SparseArray", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (String)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "String", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getStringArray(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return (String[])object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "String[]", classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<String> getStringArrayList(String string2) {
        this.unparcel();
        Object object = this.mMap.get(string2);
        if (object == null) {
            return null;
        }
        try {
            return object = (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.typeWarning(string2, object, "ArrayList<String>", classCastException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasFileDescriptors() {
        block15: {
            if (this.mFdsKnown) ** GOTO lbl9
            var1_1 = false;
            if (this.mParcelledData == null) break block15;
            if (this.mParcelledData.hasFileDescriptors()) {
                var1_1 = true;
            }
lbl6:
            // 5 sources

            while (true) {
                this.mHasFds = var1_1;
                this.mFdsKnown = true;
lbl9:
                // 2 sources

                return this.mHasFds;
            }
        }
        var2_2 = this.mMap.entrySet().iterator();
        block1: while (true) {
            if (var1_1 || !var2_2.hasNext()) ** GOTO lbl6
            var3_3 = var2_2.next().getValue();
            if (var3_3 instanceof Parcelable) {
                if ((((Parcelable)var3_3).describeContents() & 1) == 0) continue;
                var1_1 = true;
                ** continue;
            }
            if (var3_3 instanceof Parcelable[]) {
                var4_4 = (Parcelable[])var3_3;
                var5_5 = ((Parcelable[])var4_4).length - 1;
                while (true) {
                    if (var5_5 < 0) continue block1;
                    if ((var4_4[var5_5].describeContents() & 1) != 0) {
                        var1_1 = true;
                        continue block1;
                    }
                    var5_5 += -1;
                }
            }
            if (var3_3 instanceof SparseArray) {
                var6_6 = (SparseArray)var3_3;
                var5_5 = var6_6.size() - 1;
                while (true) {
                    if (var5_5 < 0) continue block1;
                    if ((((Parcelable)var6_6.get(var5_5)).describeContents() & 1) != 0) {
                        var1_1 = true;
                        continue block1;
                    }
                    var5_5 += -1;
                }
            }
            if (!(var3_3 instanceof ArrayList) || (var4_4 = (ArrayList)var3_3).size() <= 0 || !(var4_4.get(0) instanceof Parcelable)) continue;
            var5_5 = var4_4.size() - 1;
            while (true) {
                if (var5_5 < 0) continue block1;
                var7_7 = (Parcelable)var4_4.get(var5_5);
                if (var7_7 != null && (var7_7.describeContents() & 1) != 0) {
                    var1_1 = true;
                    continue block1;
                }
                var5_5 += -1;
            }
            break;
        }
    }

    public boolean isEmpty() {
        this.unparcel();
        return this.mMap.isEmpty();
    }

    public Set<String> keySet() {
        this.unparcel();
        return this.mMap.keySet();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void putAll(Bundle bundle) {
        boolean bl;
        this.unparcel();
        bundle.unparcel();
        Map<String, Object> map = this.mMap;
        Map<String, Object> map2 = bundle.mMap;
        map.putAll(map2);
        boolean bl2 = this.mHasFds;
        boolean bl3 = bundle.mHasFds;
        this.mHasFds = bl = bl2 | bl3;
        boolean bl4 = this.mFdsKnown && bundle.mFdsKnown;
        this.mFdsKnown = bl4;
    }

    public void putBoolean(String string2, boolean bl) {
        this.unparcel();
        Map<String, Object> map = this.mMap;
        Boolean bl2 = bl;
        Object object = map.put(string2, bl2);
    }

    public void putBooleanArray(String string2, boolean[] blArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, blArray);
    }

    public void putBundle(String string2, Bundle bundle) {
        this.unparcel();
        Object object = this.mMap.put(string2, bundle);
    }

    public void putByte(String string2, byte by) {
        this.unparcel();
        Map<String, Object> map = this.mMap;
        Byte by2 = by;
        Object object = map.put(string2, by2);
    }

    public void putByteArray(String string2, byte[] byArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, byArray);
    }

    public void putChar(String string2, char c) {
        this.unparcel();
        Map<String, Object> map = this.mMap;
        Character c2 = Character.valueOf(c);
        Object object = map.put(string2, c2);
    }

    public void putCharArray(String string2, char[] cArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, cArray);
    }

    public void putCharSequence(String string2, CharSequence charSequence) {
        this.unparcel();
        Object object = this.mMap.put(string2, charSequence);
    }

    public void putCharSequenceArray(String string2, CharSequence[] charSequenceArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, charSequenceArray);
    }

    public void putCharSequenceArrayList(String string2, ArrayList<CharSequence> arrayList) {
        this.unparcel();
        ArrayList<CharSequence> arrayList2 = this.mMap.put(string2, arrayList);
    }

    public void putDouble(String string2, double d) {
        this.unparcel();
        Map<String, Object> map = this.mMap;
        Double d2 = d;
        Object object = map.put(string2, d2);
    }

    public void putDoubleArray(String string2, double[] dArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, dArray);
    }

    public void putFloat(String string2, float f) {
        this.unparcel();
        Map<String, Object> map = this.mMap;
        Float f2 = Float.valueOf(f);
        Object object = map.put(string2, f2);
    }

    public void putFloatArray(String string2, float[] fArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, fArray);
    }

    @Deprecated
    public void putIBinder(String string2, IBinder iBinder) {
        this.unparcel();
        Object object = this.mMap.put(string2, iBinder);
    }

    public void putInt(String string2, int n) {
        this.unparcel();
        Map<String, Object> map = this.mMap;
        Integer n2 = n;
        Object object = map.put(string2, n2);
    }

    public void putIntArray(String string2, int[] nArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, nArray);
    }

    public void putIntegerArrayList(String string2, ArrayList<Integer> arrayList) {
        this.unparcel();
        ArrayList<Integer> arrayList2 = this.mMap.put(string2, arrayList);
    }

    public void putLong(String string2, long l) {
        this.unparcel();
        Map<String, Object> map = this.mMap;
        Long l2 = l;
        Object object = map.put(string2, l2);
    }

    public void putLongArray(String string2, long[] lArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, lArray);
    }

    public void putParcelable(String string2, Parcelable parcelable) {
        this.unparcel();
        Object object = this.mMap.put(string2, parcelable);
        this.mFdsKnown = false;
    }

    public void putParcelableArray(String string2, Parcelable[] parcelableArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, parcelableArray);
        this.mFdsKnown = false;
    }

    public void putParcelableArrayList(String string2, ArrayList<? extends Parcelable> arrayList) {
        this.unparcel();
        ArrayList<? extends Parcelable> arrayList2 = this.mMap.put(string2, arrayList);
        this.mFdsKnown = false;
    }

    public void putSerializable(String string2, Serializable serializable) {
        this.unparcel();
        Object object = this.mMap.put(string2, serializable);
    }

    public void putShort(String string2, short s) {
        this.unparcel();
        Map<String, Object> map = this.mMap;
        Short s2 = s;
        Object object = map.put(string2, s2);
    }

    public void putShortArray(String string2, short[] sArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, sArray);
    }

    public void putSparseParcelableArray(String string2, SparseArray<? extends Parcelable> sparseArray) {
        this.unparcel();
        SparseArray<? extends Parcelable> sparseArray2 = this.mMap.put(string2, sparseArray);
        this.mFdsKnown = false;
    }

    public void putString(String string2, String string3) {
        this.unparcel();
        Object object = this.mMap.put(string2, string3);
    }

    public void putStringArray(String string2, String[] stringArray) {
        this.unparcel();
        Object object = this.mMap.put(string2, stringArray);
    }

    public void putStringArrayList(String string2, ArrayList<String> arrayList) {
        this.unparcel();
        ArrayList<String> arrayList2 = this.mMap.put(string2, arrayList);
    }

    public void readFromParcel(Parcel parcel) {
        int n = parcel.readInt();
        if (n < 0) {
            String string2 = "Bad length in parcel: " + n;
            throw new RuntimeException(string2);
        }
        this.readFromParcelInner(parcel, n);
    }

    void readFromParcelInner(Parcel parcel, int n) {
        boolean bl;
        if (parcel.readInt() != 1279544898) {
            String string2 = Log.getStackTraceString(new RuntimeException());
            int n2 = Log.e(LOG_TAG, "readBundle: bad magic number");
            String string3 = "readBundle: trace = " + string2;
            int n3 = Log.e(LOG_TAG, string3);
        }
        int n4 = parcel.dataPosition();
        int n5 = n4 + n;
        parcel.setDataPosition(n5);
        Parcel parcel2 = Parcel.obtain();
        parcel2.setDataPosition(0);
        parcel2.appendFrom(parcel, n4, n);
        parcel2.setDataPosition(0);
        this.mParcelledData = parcel2;
        this.mHasFds = bl = parcel2.hasFileDescriptors();
        this.mFdsKnown = true;
    }

    public void remove(String string2) {
        this.unparcel();
        Object object = this.mMap.remove(string2);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    public int size() {
        this.unparcel();
        return this.mMap.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        synchronized (this) {
            block4: {
                if (this.mParcelledData == null) break block4;
                StringBuilder stringBuilder = new StringBuilder().append("Bundle[mParcelledData.dataSize=");
                int n = this.mParcelledData.dataSize();
                String string2 = stringBuilder.append(n).append("]").toString();
                return string2;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Bundle[");
            String string3 = this.mMap.toString();
            String string4 = stringBuilder.append(string3).append("]").toString();
            return string4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void unparcel() {
        synchronized (this) {
            int n;
            Parcel parcel = this.mParcelledData;
            if (parcel != null && (n = this.mParcelledData.readInt()) >= 0) {
                if (this.mMap == null) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    this.mMap = hashMap;
                }
                Parcel parcel2 = this.mParcelledData;
                Map<String, Object> map = this.mMap;
                ClassLoader classLoader = this.mClassLoader;
                parcel2.readMapInternal(map, n, classLoader);
                this.mParcelledData.recycle();
                this.mParcelledData = null;
            }
            return;
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (this.mParcelledData != null) {
            int n2 = this.mParcelledData.dataSize();
            parcel.writeInt(n2);
            parcel.writeInt(1279544898);
            Parcel parcel2 = this.mParcelledData;
            parcel.appendFrom(parcel2, 0, n2);
            return;
        }
        parcel.writeInt(-1);
        parcel.writeInt(1279544898);
        int n3 = parcel.dataPosition();
        Map<String, Object> map = this.mMap;
        parcel.writeMapInternal(map);
        int n4 = parcel.dataPosition();
        int n5 = n3 - 8;
        parcel.setDataPosition(n5);
        int n6 = n4 - n3;
        parcel.writeInt(n6);
        parcel.setDataPosition(n4);
    }
}

