/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.TypedProperties;
import dalvik.system.VMDebug;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public final class Debug {
    private static final String DEFAULT_TRACE_BODY = "dmtrace";
    private static final String DEFAULT_TRACE_EXTENSION = ".trace";
    private static final String DEFAULT_TRACE_FILE_PATH = "/sdcard/dmtrace.trace";
    private static final String DEFAULT_TRACE_PATH_PREFIX = "/sdcard/";
    private static final int MIN_DEBUGGER_IDLE = 1300;
    public static final int SHOW_CLASSLOADER = 2;
    public static final int SHOW_FULL_DETAIL = 1;
    public static final int SHOW_INITIALIZED = 4;
    private static final int SPIN_DELAY = 200;
    private static final String SYSFS_QEMU_TRACE_STATE = "/sys/qemu_trace/state";
    private static final String TAG = "Debug";
    public static final int TRACE_COUNT_ALLOCS = 1;
    private static final TypedProperties debugProperties;
    private static volatile boolean mWaiting;

    static {
        mWaiting = false;
        debugProperties = null;
    }

    private Debug() {
    }

    public static final boolean cacheRegisterMap(String string2) {
        return VMDebug.cacheRegisterMap((String)string2);
    }

    @Deprecated
    public static void changeDebugPort(int n) {
    }

    public static void dumpHprofData(String string2) throws IOException {
        VMDebug.dumpHprofData((String)string2);
    }

    public static void dumpHprofDataDdms() {
        VMDebug.dumpHprofDataDdms();
    }

    public static final void dumpReferenceTables() {
        VMDebug.dumpReferenceTables();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean dumpService(String string2, FileDescriptor fileDescriptor, String[] stringArray) {
        IBinder iBinder = ServiceManager.getService(string2);
        if (iBinder == null) {
            String string3 = "Can't find service to dump: " + string2;
            int n = Log.e(TAG, string3);
            return false;
        }
        try {
            iBinder.dump(fileDescriptor, stringArray);
            return true;
        }
        catch (RemoteException remoteException) {
            String string4 = "Can't dump service: " + string2;
            int n = Log.e(TAG, string4, remoteException);
            return false;
        }
    }

    public static void enableEmulatorTraceOutput() {
        VMDebug.startEmulatorTracing();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean fieldTypeMatches(Field annotatedElement, Class<?> clazz) {
        Object var6_7;
        Field field;
        void var1_2;
        Class<?> clazz2 = ((Field)annotatedElement).getType();
        if (clazz2 == var1_2) {
            return true;
        }
        try {
            Field field2;
            field = field2 = var1_2.getField("TYPE");
            var6_7 = null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        try {
            Class clazz3 = (Class)field.get(var6_7);
            if (clazz2 != clazz3) return false;
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    public static final native int getBinderDeathObjectCount();

    public static final native int getBinderLocalObjectCount();

    public static final native int getBinderProxyObjectCount();

    public static native int getBinderReceivedTransactions();

    public static native int getBinderSentTransactions();

    public static int getGlobalAllocCount() {
        return VMDebug.getAllocCount((int)1);
    }

    public static int getGlobalAllocSize() {
        return VMDebug.getAllocCount((int)2);
    }

    public static int getGlobalClassInitCount() {
        return VMDebug.getAllocCount((int)32);
    }

    public static int getGlobalClassInitTime() {
        return VMDebug.getAllocCount((int)64);
    }

    public static int getGlobalExternalAllocCount() {
        return VMDebug.getAllocCount((int)4096);
    }

    public static int getGlobalExternalAllocSize() {
        return VMDebug.getAllocCount((int)8192);
    }

    public static int getGlobalExternalFreedCount() {
        return VMDebug.getAllocCount((int)16384);
    }

    public static int getGlobalExternalFreedSize() {
        return VMDebug.getAllocCount((int)32768);
    }

    public static int getGlobalFreedCount() {
        return VMDebug.getAllocCount((int)4);
    }

    public static int getGlobalFreedSize() {
        return VMDebug.getAllocCount((int)8);
    }

    public static int getGlobalGcInvocationCount() {
        return VMDebug.getAllocCount((int)16);
    }

    public static int getLoadedClassCount() {
        return VMDebug.getLoadedClassCount();
    }

    public static native void getMemoryInfo(int var0, MemoryInfo var1);

    public static native void getMemoryInfo(MemoryInfo var0);

    public static native long getNativeHeapAllocatedSize();

    public static native long getNativeHeapFreeSize();

    public static native long getNativeHeapSize();

    public static int getThreadAllocCount() {
        return VMDebug.getAllocCount((int)65536);
    }

    public static int getThreadAllocSize() {
        return VMDebug.getAllocCount((int)131072);
    }

    public static int getThreadExternalAllocCount() {
        return VMDebug.getAllocCount((int)0x10000000);
    }

    public static int getThreadExternalAllocSize() {
        return VMDebug.getAllocCount((int)0x20000000);
    }

    public static int getThreadGcInvocationCount() {
        return VMDebug.getAllocCount((int)0x100000);
    }

    public static String[] getVmFeatureList() {
        return VMDebug.getVmFeatureList();
    }

    public static boolean isDebuggerConnected() {
        return VMDebug.isDebuggerConnected();
    }

    public static boolean isMethodTracingActive() {
        return VMDebug.isMethodTracingActive();
    }

    /*
     * Exception decompiling
     */
    private static void modifyFieldIfSet(Field var0, TypedProperties var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CASE]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void printLoadedClasses(int n) {
        VMDebug.printLoadedClasses((int)n);
    }

    public static void resetAllCounts() {
        VMDebug.resetAllocCount((int)-1);
    }

    public static void resetGlobalAllocCount() {
        VMDebug.resetAllocCount((int)1);
    }

    public static void resetGlobalAllocSize() {
        VMDebug.resetAllocCount((int)2);
    }

    public static void resetGlobalClassInitCount() {
        VMDebug.resetAllocCount((int)32);
    }

    public static void resetGlobalClassInitTime() {
        VMDebug.resetAllocCount((int)64);
    }

    public static void resetGlobalExternalAllocCount() {
        VMDebug.resetAllocCount((int)4096);
    }

    public static void resetGlobalExternalAllocSize() {
        VMDebug.resetAllocCount((int)8192);
    }

    public static void resetGlobalExternalFreedCount() {
        VMDebug.resetAllocCount((int)16384);
    }

    public static void resetGlobalExternalFreedSize() {
        VMDebug.resetAllocCount((int)32768);
    }

    public static void resetGlobalFreedCount() {
        VMDebug.resetAllocCount((int)4);
    }

    public static void resetGlobalFreedSize() {
        VMDebug.resetAllocCount((int)8);
    }

    public static void resetGlobalGcInvocationCount() {
        VMDebug.resetAllocCount((int)16);
    }

    public static void resetThreadAllocCount() {
        VMDebug.resetAllocCount((int)65536);
    }

    public static void resetThreadAllocSize() {
        VMDebug.resetAllocCount((int)131072);
    }

    public static void resetThreadExternalAllocCount() {
        VMDebug.resetAllocCount((int)0x10000000);
    }

    public static void resetThreadExternalAllocSize() {
        VMDebug.resetAllocCount((int)0x20000000);
    }

    public static void resetThreadGcInvocationCount() {
        VMDebug.resetAllocCount((int)0x100000);
    }

    public static int setAllocationLimit(int n) {
        return VMDebug.setAllocationLimit((int)n);
    }

    public static void setFieldsOn(Class<?> clazz) {
        Debug.setFieldsOn(clazz, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setFieldsOn(Class<?> clazz, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder().append("setFieldsOn(");
        String string2 = clazz == null ? "null" : clazz.getName();
        String string3 = stringBuilder.append(string2).append(") called in non-DEBUG build").toString();
        int n = Log.wtf(TAG, string3);
    }

    public static int setGlobalAllocationLimit(int n) {
        if (n != 0 && n != -1) {
            throw new IllegalArgumentException("limit must be 0 or -1");
        }
        return VMDebug.setGlobalAllocationLimit((int)n);
    }

    public static void startAllocCounting() {
        VMDebug.startAllocCounting();
    }

    public static void startMethodTracing() {
        VMDebug.startMethodTracing((String)DEFAULT_TRACE_FILE_PATH, (int)0, (int)0);
    }

    public static void startMethodTracing(String string2) {
        Debug.startMethodTracing(string2, 0, 0);
    }

    public static void startMethodTracing(String string2, int n) {
        Debug.startMethodTracing(string2, n, 0);
    }

    public static void startMethodTracing(String string2, int n, int n2) {
        String string3 = string2;
        if (string3.charAt(0) != '/') {
            string3 = DEFAULT_TRACE_PATH_PREFIX + string3;
        }
        if (!string3.endsWith(DEFAULT_TRACE_EXTENSION)) {
            string3 = string3 + DEFAULT_TRACE_EXTENSION;
        }
        VMDebug.startMethodTracing((String)string3, (int)n, (int)n2);
    }

    public static void startMethodTracing(String string2, FileDescriptor fileDescriptor, int n, int n2) {
        VMDebug.startMethodTracing((String)string2, (FileDescriptor)fileDescriptor, (int)n, (int)n2);
    }

    public static void startMethodTracingDdms(int n, int n2) {
        VMDebug.startMethodTracingDdms((int)n, (int)n2);
    }

    /*
     * Unable to fully structure code
     */
    public static void startNativeTracing() {
        block10: {
            var0 = null;
            var1_1 = new FileOutputStream("/sys/qemu_trace/state");
            var2_2 = new OutputStreamWriter(var1_1);
            var3_3 = new PrintWriter(var2_2);
            try {
                var3_3.println("1");
                if (var3_3 == null) break block10;
                var3_3.close();
                var4_4 = var3_3;
            }
            catch (Throwable var6_8) {
                var7_9 = var3_3;
                ** continue;
            }
            catch (Exception var8_10) {
                var0 = var3_3;
                ** continue;
            }
lbl11:
            // 4 sources

            while (true) {
                VMDebug.startEmulatorTracing();
                return;
            }
            catch (Exception var5_5) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var0 == null) ** GOTO lbl11
                    var0.close();
                    break;
                }
            }
            catch (Throwable var6_6) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var7_9 != null) {
                        var7_9.close();
                    }
                    throw var6_7;
                }
            }
        }
        var9_11 = var3_3;
        ** while (true)
    }

    public static void stopAllocCounting() {
        VMDebug.stopAllocCounting();
    }

    public static void stopMethodTracing() {
        VMDebug.stopMethodTracing();
    }

    /*
     * Unable to fully structure code
     */
    public static void stopNativeTracing() {
        VMDebug.stopEmulatorTracing();
        var0 = null;
        var1_1 = new FileOutputStream("/sys/qemu_trace/state");
        var2_2 = new OutputStreamWriter(var1_1);
        var3_3 = new PrintWriter(var2_2);
        var3_3.println("0");
        if (var3_3 != null) {
            var3_3.close();
            var4_4 = var3_3;
            return;
        }
        catch (Exception var5_5) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var0 == null) {
                    return;
                }
                var0.close();
                return;
            }
        }
        catch (Throwable var6_6) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var7_9 != null) {
                    var7_9.close();
                }
                throw var6_7;
            }
        }
        catch (Throwable var6_8) {
            var7_9 = var3_3;
            ** continue;
        }
        catch (Exception var8_10) {
            var0 = var3_3;
            ** continue;
        }
        var9_11 = var3_3;
    }

    public static long threadCpuTimeNanos() {
        return VMDebug.threadCpuTimeNanos();
    }

    public static void waitForDebugger() {
        long l;
        if (!VMDebug.isDebuggingEnabled()) {
            return;
        }
        if (Debug.isDebuggerConnected()) {
            return;
        }
        System.out.println("Sending WAIT chunk");
        byte[] byArray = new byte[]{0};
        int n = ChunkHandler.type((String)"WAIT");
        DdmServer.sendChunk((Chunk)new Chunk(n, byArray, 0, 1));
        mWaiting = true;
        while (!Debug.isDebuggerConnected()) {
            long l2 = 200L;
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
        mWaiting = false;
        System.out.println("Debugger has connected");
        while (true) {
            if ((l = VMDebug.lastDebuggerActivity()) < 0L) {
                System.out.println("debugger detached?");
                return;
            }
            if (l >= 1300L) break;
            System.out.println("waiting for debugger to settle...");
            long l3 = 200L;
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {}
        }
        PrintStream printStream = System.out;
        String string2 = "debugger has settled (" + l + ")";
        printStream.println(string2);
    }

    public static boolean waitingForDebugger() {
        return mWaiting;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DebugProperty {
    }

    public static class InstructionCount {
        private static final int NUM_INSTR = 256;
        private int[] mCounts;

        public InstructionCount() {
            int[] nArray = new int[256];
            this.mCounts = nArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean collect() {
            try {
                VMDebug.stopInstructionCounting();
                VMDebug.getInstructionCount((int[])this.mCounts);
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return false;
            }
        }

        public int globalMethodInvocations() {
            int n = this.mCounts[110];
            int n2 = 0 + n;
            int n3 = this.mCounts[111];
            int n4 = n2 + n3;
            int n5 = this.mCounts[112];
            int n6 = n4 + n5;
            int n7 = this.mCounts[113];
            int n8 = n6 + n7;
            int n9 = this.mCounts[114];
            int n10 = n8 + n9;
            int n11 = this.mCounts[116];
            int n12 = n10 + n11;
            int n13 = this.mCounts[117];
            int n14 = n12 + n13;
            int n15 = this.mCounts[118];
            int n16 = n14 + n15;
            int n17 = this.mCounts[119];
            int n18 = n16 + n17;
            int n19 = this.mCounts[120];
            int n20 = n18 + n19;
            int n21 = this.mCounts[248];
            int n22 = n20 + n21;
            int n23 = this.mCounts[249];
            int n24 = n22 + n23;
            int n25 = this.mCounts[250];
            int n26 = n24 + n25;
            int n27 = this.mCounts[251];
            return n26 + n27;
        }

        public int globalTotal() {
            int n = 0;
            for (int i = 0; i < 256; ++i) {
                int n2 = this.mCounts[i];
                n += n2;
            }
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean resetAndStart() {
            try {
                VMDebug.startInstructionCounting();
                VMDebug.resetInstructionCount();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return false;
            }
        }
    }

    public static class MemoryInfo
    implements Parcelable {
        public static final Parcelable.Creator<MemoryInfo> CREATOR = new Parcelable.Creator<MemoryInfo>(){

            @Override
            public MemoryInfo createFromParcel(Parcel parcel) {
                return new MemoryInfo(parcel);
            }

            public MemoryInfo[] newArray(int n) {
                return new MemoryInfo[n];
            }
        };
        public int dalvikPrivateDirty;
        public int dalvikPss;
        public int dalvikSharedDirty;
        public int nativePrivateDirty;
        public int nativePss;
        public int nativeSharedDirty;
        public int otherPrivateDirty;
        public int otherPss;
        public int otherSharedDirty;

        public MemoryInfo() {
        }

        private MemoryInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int getTotalPrivateDirty() {
            int n = this.dalvikPrivateDirty;
            int n2 = this.nativePrivateDirty;
            int n3 = n + n2;
            int n4 = this.otherPrivateDirty;
            return n3 + n4;
        }

        public int getTotalPss() {
            int n = this.dalvikPss;
            int n2 = this.nativePss;
            int n3 = n + n2;
            int n4 = this.otherPss;
            return n3 + n4;
        }

        public int getTotalSharedDirty() {
            int n = this.dalvikSharedDirty;
            int n2 = this.nativeSharedDirty;
            int n3 = n + n2;
            int n4 = this.otherSharedDirty;
            return n3 + n4;
        }

        public void readFromParcel(Parcel parcel) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            this.dalvikPss = n9 = parcel.readInt();
            this.dalvikPrivateDirty = n8 = parcel.readInt();
            this.dalvikSharedDirty = n7 = parcel.readInt();
            this.nativePss = n6 = parcel.readInt();
            this.nativePrivateDirty = n5 = parcel.readInt();
            this.nativeSharedDirty = n4 = parcel.readInt();
            this.otherPss = n3 = parcel.readInt();
            this.otherPrivateDirty = n2 = parcel.readInt();
            this.otherSharedDirty = n = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = this.dalvikPss;
            parcel.writeInt(n2);
            int n3 = this.dalvikPrivateDirty;
            parcel.writeInt(n3);
            int n4 = this.dalvikSharedDirty;
            parcel.writeInt(n4);
            int n5 = this.nativePss;
            parcel.writeInt(n5);
            int n6 = this.nativePrivateDirty;
            parcel.writeInt(n6);
            int n7 = this.nativeSharedDirty;
            parcel.writeInt(n7);
            int n8 = this.otherPss;
            parcel.writeInt(n8);
            int n9 = this.otherPrivateDirty;
            parcel.writeInt(n9);
            int n10 = this.otherSharedDirty;
            parcel.writeInt(n10);
        }
    }
}

