/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.os.IDropBoxManagerService;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class DropBoxManager {
    private static final int HAS_BYTE_ARRAY = 8;
    public static final int IS_EMPTY = 1;
    public static final int IS_GZIPPED = 4;
    public static final int IS_TEXT = 2;
    private static final String TAG = "DropBoxManager";
    private final IDropBoxManagerService mService;

    protected DropBoxManager() {
        this.mService = null;
    }

    public DropBoxManager(IDropBoxManagerService iDropBoxManagerService) {
        this.mService = iDropBoxManagerService;
    }

    public void addData(String string2, byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("data == null");
        }
        try {
            IDropBoxManagerService iDropBoxManagerService = this.mService;
            String string3 = string2;
            byte[] byArray2 = byArray;
            int n2 = n;
            Entry entry = new Entry(string3, 0L, byArray2, n2);
            iDropBoxManagerService.add(entry);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void addFile(String string2, File file, int n) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        String string3 = string2;
        File file2 = file;
        int n2 = n;
        Entry entry = new Entry(string3, 0L, file2, n2);
        try {
            this.mService.add(entry);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        finally {
            entry.close();
        }
    }

    public void addText(String string2, String string3) {
        try {
            IDropBoxManagerService iDropBoxManagerService = this.mService;
            Entry entry = new Entry(string2, 0L, string3);
            iDropBoxManagerService.add(entry);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entry getNextEntry(String string2, long l) {
        try {
            Entry entry = this.mService.getNextEntry(string2, l);
            return entry;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTagEnabled(String string2) {
        try {
            boolean bl = this.mService.isTagEnabled(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static class Entry
    implements Parcelable,
    Closeable {
        public static final Parcelable.Creator<Entry> CREATOR = new Parcelable.Creator(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Entry createFromParcel(Parcel parcel) {
                String string2 = parcel.readString();
                long l = parcel.readLong();
                int n = parcel.readInt();
                if ((n & 8) != 0) {
                    byte[] byArray = parcel.createByteArray();
                    int n2 = n & 0xFFFFFFF7;
                    return new Entry(string2, l, byArray, n2);
                }
                ParcelFileDescriptor parcelFileDescriptor = parcel.readFileDescriptor();
                return new Entry(string2, l, parcelFileDescriptor, n);
            }

            public Entry[] newArray(int n) {
                return new Entry[n];
            }
        };
        private final byte[] mData;
        private final ParcelFileDescriptor mFileDescriptor;
        private final int mFlags;
        private final String mTag;
        private final long mTimeMillis;

        public Entry(String string2, long l) {
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            this.mData = null;
            this.mFileDescriptor = null;
            this.mFlags = 1;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Entry(String string2, long l, ParcelFileDescriptor parcelFileDescriptor, int n) {
            n = 0;
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            int n2 = (n & 1) != 0 ? 1 : 0;
            if (parcelFileDescriptor == null) {
                n = 1;
            }
            if (n2 != n) {
                String string3 = "Bad flags: " + n;
                throw new IllegalArgumentException(string3);
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            this.mData = null;
            this.mFileDescriptor = parcelFileDescriptor;
            this.mFlags = n;
        }

        public Entry(String string2, long l, File file, int n) throws IOException {
            ParcelFileDescriptor parcelFileDescriptor;
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            if ((n & 1) != 0) {
                String string3 = "Bad flags: " + n;
                throw new IllegalArgumentException(string3);
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            this.mData = null;
            this.mFileDescriptor = parcelFileDescriptor = ParcelFileDescriptor.open(file, 0x10000000);
            this.mFlags = n;
        }

        public Entry(String string2, long l, String string3) {
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            if (string3 == null) {
                throw new NullPointerException("text == null");
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            byte[] byArray = string3.getBytes();
            this.mData = byArray;
            this.mFileDescriptor = null;
            this.mFlags = 2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Entry(String string2, long l, byte[] byArray, int n) {
            n = 0;
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            int n2 = (n & 1) != 0 ? 1 : 0;
            if (byArray == null) {
                n = 1;
            }
            if (n2 != n) {
                String string3 = "Bad flags: " + n;
                throw new IllegalArgumentException(string3);
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            this.mData = byArray;
            this.mFileDescriptor = null;
            this.mFlags = n;
        }

        @Override
        public void close() {
            try {
                if (this.mFileDescriptor == null) {
                    return;
                }
                this.mFileDescriptor.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int describeContents() {
            if (this.mFileDescriptor == null) return 0;
            return 1;
        }

        public int getFlags() {
            return this.mFlags & 0xFFFFFFFB;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public InputStream getInputStream() throws IOException {
            void var2_3;
            void var3_6;
            if (this.mData != null) {
                byte[] byArray = this.mData;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            } else {
                if (this.mFileDescriptor == null) return var3_6;
                ParcelFileDescriptor parcelFileDescriptor = this.mFileDescriptor;
                ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
            }
            if ((this.mFlags & 4) != 0) {
                GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)var2_3);
                return var3_6;
            }
            void var3_8 = var2_3;
            return var3_6;
        }

        public String getTag() {
            return this.mTag;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getText(int n) {
            InputStream inputStream;
            block18: {
                InputStream inputStream2;
                if ((this.mFlags & 2) == 0) {
                    return null;
                }
                if (this.mData != null) {
                    byte[] byArray = this.mData;
                    int n2 = this.mData.length;
                    int n3 = Math.min(n, n2);
                    return new String(byArray, 0, n3);
                }
                inputStream = null;
                inputStream = inputStream2 = this.getInputStream();
                if (inputStream != null) break block18;
                if (inputStream == null) return null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    return null;
                }
                return null;
            }
            byte[] byArray = new byte[n];
            int n4 = inputStream.read(byArray);
            int n5 = Math.max(0, n4);
            String string2 = new String(byArray, 0, n5);
            if (inputStream == null) return string2;
            try {
                inputStream.close();
                return string2;
            }
            catch (IOException iOException) {}
            return string2;
            catch (IOException iOException) {
                if (inputStream == null) return null;
                inputStream.close();
                return null;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            {
                catch (IOException iOException) {
                    return null;
                }
            }
            {
                catch (IOException iOException) {
                    throw throwable;
                }
            }
        }

        public long getTimeMillis() {
            return this.mTimeMillis;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            String string2 = this.mTag;
            parcel.writeString(string2);
            long l = this.mTimeMillis;
            parcel.writeLong(l);
            if (this.mFileDescriptor != null) {
                int n2 = this.mFlags & 0xFFFFFFF7;
                parcel.writeInt(n2);
                this.mFileDescriptor.writeToParcel(parcel, n);
                return;
            }
            int n3 = this.mFlags | 8;
            parcel.writeInt(n3);
            byte[] byArray = this.mData;
            parcel.writeByteArray(byArray);
        }
    }
}

