/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.res.Resources;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.storage.IMountService;
import java.io.File;

public class Environment {
    private static final File DATA_DIRECTORY;
    public static String DIRECTORY_ALARMS;
    public static String DIRECTORY_DCIM;
    public static String DIRECTORY_DOWNLOADS;
    public static String DIRECTORY_MOVIES;
    public static String DIRECTORY_MUSIC;
    public static String DIRECTORY_NOTIFICATIONS;
    public static String DIRECTORY_PICTURES;
    public static String DIRECTORY_PODCASTS;
    public static String DIRECTORY_RINGTONES;
    private static final File DOWNLOAD_CACHE_DIRECTORY;
    private static final File EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY;
    private static final File EXTERNAL_STORAGE_ANDROID_MEDIA_DIRECTORY;
    private static final File EXTERNAL_STORAGE_DIRECTORY;
    public static final String MEDIA_BAD_REMOVAL = "bad_removal";
    public static final String MEDIA_CHECKING = "checking";
    public static final String MEDIA_MOUNTED = "mounted";
    public static final String MEDIA_MOUNTED_READ_ONLY = "mounted_ro";
    public static final String MEDIA_NOFS = "nofs";
    public static final String MEDIA_REMOVED = "removed";
    public static final String MEDIA_SHARED = "shared";
    public static final String MEDIA_UNMOUNTABLE = "unmountable";
    public static final String MEDIA_UNMOUNTED = "unmounted";
    private static final File ROOT_DIRECTORY;
    private static final File SECURE_DATA_DIRECTORY;
    private static final String SYSTEM_PROPERTY_EFS_ENABLED = "persist.security.efs.enabled";
    private static IMountService mMntSvc;

    static {
        ROOT_DIRECTORY = Environment.getDirectory("ANDROID_ROOT", "/system");
        mMntSvc = null;
        DATA_DIRECTORY = Environment.getDirectory("ANDROID_DATA", "/data");
        SECURE_DATA_DIRECTORY = Environment.getDirectory("ANDROID_SECURE_DATA", "/data/secure");
        EXTERNAL_STORAGE_DIRECTORY = Environment.getDirectory("EXTERNAL_STORAGE", "/sdcard");
        File file = Environment.getDirectory("EXTERNAL_STORAGE", "/sdcard");
        File file2 = new File(file, "Android");
        EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY = new File(file2, "data");
        File file3 = Environment.getDirectory("EXTERNAL_STORAGE", "/sdcard");
        File file4 = new File(file3, "Android");
        EXTERNAL_STORAGE_ANDROID_MEDIA_DIRECTORY = new File(file4, "media");
        DOWNLOAD_CACHE_DIRECTORY = Environment.getDirectory("DOWNLOAD_CACHE", "/cache");
        DIRECTORY_MUSIC = "Music";
        DIRECTORY_PODCASTS = "Podcasts";
        DIRECTORY_RINGTONES = "Ringtones";
        DIRECTORY_ALARMS = "Alarms";
        DIRECTORY_NOTIFICATIONS = "Notifications";
        DIRECTORY_PICTURES = "Pictures";
        DIRECTORY_MOVIES = "Movies";
        DIRECTORY_DOWNLOADS = "Download";
        DIRECTORY_DCIM = "DCIM";
    }

    public static File getDataDirectory() {
        return DATA_DIRECTORY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static File getDirectory(String string2, String string3) {
        String string4 = System.getenv(string2);
        if (string4 != null) return new File(string4);
        return new File(string3);
    }

    public static File getDownloadCacheDirectory() {
        return DOWNLOAD_CACHE_DIRECTORY;
    }

    public static File getExternalStorageAndroidDataDir() {
        return EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY;
    }

    public static File getExternalStorageAppCacheDirectory(String string2) {
        File file = EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY;
        File file2 = new File(file, string2);
        return new File(file2, "cache");
    }

    public static File getExternalStorageAppDataDirectory(String string2) {
        File file = EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY;
        return new File(file, string2);
    }

    public static File getExternalStorageAppFilesDirectory(String string2) {
        File file = EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY;
        File file2 = new File(file, string2);
        return new File(file2, "files");
    }

    public static File getExternalStorageAppMediaDirectory(String string2) {
        File file = EXTERNAL_STORAGE_ANDROID_MEDIA_DIRECTORY;
        return new File(file, string2);
    }

    public static File getExternalStorageDirectory() {
        return EXTERNAL_STORAGE_DIRECTORY;
    }

    public static File getExternalStoragePublicDirectory(String string2) {
        File file = Environment.getExternalStorageDirectory();
        return new File(file, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getExternalStorageState() {
        try {
            if (mMntSvc == null) {
                mMntSvc = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            }
            IMountService iMountService = mMntSvc;
            String string2 = Environment.getExternalStorageDirectory().toString();
            String string3 = iMountService.getVolumeState(string2);
            return string3;
        }
        catch (Exception exception) {
            return MEDIA_REMOVED;
        }
    }

    public static File getRootDirectory() {
        return ROOT_DIRECTORY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getSecureDataDirectory() {
        if (!Environment.isEncryptedFilesystemEnabled()) return DATA_DIRECTORY;
        return SECURE_DATA_DIRECTORY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getSystemSecureDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            File file = SECURE_DATA_DIRECTORY;
            return new File(file, "system");
        }
        File file = DATA_DIRECTORY;
        return new File(file, "system");
    }

    public static boolean isEncryptedFilesystemEnabled() {
        return SystemProperties.getBoolean(SYSTEM_PROPERTY_EFS_ENABLED, false);
    }

    public static boolean isExternalStorageRemovable() {
        return Resources.getSystem().getBoolean(17629186);
    }
}

