/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public abstract class FileObserver {
    public static final int ACCESS = 1;
    public static final int ALL_EVENTS = 4095;
    public static final int ATTRIB = 4;
    public static final int CLOSE_NOWRITE = 16;
    public static final int CLOSE_WRITE = 8;
    public static final int CREATE = 256;
    public static final int DELETE = 512;
    public static final int DELETE_SELF = 1024;
    private static final String LOG_TAG = "FileObserver";
    public static final int MODIFY = 2;
    public static final int MOVED_FROM = 64;
    public static final int MOVED_TO = 128;
    public static final int MOVE_SELF = 2048;
    public static final int OPEN = 32;
    private static ObserverThread s_observerThread = new ObserverThread();
    private Integer m_descriptor;
    private int m_mask;
    private String m_path;

    static {
        s_observerThread.start();
    }

    public FileObserver(String string2) {
        this(string2, 4095);
    }

    public FileObserver(String string2, int n) {
        Integer n2;
        this.m_path = string2;
        this.m_mask = n;
        this.m_descriptor = n2 = Integer.valueOf(-1);
    }

    protected void finalize() {
        this.stopWatching();
    }

    public abstract void onEvent(int var1, String var2);

    public void startWatching() {
        Integer n;
        if (this.m_descriptor >= 0) {
            return;
        }
        ObserverThread observerThread = s_observerThread;
        String string2 = this.m_path;
        int n2 = this.m_mask;
        this.m_descriptor = n = Integer.valueOf(observerThread.startWatching(string2, n2, this));
    }

    public void stopWatching() {
        Integer n;
        if (this.m_descriptor < 0) {
            return;
        }
        ObserverThread observerThread = s_observerThread;
        int n2 = this.m_descriptor;
        observerThread.stopWatching(n2);
        this.m_descriptor = n = Integer.valueOf(-1);
    }

    private static class ObserverThread
    extends Thread {
        private int m_fd;
        private HashMap<Integer, WeakReference> m_observers;

        public ObserverThread() {
            super(FileObserver.LOG_TAG);
            int n;
            HashMap hashMap = new HashMap();
            this.m_observers = hashMap;
            this.m_fd = n = this.init();
        }

        private native int init();

        private native void observe(int var1);

        private native int startWatching(int var1, String var2, int var3);

        private native void stopWatching(int var1, int var2);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onEvent(int n, int n2, String string2) {
            FileObserver fileObserver = null;
            HashMap<Integer, WeakReference> hashMap = this.m_observers;
            // MONITORENTER : hashMap
            HashMap<Integer, WeakReference> hashMap2 = this.m_observers;
            Integer n3 = n;
            WeakReference weakReference = hashMap2.get(n3);
            if (weakReference != null && (fileObserver = (FileObserver)weakReference.get()) == null) {
                HashMap<Integer, WeakReference> hashMap3 = this.m_observers;
                Integer n4 = n;
                WeakReference weakReference2 = hashMap3.remove(n4);
            }
            // MONITOREXIT : hashMap
            if (fileObserver == null) {
                return;
            }
            try {
                fileObserver.onEvent(n2, string2);
                return;
            }
            catch (Throwable throwable) {
                String string3 = "Unhandled exception in FileObserver " + fileObserver;
                int n5 = Log.wtf(FileObserver.LOG_TAG, string3, throwable);
                return;
            }
        }

        @Override
        public void run() {
            int n = this.m_fd;
            this.observe(n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int startWatching(String string2, int n, FileObserver fileObserver) {
            int n2 = this.m_fd;
            int n3 = this.startWatching(n2, string2, n);
            Integer n4 = new Integer(n3);
            if (n3 >= 0) {
                HashMap<Integer, WeakReference> hashMap = this.m_observers;
                synchronized (hashMap) {
                    HashMap<Integer, WeakReference> hashMap2 = this.m_observers;
                    WeakReference<FileObserver> weakReference = new WeakReference<FileObserver>(fileObserver);
                    WeakReference<FileObserver> weakReference2 = hashMap2.put(n4, weakReference);
                }
            }
            return n4;
        }

        public void stopWatching(int n) {
            int n2 = this.m_fd;
            this.stopWatching(n2, n);
        }
    }
}

