/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IMessenger;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;

public class Handler {
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    private static final String TAG = "Handler";
    final Callback mCallback;
    final Looper mLooper;
    IMessenger mMessenger;
    final MessageQueue mQueue;

    public Handler() {
        MessageQueue messageQueue;
        Looper looper;
        this.mLooper = looper = Looper.myLooper();
        if (this.mLooper == null) {
            throw new RuntimeException("Can't create handler inside thread that has not called Looper.prepare()");
        }
        this.mQueue = messageQueue = this.mLooper.mQueue;
        this.mCallback = null;
    }

    public Handler(Callback callback) {
        MessageQueue messageQueue;
        Looper looper;
        this.mLooper = looper = Looper.myLooper();
        if (this.mLooper == null) {
            throw new RuntimeException("Can't create handler inside thread that has not called Looper.prepare()");
        }
        this.mQueue = messageQueue = this.mLooper.mQueue;
        this.mCallback = callback;
    }

    public Handler(Looper looper) {
        MessageQueue messageQueue;
        this.mLooper = looper;
        this.mQueue = messageQueue = looper.mQueue;
        this.mCallback = null;
    }

    public Handler(Looper looper, Callback callback) {
        MessageQueue messageQueue;
        this.mLooper = looper;
        this.mQueue = messageQueue = looper.mQueue;
        this.mCallback = callback;
    }

    private final Message getPostMessage(Runnable runnable) {
        Message message = Message.obtain();
        message.callback = runnable;
        return message;
    }

    private final Message getPostMessage(Runnable runnable, Object object) {
        Message message = Message.obtain();
        message.obj = object;
        message.callback = runnable;
        return message;
    }

    private final void handleCallback(Message message) {
        message.callback.run();
    }

    public void dispatchMessage(Message message) {
        if (message.callback != null) {
            this.handleCallback(message);
            return;
        }
        if (this.mCallback != null && this.mCallback.handleMessage(message)) {
            return;
        }
        this.handleMessage(message);
    }

    public final void dump(Printer printer, String string2) {
        StringBuilder stringBuilder = new StringBuilder().append(string2).append(this).append(" @ ");
        long l = SystemClock.uptimeMillis();
        String string3 = stringBuilder.append(l).toString();
        printer.println(string3);
        if (this.mLooper == null) {
            String string4 = string2 + "looper uninitialized";
            printer.println(string4);
            return;
        }
        Looper looper = this.mLooper;
        String string5 = string2 + "  ";
        looper.dump(printer, string5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final IMessenger getIMessenger() {
        MessageQueue messageQueue = this.mQueue;
        synchronized (messageQueue) {
            if (this.mMessenger != null) {
                IMessenger iMessenger = this.mMessenger;
                return iMessenger;
            }
            MessengerImpl messengerImpl = new MessengerImpl();
            IMessenger iMessenger = this.mMessenger = messengerImpl;
            return iMessenger;
        }
    }

    public final Looper getLooper() {
        return this.mLooper;
    }

    public void handleMessage(Message message) {
    }

    public final boolean hasMessages(int n) {
        return this.mQueue.removeMessages(this, n, null, false);
    }

    public final boolean hasMessages(int n, Object object) {
        return this.mQueue.removeMessages(this, n, object, false);
    }

    public final Message obtainMessage() {
        return Message.obtain(this);
    }

    public final Message obtainMessage(int n) {
        return Message.obtain(this, n);
    }

    public final Message obtainMessage(int n, int n2, int n3) {
        return Message.obtain(this, n, n2, n3);
    }

    public final Message obtainMessage(int n, int n2, int n3, Object object) {
        return Message.obtain(this, n, n2, n3, object);
    }

    public final Message obtainMessage(int n, Object object) {
        return Message.obtain(this, n, object);
    }

    public final boolean post(Runnable runnable) {
        Message message = this.getPostMessage(runnable);
        return this.sendMessageDelayed(message, 0L);
    }

    public final boolean postAtFrontOfQueue(Runnable runnable) {
        Message message = this.getPostMessage(runnable);
        return this.sendMessageAtFrontOfQueue(message);
    }

    public final boolean postAtTime(Runnable runnable, long l) {
        Message message = this.getPostMessage(runnable);
        return this.sendMessageAtTime(message, l);
    }

    public final boolean postAtTime(Runnable runnable, Object object, long l) {
        Message message = this.getPostMessage(runnable, object);
        return this.sendMessageAtTime(message, l);
    }

    public final boolean postDelayed(Runnable runnable, long l) {
        Message message = this.getPostMessage(runnable);
        return this.sendMessageDelayed(message, l);
    }

    public final void removeCallbacks(Runnable runnable) {
        this.mQueue.removeMessages(this, runnable, null);
    }

    public final void removeCallbacks(Runnable runnable, Object object) {
        this.mQueue.removeMessages(this, runnable, object);
    }

    public final void removeCallbacksAndMessages(Object object) {
        this.mQueue.removeCallbacksAndMessages(this, object);
    }

    public final void removeMessages(int n) {
        boolean bl = this.mQueue.removeMessages(this, n, null, true);
    }

    public final void removeMessages(int n, Object object) {
        boolean bl = this.mQueue.removeMessages(this, n, object, true);
    }

    public final boolean sendEmptyMessage(int n) {
        return this.sendEmptyMessageDelayed(n, 0L);
    }

    public final boolean sendEmptyMessageAtTime(int n, long l) {
        Message message = Message.obtain();
        message.what = n;
        return this.sendMessageAtTime(message, l);
    }

    public final boolean sendEmptyMessageDelayed(int n, long l) {
        Message message = Message.obtain();
        message.what = n;
        return this.sendMessageDelayed(message, l);
    }

    public final boolean sendMessage(Message message) {
        return this.sendMessageDelayed(message, 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean sendMessageAtFrontOfQueue(Message message) {
        boolean bl = false;
        MessageQueue messageQueue = this.mQueue;
        if (messageQueue != null) {
            message.target = this;
            return messageQueue.enqueueMessage(message, 0L);
        }
        String string2 = this + " sendMessageAtTime() called with no mQueue";
        RuntimeException runtimeException = new RuntimeException(string2);
        String string3 = runtimeException.getMessage();
        int n = Log.w("Looper", string3, runtimeException);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendMessageAtTime(Message message, long l) {
        boolean bl = false;
        MessageQueue messageQueue = this.mQueue;
        if (messageQueue != null) {
            message.target = this;
            return messageQueue.enqueueMessage(message, l);
        }
        String string2 = this + " sendMessageAtTime() called with no mQueue";
        RuntimeException runtimeException = new RuntimeException(string2);
        String string3 = runtimeException.getMessage();
        int n = Log.w("Looper", string3, runtimeException);
        return bl;
    }

    public final boolean sendMessageDelayed(Message message, long l) {
        if (l < 0L) {
            l = 0L;
        }
        long l2 = SystemClock.uptimeMillis() + l;
        return this.sendMessageAtTime(message, l2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Handler{");
        String string2 = Integer.toHexString(System.identityHashCode(this));
        return stringBuilder.append(string2).append("}").toString();
    }

    private final class MessengerImpl
    extends IMessenger.Stub {
        private MessengerImpl() {
        }

        @Override
        public void send(Message message) {
            boolean bl = Handler.this.sendMessage(message);
        }
    }

    public static interface Callback {
        public boolean handleMessage(Message var1);
    }
}

