/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Looper;
import android.os.Process;

public class HandlerThread
extends Thread {
    private Looper mLooper;
    private int mPriority;
    private int mTid = -1;

    public HandlerThread(String string2) {
        super(string2);
        this.mPriority = 0;
    }

    public HandlerThread(String string2, int n) {
        super(string2);
        this.mPriority = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Looper getLooper() {
        if (!this.isAlive()) {
            return null;
        }
        synchronized (this) {
            while (this.isAlive()) {
                Looper looper = this.mLooper;
                if (looper != null) return this.mLooper;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.mLooper;
        }
    }

    public int getThreadId() {
        return this.mTid;
    }

    protected void onLooperPrepared() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean quit() {
        Looper looper = this.getLooper();
        if (looper == null) return false;
        looper.quit();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int n;
        this.mTid = n = Process.myTid();
        Looper.prepare();
        synchronized (this) {
            Looper looper;
            this.mLooper = looper = Looper.myLooper();
            this.notifyAll();
        }
        Process.setThreadPriority(this.mPriority);
        this.onLooperPrepared();
        Looper.loop();
        this.mTid = -1;
    }
}

