/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Process;
import android.os.SystemClock;
import android.util.Printer;

public class Looper {
    private static final boolean DEBUG;
    private static final boolean localLOGV;
    private static Looper mMainLooper;
    private static final ThreadLocal sThreadLocal;
    private Printer mLogging = null;
    final MessageQueue mQueue;
    volatile boolean mRun;
    Thread mThread;

    static {
        sThreadLocal = new ThreadLocal();
        mMainLooper = null;
    }

    private Looper() {
        Thread thread;
        MessageQueue messageQueue;
        this.mQueue = messageQueue = new MessageQueue();
        this.mRun = true;
        this.mThread = thread = Thread.currentThread();
    }

    public static final Looper getMainLooper() {
        synchronized (Looper.class) {
            Looper looper = mMainLooper;
            return looper;
        }
    }

    public static final void loop() {
        Looper looper = Looper.myLooper();
        MessageQueue messageQueue = looper.mQueue;
        while (true) {
            Message message;
            if ((message = messageQueue.next()) == null) {
                continue;
            }
            if (message.target == null) {
                return;
            }
            if (looper.mLogging != null) {
                Printer printer = looper.mLogging;
                StringBuilder stringBuilder = new StringBuilder().append(">>>>> Dispatching to ");
                Handler handler = message.target;
                StringBuilder stringBuilder2 = stringBuilder.append(handler).append(" ");
                Runnable runnable = message.callback;
                StringBuilder stringBuilder3 = stringBuilder2.append(runnable).append(": ");
                int n = message.what;
                String string2 = stringBuilder3.append(n).toString();
                printer.println(string2);
            }
            message.target.dispatchMessage(message);
            if (looper.mLogging != null) {
                Printer printer = looper.mLogging;
                StringBuilder stringBuilder = new StringBuilder().append("<<<<< Finished to    ");
                Handler handler = message.target;
                StringBuilder stringBuilder4 = stringBuilder.append(handler).append(" ");
                Runnable runnable = message.callback;
                String string3 = stringBuilder4.append(runnable).toString();
                printer.println(string3);
            }
            message.recycle();
        }
    }

    public static final Looper myLooper() {
        return (Looper)sThreadLocal.get();
    }

    public static final MessageQueue myQueue() {
        return Looper.myLooper().mQueue;
    }

    public static final void prepare() {
        if (sThreadLocal.get() != null) {
            throw new RuntimeException("Only one Looper may be created per thread");
        }
        ThreadLocal threadLocal = sThreadLocal;
        Looper looper = new Looper();
        threadLocal.set(looper);
    }

    public static final void prepareMainLooper() {
        Looper.prepare();
        Looper.setMainLooper(Looper.myLooper());
        if (!Process.supportsProcesses()) {
            return;
        }
        Looper.myLooper().mQueue.mQuitAllowed = false;
    }

    private static void setMainLooper(Looper looper) {
        synchronized (Looper.class) {
            mMainLooper = looper;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(Printer printer, String string2) {
        String string3 = string2 + this;
        printer.println(string3);
        StringBuilder stringBuilder = new StringBuilder().append(string2).append("mRun=");
        boolean bl = this.mRun;
        String string4 = stringBuilder.append(bl).toString();
        printer.println(string4);
        StringBuilder stringBuilder2 = new StringBuilder().append(string2).append("mThread=");
        Thread thread = this.mThread;
        String string5 = stringBuilder2.append(thread).toString();
        printer.println(string5);
        StringBuilder stringBuilder3 = new StringBuilder().append(string2).append("mQueue=");
        Object object = this.mQueue != null ? this.mQueue : "(null";
        String string6 = stringBuilder3.append(object).toString();
        printer.println(string6);
        if (this.mQueue == null) {
            return;
        }
        MessageQueue messageQueue = this.mQueue;
        synchronized (messageQueue) {
            long l = SystemClock.uptimeMillis();
            Message message = this.mQueue.mMessages;
            int n = 0;
            while (true) {
                if (message == null) {
                    String string7 = string2 + "(Total messages: " + n + ")";
                    printer.println(string7);
                    return;
                }
                StringBuilder stringBuilder4 = new StringBuilder().append(string2).append("  Message ").append(n).append(": ");
                String string8 = message.toString(l);
                String string9 = stringBuilder4.append(string8).toString();
                printer.println(string9);
                ++n;
                message = message.next;
            }
        }
    }

    public MessageQueue getQueue() {
        return this.mQueue;
    }

    public Thread getThread() {
        return this.mThread;
    }

    public void quit() {
        Message message = Message.obtain();
        boolean bl = this.mQueue.enqueueMessage(message, 0L);
    }

    public void setMessageLogging(Printer printer) {
        this.mLogging = printer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Looper{");
        String string2 = Integer.toHexString(System.identityHashCode(this));
        return stringBuilder.append(string2).append("}").toString();
    }

    static class HandlerException
    extends Exception {
        HandlerException(Message message, Throwable throwable) {
            String string2 = HandlerException.createMessage(throwable);
            super(string2, throwable);
        }

        static String createMessage(Throwable throwable) {
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = throwable.toString();
            }
            return string2;
        }
    }
}

