/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryFile {
    private static final int PROT_READ = 1;
    private static final int PROT_WRITE = 2;
    private static String TAG = "MemoryFile";
    private int mAddress;
    private boolean mAllowPurging = false;
    private FileDescriptor mFD;
    private int mLength;
    private final boolean mOwnsRegion;

    public MemoryFile(FileDescriptor fileDescriptor, int n, String string2) throws IOException {
        int n2;
        if (fileDescriptor == null) {
            throw new NullPointerException("File descriptor is null.");
        }
        if (!MemoryFile.isMemoryFile(fileDescriptor)) {
            throw new IllegalArgumentException("Not a memory file.");
        }
        this.mLength = n;
        FileDescriptor fileDescriptor2 = this.mFD = fileDescriptor;
        int n3 = MemoryFile.modeToProt(string2);
        this.mAddress = n2 = MemoryFile.native_mmap(fileDescriptor2, n, n3);
        this.mOwnsRegion = false;
    }

    public MemoryFile(String string2, int n) throws IOException {
        int n2;
        FileDescriptor fileDescriptor;
        this.mLength = n;
        this.mFD = fileDescriptor = MemoryFile.native_open(string2, n);
        this.mAddress = n2 = MemoryFile.native_mmap(this.mFD, n, 3);
        this.mOwnsRegion = true;
    }

    public static int getSize(FileDescriptor fileDescriptor) throws IOException {
        return MemoryFile.native_get_size(fileDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isClosed() {
        if (this.mFD.valid()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDeactivated() {
        if (this.mAddress != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMemoryFile(FileDescriptor fileDescriptor) throws IOException {
        if (MemoryFile.native_get_size(fileDescriptor) < 0) return false;
        return true;
    }

    private static int modeToProt(String string2) {
        if ("r".equals(string2)) {
            return 1;
        }
        String string3 = "Unsupported file mode: '" + string2 + "'";
        throw new IllegalArgumentException(string3);
    }

    private static native void native_close(FileDescriptor var0);

    private static native int native_get_size(FileDescriptor var0) throws IOException;

    private static native int native_mmap(FileDescriptor var0, int var1, int var2) throws IOException;

    private static native void native_munmap(int var0, int var1) throws IOException;

    private static native FileDescriptor native_open(String var0, int var1) throws IOException;

    private static native void native_pin(FileDescriptor var0, boolean var1) throws IOException;

    private static native int native_read(FileDescriptor var0, int var1, byte[] var2, int var3, int var4, int var5, boolean var6) throws IOException;

    private static native void native_write(FileDescriptor var0, int var1, byte[] var2, int var3, int var4, int var5, boolean var6) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean allowPurging(boolean bl) throws IOException {
        synchronized (this) {
            if (!this.mOwnsRegion) {
                throw new IOException("Only the owner can make ashmem regions purgable.");
            }
            boolean bl2 = this.mAllowPurging;
            if (bl2 != bl) {
                FileDescriptor fileDescriptor = this.mFD;
                boolean bl3 = !bl;
                MemoryFile.native_pin(fileDescriptor, bl3);
                this.mAllowPurging = bl;
            }
            return bl2;
        }
    }

    public void close() {
        this.deactivate();
        if (this.isClosed()) {
            return;
        }
        MemoryFile.native_close(this.mFD);
    }

    public void deactivate() {
        if (this.isDeactivated()) {
            return;
        }
        try {
            int n = this.mAddress;
            int n2 = this.mLength;
            MemoryFile.native_munmap(n, n2);
            this.mAddress = 0;
            return;
        }
        catch (IOException iOException) {
            String string2 = TAG;
            String string3 = iOException.toString();
            int n = Log.e(string2, string3);
            return;
        }
    }

    protected void finalize() {
        if (this.isClosed()) {
            return;
        }
        int n = Log.e(TAG, "MemoryFile.finalize() called while ashmem still open");
        this.close();
    }

    public FileDescriptor getFileDescriptor() throws IOException {
        return this.mFD;
    }

    public InputStream getInputStream() {
        return new MemoryInputStream();
    }

    public OutputStream getOutputStream() {
        return new MemoryOutputStream();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParcelFileDescriptor getParcelFileDescriptor() throws IOException {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        if (fileDescriptor == null) return null;
        return new ParcelFileDescriptor(fileDescriptor);
    }

    public boolean isPurgingAllowed() {
        return this.mAllowPurging;
    }

    public int length() {
        return this.mLength;
    }

    public int readBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.isDeactivated()) {
            throw new IOException("Can't read from deactivated memory file.");
        }
        if (n2 < 0 || n2 > (n7 = byArray.length) || n3 < 0 || n3 > (n6 = byArray.length - n2) || n < 0 || n > (n5 = this.mLength) || n3 > (n4 = this.mLength - n)) {
            throw new IndexOutOfBoundsException();
        }
        FileDescriptor fileDescriptor = this.mFD;
        int n8 = this.mAddress;
        boolean bl = this.mAllowPurging;
        byte[] byArray2 = byArray;
        int n9 = n;
        int n10 = n2;
        int n11 = n3;
        return MemoryFile.native_read(fileDescriptor, n8, byArray2, n9, n10, n11, bl);
    }

    public void writeBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.isDeactivated()) {
            throw new IOException("Can't write to deactivated memory file.");
        }
        if (n < 0 || n > (n7 = byArray.length) || n3 < 0 || n3 > (n6 = byArray.length - n) || n2 < 0 || n2 > (n5 = this.mLength) || n3 > (n4 = this.mLength - n2)) {
            throw new IndexOutOfBoundsException();
        }
        FileDescriptor fileDescriptor = this.mFD;
        int n8 = this.mAddress;
        boolean bl = this.mAllowPurging;
        byte[] byArray2 = byArray;
        int n9 = n;
        int n10 = n2;
        int n11 = n3;
        MemoryFile.native_write(fileDescriptor, n8, byArray2, n9, n10, n11, bl);
    }

    private class MemoryOutputStream
    extends OutputStream {
        private int mOffset = 0;
        private byte[] mSingleByte;

        private MemoryOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            byte by;
            if (this.mSingleByte == null) {
                byte[] byArray = new byte[1];
                this.mSingleByte = byArray;
            }
            byte[] byArray = this.mSingleByte;
            byArray[0] = by = (byte)n;
            byte[] byArray2 = this.mSingleByte;
            this.write(byArray2, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            MemoryFile memoryFile = MemoryFile.this;
            int n3 = this.mOffset;
            memoryFile.writeBytes(byArray, n, n3, n2);
        }
    }

    private class MemoryInputStream
    extends InputStream {
        private int mMark = 0;
        private int mOffset = 0;
        private byte[] mSingleByte;

        private MemoryInputStream() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int available() throws IOException {
            int n = this.mOffset;
            int n2 = MemoryFile.this.mLength;
            if (n >= n2) {
                return 0;
            }
            int n3 = MemoryFile.this.mLength;
            int n4 = this.mOffset;
            return n3 - n4;
        }

        @Override
        public void mark(int n) {
            int n2;
            this.mMark = n2 = this.mOffset;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            byte[] byArray;
            if (this.mSingleByte == null) {
                byte[] byArray2 = new byte[1];
                this.mSingleByte = byArray2;
            }
            if (this.read(byArray = this.mSingleByte, 0, 1) == 1) return this.mSingleByte[0];
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n < 0) throw new IndexOutOfBoundsException();
            if (n2 < 0) throw new IndexOutOfBoundsException();
            int n4 = n + n2;
            int n5 = byArray.length;
            if (n4 > n5) {
                throw new IndexOutOfBoundsException();
            }
            int n6 = this.available();
            int n7 = Math.min(n2, n6);
            if (n7 < 1) {
                return -1;
            }
            MemoryFile memoryFile = MemoryFile.this;
            int n8 = this.mOffset;
            int n9 = memoryFile.readBytes(byArray, n8, n, n7);
            if (n9 <= 0) return n9;
            this.mOffset = n3 = this.mOffset + n9;
            return n9;
        }

        @Override
        public void reset() throws IOException {
            int n;
            this.mOffset = n = this.mMark;
        }

        @Override
        public long skip(long l) throws IOException {
            int n;
            long l2 = (long)this.mOffset + l;
            long l3 = MemoryFile.this.mLength;
            if (l2 > l3) {
                int n2 = MemoryFile.this.mLength;
                int n3 = this.mOffset;
                l = n2 - n3;
            }
            this.mOffset = n = (int)((long)this.mOffset + l);
            return l;
        }
    }
}

