/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.TimeUtils;

public final class Message
implements Parcelable {
    public static final Parcelable.Creator<Message> CREATOR;
    private static final int MAX_POOL_SIZE = 10;
    private static Message mPool;
    private static int mPoolSize;
    private static Object mPoolSync;
    public int arg1;
    public int arg2;
    Runnable callback;
    Bundle data;
    Message next;
    public Object obj;
    public Messenger replyTo;
    Handler target;
    public int what;
    long when;

    static {
        mPoolSync = new Object();
        mPoolSize = 0;
        CREATOR = new Parcelable.Creator<Message>(){

            @Override
            public Message createFromParcel(Parcel parcel) {
                Message message = Message.obtain();
                message.readFromParcel(parcel);
                return message;
            }

            public Message[] newArray(int n) {
                return new Message[n];
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message obtain() {
        Object object = mPoolSync;
        synchronized (object) {
            if (mPool == null) return new Message();
            Message message = mPool;
            mPool = message.next;
            message.next = null;
            return message;
        }
    }

    public static Message obtain(Handler handler) {
        Message message = Message.obtain();
        message.target = handler;
        return message;
    }

    public static Message obtain(Handler handler, int n) {
        Message message = Message.obtain();
        message.target = handler;
        message.what = n;
        return message;
    }

    public static Message obtain(Handler handler, int n, int n2, int n3) {
        Message message = Message.obtain();
        message.target = handler;
        message.what = n;
        message.arg1 = n2;
        message.arg2 = n3;
        return message;
    }

    public static Message obtain(Handler handler, int n, int n2, int n3, Object object) {
        Message message = Message.obtain();
        message.target = handler;
        message.what = n;
        message.arg1 = n2;
        message.arg2 = n3;
        message.obj = object;
        return message;
    }

    public static Message obtain(Handler handler, int n, Object object) {
        Message message = Message.obtain();
        message.target = handler;
        message.what = n;
        message.obj = object;
        return message;
    }

    public static Message obtain(Handler handler, Runnable runnable) {
        Message message = Message.obtain();
        message.target = handler;
        message.callback = runnable;
        return message;
    }

    public static Message obtain(Message message) {
        Runnable runnable;
        Handler handler;
        Messenger messenger;
        Object object;
        int n;
        int n2;
        int n3;
        Message message2 = Message.obtain();
        message2.what = n3 = message.what;
        message2.arg1 = n2 = message.arg1;
        message2.arg2 = n = message.arg2;
        message2.obj = object = message.obj;
        message2.replyTo = messenger = message.replyTo;
        if (message.data != null) {
            Bundle bundle;
            Bundle bundle2 = message.data;
            message2.data = bundle = new Bundle(bundle2);
        }
        message2.target = handler = message.target;
        message2.callback = runnable = message.callback;
        return message2;
    }

    private final void readFromParcel(Parcel parcel) {
        Messenger messenger;
        Bundle bundle;
        long l;
        int n;
        int n2;
        int n3;
        this.what = n3 = parcel.readInt();
        this.arg1 = n2 = parcel.readInt();
        this.arg2 = n = parcel.readInt();
        if (parcel.readInt() != 0) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Object t = parcel.readParcelable(classLoader);
            this.obj = t;
        }
        this.when = l = parcel.readLong();
        this.data = bundle = parcel.readBundle();
        this.replyTo = messenger = Messenger.readMessengerOrNullFromParcel(parcel);
    }

    void clearForRecycle() {
        this.what = 0;
        this.arg1 = 0;
        this.arg2 = 0;
        this.obj = null;
        this.replyTo = null;
        this.when = 0L;
        this.target = null;
        this.callback = null;
        this.data = null;
    }

    public void copyFrom(Message message) {
        Messenger messenger;
        Object object;
        int n;
        int n2;
        int n3;
        this.what = n3 = message.what;
        this.arg1 = n2 = message.arg1;
        this.arg2 = n = message.arg2;
        this.obj = object = message.obj;
        this.replyTo = messenger = message.replyTo;
        if (message.data != null) {
            Bundle bundle;
            this.data = bundle = (Bundle)message.data.clone();
            return;
        }
        this.data = null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Runnable getCallback() {
        return this.callback;
    }

    public Bundle getData() {
        if (this.data == null) {
            Bundle bundle;
            this.data = bundle = new Bundle();
        }
        return this.data;
    }

    public Handler getTarget() {
        return this.target;
    }

    public long getWhen() {
        return this.when;
    }

    public Bundle peekData() {
        return this.data;
    }

    public void recycle() {
        Object object = mPoolSync;
        synchronized (object) {
            if (mPoolSize < 10) {
                Message message;
                this.clearForRecycle();
                this.next = message = mPool;
                mPool = this;
            }
            return;
        }
    }

    public void sendToTarget() {
        boolean bl = this.target.sendMessage(this);
    }

    public void setData(Bundle bundle) {
        this.data = bundle;
    }

    public void setTarget(Handler handler) {
        this.target = handler;
    }

    public String toString() {
        long l = SystemClock.uptimeMillis();
        return this.toString(l);
    }

    String toString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("{ what=");
        int n = this.what;
        StringBuilder stringBuilder3 = stringBuilder.append(n);
        StringBuilder stringBuilder4 = stringBuilder.append(" when=");
        TimeUtils.formatDuration(this.when - l, stringBuilder);
        if (this.arg1 != 0) {
            StringBuilder stringBuilder5 = stringBuilder.append(" arg1=");
            int n2 = this.arg1;
            StringBuilder stringBuilder6 = stringBuilder.append(n2);
        }
        if (this.arg2 != 0) {
            StringBuilder stringBuilder7 = stringBuilder.append(" arg2=");
            int n3 = this.arg2;
            StringBuilder stringBuilder8 = stringBuilder.append(n3);
        }
        if (this.obj != null) {
            StringBuilder stringBuilder9 = stringBuilder.append(" obj=");
            Object object = this.obj;
            StringBuilder stringBuilder10 = stringBuilder.append(object);
        }
        StringBuilder stringBuilder11 = stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (this.callback != null) {
            throw new RuntimeException("Can't marshal callbacks across processes.");
        }
        int n2 = this.what;
        parcel.writeInt(n2);
        int n3 = this.arg1;
        parcel.writeInt(n3);
        int n4 = this.arg2;
        parcel.writeInt(n4);
        if (this.obj != null) {
            try {
                Parcelable parcelable = (Parcelable)this.obj;
                parcel.writeInt(1);
                parcel.writeParcelable(parcelable, n);
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException("Can't marshal non-Parcelable objects across processes.");
            }
        } else {
            parcel.writeInt(0);
        }
        long l = this.when;
        parcel.writeLong(l);
        Bundle bundle = this.data;
        parcel.writeBundle(bundle);
        Messenger.writeMessengerOrNullToParcel(this.replyTo, parcel);
    }
}

