/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.util.ArrayList;

public class MessageQueue {
    private boolean mBlocked;
    private final ArrayList<IdleHandler> mIdleHandlers;
    Message mMessages;
    private IdleHandler[] mPendingIdleHandlers;
    private int mPtr;
    boolean mQuitAllowed;
    private boolean mQuiting;

    MessageQueue() {
        ArrayList arrayList = new ArrayList();
        this.mIdleHandlers = arrayList;
        this.mQuitAllowed = true;
        this.nativeInit();
    }

    private native void nativeDestroy();

    private native void nativeInit();

    private native void nativePollOnce(int var1, int var2);

    private native void nativeWake(int var1);

    public final void addIdleHandler(IdleHandler idleHandler) {
        if (idleHandler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        synchronized (this) {
            boolean bl = this.mIdleHandlers.add(idleHandler);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean enqueueMessage(Message message, long l) {
        boolean bl;
        if (message.when != 0L) {
            String string2 = message + " This message is already in use.";
            throw new AndroidRuntimeException(string2);
        }
        if (message.target == null && !this.mQuitAllowed) {
            throw new RuntimeException("Main thread not allowed to quit");
        }
        synchronized (this) {
            long l2;
            if (this.mQuiting) {
                StringBuilder stringBuilder = new StringBuilder();
                Handler handler = message.target;
                String string3 = stringBuilder.append(handler).append(" sending message to a Handler on a dead thread").toString();
                RuntimeException runtimeException = new RuntimeException(string3);
                String string4 = runtimeException.getMessage();
                int n = Log.w("MessageQueue", string4, runtimeException);
                return false;
            }
            if (message.target == null) {
                this.mQuiting = true;
            }
            message.when = l;
            Message message2 = this.mMessages;
            if (message2 != null && l != 0L && l >= (l2 = message2.when)) {
                Message message3;
                Message message4 = null;
                while (message2 != null && message2.when <= l) {
                    message4 = message2;
                    message2 = message2.next;
                }
                message.next = message3 = message4.next;
                message4.next = message;
                return true;
            }
            message.next = message2;
            this.mMessages = message;
            bl = this.mBlocked;
        }
        if (!bl) return true;
        int n = this.mPtr;
        this.nativeWake(n);
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeDestroy();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Message next() {
        int n = -1;
        int n2 = 0;
        while (true) {
            if (n2 != 0) {
                Binder.flushPendingCommands();
            }
            int n3 = this.mPtr;
            this.nativePollOnce(n3, n2);
            synchronized (this) {
                long l = SystemClock.uptimeMillis();
                Message message = this.mMessages;
                if (message != null) {
                    long l2 = message.when;
                    if (l >= l2) {
                        Message message2;
                        this.mBlocked = false;
                        this.mMessages = message2 = message.next;
                        message.next = null;
                        return message;
                    }
                    n2 = (int)Math.min(l2 - l, Integer.MAX_VALUE);
                } else {
                    n2 = -1;
                }
                if (n < 0) {
                    n = this.mIdleHandlers.size();
                }
                if (n == 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    IdleHandler[] idleHandlerArray = new IdleHandler[Math.max(n, 4)];
                    this.mPendingIdleHandlers = idleHandlerArray;
                }
                ArrayList<IdleHandler> arrayList = this.mIdleHandlers;
                IdleHandler[] idleHandlerArray = this.mPendingIdleHandlers;
                IdleHandler[] idleHandlerArray2 = arrayList.toArray(idleHandlerArray);
                this.mPendingIdleHandlers = idleHandlerArray2;
            }
            for (int i = 0; i < n; ++i) {
                IdleHandler idleHandler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean bl = false;
                try {
                    boolean bl2;
                    bl = bl2 = idleHandler.queueIdle();
                }
                catch (Throwable throwable) {
                    int n4 = Log.wtf("MessageQueue", "IdleHandler threw exception", throwable);
                }
                if (bl) continue;
                synchronized (this) {
                    boolean bl3 = this.mIdleHandlers.remove(idleHandler);
                    continue;
                }
            }
            n = 0;
            n2 = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void removeCallbacksAndMessages(Handler handler, Object object) {
        synchronized (this) {
            Message message = this.mMessages;
            while (message != null && message.target == handler && (object == null || message.obj == object)) {
                Message message2;
                this.mMessages = message2 = message.next;
                message.recycle();
                message = message2;
            }
            while (message != null) {
                Message message3 = message.next;
                if (message3 != null && message3.target == handler && (object == null || message3.obj == object)) {
                    Message message4 = message3.next;
                    message3.recycle();
                    message.next = message4;
                    continue;
                }
                message = message3;
            }
            return;
        }
    }

    public final void removeIdleHandler(IdleHandler idleHandler) {
        synchronized (this) {
            boolean bl = this.mIdleHandlers.remove(idleHandler);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void removeMessages(Handler handler, Runnable runnable, Object object) {
        if (runnable == null) {
            return;
        }
        synchronized (this) {
            Message message = this.mMessages;
            while (message != null && message.target == handler && message.callback == runnable && (object == null || message.obj == object)) {
                Message message2;
                this.mMessages = message2 = message.next;
                message.recycle();
                message = message2;
            }
            while (message != null) {
                Message message3 = message.next;
                if (message3 != null && message3.target == handler && message3.callback == runnable && (object == null || message3.obj == object)) {
                    Message message4 = message3.next;
                    message3.recycle();
                    message.next = message4;
                    continue;
                }
                message = message3;
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    final boolean removeMessages(Handler var1_1, int var2_2, Object var3_3, boolean var4_4) {
        synchronized (this) {
            block8: {
                var5_5 = this.mMessages;
                var6_6 = false;
                while (var5_5 != null && var5_5.target == var1_1 && var5_5.what != var2_2 && (var3_3 == null || var5_5.obj == var3_3)) {
                    if (!var4_4) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 7] lbl7 : MonitorExitStatement: MONITOREXIT : this
                        var7_8 = true;
lbl9:
                        // 3 sources

                        return var7_8;
                    }
                    var6_6 = true;
                    this.mMessages = var8_7 = var5_5.next;
                    var5_5.recycle();
                    var5_5 = var8_7;
                }
                break block8;
                while (true) {
                    var6_6 = true;
                    var10_10 = var9_9.next;
                    var9_9.recycle();
                    var5_5.next = var10_10;
                    break;
                }
            }
            while (var5_5 != null) {
                block9: {
                    var9_9 = var5_5.next;
                    if (var9_9 == null || var9_9.target != var1_1 || var9_9.what == var2_2 || var3_3 != null && var9_9.obj != var3_3) break block9;
                    if (var4_4) ** continue;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl26 : MonitorExitStatement: MONITOREXIT : this
                    var7_8 = true;
                    ** GOTO lbl9
                }
                var5_5 = var9_9;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl31 : MonitorExitStatement: MONITOREXIT : this
            var7_8 = var6_6;
            ** continue;
        }
    }

    public static interface IdleHandler {
        public boolean queueIdle();
    }
}

