/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.IBinder;
import android.os.IMessenger;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public final class Messenger
implements Parcelable {
    public static final Parcelable.Creator<Messenger> CREATOR = new Parcelable.Creator<Messenger>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Messenger createFromParcel(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            if (iBinder == null) return null;
            return new Messenger(iBinder);
        }

        public Messenger[] newArray(int n) {
            return new Messenger[n];
        }
    };
    private final IMessenger mTarget;

    public Messenger(Handler handler) {
        IMessenger iMessenger;
        this.mTarget = iMessenger = handler.getIMessenger();
    }

    public Messenger(IBinder iBinder) {
        IMessenger iMessenger;
        this.mTarget = iMessenger = IMessenger.Stub.asInterface(iBinder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Messenger readMessengerOrNullFromParcel(Parcel parcel) {
        IBinder iBinder = parcel.readStrongBinder();
        if (iBinder == null) return null;
        return new Messenger(iBinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeMessengerOrNullToParcel(Messenger messenger, Parcel parcel) {
        IBinder iBinder = messenger != null ? messenger.mTarget.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            IBinder iBinder = this.mTarget.asBinder();
            IBinder iBinder2 = ((Messenger)object).mTarget.asBinder();
            boolean bl = iBinder.equals(iBinder2);
            return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public IBinder getBinder() {
        return this.mTarget.asBinder();
    }

    public int hashCode() {
        return this.mTarget.asBinder().hashCode();
    }

    public void send(Message message) throws RemoteException {
        this.mTarget.send(message);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        IBinder iBinder = this.mTarget.asBinder();
        parcel.writeStrongBinder(iBinder);
    }
}

