/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.StrictMode;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Parcel {
    private static final boolean DEBUG_RECYCLE = false;
    private static final int EX_BAD_PARCELABLE = 254;
    private static final int EX_HAS_REPLY_HEADER = 128;
    private static final int EX_ILLEGAL_ARGUMENT = 253;
    private static final int EX_ILLEGAL_STATE = 251;
    private static final int EX_NULL_POINTER = 252;
    private static final int EX_SECURITY = 255;
    private static final int POOL_SIZE = 6;
    public static final Parcelable.Creator<String> STRING_CREATOR;
    private static final String TAG = "Parcel";
    private static final int VAL_BOOLEAN = 9;
    private static final int VAL_BOOLEANARRAY = 23;
    private static final int VAL_BUNDLE = 3;
    private static final int VAL_BYTE = 20;
    private static final int VAL_BYTEARRAY = 13;
    private static final int VAL_CHARSEQUENCE = 10;
    private static final int VAL_CHARSEQUENCEARRAY = 24;
    private static final int VAL_DOUBLE = 8;
    private static final int VAL_FLOAT = 7;
    private static final int VAL_IBINDER = 15;
    private static final int VAL_INTARRAY = 18;
    private static final int VAL_INTEGER = 1;
    private static final int VAL_LIST = 11;
    private static final int VAL_LONG = 6;
    private static final int VAL_LONGARRAY = 19;
    private static final int VAL_MAP = 2;
    private static final int VAL_NULL = 255;
    private static final int VAL_OBJECTARRAY = 17;
    private static final int VAL_PARCELABLE = 4;
    private static final int VAL_PARCELABLEARRAY = 16;
    private static final int VAL_SERIALIZABLE = 21;
    private static final int VAL_SHORT = 5;
    private static final int VAL_SPARSEARRAY = 12;
    private static final int VAL_SPARSEBOOLEANARRAY = 22;
    private static final int VAL_STRING = 0;
    private static final int VAL_STRINGARRAY = 14;
    private static final HashMap<ClassLoader, HashMap<String, Parcelable.Creator>> mCreators;
    private static final Parcel[] sHolderPool;
    private static final Parcel[] sOwnedPool;
    private int mObject;
    private int mOwnObject;
    private RuntimeException mStack;

    static {
        sOwnedPool = new Parcel[6];
        sHolderPool = new Parcel[6];
        STRING_CREATOR = new Parcelable.Creator<String>(){

            @Override
            public String createFromParcel(Parcel parcel) {
                return parcel.readString();
            }

            public String[] newArray(int n) {
                return new String[n];
            }
        };
        mCreators = new HashMap();
    }

    private Parcel(int n) {
        this.init(n);
    }

    static native void closeFileDescriptor(FileDescriptor var0) throws IOException;

    private native void destroy();

    private native void freeBuffer();

    private native void init(int var1);

    private native FileDescriptor internalReadFileDescriptor();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Parcel obtain() {
        Parcel[] parcelArray = sOwnedPool;
        synchronized (parcelArray) {
            int n = 0;
            while (n < 6) {
                Parcel parcel = parcelArray[n];
                if (parcel != null) {
                    parcelArray[n] = null;
                    return parcel;
                }
                ++n;
            }
            return new Parcel(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final Parcel obtain(int n) {
        Parcel[] parcelArray = sHolderPool;
        synchronized (parcelArray) {
            int n2 = 0;
            while (n2 < 6) {
                Parcel parcel = parcelArray[n2];
                if (parcel != null) {
                    parcelArray[n2] = null;
                    parcel.init(n);
                    return parcel;
                }
                ++n2;
            }
            return new Parcel(n);
        }
    }

    static native FileDescriptor openFileDescriptor(String var0, int var1) throws FileNotFoundException;

    private void readArrayInternal(Object[] objectArray, int n, ClassLoader classLoader) {
        int n2 = 0;
        while (n2 < n) {
            Object object;
            objectArray[n2] = object = this.readValue(classLoader);
            ++n2;
        }
        return;
    }

    private void readListInternal(List list, int n, ClassLoader classLoader) {
        while (n > 0) {
            Object object = this.readValue(classLoader);
            boolean bl = list.add(object);
            n += -1;
        }
        return;
    }

    private void readSparseArrayInternal(SparseArray sparseArray, int n, ClassLoader classLoader) {
        while (n > 0) {
            int n2 = this.readInt();
            Object object = this.readValue(classLoader);
            sparseArray.append(n2, object);
            n += -1;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readSparseBooleanArrayInternal(SparseBooleanArray sparseBooleanArray, int n) {
        while (n > 0) {
            int n2 = this.readInt();
            boolean bl = this.readByte() == 1;
            sparseBooleanArray.append(n2, bl);
            n += -1;
        }
        return;
    }

    private native void writeNative(byte[] var1, int var2, int var3);

    public final native void appendFrom(Parcel var1, int var2, int var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IBinder[] createBinderArray() {
        int n = this.readInt();
        if (n < 0) return null;
        IBinder[] iBinderArray = new IBinder[n];
        int n2 = 0;
        while (n2 < n) {
            IBinder iBinder;
            iBinderArray[n2] = iBinder = this.readStrongBinder();
            ++n2;
        }
        return iBinderArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<IBinder> createBinderArrayList() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList<IBinder> arrayList = new ArrayList<IBinder>(n);
        while (n > 0) {
            IBinder iBinder = this.readStrongBinder();
            boolean bl = arrayList.add(iBinder);
            n += -1;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean[] createBooleanArray() {
        int n = this.readInt();
        if (n < 0) return null;
        int n2 = this.dataAvail() >> 2;
        if (n > n2) return null;
        boolean[] blArray = new boolean[n];
        int n3 = 0;
        while (n3 < n) {
            boolean bl = this.readInt() != 0;
            blArray[n3] = bl;
            ++n3;
        }
        return blArray;
    }

    public final native byte[] createByteArray();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final char[] createCharArray() {
        int n = this.readInt();
        if (n < 0) return null;
        int n2 = this.dataAvail() >> 2;
        if (n > n2) return null;
        char[] cArray = new char[n];
        int n3 = 0;
        while (n3 < n) {
            char c;
            cArray[n3] = c = (char)this.readInt();
            ++n3;
        }
        return cArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final double[] createDoubleArray() {
        int n = this.readInt();
        if (n < 0) return null;
        int n2 = this.dataAvail() >> 3;
        if (n > n2) return null;
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            double d;
            dArray[n3] = d = this.readDouble();
            ++n3;
        }
        return dArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final float[] createFloatArray() {
        int n = this.readInt();
        if (n < 0) return null;
        int n2 = this.dataAvail() >> 2;
        if (n > n2) return null;
        float[] fArray = new float[n];
        int n3 = 0;
        while (n3 < n) {
            float f;
            fArray[n3] = f = this.readFloat();
            ++n3;
        }
        return fArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int[] createIntArray() {
        int n = this.readInt();
        if (n < 0) return null;
        int n2 = this.dataAvail() >> 2;
        if (n > n2) return null;
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            int n4;
            nArray[n3] = n4 = this.readInt();
            ++n3;
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long[] createLongArray() {
        int n = this.readInt();
        if (n < 0) return 0;
        int n2 = this.dataAvail() >> 3;
        if (n > n2) return 0;
        int n3 = n;
        int n4 = 0;
        while (n4 < n) {
            long l;
            n3[n4] = l = this.readLong();
            ++n4;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String[] createStringArray() {
        int n = this.readInt();
        if (n < 0) return null;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string2;
            stringArray[n2] = string2 = this.readString();
            ++n2;
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<String> createStringArrayList() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        while (n > 0) {
            String string2 = this.readString();
            boolean bl = arrayList.add(string2);
            n += -1;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <T> T[] createTypedArray(Parcelable.Creator<T> creator) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        T[] TArray = creator.newArray(n);
        int n2 = 0;
        while (n2 < n) {
            if (this.readInt() != 0) {
                T t;
                TArray[n2] = t = creator.createFromParcel(this);
            }
            ++n2;
        }
        return TArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T> ArrayList<T> createTypedArrayList(Parcelable.Creator<T> creator) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>(n);
        while (n > 0) {
            if (this.readInt() != 0) {
                T t = creator.createFromParcel(this);
                boolean bl = arrayList.add(t);
            } else {
                boolean bl = arrayList.add(null);
            }
            n += -1;
        }
        return arrayList;
    }

    public final native int dataAvail();

    public final native int dataCapacity();

    public final native int dataPosition();

    public final native int dataSize();

    public final native void enforceInterface(String var1);

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public final native boolean hasFileDescriptors();

    public final native byte[] marshall();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object[] readArray(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        this.readArrayInternal(objectArray, n, classLoader);
        return objectArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList readArrayList(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(n);
        this.readListInternal(arrayList, n, classLoader);
        return arrayList;
    }

    public final void readBinderArray(IBinder[] iBinderArray) {
        int n;
        int n2 = this.readInt();
        if (n2 != (n = iBinderArray.length)) {
            int n3 = 0;
            while (true) {
                IBinder iBinder;
                if (n3 >= n2) {
                    return;
                }
                iBinderArray[n3] = iBinder = this.readStrongBinder();
                ++n3;
            }
        }
        throw new RuntimeException("bad array lengths");
    }

    public final void readBinderList(List<IBinder> list) {
        int n;
        int n2 = list.size();
        int n3 = this.readInt();
        for (n = 0; n < n2 && n < n3; ++n) {
            IBinder iBinder = this.readStrongBinder();
            IBinder iBinder2 = list.set(n, iBinder);
        }
        while (n < n3) {
            IBinder iBinder = this.readStrongBinder();
            boolean bl = list.add(iBinder);
            ++n;
        }
        while (n < n2) {
            IBinder iBinder = list.remove(n3);
            ++n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void readBooleanArray(boolean[] blArray) {
        int n;
        int n2 = this.readInt();
        if (n2 == (n = blArray.length)) {
            throw new RuntimeException("bad array lengths");
        }
        int n3 = 0;
        while (n3 < n2) {
            boolean bl = this.readInt() != 0;
            blArray[n3] = bl;
            ++n3;
        }
        return;
    }

    public final Bundle readBundle() {
        return this.readBundle(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Bundle readBundle(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        Bundle bundle = new Bundle(this, n);
        if (classLoader == null) return bundle;
        bundle.setClassLoader(classLoader);
        return bundle;
    }

    public final byte readByte() {
        return (byte)(this.readInt() & 0xFF);
    }

    public final void readByteArray(byte[] byArray) {
        int n;
        byte[] byArray2 = this.createByteArray();
        int n2 = byArray2.length;
        if (n2 != (n = byArray.length)) {
            int n3 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, 0, n3);
            return;
        }
        throw new RuntimeException("bad array lengths");
    }

    public final void readCharArray(char[] cArray) {
        int n;
        int n2 = this.readInt();
        if (n2 != (n = cArray.length)) {
            int n3 = 0;
            while (true) {
                char c;
                if (n3 >= n2) {
                    return;
                }
                cArray[n3] = c = (char)this.readInt();
                ++n3;
            }
        }
        throw new RuntimeException("bad array lengths");
    }

    public final CharSequence readCharSequence() {
        return TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(this);
    }

    public final CharSequence[] readCharSequenceArray() {
        CharSequence[] charSequenceArray = null;
        int n = this.readInt();
        if (n >= 0) {
            charSequenceArray = new CharSequence[n];
            for (int i = 0; i < n; ++i) {
                CharSequence charSequence;
                charSequenceArray[i] = charSequence = this.readCharSequence();
            }
        }
        return charSequenceArray;
    }

    public final native double readDouble();

    public final void readDoubleArray(double[] dArray) {
        int n;
        int n2 = this.readInt();
        if (n2 != (n = dArray.length)) {
            int n3 = 0;
            while (true) {
                double d;
                if (n3 >= n2) {
                    return;
                }
                dArray[n3] = d = this.readDouble();
                ++n3;
            }
        }
        throw new RuntimeException("bad array lengths");
    }

    public final void readException() {
        int n = this.readExceptionCode();
        if (n == 0) {
            return;
        }
        String string2 = this.readString();
        this.readException(n, string2);
    }

    public final void readException(int n, String string2) {
        switch (n) {
            default: {
                String string3 = "Unknown exception code: " + n + " msg " + string2;
                throw new RuntimeException(string3);
            }
            case -1: {
                throw new SecurityException(string2);
            }
            case -2: {
                throw new BadParcelableException(string2);
            }
            case -3: {
                throw new IllegalArgumentException(string2);
            }
            case -4: {
                throw new NullPointerException(string2);
            }
            case -5: 
        }
        throw new IllegalStateException(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int readExceptionCode() {
        int n = this.readInt();
        if (n != 65408) return n;
        if (this.readInt() == 0) {
            int n2 = Log.e(TAG, "Unexpected zero-sized Parcel reply header.");
            return 0;
        }
        StrictMode.readAndHandleBinderCallViolations(this);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ParcelFileDescriptor readFileDescriptor() {
        FileDescriptor fileDescriptor = this.internalReadFileDescriptor();
        if (fileDescriptor == null) return null;
        return new ParcelFileDescriptor(fileDescriptor);
    }

    public final native float readFloat();

    public final void readFloatArray(float[] fArray) {
        int n;
        int n2 = this.readInt();
        if (n2 != (n = fArray.length)) {
            int n3 = 0;
            while (true) {
                float f;
                if (n3 >= n2) {
                    return;
                }
                fArray[n3] = f = this.readFloat();
                ++n3;
            }
        }
        throw new RuntimeException("bad array lengths");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final HashMap readHashMap(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        HashMap hashMap = new HashMap(n);
        this.readMapInternal(hashMap, n, classLoader);
        return hashMap;
    }

    public final native int readInt();

    public final void readIntArray(int[] nArray) {
        int n;
        int n2 = this.readInt();
        if (n2 != (n = nArray.length)) {
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 >= n2) {
                    return;
                }
                nArray[n3] = n4 = this.readInt();
                ++n3;
            }
        }
        throw new RuntimeException("bad array lengths");
    }

    public final void readList(List list, ClassLoader classLoader) {
        int n = this.readInt();
        this.readListInternal(list, n, classLoader);
    }

    public final native long readLong();

    public final void readLongArray(long[] lArray) {
        int n;
        int n2 = this.readInt();
        if (n2 != (n = lArray.length)) {
            int n3 = 0;
            while (true) {
                long l;
                if (n3 >= n2) {
                    return;
                }
                lArray[n3] = l = this.readLong();
                ++n3;
            }
        }
        throw new RuntimeException("bad array lengths");
    }

    public final void readMap(Map map, ClassLoader classLoader) {
        int n = this.readInt();
        this.readMapInternal(map, n, classLoader);
    }

    void readMapInternal(Map map, int n, ClassLoader classLoader) {
        while (n > 0) {
            Object object = this.readValue(classLoader);
            Object object2 = this.readValue(classLoader);
            Object object3 = map.put(object, object2);
            n += -1;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T extends Parcelable> T readParcelable(ClassLoader var1_1) {
        block12: {
            var2_2 = false;
            var3_3 = this.readString();
            if (var3_3 == null) {
                var4_4 = null;
                return (T)var4_4;
            }
            var5_5 = Parcel.mCreators;
            synchronized (var5_5) {
                block14: {
                    block13: {
                        var6_6 = Parcel.mCreators.get(var1_1);
                        if (var6_6 == null) {
                            var6_6 = new HashMap<K, V>();
                            var7_7 = Parcel.mCreators.put(var1_1, var6_6);
                        }
                        if ((var8_8 = var6_6.get(var3_3)) != null) break block12;
                        if (var1_1 != null) break block13;
                        try {
                            var9_9 = Class.forName(var3_3);
                        }
                        catch (IllegalAccessException var13_12) {
                            var14_13 = "Class not found when unmarshalling: " + var3_3 + ", e: " + var13_12;
                            var15_14 = Log.e("Parcel", var14_13);
                            var16_15 = "IllegalAccessException when unmarshalling: " + var3_3;
                            throw new BadParcelableException(var16_15);
                        }
                        catch (ClassNotFoundException var17_16) {
                            var18_17 = "Class not found when unmarshalling: " + var3_3 + ", e: " + var17_16;
                            var19_18 = Log.e("Parcel", var18_17);
                            var20_19 = "ClassNotFoundException when unmarshalling: " + var3_3;
                            throw new BadParcelableException(var20_19);
                        }
                        catch (ClassCastException var21_20) {
                            var22_21 = "Parcelable protocol requires a Parcelable.Creator object called  CREATOR on class " + var3_3;
                            throw new BadParcelableException(var22_21);
                        }
                        catch (NoSuchFieldException var23_22) {
                            var24_23 = "Parcelable protocol requires a Parcelable.Creator object called  CREATOR on class " + var3_3;
                            throw new BadParcelableException(var24_23);
                        }
lbl33:
                        // 2 sources

                        while ((var8_8 = (Parcelable.Creator)var9_9.getField("CREATOR").get(null)) == null) {
                            var10_10 = "Parcelable protocol requires a Parcelable.Creator object called  CREATOR on class " + var3_3;
                            throw new BadParcelableException(var10_10);
                        }
                        break block14;
                    }
                    var2_2 = true;
                    {
                        var12_11 = Class.forName(var3_3, var2_2, var1_1);
                        var9_9 = var12_11;
                        ** GOTO lbl33
                    }
                }
                var25_24 = var6_6.put(var3_3, var8_8);
            }
        }
        var4_4 = (Parcelable)var8_8.createFromParcel(this);
        return (T)var4_4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Parcelable[] readParcelableArray(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        Parcelable[] parcelableArray = new Parcelable[n];
        int n2 = 0;
        while (n2 < n) {
            Object t = this.readParcelable(classLoader);
            parcelableArray[n2] = t;
            ++n2;
        }
        return parcelableArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Serializable readSerializable() {
        String string2 = ((Parcel)((Object)serializable)).readString();
        if (string2 == null) {
            return null;
        }
        byte[] byArray = ((Parcel)((Object)serializable)).createByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            Serializable serializable = (Serializable)new ObjectInputStream(byteArrayInputStream).readObject();
            return serializable;
        }
        catch (IOException iOException) {
            String string3 = "Parcelable encountered IOException reading a Serializable object (name = " + string2 + ")";
            throw new RuntimeException(string3, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string4 = "Parcelable encounteredClassNotFoundException reading a Serializable object (name = " + string2 + ")";
            throw new RuntimeException(string4, classNotFoundException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final SparseArray readSparseArray(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray(n);
        this.readSparseArrayInternal(sparseArray, n, classLoader);
        return sparseArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final SparseBooleanArray readSparseBooleanArray() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        SparseBooleanArray sparseBooleanArray = new SparseBooleanArray(n);
        this.readSparseBooleanArrayInternal(sparseBooleanArray, n);
        return sparseBooleanArray;
    }

    public final native String readString();

    public final void readStringArray(String[] stringArray) {
        int n;
        int n2 = this.readInt();
        if (n2 != (n = stringArray.length)) {
            int n3 = 0;
            while (true) {
                String string2;
                if (n3 >= n2) {
                    return;
                }
                stringArray[n3] = string2 = this.readString();
                ++n3;
            }
        }
        throw new RuntimeException("bad array lengths");
    }

    public final String[] readStringArray() {
        String[] stringArray = null;
        int n = this.readInt();
        if (n >= 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                String string2;
                stringArray[i] = string2 = this.readString();
            }
        }
        return stringArray;
    }

    public final void readStringList(List<String> list) {
        int n;
        int n2 = list.size();
        int n3 = this.readInt();
        for (n = 0; n < n2 && n < n3; ++n) {
            String string2 = this.readString();
            String string3 = list.set(n, string2);
        }
        while (n < n3) {
            String string4 = this.readString();
            boolean bl = list.add(string4);
            ++n;
        }
        while (n < n2) {
            String string5 = list.remove(n3);
            ++n;
        }
        return;
    }

    public final native IBinder readStrongBinder();

    /*
     * Enabled aggressive block sorting
     */
    public final <T> void readTypedArray(T[] TArray, Parcelable.Creator<T> creator) {
        int n;
        int n2 = this.readInt();
        if (n2 == (n = TArray.length)) {
            throw new RuntimeException("bad array lengths");
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.readInt() != 0) {
                T t = creator.createFromParcel(this);
                TArray[n3] = t;
            } else {
                TArray[n3] = null;
            }
            ++n3;
        }
        return;
    }

    @Deprecated
    public final <T> T[] readTypedArray(Parcelable.Creator<T> creator) {
        return this.createTypedArray(creator);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T> void readTypedList(List<T> list, Parcelable.Creator<T> creator) {
        int n;
        int n2 = list.size();
        int n3 = this.readInt();
        for (n = 0; n < n2 && n < n3; ++n) {
            if (this.readInt() != 0) {
                T t = creator.createFromParcel(this);
                T t2 = list.set(n, t);
                continue;
            }
            Object var8_8 = list.set(n, null);
        }
        while (n < n3) {
            if (this.readInt() != 0) {
                T t = creator.createFromParcel(this);
                boolean bl = list.add(t);
            } else {
                boolean bl = list.add(null);
            }
            ++n;
        }
        while (n < n2) {
            T t = list.remove(n3);
            ++n;
        }
        return;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final Object readValue(ClassLoader classLoader) {
        void var5_6;
        int n = this.readInt();
        switch (n) {
            default: {
                int n2 = this.dataPosition() - 4;
                String string2 = "Parcel " + this + ": Unmarshalling unknown type code " + n + " at offset " + n2;
                throw new RuntimeException(string2);
            }
            case -1: {
                return var5_6;
            }
            case 0: {
                String string3 = this.readString();
                return var5_6;
            }
            case 1: {
                Integer n3 = this.readInt();
                return var5_6;
            }
            case 2: {
                HashMap hashMap = this.readHashMap(classLoader);
                return var5_6;
            }
            case 4: {
                Object t = this.readParcelable(classLoader);
                return var5_6;
            }
            case 5: {
                Short s = (short)this.readInt();
                return var5_6;
            }
            case 6: {
                Long l = this.readLong();
                return var5_6;
            }
            case 7: {
                Float f = Float.valueOf(this.readFloat());
                return var5_6;
            }
            case 8: {
                Double d = this.readDouble();
                return var5_6;
            }
            case 9: {
                boolean bl = this.readInt() == 1;
                Boolean bl2 = bl;
                return var5_6;
            }
            case 10: {
                CharSequence charSequence = this.readCharSequence();
                return var5_6;
            }
            case 11: {
                ArrayList arrayList = this.readArrayList(classLoader);
                return var5_6;
            }
            case 23: {
                boolean[] blArray = this.createBooleanArray();
                return var5_6;
            }
            case 13: {
                byte[] byArray = this.createByteArray();
                return var5_6;
            }
            case 14: {
                String[] stringArray = this.readStringArray();
                return var5_6;
            }
            case 24: {
                CharSequence[] charSequenceArray = this.readCharSequenceArray();
                return var5_6;
            }
            case 15: {
                IBinder iBinder = this.readStrongBinder();
                return var5_6;
            }
            case 17: {
                Object[] objectArray = this.readArray(classLoader);
                return var5_6;
            }
            case 18: {
                int[] nArray = this.createIntArray();
                return var5_6;
            }
            case 19: {
                long[] lArray = this.createLongArray();
                return var5_6;
            }
            case 20: {
                Byte by = this.readByte();
                return var5_6;
            }
            case 21: {
                Serializable serializable = this.readSerializable();
                return var5_6;
            }
            case 16: {
                Parcelable[] parcelableArray = this.readParcelableArray(classLoader);
                return var5_6;
            }
            case 12: {
                SparseArray sparseArray = this.readSparseArray(classLoader);
                return var5_6;
            }
            case 22: {
                SparseBooleanArray sparseBooleanArray = this.readSparseBooleanArray();
                return var5_6;
            }
            case 3: 
        }
        Bundle bundle = this.readBundle(classLoader);
        return var5_6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void recycle() {
        this.freeBuffer();
        Parcel[] parcelArray = this.mOwnObject != 0 ? sOwnedPool : sHolderPool;
        synchronized (parcelArray) {
            int n = 0;
            while (n < 6) {
                if (parcelArray[n] == null) {
                    parcelArray[n] = this;
                    return;
                }
                ++n;
            }
            return;
        }
    }

    public final native void setDataCapacity(int var1);

    public final native void setDataPosition(int var1);

    public final native void setDataSize(int var1);

    public final native void unmarshall(byte[] var1, int var2, int var3);

    public final void writeArray(Object[] objectArray) {
        if (objectArray == null) {
            this.writeInt(-1);
            return;
        }
        int n = objectArray.length;
        int n2 = 0;
        this.writeInt(n);
        while (n2 < n) {
            Object object = objectArray[n2];
            this.writeValue(object);
            ++n2;
        }
        return;
    }

    public final void writeBinderArray(IBinder[] iBinderArray) {
        if (iBinderArray != null) {
            int n = iBinderArray.length;
            this.writeInt(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                IBinder iBinder = iBinderArray[n2];
                this.writeStrongBinder(iBinder);
                ++n2;
            }
        }
        this.writeInt(-1);
    }

    public final void writeBinderList(List<IBinder> list) {
        if (list == null) {
            this.writeInt(-1);
            return;
        }
        int n = list.size();
        int n2 = 0;
        this.writeInt(n);
        while (n2 < n) {
            IBinder iBinder = list.get(n2);
            this.writeStrongBinder(iBinder);
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeBooleanArray(boolean[] blArray) {
        if (blArray == null) {
            this.writeInt(-1);
            return;
        }
        int n = blArray.length;
        this.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = blArray[n2] != null ? 1 : 0;
            this.writeInt(n3);
            ++n2;
        }
        return;
    }

    public final void writeBundle(Bundle bundle) {
        if (bundle == null) {
            this.writeInt(-1);
            return;
        }
        bundle.writeToParcel(this, 0);
    }

    public final void writeByte(byte by) {
        this.writeInt(by);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeByteArray(byte[] byArray) {
        int n = byArray != null ? byArray.length : 0;
        this.writeByteArray(byArray, 0, n);
    }

    public final void writeByteArray(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            this.writeInt(-1);
            return;
        }
        int n3 = byArray.length;
        int n4 = n + n2;
        if (n3 < n4 || n2 < 0 || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.writeNative(byArray, n, n2);
    }

    public final void writeCharArray(char[] cArray) {
        if (cArray != null) {
            int n = cArray.length;
            this.writeInt(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                char c = cArray[n2];
                this.writeInt(c);
                ++n2;
            }
        }
        this.writeInt(-1);
    }

    public final void writeCharSequence(CharSequence charSequence) {
        TextUtils.writeToParcel(charSequence, this, 0);
    }

    public final void writeCharSequenceArray(CharSequence[] charSequenceArray) {
        if (charSequenceArray != null) {
            int n = charSequenceArray.length;
            this.writeInt(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                CharSequence charSequence = charSequenceArray[n2];
                this.writeCharSequence(charSequence);
                ++n2;
            }
        }
        this.writeInt(-1);
    }

    public final native void writeDouble(double var1);

    public final void writeDoubleArray(double[] dArray) {
        if (dArray != null) {
            int n = dArray.length;
            this.writeInt(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                double d = dArray[n2];
                this.writeDouble(d);
                ++n2;
            }
        }
        this.writeInt(-1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeException(Exception exception) {
        int n = 0;
        if (exception instanceof SecurityException) {
            n = -1;
        } else if (exception instanceof BadParcelableException) {
            n = -1;
        } else if (exception instanceof IllegalArgumentException) {
            n = -1;
        } else if (exception instanceof NullPointerException) {
            n = -1;
        } else if (exception instanceof IllegalStateException) {
            n = -1;
        }
        this.writeInt(n);
        StrictMode.clearGatheredViolations();
        if (n != 0) {
            String string2 = exception.getMessage();
            this.writeString(string2);
            return;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public final native void writeFileDescriptor(FileDescriptor var1);

    public final native void writeFloat(float var1);

    public final void writeFloatArray(float[] fArray) {
        if (fArray != null) {
            int n = fArray.length;
            this.writeInt(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                float f = fArray[n2];
                this.writeFloat(f);
                ++n2;
            }
        }
        this.writeInt(-1);
    }

    public final native void writeInt(int var1);

    public final void writeIntArray(int[] nArray) {
        if (nArray != null) {
            int n = nArray.length;
            this.writeInt(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                int n3 = nArray[n2];
                this.writeInt(n3);
                ++n2;
            }
        }
        this.writeInt(-1);
    }

    public final native void writeInterfaceToken(String var1);

    public final void writeList(List list) {
        if (list == null) {
            this.writeInt(-1);
            return;
        }
        int n = list.size();
        int n2 = 0;
        this.writeInt(n);
        while (n2 < n) {
            Object e = list.get(n2);
            this.writeValue(e);
            ++n2;
        }
        return;
    }

    public final native void writeLong(long var1);

    public final void writeLongArray(long[] lArray) {
        if (lArray != null) {
            int n = lArray.length;
            this.writeInt(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                long l = lArray[n2];
                this.writeLong(l);
                ++n2;
            }
        }
        this.writeInt(-1);
    }

    public final void writeMap(Map map) {
        this.writeMapInternal(map);
    }

    void writeMapInternal(Map<String, Object> map) {
        if (map == null) {
            this.writeInt(-1);
            return;
        }
        Set<Map.Entry<String, Object>> set = map.entrySet();
        int n = set.size();
        this.writeInt(n);
        Iterator<Map.Entry<String, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String string2 = entry.getKey();
            this.writeValue(string2);
            Object object = entry.getValue();
            this.writeValue(object);
        }
        return;
    }

    public final void writeNoException() {
        if (StrictMode.hasGatheredViolations()) {
            this.writeInt(65408);
            int n = this.dataPosition();
            this.writeInt(0);
            StrictMode.writeGatheredViolationsToParcel(this);
            int n2 = this.dataPosition();
            this.setDataPosition(n);
            int n3 = n2 - n;
            this.writeInt(n3);
            this.setDataPosition(n2);
            return;
        }
        this.writeInt(0);
    }

    public final void writeParcelable(Parcelable parcelable, int n) {
        if (parcelable == null) {
            this.writeString(null);
            return;
        }
        String string2 = parcelable.getClass().getName();
        this.writeString(string2);
        parcelable.writeToParcel(this, n);
    }

    public final <T extends Parcelable> void writeParcelableArray(T[] TArray, int n) {
        if (TArray != null) {
            int n2 = TArray.length;
            this.writeInt(n2);
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return;
                }
                T t = TArray[n3];
                this.writeParcelable((Parcelable)t, n);
                ++n3;
            }
        }
        this.writeInt(-1);
    }

    public final void writeSerializable(Serializable serializable) {
        if (serializable == null) {
            this.writeString(null);
            return;
        }
        String string2 = serializable.getClass().getName();
        this.writeString(string2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.writeByteArray(byArray);
            return;
        }
        catch (IOException iOException) {
            String string3 = "Parcelable encountered IOException writing serializable object (name = " + string2 + ")";
            throw new RuntimeException(string3, iOException);
        }
    }

    public final void writeSparseArray(SparseArray<Object> sparseArray) {
        if (sparseArray == null) {
            this.writeInt(-1);
            return;
        }
        int n = sparseArray.size();
        this.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = sparseArray.keyAt(n2);
            this.writeInt(n3);
            Object object = sparseArray.valueAt(n2);
            this.writeValue(object);
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeSparseBooleanArray(SparseBooleanArray sparseBooleanArray) {
        if (sparseBooleanArray == null) {
            this.writeInt(-1);
            return;
        }
        int n = sparseBooleanArray.size();
        this.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = sparseBooleanArray.keyAt(n2);
            this.writeInt(n3);
            boolean bl = sparseBooleanArray.valueAt(n2);
            byte by = (byte)(bl ? 1 : 0);
            this.writeByte(by);
            ++n2;
        }
        return;
    }

    public final native void writeString(String var1);

    public final void writeStringArray(String[] stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            this.writeInt(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                String string2 = stringArray[n2];
                this.writeString(string2);
                ++n2;
            }
        }
        this.writeInt(-1);
    }

    public final void writeStringList(List<String> list) {
        if (list == null) {
            this.writeInt(-1);
            return;
        }
        int n = list.size();
        int n2 = 0;
        this.writeInt(n);
        while (n2 < n) {
            String string2 = list.get(n2);
            this.writeString(string2);
            ++n2;
        }
        return;
    }

    public final native void writeStrongBinder(IBinder var1);

    /*
     * Enabled aggressive block sorting
     */
    public final void writeStrongInterface(IInterface iInterface) {
        IBinder iBinder = iInterface == null ? null : iInterface.asBinder();
        this.writeStrongBinder(iBinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T extends Parcelable> void writeTypedArray(T[] TArray, int n) {
        if (TArray == null) {
            this.writeInt(-1);
            return;
        }
        int n2 = TArray.length;
        this.writeInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            T t = TArray[n3];
            if (t != null) {
                this.writeInt(1);
                t.writeToParcel(this, n);
            } else {
                this.writeInt(0);
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T extends Parcelable> void writeTypedList(List<T> list) {
        if (list == null) {
            this.writeInt(-1);
            return;
        }
        int n = list.size();
        int n2 = 0;
        this.writeInt(n);
        while (n2 < n) {
            Parcelable parcelable = (Parcelable)list.get(n2);
            if (parcelable != null) {
                this.writeInt(1);
                parcelable.writeToParcel(this, 0);
            } else {
                this.writeInt(0);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeValue(Object object) {
        if (object == null) {
            this.writeInt(-1);
            return;
        }
        if (object instanceof String) {
            this.writeInt(0);
            String string2 = (String)object;
            this.writeString(string2);
            return;
        }
        if (object instanceof Integer) {
            this.writeInt(1);
            int n = (Integer)object;
            this.writeInt(n);
            return;
        }
        if (object instanceof Map) {
            this.writeInt(2);
            Map map = (Map)object;
            this.writeMap(map);
            return;
        }
        if (object instanceof Bundle) {
            this.writeInt(3);
            Bundle bundle = (Bundle)object;
            this.writeBundle(bundle);
            return;
        }
        if (object instanceof Parcelable) {
            this.writeInt(4);
            Parcelable parcelable = (Parcelable)object;
            this.writeParcelable(parcelable, 0);
            return;
        }
        if (object instanceof Short) {
            this.writeInt(5);
            int n = ((Short)object).intValue();
            this.writeInt(n);
            return;
        }
        if (object instanceof Long) {
            this.writeInt(6);
            long l = (Long)object;
            this.writeLong(l);
            return;
        }
        if (object instanceof Float) {
            this.writeInt(7);
            float f = ((Float)object).floatValue();
            this.writeFloat(f);
            return;
        }
        if (object instanceof Double) {
            this.writeInt(8);
            double d = (Double)object;
            this.writeDouble(d);
            return;
        }
        if (object instanceof Boolean) {
            this.writeInt(9);
            int n = (Boolean)object != false ? 1 : 0;
            this.writeInt(n);
            return;
        }
        if (object instanceof CharSequence) {
            this.writeInt(10);
            CharSequence charSequence = (CharSequence)object;
            this.writeCharSequence(charSequence);
            return;
        }
        if (object instanceof List) {
            this.writeInt(11);
            List list = (List)object;
            this.writeList(list);
            return;
        }
        if (object instanceof SparseArray) {
            this.writeInt(12);
            SparseArray sparseArray = (SparseArray)object;
            this.writeSparseArray(sparseArray);
            return;
        }
        if (object instanceof boolean[]) {
            this.writeInt(23);
            boolean[] blArray = (boolean[])object;
            this.writeBooleanArray(blArray);
            return;
        }
        if (object instanceof byte[]) {
            this.writeInt(13);
            byte[] byArray = (byte[])object;
            this.writeByteArray(byArray);
            return;
        }
        if (object instanceof String[]) {
            this.writeInt(14);
            String[] stringArray = (String[])object;
            this.writeStringArray(stringArray);
            return;
        }
        if (object instanceof CharSequence[]) {
            this.writeInt(24);
            CharSequence[] charSequenceArray = (CharSequence[])object;
            this.writeCharSequenceArray(charSequenceArray);
            return;
        }
        if (object instanceof IBinder) {
            this.writeInt(15);
            IBinder iBinder = (IBinder)object;
            this.writeStrongBinder(iBinder);
            return;
        }
        if (object instanceof Parcelable[]) {
            this.writeInt(16);
            Parcelable[] parcelableArray = (Parcelable[])object;
            this.writeParcelableArray(parcelableArray, 0);
            return;
        }
        if (object instanceof Object[]) {
            this.writeInt(17);
            Object[] objectArray = (Object[])object;
            this.writeArray(objectArray);
            return;
        }
        if (object instanceof int[]) {
            this.writeInt(18);
            int[] nArray = (int[])object;
            this.writeIntArray(nArray);
            return;
        }
        if (object instanceof long[]) {
            this.writeInt(19);
            long[] lArray = (long[])object;
            this.writeLongArray(lArray);
            return;
        }
        if (object instanceof Byte) {
            this.writeInt(20);
            byte by = (Byte)object;
            this.writeInt(by);
            return;
        }
        if (object instanceof Serializable) {
            this.writeInt(21);
            Serializable serializable = (Serializable)object;
            this.writeSerializable(serializable);
            return;
        }
        String string3 = "Parcel: unable to marshal value " + object;
        throw new RuntimeException(string3);
    }
}

