/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;

public class ParcelFileDescriptor
implements Parcelable {
    public static final Parcelable.Creator<ParcelFileDescriptor> CREATOR = new Parcelable.Creator<ParcelFileDescriptor>(){

        @Override
        public ParcelFileDescriptor createFromParcel(Parcel parcel) {
            return parcel.readFileDescriptor();
        }

        public ParcelFileDescriptor[] newArray(int n) {
            return new ParcelFileDescriptor[n];
        }
    };
    public static final int MODE_APPEND = 0x2000000;
    public static final int MODE_CREATE = 0x8000000;
    public static final int MODE_READ_ONLY = 0x10000000;
    public static final int MODE_READ_WRITE = 0x30000000;
    public static final int MODE_TRUNCATE = 0x4000000;
    public static final int MODE_WORLD_READABLE = 1;
    public static final int MODE_WORLD_WRITEABLE = 2;
    public static final int MODE_WRITE_ONLY = 0x20000000;
    private boolean mClosed;
    private final FileDescriptor mFileDescriptor;
    private final ParcelFileDescriptor mParcelDescriptor;

    public ParcelFileDescriptor(ParcelFileDescriptor parcelFileDescriptor) {
        FileDescriptor fileDescriptor;
        this.mParcelDescriptor = parcelFileDescriptor;
        this.mFileDescriptor = fileDescriptor = this.mParcelDescriptor.mFileDescriptor;
    }

    ParcelFileDescriptor(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException("descriptor must not be null");
        }
        this.mFileDescriptor = fileDescriptor;
        this.mParcelDescriptor = null;
    }

    public static ParcelFileDescriptor[] createPipe() throws IOException {
        FileDescriptor[] fileDescriptorArray = new FileDescriptor[2];
        int n = ParcelFileDescriptor.createPipeNative(fileDescriptorArray);
        if (n == 0) {
            ParcelFileDescriptor parcelFileDescriptor;
            ParcelFileDescriptor parcelFileDescriptor2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = new ParcelFileDescriptor[2];
            FileDescriptor fileDescriptor = fileDescriptorArray[0];
            parcelFileDescriptorArray[0] = parcelFileDescriptor2 = new ParcelFileDescriptor(fileDescriptor);
            FileDescriptor fileDescriptor2 = fileDescriptorArray[1];
            parcelFileDescriptorArray[1] = parcelFileDescriptor = new ParcelFileDescriptor(fileDescriptor2);
            return parcelFileDescriptorArray;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unable to create pipe: errno=");
        int n2 = -n;
        String string2 = stringBuilder.append(n2).toString();
        throw new IOException(string2);
    }

    private static native int createPipeNative(FileDescriptor[] var0);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParcelFileDescriptor fromSocket(Socket socket) {
        FileDescriptor fileDescriptor = ParcelFileDescriptor.getFileDescriptorFromSocket(socket);
        if (fileDescriptor == null) return null;
        return new ParcelFileDescriptor(fileDescriptor);
    }

    private static native FileDescriptor getFileDescriptorFromSocket(Socket var0);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParcelFileDescriptor open(File file, int n) throws FileNotFoundException {
        String string2 = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string2);
            if ((0x20000000 & n) != 0) {
                securityManager.checkWrite(string2);
            }
        }
        if ((0x30000000 & n) == 0) {
            throw new IllegalArgumentException("Must specify MODE_READ_ONLY, MODE_WRITE_ONLY, or MODE_READ_WRITE");
        }
        FileDescriptor fileDescriptor = Parcel.openFileDescriptor(string2, n);
        if (fileDescriptor == null) return null;
        return new ParcelFileDescriptor(fileDescriptor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        // MONITORENTER : this
        if (this.mClosed) {
            // MONITOREXIT : this
            return;
        }
        this.mClosed = true;
        // MONITOREXIT : this
        if (this.mParcelDescriptor != null) {
            this.mParcelDescriptor.close();
            return;
        }
        Parcel.closeFileDescriptor(this.mFileDescriptor);
    }

    @Override
    public int describeContents() {
        return 1;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.mClosed) {
                this.close();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public FileDescriptor getFileDescriptor() {
        return this.mFileDescriptor;
    }

    public native long getStatSize();

    public native long seekTo(long var1);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("{ParcelFileDescriptor: ");
        FileDescriptor fileDescriptor = this.mFileDescriptor;
        return stringBuilder.append(fileDescriptor).append("}").toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        FileDescriptor fileDescriptor = this.mFileDescriptor;
        parcel.writeFileDescriptor(fileDescriptor);
        if ((n & 1) == 0) {
            return;
        }
        if (this.mClosed) {
            return;
        }
        try {
            this.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static class AutoCloseOutputStream
    extends FileOutputStream {
        private final ParcelFileDescriptor mFd;

        public AutoCloseOutputStream(ParcelFileDescriptor parcelFileDescriptor) {
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            super(fileDescriptor);
            this.mFd = parcelFileDescriptor;
        }

        @Override
        public void close() throws IOException {
            this.mFd.close();
        }
    }

    public static class AutoCloseInputStream
    extends FileInputStream {
        private final ParcelFileDescriptor mFd;

        public AutoCloseInputStream(ParcelFileDescriptor parcelFileDescriptor) {
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            super(fileDescriptor);
            this.mFd = parcelFileDescriptor;
        }

        @Override
        public void close() throws IOException {
            this.mFd.close();
        }
    }
}

