/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import java.util.ArrayList;

public class PerformanceCollector {
    public static final String METRIC_KEY_CPU_TIME = "cpu_time";
    public static final String METRIC_KEY_EXECUTION_TIME = "execution_time";
    public static final String METRIC_KEY_GC_INVOCATION_COUNT = "gc_invocation_count";
    public static final String METRIC_KEY_GLOBAL_ALLOC_COUNT = "global_alloc_count";
    public static final String METRIC_KEY_GLOBAL_ALLOC_SIZE = "global_alloc_size";
    public static final String METRIC_KEY_GLOBAL_FREED_COUNT = "global_freed_count";
    public static final String METRIC_KEY_GLOBAL_FREED_SIZE = "global_freed_size";
    public static final String METRIC_KEY_ITERATIONS = "iterations";
    public static final String METRIC_KEY_JAVA_ALLOCATED = "java_allocated";
    public static final String METRIC_KEY_JAVA_FREE = "java_free";
    public static final String METRIC_KEY_JAVA_PRIVATE_DIRTY = "java_private_dirty";
    public static final String METRIC_KEY_JAVA_PSS = "java_pss";
    public static final String METRIC_KEY_JAVA_SHARED_DIRTY = "java_shared_dirty";
    public static final String METRIC_KEY_JAVA_SIZE = "java_size";
    public static final String METRIC_KEY_LABEL = "label";
    public static final String METRIC_KEY_NATIVE_ALLOCATED = "native_allocated";
    public static final String METRIC_KEY_NATIVE_FREE = "native_free";
    public static final String METRIC_KEY_NATIVE_PRIVATE_DIRTY = "native_private_dirty";
    public static final String METRIC_KEY_NATIVE_PSS = "native_pss";
    public static final String METRIC_KEY_NATIVE_SHARED_DIRTY = "native_shared_dirty";
    public static final String METRIC_KEY_NATIVE_SIZE = "native_size";
    public static final String METRIC_KEY_OTHER_PRIVATE_DIRTY = "other_private_dirty";
    public static final String METRIC_KEY_OTHER_PSS = "other_pss";
    public static final String METRIC_KEY_OTHER_SHARED_DIRTY = "other_shared_dirty";
    public static final String METRIC_KEY_PRE_RECEIVED_TRANSACTIONS = "pre_received_transactions";
    public static final String METRIC_KEY_PRE_SENT_TRANSACTIONS = "pre_sent_transactions";
    public static final String METRIC_KEY_RECEIVED_TRANSACTIONS = "received_transactions";
    public static final String METRIC_KEY_SENT_TRANSACTIONS = "sent_transactions";
    private long mCpuTime;
    private long mExecTime;
    private Bundle mPerfMeasurement;
    private Bundle mPerfSnapshot;
    private PerformanceResultsWriter mPerfWriter;
    private long mSnapshotCpuTime;
    private long mSnapshotExecTime;

    public PerformanceCollector() {
    }

    public PerformanceCollector(PerformanceResultsWriter performanceResultsWriter) {
        this.setPerformanceResultsWriter(performanceResultsWriter);
    }

    private void endPerformanceSnapshot() {
        long l;
        long l2;
        long l3 = Process.getElapsedCpuTime();
        long l4 = this.mSnapshotCpuTime;
        this.mSnapshotCpuTime = l2 = l3 - l4;
        long l5 = SystemClock.uptimeMillis();
        long l6 = this.mSnapshotExecTime;
        this.mSnapshotExecTime = l = l5 - l6;
        PerformanceCollector.stopAllocCounting();
        long l7 = Debug.getNativeHeapSize() / 1024L;
        long l8 = Debug.getNativeHeapAllocatedSize() / 1024L;
        long l9 = Debug.getNativeHeapFreeSize() / 1024L;
        Debug.MemoryInfo memoryInfo = new Debug.MemoryInfo();
        Debug.getMemoryInfo(memoryInfo);
        Runtime runtime = Runtime.getRuntime();
        long l10 = runtime.totalMemory() / 1024L;
        long l11 = runtime.freeMemory() / 1024L;
        long l12 = l10 - l11;
        Bundle bundle = PerformanceCollector.getBinderCounts();
        for (String string2 : bundle.keySet()) {
            Bundle bundle2 = this.mPerfSnapshot;
            long l13 = bundle.getLong(string2);
            Bundle bundle3 = bundle2;
            String string3 = string2;
            long l14 = l13;
            bundle3.putLong(string3, l14);
        }
        Bundle bundle4 = PerformanceCollector.getAllocCounts();
        for (String string4 : bundle4.keySet()) {
            Bundle bundle5 = this.mPerfSnapshot;
            long l15 = bundle4.getLong(string4);
            Bundle bundle6 = bundle5;
            String string5 = string4;
            long l16 = l15;
            bundle6.putLong(string5, l16);
        }
        Bundle bundle7 = this.mPerfSnapshot;
        long l17 = this.mSnapshotExecTime;
        bundle7.putLong(METRIC_KEY_EXECUTION_TIME, l17);
        Bundle bundle8 = this.mPerfSnapshot;
        long l18 = this.mSnapshotCpuTime;
        bundle8.putLong(METRIC_KEY_CPU_TIME, l18);
        Bundle bundle9 = this.mPerfSnapshot;
        String string6 = METRIC_KEY_NATIVE_SIZE;
        long l19 = l7;
        bundle9.putLong(string6, l19);
        Bundle bundle10 = this.mPerfSnapshot;
        String string7 = METRIC_KEY_NATIVE_ALLOCATED;
        long l20 = l8;
        bundle10.putLong(string7, l20);
        Bundle bundle11 = this.mPerfSnapshot;
        String string8 = METRIC_KEY_NATIVE_FREE;
        long l21 = l9;
        bundle11.putLong(string8, l21);
        Bundle bundle12 = this.mPerfSnapshot;
        long l22 = memoryInfo.nativePss;
        bundle12.putLong(METRIC_KEY_NATIVE_PSS, l22);
        Bundle bundle13 = this.mPerfSnapshot;
        long l23 = memoryInfo.nativePrivateDirty;
        bundle13.putLong(METRIC_KEY_NATIVE_PRIVATE_DIRTY, l23);
        Bundle bundle14 = this.mPerfSnapshot;
        long l24 = memoryInfo.nativeSharedDirty;
        bundle14.putLong(METRIC_KEY_NATIVE_SHARED_DIRTY, l24);
        Bundle bundle15 = this.mPerfSnapshot;
        String string9 = METRIC_KEY_JAVA_SIZE;
        long l25 = l10;
        bundle15.putLong(string9, l25);
        Bundle bundle16 = this.mPerfSnapshot;
        String string10 = METRIC_KEY_JAVA_ALLOCATED;
        long l26 = l12;
        bundle16.putLong(string10, l26);
        Bundle bundle17 = this.mPerfSnapshot;
        String string11 = METRIC_KEY_JAVA_FREE;
        long l27 = l11;
        bundle17.putLong(string11, l27);
        Bundle bundle18 = this.mPerfSnapshot;
        long l28 = memoryInfo.dalvikPss;
        bundle18.putLong(METRIC_KEY_JAVA_PSS, l28);
        Bundle bundle19 = this.mPerfSnapshot;
        long l29 = memoryInfo.dalvikPrivateDirty;
        bundle19.putLong(METRIC_KEY_JAVA_PRIVATE_DIRTY, l29);
        Bundle bundle20 = this.mPerfSnapshot;
        long l30 = memoryInfo.dalvikSharedDirty;
        bundle20.putLong(METRIC_KEY_JAVA_SHARED_DIRTY, l30);
        Bundle bundle21 = this.mPerfSnapshot;
        long l31 = memoryInfo.otherPss;
        bundle21.putLong(METRIC_KEY_OTHER_PSS, l31);
        Bundle bundle22 = this.mPerfSnapshot;
        long l32 = memoryInfo.otherPrivateDirty;
        bundle22.putLong(METRIC_KEY_OTHER_PRIVATE_DIRTY, l32);
        Bundle bundle23 = this.mPerfSnapshot;
        long l33 = memoryInfo.otherSharedDirty;
        bundle23.putLong(METRIC_KEY_OTHER_SHARED_DIRTY, l33);
    }

    private static Bundle getAllocCounts() {
        Bundle bundle = new Bundle();
        long l = Debug.getGlobalAllocCount();
        bundle.putLong(METRIC_KEY_GLOBAL_ALLOC_COUNT, l);
        long l2 = Debug.getGlobalAllocSize();
        bundle.putLong(METRIC_KEY_GLOBAL_ALLOC_SIZE, l2);
        long l3 = Debug.getGlobalFreedCount();
        bundle.putLong(METRIC_KEY_GLOBAL_FREED_COUNT, l3);
        long l4 = Debug.getGlobalFreedSize();
        bundle.putLong(METRIC_KEY_GLOBAL_FREED_SIZE, l4);
        long l5 = Debug.getGlobalGcInvocationCount();
        bundle.putLong(METRIC_KEY_GC_INVOCATION_COUNT, l5);
        return bundle;
    }

    private static Bundle getBinderCounts() {
        Bundle bundle = new Bundle();
        long l = Debug.getBinderSentTransactions();
        bundle.putLong(METRIC_KEY_SENT_TRANSACTIONS, l);
        long l2 = Debug.getBinderReceivedTransactions();
        bundle.putLong(METRIC_KEY_RECEIVED_TRANSACTIONS, l2);
        return bundle;
    }

    private static void startAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.resetAllCounts();
        Debug.startAllocCounting();
    }

    private void startPerformanceSnapshot() {
        long l;
        long l2;
        Bundle bundle;
        this.mPerfSnapshot = bundle = new Bundle();
        Bundle bundle2 = PerformanceCollector.getBinderCounts();
        for (String string2 : bundle2.keySet()) {
            Bundle bundle3 = this.mPerfSnapshot;
            String string3 = "pre_" + string2;
            long l3 = bundle2.getLong(string2);
            bundle3.putLong(string3, l3);
        }
        PerformanceCollector.startAllocCounting();
        this.mSnapshotExecTime = l2 = SystemClock.uptimeMillis();
        this.mSnapshotCpuTime = l = Process.getElapsedCpuTime();
    }

    private static void stopAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.stopAllocCounting();
    }

    public Bundle addIteration(String string2) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5 = Process.getElapsedCpuTime();
        long l6 = this.mCpuTime;
        this.mCpuTime = l4 = l5 - l6;
        long l7 = SystemClock.uptimeMillis();
        long l8 = this.mExecTime;
        this.mExecTime = l3 = l7 - l8;
        Bundle bundle = new Bundle();
        bundle.putString(METRIC_KEY_LABEL, string2);
        long l9 = this.mExecTime;
        bundle.putLong(METRIC_KEY_EXECUTION_TIME, l9);
        long l10 = this.mCpuTime;
        bundle.putLong(METRIC_KEY_CPU_TIME, l10);
        boolean bl = this.mPerfMeasurement.getParcelableArrayList(METRIC_KEY_ITERATIONS).add(bundle);
        this.mExecTime = l2 = SystemClock.uptimeMillis();
        this.mCpuTime = l = Process.getElapsedCpuTime();
        return bundle;
    }

    public void addMeasurement(String string2, float f) {
        if (this.mPerfWriter == null) {
            return;
        }
        this.mPerfWriter.writeMeasurement(string2, f);
    }

    public void addMeasurement(String string2, long l) {
        if (this.mPerfWriter == null) {
            return;
        }
        this.mPerfWriter.writeMeasurement(string2, l);
    }

    public void addMeasurement(String string2, String string3) {
        if (this.mPerfWriter == null) {
            return;
        }
        this.mPerfWriter.writeMeasurement(string2, string3);
    }

    public void beginSnapshot(String string2) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeBeginSnapshot(string2);
        }
        this.startPerformanceSnapshot();
    }

    public Bundle endSnapshot() {
        this.endPerformanceSnapshot();
        if (this.mPerfWriter != null) {
            PerformanceResultsWriter performanceResultsWriter = this.mPerfWriter;
            Bundle bundle = this.mPerfSnapshot;
            performanceResultsWriter.writeEndSnapshot(bundle);
        }
        return this.mPerfSnapshot;
    }

    public void setPerformanceResultsWriter(PerformanceResultsWriter performanceResultsWriter) {
        this.mPerfWriter = performanceResultsWriter;
    }

    public void startTiming(String string2) {
        long l;
        long l2;
        Bundle bundle;
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeStartTiming(string2);
        }
        Bundle bundle2 = this.mPerfMeasurement = (bundle = new Bundle());
        ArrayList arrayList = new ArrayList();
        bundle2.putParcelableArrayList(METRIC_KEY_ITERATIONS, arrayList);
        this.mExecTime = l2 = SystemClock.uptimeMillis();
        this.mCpuTime = l = Process.getElapsedCpuTime();
    }

    public Bundle stopTiming(String string2) {
        Bundle bundle = this.addIteration(string2);
        if (this.mPerfWriter != null) {
            PerformanceResultsWriter performanceResultsWriter = this.mPerfWriter;
            Bundle bundle2 = this.mPerfMeasurement;
            performanceResultsWriter.writeStopTiming(bundle2);
        }
        return this.mPerfMeasurement;
    }

    public static interface PerformanceResultsWriter {
        public void writeBeginSnapshot(String var1);

        public void writeEndSnapshot(Bundle var1);

        public void writeMeasurement(String var1, float var2);

        public void writeMeasurement(String var1, long var2);

        public void writeMeasurement(String var1, String var2);

        public void writeStartTiming(String var1);

        public void writeStopTiming(Bundle var1);
    }
}

