/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;

public class PowerManager {
    public static final int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
    public static final int FULL_WAKE_LOCK = 26;
    private static final int LOCK_MASK = 63;
    public static final int ON_AFTER_RELEASE = 0x20000000;
    public static final int PARTIAL_WAKE_LOCK = 1;
    public static final int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    public static final int SCREEN_BRIGHT_WAKE_LOCK = 10;
    public static final int SCREEN_DIM_WAKE_LOCK = 6;
    private static final String TAG = "PowerManager";
    public static final int WAIT_FOR_PROXIMITY_NEGATIVE = 1;
    private static final int WAKE_BIT_CPU_STRONG = 1;
    private static final int WAKE_BIT_CPU_WEAK = 2;
    private static final int WAKE_BIT_KEYBOARD_BRIGHT = 16;
    private static final int WAKE_BIT_PROXIMITY_SCREEN_OFF = 32;
    private static final int WAKE_BIT_SCREEN_BRIGHT = 8;
    private static final int WAKE_BIT_SCREEN_DIM = 4;
    Handler mHandler;
    IPowerManager mService;

    private PowerManager() {
    }

    public PowerManager(IPowerManager iPowerManager, Handler handler) {
        this.mService = iPowerManager;
        this.mHandler = handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSupportedWakeLockFlags() {
        try {
            int n = this.mService.getSupportedWakeLockFlags();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public void goToSleep(long l) {
        try {
            this.mService.goToSleep(l);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScreenOn() {
        try {
            boolean bl = this.mService.isScreenOn();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public WakeLock newWakeLock(int n, String string2) {
        if (string2 == null) {
            throw new NullPointerException("tag is null in PowerManager.newWakeLock");
        }
        return new WakeLock(n, string2);
    }

    public void reboot(String string2) {
        try {
            this.mService.reboot(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setBacklightBrightness(int n) {
        try {
            this.mService.setBacklightBrightness(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void userActivity(long l, boolean bl) {
        try {
            this.mService.userActivity(l, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public class WakeLock {
        static final int RELEASE_WAKE_LOCK = 1;
        int mCount;
        int mFlags;
        boolean mHeld;
        boolean mRefCounted;
        Runnable mReleaser;
        String mTag;
        IBinder mToken;
        WorkSource mWorkSource;

        WakeLock(int n, String string2) {
            Runnable runnable;
            this.mReleaser = runnable = new Runnable(){

                @Override
                public void run() {
                    WakeLock.this.release();
                }
            };
            this.mCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
            switch (n & 0x3F) {
                default: {
                    throw new IllegalArgumentException();
                }
                case 1: 
                case 6: 
                case 10: 
                case 26: 
                case 32: 
            }
            this.mFlags = n;
            this.mTag = string2;
            Binder binder = new Binder();
            this.mToken = binder;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                block6: {
                    int n;
                    block5: {
                        int n2;
                        if (!this.mRefCounted) break block5;
                        n = this.mCount;
                        this.mCount = n2 = n + 1;
                        if (n != 0) break block6;
                    }
                    try {
                        IPowerManager iPowerManager = PowerManager.this.mService;
                        int n3 = this.mFlags;
                        IBinder iBinder2 = this.mToken;
                        String string2 = this.mTag;
                        WorkSource workSource = this.mWorkSource;
                        iPowerManager.acquireWakeLock(n3, iBinder2, string2, workSource);
                    }
                    catch (RemoteException remoteException) {}
                    n = 1;
                    this.mHeld = n;
                }
                return;
            }
        }

        public void acquire(long l) {
            this.acquire();
            Handler handler = PowerManager.this.mHandler;
            Runnable runnable = this.mReleaser;
            boolean bl = handler.postDelayed(runnable, l);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mHeld) {
                    StringBuilder stringBuilder = new StringBuilder().append("WakeLock finalized while still held: ");
                    String string2 = this.mTag;
                    String string3 = stringBuilder.append(string2).toString();
                    int n = Log.wtf(PowerManager.TAG, string3);
                    try {
                        IPowerManager iPowerManager = PowerManager.this.mService;
                        IBinder iBinder2 = this.mToken;
                        iPowerManager.releaseWakeLock(iBinder2, 0);
                    }
                    catch (RemoteException remoteException) {}
                }
                return;
            }
        }

        public boolean isHeld() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                boolean bl = this.mHeld;
                return bl;
            }
        }

        public void release() {
            this.release(0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release(int n) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                block8: {
                    int n2;
                    block7: {
                        if (!this.mRefCounted) break block7;
                        this.mCount = n2 = this.mCount - 1;
                        if (n2 != 0) break block8;
                    }
                    try {
                        IPowerManager iPowerManager = PowerManager.this.mService;
                        IBinder iBinder2 = this.mToken;
                        iPowerManager.releaseWakeLock(iBinder2, n);
                    }
                    catch (RemoteException remoteException) {}
                    n2 = 0;
                    this.mHeld = n2;
                }
                if (this.mCount < 0) {
                    StringBuilder stringBuilder = new StringBuilder().append("WakeLock under-locked ");
                    String string2 = this.mTag;
                    String string3 = stringBuilder.append(string2).toString();
                    throw new RuntimeException(string3);
                }
                return;
            }
        }

        public void setReferenceCounted(boolean bl) {
            this.mRefCounted = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setWorkSource(WorkSource workSource) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                boolean bl;
                if (workSource != null && workSource.size() == 0) {
                    workSource = null;
                }
                boolean bl2 = true;
                if (workSource == null) {
                    this.mWorkSource = null;
                } else if (this.mWorkSource == null) {
                    WorkSource workSource2;
                    bl2 = this.mWorkSource != null;
                    this.mWorkSource = workSource2 = new WorkSource(workSource);
                } else {
                    bl2 = this.mWorkSource.diff(workSource);
                    if (bl2) {
                        this.mWorkSource.set(workSource);
                    }
                }
                if (bl2 && (bl = this.mHeld)) {
                    try {
                        IPowerManager iPowerManager = PowerManager.this.mService;
                        IBinder iBinder2 = this.mToken;
                        WorkSource workSource3 = this.mWorkSource;
                        iPowerManager.updateWakeLockWorkSource(iBinder2, workSource3);
                    }
                    catch (RemoteException remoteException) {}
                }
                return;
            }
        }

        public String toString() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                StringBuilder stringBuilder = new StringBuilder().append("WakeLock{");
                String string2 = Integer.toHexString(System.identityHashCode(this));
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" held=");
                boolean bl = this.mHeld;
                StringBuilder stringBuilder3 = stringBuilder2.append(bl).append(", refCount=");
                int n = this.mCount;
                String string3 = stringBuilder3.append(n).append("}").toString();
                return string3;
            }
        }
    }
}

