/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.ZygoteStartFailedEx;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class Process {
    public static final String ANDROID_SHARED_MEDIA = "com.android.process.media";
    public static final int BLUETOOTH_GID = 2000;
    public static final int FIRST_APPLICATION_UID = 10000;
    public static final String GOOGLE_SHARED_APP_CONTENT = "com.google.process.content";
    public static final int LAST_APPLICATION_UID = 99999;
    private static final String LOG_TAG = "Process";
    public static final int LOG_UID = 1007;
    public static final int NFC_UID = 1022;
    public static final int PHONE_UID = 1001;
    public static final int PROC_COMBINE = 256;
    public static final int PROC_OUT_FLOAT = 16384;
    public static final int PROC_OUT_LONG = 8192;
    public static final int PROC_OUT_STRING = 4096;
    public static final int PROC_PARENS = 512;
    public static final int PROC_SPACE_TERM = 32;
    public static final int PROC_TAB_TERM = 9;
    public static final int PROC_TERM_MASK = 255;
    public static final int PROC_ZERO_TERM = 0;
    public static final int SHELL_UID = 2000;
    public static final int SIGNAL_KILL = 9;
    public static final int SIGNAL_QUIT = 3;
    public static final int SIGNAL_USR1 = 10;
    public static final int SYSTEM_UID = 1000;
    public static final int THREAD_GROUP_BG_NONINTERACTIVE = 1;
    public static final int THREAD_GROUP_DEFAULT = 0;
    public static final int THREAD_GROUP_FG_BOOST = 2;
    public static final int THREAD_PRIORITY_AUDIO = 240;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_PRIORITY_DEFAULT = 0;
    public static final int THREAD_PRIORITY_DISPLAY = 252;
    public static final int THREAD_PRIORITY_FOREGROUND = 254;
    public static final int THREAD_PRIORITY_LESS_FAVORABLE = 1;
    public static final int THREAD_PRIORITY_LOWEST = 19;
    public static final int THREAD_PRIORITY_MORE_FAVORABLE = 255;
    public static final int THREAD_PRIORITY_URGENT_AUDIO = 237;
    public static final int THREAD_PRIORITY_URGENT_DISPLAY = 248;
    public static final int WIFI_UID = 1010;
    static final int ZYGOTE_RETRY_MILLIS = 500;
    private static final String ZYGOTE_SOCKET = "zygote";
    static boolean sPreviousZygoteOpenFailed;
    static DataInputStream sZygoteInputStream;
    static LocalSocket sZygoteSocket;
    static BufferedWriter sZygoteWriter;

    public static final native long getElapsedCpuTime();

    public static final native long getFreeMemory();

    public static final native int getGidForName(String var0);

    public static final native int[] getPids(String var0, int[] var1);

    public static final native long getPss(int var0);

    public static final native int getThreadPriority(int var0) throws IllegalArgumentException;

    public static final native int getUidForName(String var0);

    public static final int getUidForPid(int n) {
        String[] stringArray = new String[]{"Uid:"};
        long[] lArray = null;
        lArray[0] = 65535L;
        Process.readProcLines("/proc/" + n + "/status", stringArray, lArray);
        return (int)lArray[0];
    }

    private static void invokeStaticMain(String string2) {
        String[] stringArray = new String[0];
        Object[] objectArray = new Object[]{stringArray};
        try {
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[]{String[].class};
            Object object = clazz.getMethod("main", classArray).invoke(null, objectArray);
            return;
        }
        catch (Exception exception) {
            String string3 = "Exception invoking static main on " + string2;
            int n = Log.e(LOG_TAG, string3, exception);
            throw new RuntimeException(exception);
        }
    }

    public static final void killProcess(int n) {
        Process.sendSignal(n, 9);
    }

    public static final void killProcessQuiet(int n) {
        Process.sendSignalQuiet(n, 9);
    }

    public static final native int myPid();

    public static final native int myTid();

    public static final native int myUid();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void openZygoteSocketIfNeeded() throws ZygoteStartFailedEx {
        int n;
        int n2 = sPreviousZygoteOpenFailed ? 0 : 10;
        for (int i = 0; sZygoteSocket == null && i < (n = n2 + 1); ++i) {
            if (i > 0) {
                try {
                    int n3 = Log.i("Zygote", "Zygote not up yet, sleeping...");
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                LocalSocket localSocket = sZygoteSocket = new LocalSocket();
                LocalSocketAddress.Namespace namespace = LocalSocketAddress.Namespace.RESERVED;
                LocalSocketAddress localSocketAddress = new LocalSocketAddress(ZYGOTE_SOCKET, namespace);
                localSocket.connect(localSocketAddress);
                InputStream inputStream = sZygoteSocket.getInputStream();
                sZygoteInputStream = new DataInputStream(inputStream);
                OutputStream outputStream = sZygoteSocket.getOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                sZygoteWriter = new BufferedWriter(outputStreamWriter, 256);
                int n4 = Log.i("Zygote", "Process: zygote socket opened");
                sPreviousZygoteOpenFailed = false;
                break;
            }
            catch (IOException iOException) {
                if (sZygoteSocket != null) {
                    try {
                        sZygoteSocket.close();
                    }
                    catch (IOException iOException2) {
                        int n5 = Log.e(LOG_TAG, "I/O exception on close after exception", iOException2);
                    }
                }
                sZygoteSocket = null;
                continue;
            }
        }
        if (sZygoteSocket != null) {
            return;
        }
        sPreviousZygoteOpenFailed = true;
        throw new ZygoteStartFailedEx("connect failed");
    }

    public static final native boolean parseProcLine(byte[] var0, int var1, int var2, int[] var3, String[] var4, long[] var5, float[] var6);

    public static final native boolean readProcFile(String var0, int[] var1, String[] var2, long[] var3, float[] var4);

    public static final native void readProcLines(String var0, String[] var1, long[] var2);

    public static final native void sendSignal(int var0, int var1);

    public static final native void sendSignalQuiet(int var0, int var1);

    public static final native void setArgV0(String var0);

    public static final native void setCanSelfBackground(boolean var0);

    public static final native int setGid(int var0);

    public static final native boolean setOomAdj(int var0, int var1);

    public static final native void setProcessGroup(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native void setThreadGroup(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native void setThreadPriority(int var0) throws IllegalArgumentException, SecurityException;

    public static final native void setThreadPriority(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native int setUid(int var0);

    public static final int start(String string2, int n, int n2, int[] nArray, int n3, String[] stringArray) {
        String string3 = string2;
        int n4 = n;
        int n5 = n2;
        int[] nArray2 = nArray;
        int n6 = n3;
        String[] stringArray2 = stringArray;
        return Process.start(string3, "", n4, n5, nArray2, n6, stringArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int start(final String string2, String string3, int n, int n2, int[] nArray, int n3, String[] stringArray) {
        if (Process.supportsProcesses()) {
            try {
                int n4 = Process.startViaZygote(string2, string3, n, n2, nArray, n3, stringArray);
                return n4;
            }
            catch (ZygoteStartFailedEx zygoteStartFailedEx) {
                int n5 = Log.e(LOG_TAG, "Starting VM process through Zygote failed");
                throw new RuntimeException("Starting VM process through Zygote failed", zygoteStartFailedEx);
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Process.invokeStaticMain(string2);
            }
        };
        if (string3 != null) {
            new Thread(runnable, string3).start();
            return 0;
        }
        new Thread(runnable).start();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static int startViaZygote(String string2, String stringArray, int n, int n2, int[] nArray, int n3, String[] stringArray2) throws ZygoteStartFailedEx {
        // MONITORENTER : android.os.Process.class
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = arrayList.add("--runtime-init");
        String string3 = "--setuid=" + n;
        boolean bl2 = arrayList.add(string3);
        String string4 = "--setgid=" + n2;
        boolean bl3 = arrayList.add(string4);
        if ((n3 & 8) != 0) {
            boolean bl4 = arrayList.add("--enable-safemode");
        }
        if ((n3 & 1) != 0) {
            boolean bl5 = arrayList.add("--enable-debugger");
        }
        if ((n3 & 2) != 0) {
            boolean bl6 = arrayList.add("--enable-checkjni");
        }
        if ((n3 & 4) != 0) {
            boolean bl7 = arrayList.add("--enable-assert");
        }
        if (nArray != null && nArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = stringBuilder.append("--setgroups=");
            n3 = nArray.length;
            for (n = 0; n < n3; ++n) {
                if (n != 0) {
                    StringBuilder stringBuilder3 = stringBuilder.append(',');
                }
                int n4 = nArray[n];
                StringBuilder stringBuilder4 = stringBuilder.append(n4);
            }
            String string5 = stringBuilder.toString();
            boolean bl8 = arrayList.add(string5);
        }
        if (stringArray != null) {
            String string6 = "--nice-name=" + (String)stringArray;
            boolean bl9 = arrayList.add(string6);
        }
        boolean bl10 = arrayList.add(string2);
        if (stringArray2 != null) {
            for (String string7 : stringArray2) {
                boolean bl11 = arrayList.add(string7);
            }
        }
        int n5 = Process.zygoteSendArgsAndGetPid(arrayList);
        // MONITOREXIT : android.os.Process.class
        if (n5 > 0) return n5;
        String string8 = "zygote start failed:" + n5;
        throw new ZygoteStartFailedEx(string8);
    }

    public static final native boolean supportsProcesses();

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int zygoteSendArgsAndGetPid(ArrayList<String> var0) throws ZygoteStartFailedEx {
        Process.openZygoteSocketIfNeeded();
        try {
            var1_1 = Process.sZygoteWriter;
            var2_2 = Integer.toString(var0.size());
            var1_1.write(var2_2);
            Process.sZygoteWriter.newLine();
            var3_3 = var0.size();
            for (var4_4 = 0; var4_4 < var3_3; ++var4_4) {
                var5_5 = var0.get(var4_4);
                if (var5_5.indexOf(10) >= 0) {
                    throw new ZygoteStartFailedEx("embedded newlines not allowed");
                }
                Process.sZygoteWriter.write(var5_5);
                Process.sZygoteWriter.newLine();
            }
            ** GOTO lbl21
        }
        catch (IOException var6_6) {
            try {
                if (Process.sZygoteSocket != null) {
                    Process.sZygoteSocket.close();
                }
            }
            catch (IOException var8_8) {
                var9_9 = Log.e("Process", "I/O exception on routine close", var8_8);
            }
lbl21:
            // 1 sources

            Process.sZygoteWriter.flush();
            var7_7 = Process.sZygoteInputStream.readInt();
            if (var7_7 >= 0) return var7_7;
            throw new ZygoteStartFailedEx("fork() failed");
            Process.sZygoteSocket = null;
            throw new ZygoteStartFailedEx(var6_6);
        }
    }
}

