/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.os.FileUtils;
import android.os.PowerManager;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecoverySystem {
    private static File COMMAND_FILE;
    private static final File DEFAULT_KEYSTORE;
    private static String LAST_LOG_FILENAME;
    private static File LOG_FILE;
    private static int LOG_FILE_MAX_LENGTH = 0;
    private static final long PUBLISH_PROGRESS_INTERVAL_MS = 500L;
    private static File RECOVERY_DIR;
    private static final String TAG = "RecoverySystem";

    static {
        DEFAULT_KEYSTORE = new File("/system/etc/security/otacerts.zip");
        File file = RECOVERY_DIR = new File("/cache/recovery");
        COMMAND_FILE = new File(file, "command");
        File file2 = RECOVERY_DIR;
        LOG_FILE = new File(file2, "log");
        LAST_LOG_FILENAME = "last_log";
        LOG_FILE_MAX_LENGTH = 65536;
    }

    private void RecoverySystem() {
    }

    private static void bootCommand(Context context, String string2) throws IOException {
        boolean bl = RECOVERY_DIR.mkdirs();
        boolean bl2 = COMMAND_FILE.delete();
        boolean bl3 = LOG_FILE.delete();
        File file = COMMAND_FILE;
        FileWriter fileWriter = new FileWriter(file);
        try {
            fileWriter.write(string2);
            fileWriter.write("\n");
            ((PowerManager)context.getSystemService("power")).reboot("recovery");
            throw new IOException("Reboot failed (no permissions?)");
        }
        finally {
            fileWriter.close();
        }
    }

    private static HashSet<Certificate> getTrustedCerts(File file) throws IOException, GeneralSecurityException {
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        if (file == null) {
            file = DEFAULT_KEYSTORE;
        }
        ZipFile zipFile = new ZipFile(file);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Certificate certificate = certificateFactory.generateCertificate(inputStream);
                boolean bl = hashSet.add(certificate);
            }
        }
        finally {
            zipFile.close();
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String handleAftermath() {
        int n;
        String string2 = null;
        try {
            String string3;
            File file = LOG_FILE;
            int n2 = -LOG_FILE_MAX_LENGTH;
            string2 = string3 = FileUtils.readTextFile(file, n2, "...\n");
        }
        catch (FileNotFoundException fileNotFoundException) {
            int n3 = Log.i(TAG, "No recovery log file");
        }
        catch (IOException iOException) {
            int n4 = Log.e(TAG, "Error reading recovery log", iOException);
        }
        String[] stringArray = RECOVERY_DIR.list();
        for (int i = 0; stringArray != null && i < (n = stringArray.length); ++i) {
            String string4 = stringArray[i];
            String string5 = LAST_LOG_FILENAME;
            if (string4.equals(string5)) continue;
            File file = RECOVERY_DIR;
            String string6 = stringArray[i];
            File file2 = new File(file, string6);
            if (!file2.delete()) {
                String string7 = "Can't delete: " + file2;
                int n5 = Log.e(TAG, string7);
                continue;
            }
            String string8 = "Deleted: " + file2;
            int n6 = Log.i(TAG, string8);
        }
        return string2;
    }

    public static void installPackage(Context context, File file) throws IOException {
        String string2 = file.getCanonicalPath();
        String string3 = "!!! REBOOTING TO INSTALL " + string2 + " !!!";
        int n = Log.w(TAG, string3);
        String string4 = "--update_package=" + string2;
        RecoverySystem.bootCommand(context, string4);
    }

    public static void rebootToggleEFS(Context context, boolean bl) throws IOException {
        if (bl) {
            RecoverySystem.bootCommand(context, "--set_encrypted_filesystem=on");
            return;
        }
        RecoverySystem.bootCommand(context, "--set_encrypted_filesystem=off");
    }

    public static void rebootWipeUserData(Context context) throws IOException {
        RecoverySystem.bootCommand(context, "--wipe_data");
    }

    /*
     * Exception decompiling
     */
    public static void verifyPackage(File var0, ProgressListener var1_4, File var2_5) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 133->836)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface ProgressListener {
        public void onProgress(int var1);
    }
}

