/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import java.lang.ref.WeakReference;

public class Registrant {
    WeakReference refH;
    Object userObj;
    int what;

    public Registrant(Handler handler, int n, Object object) {
        WeakReference<Handler> weakReference;
        this.refH = weakReference = new WeakReference<Handler>(handler);
        this.what = n;
        this.userObj = object;
    }

    public void clear() {
        this.refH = null;
        this.userObj = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler getHandler() {
        if (this.refH != null) return (Handler)this.refH.get();
        return null;
    }

    void internalNotifyRegistrant(Object object, Throwable throwable) {
        int n;
        Handler handler = this.getHandler();
        if (handler == null) {
            this.clear();
            return;
        }
        Message message = Message.obtain();
        message.what = n = this.what;
        Object object2 = this.userObj;
        AsyncResult asyncResult = new AsyncResult(object2, object, throwable);
        message.obj = asyncResult;
        boolean bl = handler.sendMessage(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message messageForRegistrant() {
        Object object;
        int n;
        Handler handler = this.getHandler();
        if (handler == null) {
            this.clear();
            return null;
        }
        Message message = handler.obtainMessage();
        message.what = n = this.what;
        message.obj = object = this.userObj;
        return message;
    }

    public void notifyException(Throwable throwable) {
        this.internalNotifyRegistrant(null, throwable);
    }

    public void notifyRegistrant() {
        this.internalNotifyRegistrant(null, null);
    }

    public void notifyRegistrant(AsyncResult asyncResult) {
        Object object = asyncResult.result;
        Throwable throwable = asyncResult.exception;
        this.internalNotifyRegistrant(object, throwable);
    }

    public void notifyResult(Object object) {
        this.internalNotifyRegistrant(object, null);
    }
}

