/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public abstract class RemoteCallback
implements Parcelable {
    public static final Parcelable.Creator<RemoteCallback> CREATOR = new Parcelable.Creator<RemoteCallback>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public RemoteCallback createFromParcel(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            if (iBinder == null) return null;
            IRemoteCallback iRemoteCallback = IRemoteCallback.Stub.asInterface(iBinder);
            return new RemoteCallbackProxy(iRemoteCallback);
        }

        public RemoteCallback[] newArray(int n) {
            return new RemoteCallback[n];
        }
    };
    final Handler mHandler;
    final IRemoteCallback mTarget;

    public RemoteCallback(Handler handler) {
        this.mHandler = handler;
        LocalCallback localCallback = new LocalCallback();
        this.mTarget = localCallback;
    }

    RemoteCallback(IRemoteCallback iRemoteCallback) {
        this.mHandler = null;
        this.mTarget = iRemoteCallback;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            IBinder iBinder = this.mTarget.asBinder();
            IBinder iBinder2 = ((RemoteCallback)object).mTarget.asBinder();
            boolean bl = iBinder.equals(iBinder2);
            return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.mTarget.asBinder().hashCode();
    }

    protected abstract void onResult(Bundle var1);

    public void sendResult(Bundle bundle) throws RemoteException {
        this.mTarget.sendResult(bundle);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        IBinder iBinder = this.mTarget.asBinder();
        parcel.writeStrongBinder(iBinder);
    }

    static class RemoteCallbackProxy
    extends RemoteCallback {
        RemoteCallbackProxy(IRemoteCallback iRemoteCallback) {
            super(iRemoteCallback);
        }

        @Override
        protected void onResult(Bundle bundle) {
        }
    }

    class LocalCallback
    extends IRemoteCallback.Stub {
        LocalCallback() {
        }

        @Override
        public void sendResult(Bundle bundle) {
            Handler handler = RemoteCallback.this.mHandler;
            RemoteCallback remoteCallback = RemoteCallback.this;
            DeliverResult deliverResult = remoteCallback.new DeliverResult(bundle);
            boolean bl = handler.post(deliverResult);
        }
    }

    class DeliverResult
    implements Runnable {
        final Bundle mResult;

        DeliverResult(Bundle bundle) {
            this.mResult = bundle;
        }

        @Override
        public void run() {
            RemoteCallback remoteCallback = RemoteCallback.this;
            Bundle bundle = this.mResult;
            remoteCallback.onResult(bundle);
        }
    }
}

