/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import java.util.HashMap;
import java.util.Iterator;

public class RemoteCallbackList<E extends IInterface> {
    private Object[] mActiveBroadcast;
    private int mBroadcastCount;
    HashMap<IBinder, Callback> mCallbacks;
    private boolean mKilled;

    public RemoteCallbackList() {
        HashMap hashMap = new HashMap();
        this.mCallbacks = hashMap;
        this.mBroadcastCount = -1;
        this.mKilled = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int beginBroadcast() {
        HashMap<IBinder, Callback> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            int n;
            if (this.mBroadcastCount > 0) {
                throw new IllegalStateException("beginBroadcast() called while already in a broadcast");
            }
            this.mBroadcastCount = n = this.mCallbacks.size();
            if (n <= 0) {
                return 0;
            }
            Object[] objectArray = this.mActiveBroadcast;
            if (objectArray == null || objectArray.length < n) {
                this.mActiveBroadcast = objectArray = new Object[n];
            }
            Iterator<Callback> iterator = this.mCallbacks.values().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Callback callback = iterator.next();
                int n3 = n2 + 1;
                objectArray[n2] = callback;
                n2 = n3;
            }
            return n2;
        }
    }

    public void finishBroadcast() {
        if (this.mBroadcastCount < 0) {
            throw new IllegalStateException("finishBroadcast() called outside of a broadcast");
        }
        Object[] objectArray = this.mActiveBroadcast;
        if (objectArray != null) {
            int n = this.mBroadcastCount;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = null;
            }
        }
        this.mBroadcastCount = -1;
    }

    public Object getBroadcastCookie(int n) {
        return ((Callback)this.mActiveBroadcast[n]).mCookie;
    }

    public E getBroadcastItem(int n) {
        return ((Callback)this.mActiveBroadcast[n]).mCallback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void kill() {
        HashMap<IBinder, Callback> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            Iterator<Callback> iterator = this.mCallbacks.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.mCallbacks.clear();
                    this.mKilled = true;
                    return;
                }
                Callback callback = iterator.next();
                boolean bl = callback.mCallback.asBinder().unlinkToDeath(callback, 0);
            }
        }
    }

    public void onCallbackDied(E e) {
    }

    public void onCallbackDied(E e, Object object) {
        this.onCallbackDied(e);
    }

    public boolean register(E e) {
        return this.register(e, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean register(E e, Object object) {
        HashMap<IBinder, Callback> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            IBinder iBinder;
            if (this.mKilled) {
                return (boolean)null;
            }
            IBinder iBinder2 = iBinder = e.asBinder();
            try {
                Callback callback = new Callback(this, e, object);
                iBinder2.linkToDeath(callback, 0);
                Callback callback2 = this.mCallbacks.put(iBinder2, callback);
                return (boolean)null;
            }
            catch (RemoteException remoteException) {
                return (boolean)null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean unregister(E e) {
        HashMap<IBinder, Callback> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            HashMap<IBinder, Callback> hashMap2 = this.mCallbacks;
            IBinder iBinder = e.asBinder();
            Callback callback = hashMap2.remove(iBinder);
            if (callback == null) return (boolean)null;
            boolean bl = callback.mCallback.asBinder().unlinkToDeath(callback, 0);
            return (boolean)null;
        }
    }

    private static final class Callback
    implements IBinder.DeathRecipient {
        final E mCallback;
        final Object mCookie;
        final /* synthetic */ RemoteCallbackList this$0;

        Callback(E e, Object object) {
            this.this$0 = var1_1;
            this.mCallback = e;
            this.mCookie = object;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            HashMap<IBinder, Callback> hashMap = this.this$0.mCallbacks;
            synchronized (hashMap) {
                HashMap<IBinder, Callback> hashMap2 = this.this$0.mCallbacks;
                IBinder iBinder = this.mCallback.asBinder();
                Callback callback = hashMap2.remove(iBinder);
            }
            RemoteCallbackList remoteCallbackList = this.this$0;
            Object e = this.mCallback;
            Object object = this.mCookie;
            remoteCallbackList.onCallbackDied(e, object);
        }
    }
}

