/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.os.IResultReceiver;

public class ResultReceiver
implements Parcelable {
    public static final Parcelable.Creator<ResultReceiver> CREATOR = new Parcelable.Creator<ResultReceiver>(){

        @Override
        public ResultReceiver createFromParcel(Parcel parcel) {
            return new ResultReceiver(parcel);
        }

        public ResultReceiver[] newArray(int n) {
            return new ResultReceiver[n];
        }
    };
    final Handler mHandler;
    final boolean mLocal;
    IResultReceiver mReceiver;

    public ResultReceiver(Handler handler) {
        this.mLocal = true;
        this.mHandler = handler;
    }

    ResultReceiver(Parcel parcel) {
        IResultReceiver iResultReceiver;
        this.mLocal = false;
        this.mHandler = null;
        this.mReceiver = iResultReceiver = IResultReceiver.Stub.asInterface(parcel.readStrongBinder());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected void onReceiveResult(int n, Bundle bundle) {
    }

    public void send(int n, Bundle bundle) {
        if (this.mLocal) {
            if (this.mHandler != null) {
                Handler handler = this.mHandler;
                MyRunnable myRunnable = new MyRunnable(n, bundle);
                boolean bl = handler.post(myRunnable);
                return;
            }
            this.onReceiveResult(n, bundle);
            return;
        }
        if (this.mReceiver == null) {
            return;
        }
        try {
            this.mReceiver.send(n, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        synchronized (this) {
            if (this.mReceiver == null) {
                MyResultReceiver myResultReceiver = new MyResultReceiver();
                this.mReceiver = myResultReceiver;
            }
            IBinder iBinder = this.mReceiver.asBinder();
            parcel.writeStrongBinder(iBinder);
            return;
        }
    }

    class MyResultReceiver
    extends IResultReceiver.Stub {
        MyResultReceiver() {
        }

        @Override
        public void send(int n, Bundle bundle) {
            if (ResultReceiver.this.mHandler != null) {
                Handler handler = ResultReceiver.this.mHandler;
                ResultReceiver resultReceiver = ResultReceiver.this;
                MyRunnable myRunnable = resultReceiver.new MyRunnable(n, bundle);
                boolean bl = handler.post(myRunnable);
                return;
            }
            ResultReceiver.this.onReceiveResult(n, bundle);
        }
    }

    class MyRunnable
    implements Runnable {
        final int mResultCode;
        final Bundle mResultData;

        MyRunnable(int n, Bundle bundle) {
            this.mResultCode = n;
            this.mResultData = bundle;
        }

        @Override
        public void run() {
            ResultReceiver resultReceiver = ResultReceiver.this;
            int n = this.mResultCode;
            Bundle bundle = this.mResultData;
            resultReceiver.onReceiveResult(n, bundle);
        }
    }
}

