/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.ActivityManagerNative;
import android.app.ApplicationErrorReport;
import android.app.IActivityManager;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import com.android.internal.os.RuntimeInit;
import dalvik.system.BlockGuard;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class StrictMode {
    public static final int DETECT_DISK_READ = 2;
    public static final int DETECT_DISK_WRITE = 1;
    public static final int DETECT_NETWORK = 4;
    public static final int DETECT_VM_CURSOR_LEAKS = 512;
    private static final boolean LOG_V = false;
    private static final int MAX_OFFENSES_PER_LOOP = 10;
    private static final long MIN_DIALOG_INTERVAL_MS = 30000L;
    private static final long MIN_LOG_INTERVAL_MS = 1000L;
    public static final int PENALTY_DEATH = 64;
    public static final int PENALTY_DIALOG = 32;
    public static final int PENALTY_DROPBOX = 128;
    public static final int PENALTY_GATHER = 256;
    public static final int PENALTY_LOG = 16;
    private static final String TAG = "StrictMode";
    private static final ThreadLocal<ArrayList<ViolationInfo>> gatheredViolations;
    private static volatile int sVmPolicyMask;
    private static final ThreadLocal<ArrayList<ViolationInfo>> violationsBeingTimed;

    static {
        sVmPolicyMask = 0;
        gatheredViolations = new ThreadLocal<ArrayList<ViolationInfo>>(){

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return null;
            }
        };
        violationsBeingTimed = new ThreadLocal<ArrayList<ViolationInfo>>(){

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return new ArrayList<ViolationInfo>();
            }
        };
    }

    private StrictMode() {
    }

    public static ThreadPolicy allowThreadDiskReads() {
        int n = StrictMode.getThreadPolicyMask();
        int n2 = n & 0xFFFFFFFD;
        if (n2 != n) {
            StrictMode.setThreadPolicyMask(n2);
        }
        return new ThreadPolicy(n);
    }

    public static ThreadPolicy allowThreadDiskWrites() {
        int n = StrictMode.getThreadPolicyMask();
        int n2 = n & 0xFFFFFFFC;
        if (n2 != n) {
            StrictMode.setThreadPolicyMask(n2);
        }
        return new ThreadPolicy(n);
    }

    static void clearGatheredViolations() {
        gatheredViolations.set(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean conditionallyEnableDebugLogging() {
        String string2 = Build.TYPE;
        if ("user".equals(string2)) {
            return false;
        }
        StrictMode.setThreadPolicyMask(135);
        sVmPolicyMask = 656;
        return true;
    }

    public static void enableDefaults() {
        StrictMode.setThreadPolicy(new ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy(new VmPolicy.Builder().detectLeakedSqlLiteObjects().penaltyLog().build());
    }

    public static ThreadPolicy getThreadPolicy() {
        int n = StrictMode.getThreadPolicyMask();
        return new ThreadPolicy(n);
    }

    public static int getThreadPolicyMask() {
        return BlockGuard.getThreadPolicy().getPolicyMask();
    }

    public static VmPolicy getVmPolicy() {
        int n = sVmPolicyMask;
        return new VmPolicy(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean hasGatheredViolations() {
        if (gatheredViolations.get() == null) return false;
        return true;
    }

    private static void onBinderStrictModePolicyChange(int n) {
        StrictMode.setBlockGuardPolicy(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void onSqliteObjectLeaked(String string2, Throwable throwable) {
        if ((sVmPolicyMask & 0x10) != 0) {
            int n = Log.e(TAG, string2, throwable);
        }
        if ((sVmPolicyMask & 0x80) != 0) {
            int n = sVmPolicyMask;
            ViolationInfo violationInfo = new ViolationInfo(throwable, n);
            int n2 = 640;
            int n3 = StrictMode.getThreadPolicyMask();
            int n4 = 0;
            try {
                StrictMode.setThreadPolicyMask(n4);
                IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                IBinder iBinder = RuntimeInit.getApplicationObject();
                iActivityManager.handleApplicationStrictModeViolation(iBinder, n2, violationInfo);
            }
            catch (RemoteException remoteException) {
                int n5 = Log.e(TAG, "RemoteException trying to handle StrictMode violation", remoteException);
            }
            finally {
                StrictMode.setThreadPolicyMask(n3);
            }
        }
        if ((sVmPolicyMask & 0x40) == 0) {
            return;
        }
        System.err.println("StrictMode VmPolicy violation with POLICY_DEATH; shutting down.");
        Process.killProcess(Process.myPid());
        System.exit(10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parsePolicyFromMessage(String string2) {
        if (string2 == null) return 0;
        if (!string2.startsWith("policy=")) {
            return 0;
        }
        int n = string2.indexOf(32);
        if (n == -1) {
            return 0;
        }
        String string3 = string2.substring(7, n);
        try {
            int n2 = Integer.valueOf(string3);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parseViolationFromMessage(String string2) {
        if (string2 == null) {
            return 0;
        }
        int n = string2.indexOf("violation=");
        if (n == -1) {
            return 0;
        }
        int n2 = n + 10;
        String string3 = string2.substring(n2);
        try {
            int n3 = Integer.valueOf(string3);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void readAndHandleBinderCallViolations(Parcel parcel) {
        StringWriter stringWriter = new StringWriter();
        LogStackTrace logStackTrace = new LogStackTrace();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        logStackTrace.printStackTrace(printWriter);
        String string2 = stringWriter.toString();
        boolean bl = (StrictMode.getThreadPolicyMask() & 0x100) != 0;
        int n = parcel.readInt();
        int n2 = 0;
        while (n2 < n) {
            String string3;
            boolean bl2 = !bl;
            ViolationInfo violationInfo = new ViolationInfo(parcel, bl2);
            StringBuilder stringBuilder = new StringBuilder();
            ApplicationErrorReport.CrashInfo crashInfo = violationInfo.crashInfo;
            String string4 = crashInfo.stackTrace;
            crashInfo.stackTrace = string3 = stringBuilder.append(string4).append("# via Binder call with stack:\n").append(string2).toString();
            BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
            if (policy instanceof AndroidBlockGuardPolicy) {
                ((AndroidBlockGuardPolicy)policy).handleViolationWithTimingAttempt(violationInfo);
            }
            ++n2;
        }
        return;
    }

    private static void setBlockGuardPolicy(int n) {
        if (n == 0) {
            BlockGuard.setThreadPolicy((BlockGuard.Policy)BlockGuard.LAX_POLICY);
            return;
        }
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            BlockGuard.setThreadPolicy((BlockGuard.Policy)new AndroidBlockGuardPolicy(n));
            return;
        }
        ((AndroidBlockGuardPolicy)policy).setPolicyMask(n);
    }

    public static void setThreadPolicy(ThreadPolicy threadPolicy) {
        StrictMode.setThreadPolicyMask(threadPolicy.mask);
    }

    private static void setThreadPolicyMask(int n) {
        StrictMode.setBlockGuardPolicy(n);
        Binder.setThreadStrictModePolicy(n);
    }

    public static void setVmPolicy(VmPolicy vmPolicy) {
        sVmPolicyMask = vmPolicy.mask;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean tooManyViolationsThisLoop() {
        if (violationsBeingTimed.get().size() < 10) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean vmSqliteObjectLeaksEnabled() {
        if ((sVmPolicyMask & 0x200) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void writeGatheredViolationsToParcel(Parcel parcel) {
        ArrayList<ViolationInfo> arrayList = gatheredViolations.get();
        if (arrayList == null) {
            parcel.writeInt(0);
        } else {
            int n;
            int n2 = arrayList.size();
            parcel.writeInt(n2);
            for (int i = 0; i < (n = arrayList.size()); ++i) {
                arrayList.get(i).writeToParcel(parcel, 0);
            }
            arrayList.clear();
        }
        gatheredViolations.set(null);
    }

    public static class ViolationInfo {
        public final ApplicationErrorReport.CrashInfo crashInfo;
        public int durationMillis = -1;
        public final int policy;
        public int violationNumThisLoop;
        public long violationUptimeMillis;

        public ViolationInfo() {
            this.crashInfo = null;
            this.policy = 0;
        }

        public ViolationInfo(Parcel parcel) {
            this(parcel, false);
        }

        /*
         * Enabled aggressive block sorting
         */
        public ViolationInfo(Parcel parcel, boolean bl) {
            long l;
            int n;
            int n2;
            int n3;
            ApplicationErrorReport.CrashInfo crashInfo;
            this.crashInfo = crashInfo = new ApplicationErrorReport.CrashInfo(parcel);
            int n4 = parcel.readInt();
            this.policy = bl ? (n3 = n4 & 0xFFFFFEFF) : n4;
            this.durationMillis = n2 = parcel.readInt();
            this.violationNumThisLoop = n = parcel.readInt();
            this.violationUptimeMillis = l = parcel.readLong();
        }

        public ViolationInfo(Throwable throwable, int n) {
            long l;
            ApplicationErrorReport.CrashInfo crashInfo;
            this.crashInfo = crashInfo = new ApplicationErrorReport.CrashInfo(throwable);
            this.violationUptimeMillis = l = SystemClock.uptimeMillis();
            this.policy = n;
        }

        public void dump(Printer printer, String string2) {
            this.crashInfo.dump(printer, string2);
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("policy: ");
            int n = this.policy;
            String string3 = stringBuilder.append(n).toString();
            printer.println(string3);
            if (this.durationMillis != -1) {
                StringBuilder stringBuilder2 = new StringBuilder().append(string2).append("durationMillis: ");
                int n2 = this.durationMillis;
                String string4 = stringBuilder2.append(n2).toString();
                printer.println(string4);
            }
            if (this.violationNumThisLoop != 0) {
                StringBuilder stringBuilder3 = new StringBuilder().append(string2).append("violationNumThisLoop: ");
                int n3 = this.violationNumThisLoop;
                String string5 = stringBuilder3.append(n3).toString();
                printer.println(string5);
            }
            StringBuilder stringBuilder4 = new StringBuilder().append(string2).append("violationUptimeMillis: ");
            long l = this.violationUptimeMillis;
            String string6 = stringBuilder4.append(l).toString();
            printer.println(string6);
        }

        public void writeToParcel(Parcel parcel, int n) {
            this.crashInfo.writeToParcel(parcel, n);
            int n2 = this.policy;
            parcel.writeInt(n2);
            int n3 = this.durationMillis;
            parcel.writeInt(n3);
            int n4 = this.violationNumThisLoop;
            parcel.writeInt(n4);
            long l = this.violationUptimeMillis;
            parcel.writeLong(l);
        }
    }

    private static class LogStackTrace
    extends Exception {
        private LogStackTrace() {
        }
    }

    private static class AndroidBlockGuardPolicy
    implements BlockGuard.Policy {
        private final HashMap<Integer, Long> mLastViolationTime;
        private int mPolicyMask;

        public AndroidBlockGuardPolicy(int n) {
            HashMap hashMap = new HashMap();
            this.mLastViolationTime = hashMap;
            this.mPolicyMask = n;
        }

        public int getPolicyMask() {
            return this.mPolicyMask;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void handleViolation(ViolationInfo violationInfo) {
            if (violationInfo == null || violationInfo.crashInfo == null || violationInfo.crashInfo.stackTrace == null) {
                int n = Log.wtf(StrictMode.TAG, "unexpected null stacktrace");
                return;
            }
            if ((violationInfo.policy & 0x100) != 0) {
                ViolationInfo violationInfo2;
                String string2;
                String string3;
                ArrayList<ViolationInfo> arrayList = (ArrayList<ViolationInfo>)gatheredViolations.get();
                if (arrayList == null) {
                    arrayList = new ArrayList<ViolationInfo>(1);
                    ThreadLocal threadLocal = gatheredViolations;
                    ArrayList<ViolationInfo> arrayList2 = arrayList;
                    threadLocal.set(arrayList2);
                } else {
                    int n;
                    int n2 = arrayList.size();
                    if (n2 >= (n = 5)) {
                        return;
                    }
                }
                Iterator iterator = arrayList.iterator();
                do {
                    if (!iterator.hasNext()) {
                        ArrayList<ViolationInfo> arrayList3 = arrayList;
                        ViolationInfo violationInfo3 = violationInfo;
                        boolean bl = arrayList3.add(violationInfo3);
                        return;
                    }
                    violationInfo2 = (ViolationInfo)iterator.next();
                } while (!(string3 = violationInfo.crashInfo.stackTrace).equals(string2 = violationInfo2.crashInfo.stackTrace));
                return;
            }
            Integer n = violationInfo.crashInfo.stackTrace.hashCode();
            long l = 0L;
            HashMap<Integer, Long> hashMap = this.mLastViolationTime;
            Integer n3 = n;
            if (hashMap.containsKey(n3)) {
                HashMap<Integer, Long> hashMap2 = this.mLastViolationTime;
                Integer n4 = n;
                l = hashMap2.get(n4);
            }
            long l2 = SystemClock.uptimeMillis();
            HashMap<Integer, Long> hashMap3 = this.mLastViolationTime;
            Long l3 = l2;
            HashMap<Integer, Long> hashMap4 = hashMap3;
            Integer n5 = n;
            Long l4 = l3;
            Long l5 = hashMap4.put(n5, l4);
            long l6 = l == 0L ? Long.MAX_VALUE : l2 - l;
            if ((violationInfo.policy & 0x10) != 0 && l6 > 1000L) {
                int n6 = violationInfo.durationMillis;
                int n7 = 65535;
                if (n6 != n7) {
                    StringBuilder stringBuilder = new StringBuilder().append("StrictMode policy violation; ~duration=");
                    int n8 = violationInfo.durationMillis;
                    StringBuilder stringBuilder2 = stringBuilder.append(n8).append(" ms: ");
                    String string4 = violationInfo.crashInfo.stackTrace;
                    String string5 = stringBuilder2.append(string4).toString();
                    int n9 = Log.d(StrictMode.TAG, string5);
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("StrictMode policy violation: ");
                    String string6 = violationInfo.crashInfo.stackTrace;
                    String string7 = stringBuilder.append(string6).toString();
                    int n10 = Log.d(StrictMode.TAG, string7);
                }
            }
            int n11 = 0;
            if ((violationInfo.policy & 0x20) != 0 && l6 > 30000L) {
                n11 |= 0x20;
            }
            if ((violationInfo.policy & 0x80) != 0 && l == 0L) {
                n11 |= 0x80;
            }
            if (n11 != 0) {
                int n12 = StrictMode.parseViolationFromMessage(violationInfo.crashInfo.exceptionMessage);
                n11 |= n12;
                int n13 = StrictMode.getThreadPolicyMask();
                int n14 = 0;
                try {
                    StrictMode.setThreadPolicyMask(n14);
                    IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                    IBinder iBinder = RuntimeInit.getApplicationObject();
                    IActivityManager iActivityManager2 = iActivityManager;
                    IBinder iBinder2 = iBinder;
                    int n15 = n11;
                    ViolationInfo violationInfo4 = violationInfo;
                    iActivityManager2.handleApplicationStrictModeViolation(iBinder2, n15, violationInfo4);
                }
                catch (RemoteException remoteException) {
                    String string8 = StrictMode.TAG;
                    String string9 = "RemoteException trying to handle StrictMode violation";
                    RemoteException remoteException2 = remoteException;
                    int n16 = Log.e(string8, string9, remoteException2);
                }
                finally {
                    StrictMode.setThreadPolicyMask(n13);
                }
            }
            if ((violationInfo.policy & 0x40) == 0) {
                return;
            }
            System.err.println("StrictMode policy violation with POLICY_DEATH; shutting down.");
            Process.killProcess(Process.myPid());
            System.exit(10);
        }

        void handleViolationWithTimingAttempt(ViolationInfo violationInfo) {
            if (Looper.myLooper() == null) {
                violationInfo.durationMillis = -1;
                this.handleViolation(violationInfo);
                return;
            }
            MessageQueue messageQueue = Looper.myQueue();
            final ArrayList arrayList = (ArrayList)violationsBeingTimed.get();
            if (arrayList.size() >= 10) {
                return;
            }
            boolean bl = arrayList.add(violationInfo);
            if (arrayList.size() > 1) {
                return;
            }
            MessageQueue.IdleHandler idleHandler = new MessageQueue.IdleHandler(){

                @Override
                public boolean queueIdle() {
                    int n;
                    long l = SystemClock.uptimeMillis();
                    for (int i = 0; i < (n = arrayList.size()); ++i) {
                        int n2;
                        int n3;
                        ViolationInfo violationInfo = (ViolationInfo)arrayList.get(i);
                        violationInfo.violationNumThisLoop = n3 = i + 1;
                        long l2 = violationInfo.violationUptimeMillis;
                        violationInfo.durationMillis = n2 = (int)(l - l2);
                        AndroidBlockGuardPolicy.this.handleViolation(violationInfo);
                    }
                    arrayList.clear();
                    return false;
                }
            };
            messageQueue.addIdleHandler(idleHandler);
        }

        public void onNetwork() {
            if ((this.mPolicyMask & 4) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            int n = this.mPolicyMask;
            StrictModeNetworkViolation strictModeNetworkViolation = new StrictModeNetworkViolation(n);
            Throwable throwable = strictModeNetworkViolation.fillInStackTrace();
            this.startHandlingViolationException(strictModeNetworkViolation);
        }

        public void onReadFromDisk() {
            if ((this.mPolicyMask & 2) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            int n = this.mPolicyMask;
            StrictModeDiskReadViolation strictModeDiskReadViolation = new StrictModeDiskReadViolation(n);
            Throwable throwable = strictModeDiskReadViolation.fillInStackTrace();
            this.startHandlingViolationException(strictModeDiskReadViolation);
        }

        public void onWriteToDisk() {
            if ((this.mPolicyMask & 1) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            int n = this.mPolicyMask;
            StrictModeDiskWriteViolation strictModeDiskWriteViolation = new StrictModeDiskWriteViolation(n);
            Throwable throwable = strictModeDiskWriteViolation.fillInStackTrace();
            this.startHandlingViolationException(strictModeDiskWriteViolation);
        }

        public void setPolicyMask(int n) {
            this.mPolicyMask = n;
        }

        void startHandlingViolationException(BlockGuard.BlockGuardPolicyException blockGuardPolicyException) {
            long l;
            int n = blockGuardPolicyException.getPolicy();
            ViolationInfo violationInfo = new ViolationInfo((Throwable)blockGuardPolicyException, n);
            violationInfo.violationUptimeMillis = l = SystemClock.uptimeMillis();
            this.handleViolationWithTimingAttempt(violationInfo);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("AndroidBlockGuardPolicy; mPolicyMask=");
            int n = this.mPolicyMask;
            return stringBuilder.append(n).toString();
        }
    }

    private static class StrictModeDiskWriteViolation
    extends BlockGuard.BlockGuardPolicyException {
        public StrictModeDiskWriteViolation(int n) {
            super(n, 1);
        }
    }

    private static class StrictModeDiskReadViolation
    extends BlockGuard.BlockGuardPolicyException {
        public StrictModeDiskReadViolation(int n) {
            super(n, 2);
        }
    }

    private static class StrictModeNetworkViolation
    extends BlockGuard.BlockGuardPolicyException {
        public StrictModeNetworkViolation(int n) {
            super(n, 4);
        }
    }

    public static final class VmPolicy {
        public static final VmPolicy LAX = new VmPolicy(0);
        final int mask;

        private VmPolicy(int n) {
            this.mask = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("[StrictMode.VmPolicy; mask=");
            int n = this.mask;
            return stringBuilder.append(n).append("]").toString();
        }

        public static final class Builder {
            private int mMask;

            private Builder enable(int n) {
                int n2;
                this.mMask = n2 = this.mMask | n;
                return this;
            }

            public VmPolicy build() {
                if (this.mMask != 0 && (this.mMask & 0xF0) == 0) {
                    Builder builder = this.penaltyLog();
                }
                int n = this.mMask;
                return new VmPolicy(n);
            }

            public Builder detectAll() {
                return this.enable(512);
            }

            public Builder detectLeakedSqlLiteObjects() {
                return this.enable(512);
            }

            public Builder penaltyDeath() {
                return this.enable(64);
            }

            public Builder penaltyDropBox() {
                return this.enable(128);
            }

            public Builder penaltyLog() {
                return this.enable(16);
            }
        }
    }

    public static final class ThreadPolicy {
        public static final ThreadPolicy LAX = new ThreadPolicy(0);
        final int mask;

        private ThreadPolicy(int n) {
            this.mask = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("[StrictMode.ThreadPolicy; mask=");
            int n = this.mask;
            return stringBuilder.append(n).append("]").toString();
        }

        public static final class Builder {
            private int mMask = 0;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(ThreadPolicy threadPolicy) {
                int n;
                this.mMask = n = threadPolicy.mask;
            }

            private Builder disable(int n) {
                int n2;
                int n3 = this.mMask;
                int n4 = ~n;
                this.mMask = n2 = n3 & n4;
                return this;
            }

            private Builder enable(int n) {
                int n2;
                this.mMask = n2 = this.mMask | n;
                return this;
            }

            public ThreadPolicy build() {
                if (this.mMask != 0 && (this.mMask & 0xF0) == 0) {
                    Builder builder = this.penaltyLog();
                }
                int n = this.mMask;
                return new ThreadPolicy(n);
            }

            public Builder detectAll() {
                return this.enable(7);
            }

            public Builder detectDiskReads() {
                return this.enable(2);
            }

            public Builder detectDiskWrites() {
                return this.enable(1);
            }

            public Builder detectNetwork() {
                return this.enable(4);
            }

            public Builder penaltyDeath() {
                return this.enable(64);
            }

            public Builder penaltyDialog() {
                return this.enable(32);
            }

            public Builder penaltyDropBox() {
                return this.enable(128);
            }

            public Builder penaltyLog() {
                return this.enable(16);
            }

            public Builder permitAll() {
                return this.disable(7);
            }

            public Builder permitDiskReads() {
                return this.disable(2);
            }

            public Builder permitDiskWrites() {
                return this.disable(1);
            }

            public Builder permitNetwork() {
                return this.disable(4);
            }
        }
    }
}

