/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class TokenWatcher {
    private volatile boolean mAcquired;
    private Handler mHandler;
    private int mNotificationQueue;
    private Runnable mNotificationTask;
    private String mTag;
    private WeakHashMap<IBinder, Death> mTokens;

    /*
     * Enabled aggressive block sorting
     */
    public TokenWatcher(Handler handler, String string2) {
        Runnable runnable;
        this.mNotificationTask = runnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                WeakHashMap weakHashMap = TokenWatcher.this.mTokens;
                // MONITORENTER : weakHashMap
                int n = TokenWatcher.this.mNotificationQueue;
                int n2 = TokenWatcher.access$102(TokenWatcher.this, -1);
                // MONITOREXIT : weakHashMap
                if (n == 1) {
                    TokenWatcher.this.acquired();
                    return;
                }
                if (n != 0) {
                    return;
                }
                TokenWatcher.this.released();
            }
        };
        WeakHashMap weakHashMap = new WeakHashMap();
        this.mTokens = weakHashMap;
        this.mNotificationQueue = -1;
        this.mAcquired = false;
        this.mHandler = handler;
        String string3 = string2 != null ? string2 : "TokenWatcher";
        this.mTag = string3;
    }

    static /* synthetic */ int access$102(TokenWatcher tokenWatcher, int n) {
        tokenWatcher.mNotificationQueue = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendNotificationLocked(boolean bl) {
        int n = bl ? 1 : 0;
        if (this.mNotificationQueue == -1) {
            this.mNotificationQueue = n;
            Handler handler = this.mHandler;
            Runnable runnable = this.mNotificationTask;
            boolean bl2 = handler.post(runnable);
            return;
        }
        if (this.mNotificationQueue != n) {
            return;
        }
        this.mNotificationQueue = -1;
        Handler handler = this.mHandler;
        Runnable runnable = this.mNotificationTask;
        handler.removeCallbacks(runnable);
    }

    public void acquire(IBinder iBinder, String string2) {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            block6: {
                int n = this.mTokens.size();
                Death death = new Death(iBinder, string2);
                int n2 = 0;
                try {
                    iBinder.linkToDeath(death, n2);
                    Death death2 = this.mTokens.put(iBinder, death);
                    if (n != 0 || this.mAcquired) break block6;
                    this.sendNotificationLocked(true);
                    this.mAcquired = true;
                }
                catch (RemoteException remoteException) {
                    return;
                }
            }
            return;
        }
    }

    public abstract void acquired();

    public void cleanup(IBinder iBinder, boolean bl) {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            Death death = this.mTokens.remove(iBinder);
            if (bl && death != null) {
                boolean bl2 = death.token.unlinkToDeath(death, 0);
                death.token = null;
            }
            if (this.mTokens.size() == 0 && this.mAcquired) {
                this.sendNotificationLocked(false);
                this.mAcquired = false;
            }
            return;
        }
    }

    public void dump() {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            Set<IBinder> set = this.mTokens.keySet();
            String string2 = this.mTag;
            StringBuilder stringBuilder = new StringBuilder().append("Token count: ");
            int n = this.mTokens.size();
            String string3 = stringBuilder.append(n).toString();
            int n2 = Log.i(string2, string3);
            int n3 = 0;
            for (IBinder iBinder : set) {
                String string4 = this.mTag;
                StringBuilder stringBuilder2 = new StringBuilder().append("[").append(n3).append("] ");
                String string5 = this.mTokens.get((Object)iBinder).tag;
                String string6 = stringBuilder2.append(string5).append(" - ").append(iBinder).toString();
                int n4 = Log.i(string4, string6);
                ++n3;
            }
            return;
        }
    }

    public boolean isAcquired() {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            boolean bl = this.mAcquired;
            return bl;
        }
    }

    public void release(IBinder iBinder) {
        this.cleanup(iBinder, true);
    }

    public abstract void released();

    private class Death
    implements IBinder.DeathRecipient {
        String tag;
        IBinder token;

        Death(IBinder iBinder, String string2) {
            this.token = iBinder;
            this.tag = string2;
        }

        @Override
        public void binderDied() {
            TokenWatcher tokenWatcher = TokenWatcher.this;
            IBinder iBinder = this.token;
            tokenWatcher.cleanup(iBinder, false);
        }

        protected void finalize() throws Throwable {
            try {
                if (this.token != null) {
                    String string2 = TokenWatcher.this.mTag;
                    StringBuilder stringBuilder = new StringBuilder().append("cleaning up leaked reference: ");
                    String string3 = this.tag;
                    String string4 = stringBuilder.append(string3).toString();
                    int n = Log.w(string2, string4);
                    TokenWatcher tokenWatcher = TokenWatcher.this;
                    IBinder iBinder = this.token;
                    tokenWatcher.release(iBinder);
                }
                return;
            }
            finally {
                super.finalize();
            }
        }
    }
}

