/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import java.util.ArrayList;
import java.util.HashMap;

public abstract class UEventObserver {
    private static final String TAG = UEventObserver.class.getSimpleName();
    private static UEventThread sThread;
    private static boolean sThreadStarted;

    static {
        sThreadStarted = false;
    }

    private static final void ensureThreadStarted() {
        synchronized (UEventObserver.class) {
            if (!sThreadStarted) {
                sThread = new UEventThread();
                sThread.start();
                sThreadStarted = true;
            }
            return;
        }
    }

    private static native void native_setup();

    private static native int next_event(byte[] var0);

    protected void finalize() throws Throwable {
        try {
            this.stopObserving();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public abstract void onUEvent(UEvent var1);

    public final void startObserving(String string2) {
        synchronized (this) {
            UEventObserver.ensureThreadStarted();
            sThread.addObserver(string2, this);
            return;
        }
    }

    public final void stopObserving() {
        synchronized (this) {
            sThread.removeObserver(this);
            return;
        }
    }

    private static class UEventThread
    extends Thread {
        private ArrayList<Object> mObservers;

        UEventThread() {
            super("UEventObserver");
            ArrayList arrayList = new ArrayList();
            this.mObservers = arrayList;
        }

        public void addObserver(String string2, UEventObserver uEventObserver) {
            ArrayList<Object> arrayList = this.mObservers;
            synchronized (arrayList) {
                boolean bl = this.mObservers.add(string2);
                boolean bl2 = this.mObservers.add(uEventObserver);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeObserver(UEventObserver uEventObserver) {
            ArrayList<Object> arrayList = this.mObservers;
            synchronized (arrayList) {
                boolean bl = true;
                block2: while (bl) {
                    bl = false;
                    int n = 0;
                    while (true) {
                        int n2;
                        if (n >= (n2 = this.mObservers.size())) continue block2;
                        ArrayList<Object> arrayList2 = this.mObservers;
                        int n3 = n + 1;
                        if (arrayList2.get(n3) == uEventObserver) {
                            ArrayList<Object> arrayList3 = this.mObservers;
                            int n4 = n + 1;
                            Object object = arrayList3.remove(n4);
                            Object object2 = this.mObservers.remove(n);
                            bl = true;
                            continue block2;
                        }
                        n += 2;
                    }
                    break;
                }
                return;
            }
        }

        @Override
        public void run() {
            UEventObserver.native_setup();
            byte[] byArray = new byte[1024];
            while (true) {
                int n;
                if ((n = UEventObserver.next_event(byArray)) <= 0) {
                    continue;
                }
                String string2 = new String(byArray, 0, n);
                ArrayList<Object> arrayList = this.mObservers;
                synchronized (arrayList) {
                    int n2;
                    for (int i = 0; i < (n2 = this.mObservers.size()); i += 2) {
                        String string3 = (String)this.mObservers.get(i);
                        if (string2.indexOf(string3) == -1) continue;
                        ArrayList<Object> arrayList2 = this.mObservers;
                        int n3 = i + 1;
                        UEventObserver uEventObserver = (UEventObserver)arrayList2.get(n3);
                        UEvent uEvent = new UEvent(string2);
                        uEventObserver.onUEvent(uEvent);
                    }
                }
            }
        }
    }

    public static class UEvent {
        public HashMap<String, String> mMap;

        public UEvent(String string2) {
            HashMap hashMap = new HashMap();
            this.mMap = hashMap;
            int n = 0;
            int n2 = string2.length();
            while (n < n2) {
                int n3 = string2.indexOf(61, n);
                int n4 = string2.indexOf(0, n);
                if (n4 < 0) {
                    return;
                }
                if (n3 > n && n3 < n4) {
                    HashMap<String, String> hashMap2 = this.mMap;
                    String string3 = string2.substring(n, n3);
                    int n5 = n3 + 1;
                    String string4 = string2.substring(n5, n4);
                    String string5 = hashMap2.put(string3, string4);
                }
                n = n4 + 1;
            }
            return;
        }

        public String get(String string2) {
            return this.mMap.get(string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String get(String string2, String string3) {
            String string4 = this.mMap.get(string2);
            if (string4 != null) return string4;
            return string3;
        }

        public String toString() {
            return this.mMap.toString();
        }
    }
}

