/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IVibratorService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class Vibrator {
    private static final String TAG = "Vibrator";
    IVibratorService mService;
    private final Binder mToken;

    public Vibrator() {
        IVibratorService iVibratorService;
        Binder binder;
        this.mToken = binder = new Binder();
        this.mService = iVibratorService = IVibratorService.Stub.asInterface(ServiceManager.getService("vibrator"));
    }

    public void cancel() {
        if (this.mService == null) {
            return;
        }
        try {
            IVibratorService iVibratorService = this.mService;
            Binder binder = this.mToken;
            iVibratorService.cancelVibrate(binder);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed to cancel vibration.", remoteException);
            return;
        }
    }

    public void vibrate(long l) {
        if (this.mService == null) {
            int n = Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return;
        }
        try {
            IVibratorService iVibratorService = this.mService;
            Binder binder = this.mToken;
            iVibratorService.vibrate(l, binder);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed to vibrate.", remoteException);
            return;
        }
    }

    public void vibrate(long[] lArray, int n) {
        if (this.mService == null) {
            int n2 = Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return;
        }
        int n3 = lArray.length;
        if (n < n3) {
            try {
                IVibratorService iVibratorService = this.mService;
                Binder binder = this.mToken;
                iVibratorService.vibratePattern(lArray, n, binder);
                return;
            }
            catch (RemoteException remoteException) {
                int n4 = Log.w(TAG, "Failed to vibrate.", remoteException);
                return;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

