/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.storage.IMountServiceListener;
import android.os.storage.IMountShutdownObserver;
import android.os.storage.IObbActionListener;

public interface IMountService
extends IInterface {
    public int createSecureContainer(String var1, int var2, String var3, String var4, int var5) throws RemoteException;

    public int destroySecureContainer(String var1, boolean var2) throws RemoteException;

    public int finalizeSecureContainer(String var1) throws RemoteException;

    public void finishMediaUpdate() throws RemoteException;

    public int formatVolume(String var1) throws RemoteException;

    public String getMountedObbPath(String var1) throws RemoteException;

    public String[] getSecureContainerList() throws RemoteException;

    public String getSecureContainerPath(String var1) throws RemoteException;

    public int[] getStorageUsers(String var1) throws RemoteException;

    public String getVolumeState(String var1) throws RemoteException;

    public boolean isObbMounted(String var1) throws RemoteException;

    public boolean isSecureContainerMounted(String var1) throws RemoteException;

    public boolean isUsbMassStorageConnected() throws RemoteException;

    public boolean isUsbMassStorageEnabled() throws RemoteException;

    public void mountObb(String var1, String var2, IObbActionListener var3, int var4) throws RemoteException;

    public int mountSecureContainer(String var1, String var2, int var3) throws RemoteException;

    public int mountVolume(String var1) throws RemoteException;

    public void registerListener(IMountServiceListener var1) throws RemoteException;

    public int renameSecureContainer(String var1, String var2) throws RemoteException;

    public void setUsbMassStorageEnabled(boolean var1) throws RemoteException;

    public void shutdown(IMountShutdownObserver var1) throws RemoteException;

    public void unmountObb(String var1, boolean var2, IObbActionListener var3, int var4) throws RemoteException;

    public int unmountSecureContainer(String var1, boolean var2) throws RemoteException;

    public void unmountVolume(String var1, boolean var2) throws RemoteException;

    public void unregisterListener(IMountServiceListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMountService {
        private static final String DESCRIPTOR = "IMountService";
        static final int TRANSACTION_createSecureContainer = 11;
        static final int TRANSACTION_destroySecureContainer = 13;
        static final int TRANSACTION_finalizeSecureContainer = 12;
        static final int TRANSACTION_finishMediaUpdate = 21;
        static final int TRANSACTION_formatVolume = 8;
        static final int TRANSACTION_getMountedObbPath = 25;
        static final int TRANSACTION_getSecureContainerList = 19;
        static final int TRANSACTION_getSecureContainerPath = 18;
        static final int TRANSACTION_getStorageUsers = 9;
        static final int TRANSACTION_getVolumeState = 10;
        static final int TRANSACTION_isObbMounted = 24;
        static final int TRANSACTION_isSecureContainerMounted = 16;
        static final int TRANSACTION_isUsbMassStorageConnected = 3;
        static final int TRANSACTION_isUsbMassStorageEnabled = 5;
        static final int TRANSACTION_mountObb = 22;
        static final int TRANSACTION_mountSecureContainer = 14;
        static final int TRANSACTION_mountVolume = 6;
        static final int TRANSACTION_registerListener = 1;
        static final int TRANSACTION_renameSecureContainer = 17;
        static final int TRANSACTION_setUsbMassStorageEnabled = 4;
        static final int TRANSACTION_shutdown = 20;
        static final int TRANSACTION_unmountObb = 23;
        static final int TRANSACTION_unmountSecureContainer = 15;
        static final int TRANSACTION_unmountVolume = 7;
        static final int TRANSACTION_unregisterListener = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IMountService asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IMountService) {
                IMountService iMountService = (IMountService)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    Parcel parcel3 = parcel2;
                    String string2 = DESCRIPTOR;
                    parcel3.writeString(string2);
                    return true;
                }
                case 1: {
                    Parcel parcel4 = parcel;
                    String string3 = DESCRIPTOR;
                    parcel4.enforceInterface(string3);
                    IMountServiceListener iMountServiceListener = IMountServiceListener.Stub.asInterface(parcel.readStrongBinder());
                    Stub stub = this;
                    IMountServiceListener iMountServiceListener2 = iMountServiceListener;
                    stub.registerListener(iMountServiceListener2);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    Parcel parcel5 = parcel;
                    String string4 = DESCRIPTOR;
                    parcel5.enforceInterface(string4);
                    IMountServiceListener iMountServiceListener = IMountServiceListener.Stub.asInterface(parcel.readStrongBinder());
                    Stub stub = this;
                    IMountServiceListener iMountServiceListener3 = iMountServiceListener;
                    stub.unregisterListener(iMountServiceListener3);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    Parcel parcel6 = parcel;
                    String string5 = DESCRIPTOR;
                    parcel6.enforceInterface(string5);
                    boolean bl = this.isUsbMassStorageConnected();
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    Parcel parcel7 = parcel2;
                    int n4 = n3;
                    parcel7.writeInt(n4);
                    return true;
                }
                case 4: {
                    Parcel parcel8 = parcel;
                    String string6 = DESCRIPTOR;
                    parcel8.enforceInterface(string6);
                    boolean bl = parcel.readInt() != 0;
                    Stub stub = this;
                    boolean bl2 = bl;
                    stub.setUsbMassStorageEnabled(bl2);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    Parcel parcel9 = parcel;
                    String string7 = DESCRIPTOR;
                    parcel9.enforceInterface(string7);
                    boolean bl = this.isUsbMassStorageEnabled();
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    Parcel parcel10 = parcel2;
                    int n6 = n5;
                    parcel10.writeInt(n6);
                    return true;
                }
                case 6: {
                    Parcel parcel11 = parcel;
                    String string8 = DESCRIPTOR;
                    parcel11.enforceInterface(string8);
                    String string9 = parcel.readString();
                    Stub stub = this;
                    String string10 = string9;
                    int n7 = stub.mountVolume(string10);
                    parcel2.writeNoException();
                    Parcel parcel12 = parcel2;
                    int n8 = n7;
                    parcel12.writeInt(n8);
                    return true;
                }
                case 7: {
                    Parcel parcel13 = parcel;
                    String string11 = DESCRIPTOR;
                    parcel13.enforceInterface(string11);
                    String string12 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    Stub stub = this;
                    String string13 = string12;
                    boolean bl3 = bl;
                    stub.unmountVolume(string13, bl3);
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    Parcel parcel14 = parcel;
                    String string14 = DESCRIPTOR;
                    parcel14.enforceInterface(string14);
                    String string15 = parcel.readString();
                    Stub stub = this;
                    String string16 = string15;
                    int n9 = stub.formatVolume(string16);
                    parcel2.writeNoException();
                    Parcel parcel15 = parcel2;
                    int n10 = n9;
                    parcel15.writeInt(n10);
                    return true;
                }
                case 9: {
                    Parcel parcel16 = parcel;
                    String string17 = DESCRIPTOR;
                    parcel16.enforceInterface(string17);
                    String string18 = parcel.readString();
                    Stub stub = this;
                    String string19 = string18;
                    int[] nArray = stub.getStorageUsers(string19);
                    parcel2.writeNoException();
                    Parcel parcel17 = parcel2;
                    int[] nArray2 = nArray;
                    parcel17.writeIntArray(nArray2);
                    return true;
                }
                case 10: {
                    Parcel parcel18 = parcel;
                    String string20 = DESCRIPTOR;
                    parcel18.enforceInterface(string20);
                    String string21 = parcel.readString();
                    Stub stub = this;
                    String string22 = string21;
                    String string23 = stub.getVolumeState(string22);
                    parcel2.writeNoException();
                    Parcel parcel19 = parcel2;
                    String string24 = string23;
                    parcel19.writeString(string24);
                    return true;
                }
                case 11: {
                    Parcel parcel20 = parcel;
                    String string25 = DESCRIPTOR;
                    parcel20.enforceInterface(string25);
                    String string26 = parcel.readString();
                    int n11 = parcel.readInt();
                    String string27 = parcel.readString();
                    String string28 = parcel.readString();
                    int n12 = parcel.readInt();
                    int n13 = this.createSecureContainer(string26, n11, string27, string28, n12);
                    parcel2.writeNoException();
                    Parcel parcel21 = parcel2;
                    int n14 = n13;
                    parcel21.writeInt(n14);
                    return true;
                }
                case 12: {
                    Parcel parcel22 = parcel;
                    String string29 = DESCRIPTOR;
                    parcel22.enforceInterface(string29);
                    String string30 = parcel.readString();
                    Stub stub = this;
                    String string31 = string30;
                    int n15 = stub.finalizeSecureContainer(string31);
                    parcel2.writeNoException();
                    Parcel parcel23 = parcel2;
                    int n16 = n15;
                    parcel23.writeInt(n16);
                    return true;
                }
                case 13: {
                    Parcel parcel24 = parcel;
                    String string32 = DESCRIPTOR;
                    parcel24.enforceInterface(string32);
                    String string33 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    Stub stub = this;
                    String string34 = string33;
                    boolean bl4 = bl;
                    int n17 = stub.destroySecureContainer(string34, bl4);
                    parcel2.writeNoException();
                    Parcel parcel25 = parcel2;
                    int n18 = n17;
                    parcel25.writeInt(n18);
                    return true;
                }
                case 14: {
                    Parcel parcel26 = parcel;
                    String string35 = DESCRIPTOR;
                    parcel26.enforceInterface(string35);
                    String string36 = parcel.readString();
                    String string37 = parcel.readString();
                    int n19 = parcel.readInt();
                    Stub stub = this;
                    String string38 = string36;
                    String string39 = string37;
                    int n20 = n19;
                    int n21 = stub.mountSecureContainer(string38, string39, n20);
                    parcel2.writeNoException();
                    Parcel parcel27 = parcel2;
                    int n22 = n21;
                    parcel27.writeInt(n22);
                    return true;
                }
                case 15: {
                    Parcel parcel28 = parcel;
                    String string40 = DESCRIPTOR;
                    parcel28.enforceInterface(string40);
                    String string41 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    Stub stub = this;
                    String string42 = string41;
                    boolean bl5 = bl;
                    int n23 = stub.unmountSecureContainer(string42, bl5);
                    parcel2.writeNoException();
                    Parcel parcel29 = parcel2;
                    int n24 = n23;
                    parcel29.writeInt(n24);
                    return true;
                }
                case 16: {
                    Parcel parcel30 = parcel;
                    String string43 = DESCRIPTOR;
                    parcel30.enforceInterface(string43);
                    String string44 = parcel.readString();
                    Stub stub = this;
                    String string45 = string44;
                    boolean bl = stub.isSecureContainerMounted(string45);
                    parcel2.writeNoException();
                    int n25 = bl ? 1 : 0;
                    Parcel parcel31 = parcel2;
                    int n26 = n25;
                    parcel31.writeInt(n26);
                    return true;
                }
                case 17: {
                    Parcel parcel32 = parcel;
                    String string46 = DESCRIPTOR;
                    parcel32.enforceInterface(string46);
                    String string47 = parcel.readString();
                    String string48 = parcel.readString();
                    Stub stub = this;
                    String string49 = string47;
                    String string50 = string48;
                    int n27 = stub.renameSecureContainer(string49, string50);
                    parcel2.writeNoException();
                    Parcel parcel33 = parcel2;
                    int n28 = n27;
                    parcel33.writeInt(n28);
                    return true;
                }
                case 18: {
                    Parcel parcel34 = parcel;
                    String string51 = DESCRIPTOR;
                    parcel34.enforceInterface(string51);
                    String string52 = parcel.readString();
                    Stub stub = this;
                    String string53 = string52;
                    String string54 = stub.getSecureContainerPath(string53);
                    parcel2.writeNoException();
                    Parcel parcel35 = parcel2;
                    String string55 = string54;
                    parcel35.writeString(string55);
                    return true;
                }
                case 19: {
                    Parcel parcel36 = parcel;
                    String string56 = DESCRIPTOR;
                    parcel36.enforceInterface(string56);
                    String[] stringArray = this.getSecureContainerList();
                    parcel2.writeNoException();
                    Parcel parcel37 = parcel2;
                    String[] stringArray2 = stringArray;
                    parcel37.writeStringArray(stringArray2);
                    return true;
                }
                case 20: {
                    Parcel parcel38 = parcel;
                    String string57 = DESCRIPTOR;
                    parcel38.enforceInterface(string57);
                    IMountShutdownObserver iMountShutdownObserver = IMountShutdownObserver.Stub.asInterface(parcel.readStrongBinder());
                    Stub stub = this;
                    IMountShutdownObserver iMountShutdownObserver2 = iMountShutdownObserver;
                    stub.shutdown(iMountShutdownObserver2);
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    Parcel parcel39 = parcel;
                    String string58 = DESCRIPTOR;
                    parcel39.enforceInterface(string58);
                    this.finishMediaUpdate();
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    Parcel parcel40 = parcel;
                    String string59 = DESCRIPTOR;
                    parcel40.enforceInterface(string59);
                    String string60 = parcel.readString();
                    String string61 = parcel.readString();
                    IObbActionListener iObbActionListener = IObbActionListener.Stub.asInterface(parcel.readStrongBinder());
                    int n29 = parcel.readInt();
                    Stub stub = this;
                    String string62 = string60;
                    String string63 = string61;
                    IObbActionListener iObbActionListener2 = iObbActionListener;
                    int n30 = n29;
                    stub.mountObb(string62, string63, iObbActionListener2, n30);
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    Parcel parcel41 = parcel;
                    String string64 = DESCRIPTOR;
                    parcel41.enforceInterface(string64);
                    String string65 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    IObbActionListener iObbActionListener = IObbActionListener.Stub.asInterface(parcel.readStrongBinder());
                    int n31 = parcel.readInt();
                    Stub stub = this;
                    String string66 = string65;
                    boolean bl6 = bl;
                    IObbActionListener iObbActionListener3 = iObbActionListener;
                    int n32 = n31;
                    stub.unmountObb(string66, bl6, iObbActionListener3, n32);
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    Parcel parcel42 = parcel;
                    String string67 = DESCRIPTOR;
                    parcel42.enforceInterface(string67);
                    String string68 = parcel.readString();
                    Stub stub = this;
                    String string69 = string68;
                    boolean bl = stub.isObbMounted(string69);
                    parcel2.writeNoException();
                    int n33 = bl ? 1 : 0;
                    Parcel parcel43 = parcel2;
                    int n34 = n33;
                    parcel43.writeInt(n34);
                    return true;
                }
                case 25: 
            }
            Parcel parcel44 = parcel;
            String string70 = DESCRIPTOR;
            parcel44.enforceInterface(string70);
            String string71 = parcel.readString();
            Stub stub = this;
            String string72 = string71;
            String string73 = stub.getMountedObbPath(string72);
            parcel2.writeNoException();
            Parcel parcel45 = parcel2;
            String string74 = string73;
            parcel45.writeString(string74);
            return true;
        }

        private static class Proxy
        implements IMountService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public int createSecureContainer(String string2, int n, String string3, String string4, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n3;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeString(string3);
                    parcel.writeString(string4);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = n3 = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int destroySecureContainer(String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n2 = bl ? 1 : 0;
                    parcel.writeInt(n2);
                    boolean bl2 = this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int finalizeSecureContainer(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void finishMediaUpdate() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int formatVolume(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public String getMountedObbPath(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String string3;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    String string4 = string3 = parcel2.readString();
                    parcel2.recycle();
                    parcel.recycle();
                    return string4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public String[] getSecureContainerList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String[] stringArray;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray2 = stringArray = parcel2.createStringArray();
                    parcel2.recycle();
                    parcel.recycle();
                    return stringArray2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public String getSecureContainerPath(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String string3;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    String string4 = string3 = parcel2.readString();
                    parcel2.recycle();
                    parcel.recycle();
                    return string4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int[] getStorageUsers(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int[] nArray;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int[] nArray2 = nArray = parcel2.createIntArray();
                    parcel2.recycle();
                    parcel.recycle();
                    return nArray2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public String getVolumeState(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String string3;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    String string4 = string3 = parcel2.readString();
                    parcel2.recycle();
                    parcel.recycle();
                    return string4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isObbMounted(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isSecureContainerMounted(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isUsbMassStorageConnected() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isUsbMassStorageEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void mountObb(String string2, String string3, IObbActionListener iObbActionListener, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    IBinder iBinder = iObbActionListener != null ? iObbActionListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int mountSecureContainer(String string2, String string3, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n2;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = n2 = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int mountVolume(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerListener(IMountServiceListener iMountServiceListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iMountServiceListener != null ? iMountServiceListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int renameSecureContainer(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    boolean bl = this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setUsbMassStorageEnabled(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void shutdown(IMountShutdownObserver iMountShutdownObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iMountShutdownObserver != null ? iMountShutdownObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unmountObb(String string2, boolean bl, IObbActionListener iObbActionListener, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = bl ? null : null;
                    parcel.writeInt((int)iBinder);
                    iBinder = iObbActionListener != null ? iObbActionListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int unmountSecureContainer(String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n2 = bl ? 1 : 0;
                    parcel.writeInt(n2);
                    boolean bl2 = this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unmountVolume(String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterListener(IMountServiceListener iMountServiceListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iMountServiceListener != null ? iMountServiceListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

