/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.IMountServiceListener;
import android.os.storage.IObbActionListener;
import android.os.storage.OnObbStateChangeListener;
import android.os.storage.StorageEventListener;
import android.util.Log;
import android.util.SparseArray;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class StorageManager {
    private static final String TAG = "StorageManager";
    private MountServiceBinderListener mBinderListener;
    private List<ListenerDelegate> mListeners;
    private IMountService mMountService;
    private final AtomicInteger mNextNonce;
    private final ObbActionListener mObbActionListener;
    Looper mTgtLooper;

    public StorageManager(Looper looper) throws RemoteException {
        MountServiceBinderListener mountServiceBinderListener;
        IMountService iMountService;
        ObbActionListener obbActionListener;
        AtomicInteger atomicInteger;
        ArrayList<ListenerDelegate> arrayList = new ArrayList<ListenerDelegate>();
        this.mListeners = arrayList;
        this.mNextNonce = atomicInteger = new AtomicInteger(0);
        this.mObbActionListener = obbActionListener = new ObbActionListener();
        this.mMountService = iMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        if (this.mMountService == null) {
            int n = Log.e(TAG, "Unable to connect to mount service! - is it running yet?");
            return;
        }
        this.mTgtLooper = looper;
        this.mBinderListener = mountServiceBinderListener = new MountServiceBinderListener();
        IMountService iMountService2 = this.mMountService;
        MountServiceBinderListener mountServiceBinderListener2 = this.mBinderListener;
        iMountService2.registerListener(mountServiceBinderListener2);
    }

    private int getNextNonce() {
        return this.mNextNonce.getAndIncrement();
    }

    public void disableUsbMassStorage() {
        try {
            this.mMountService.setUsbMassStorageEnabled(false);
            return;
        }
        catch (Exception exception) {
            int n = Log.e(TAG, "Failed to disable UMS", exception);
            return;
        }
    }

    public void enableUsbMassStorage() {
        try {
            this.mMountService.setUsbMassStorageEnabled(true);
            return;
        }
        catch (Exception exception) {
            int n = Log.e(TAG, "Failed to enable UMS", exception);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMountedObbPath(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        try {
            String string3 = this.mMountService.getMountedObbPath(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Failed to find mounted path for OBB", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isObbMounted(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        try {
            boolean bl = this.mMountService.isObbMounted(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Failed to check if OBB is mounted", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isUsbMassStorageConnected() {
        try {
            boolean bl = this.mMountService.isUsbMassStorageConnected();
            return bl;
        }
        catch (Exception exception) {
            int n = Log.e(TAG, "Failed to get UMS connection state", exception);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isUsbMassStorageEnabled() {
        try {
            boolean bl = this.mMountService.isUsbMassStorageEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Failed to get UMS enable state", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mountObb(String string2, String string3, OnObbStateChangeListener onObbStateChangeListener) {
        if (string2 == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (onObbStateChangeListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        try {
            int n = this.mObbActionListener.addListener(onObbStateChangeListener);
            IMountService iMountService = this.mMountService;
            ObbActionListener obbActionListener = this.mObbActionListener;
            iMountService.mountObb(string2, string3, obbActionListener, n);
            return true;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Failed to mount OBB", remoteException);
            return false;
        }
    }

    public void registerListener(StorageEventListener storageEventListener) {
        if (storageEventListener == null) {
            return;
        }
        List<ListenerDelegate> list = this.mListeners;
        synchronized (list) {
            List<ListenerDelegate> list2 = this.mListeners;
            ListenerDelegate listenerDelegate = new ListenerDelegate(storageEventListener);
            boolean bl = list2.add(listenerDelegate);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean unmountObb(String string2, boolean bl, OnObbStateChangeListener onObbStateChangeListener) {
        if (string2 == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (onObbStateChangeListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        try {
            int n = this.mObbActionListener.addListener(onObbStateChangeListener);
            IMountService iMountService = this.mMountService;
            ObbActionListener obbActionListener = this.mObbActionListener;
            iMountService.unmountObb(string2, bl, obbActionListener, n);
            return true;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Failed to mount OBB", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterListener(StorageEventListener storageEventListener) {
        if (storageEventListener == null) {
            return;
        }
        List<ListenerDelegate> list = this.mListeners;
        synchronized (list) {
            int n = this.mListeners.size();
            int n2 = 0;
            while (true) {
                block8: {
                    block7: {
                        if (n2 >= n) break block7;
                        if (this.mListeners.get(n2).getListener() != storageEventListener) break block8;
                        ListenerDelegate listenerDelegate = this.mListeners.remove(n2);
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    private class ListenerDelegate {
        private final Handler mHandler;
        final StorageEventListener mStorageEventListener;

        ListenerDelegate(StorageEventListener storageEventListener) {
            Handler handler;
            this.mStorageEventListener = storageEventListener;
            Looper looper = StorageManager.this.mTgtLooper;
            this.mHandler = handler = new Handler(looper){

                @Override
                public void handleMessage(Message message) {
                    StorageEvent storageEvent = (StorageEvent)message.obj;
                    if (message.what == 1) {
                        UmsConnectionChangedStorageEvent umsConnectionChangedStorageEvent = (UmsConnectionChangedStorageEvent)storageEvent;
                        StorageEventListener storageEventListener = ListenerDelegate.this.mStorageEventListener;
                        boolean bl = umsConnectionChangedStorageEvent.available;
                        storageEventListener.onUsbMassStorageConnectionChanged(bl);
                        return;
                    }
                    if (message.what == 2) {
                        StorageStateChangedStorageEvent storageStateChangedStorageEvent = (StorageStateChangedStorageEvent)storageEvent;
                        StorageEventListener storageEventListener = ListenerDelegate.this.mStorageEventListener;
                        String string2 = storageStateChangedStorageEvent.path;
                        String string3 = storageStateChangedStorageEvent.oldState;
                        String string4 = storageStateChangedStorageEvent.newState;
                        storageEventListener.onStorageStateChanged(string2, string3, string4);
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("Unsupported event ");
                    int n = message.what;
                    String string5 = stringBuilder.append(n).toString();
                    int n2 = Log.e(StorageManager.TAG, string5);
                }
            };
        }

        StorageEventListener getListener() {
            return this.mStorageEventListener;
        }

        void sendShareAvailabilityChanged(boolean bl) {
            StorageManager storageManager = StorageManager.this;
            UmsConnectionChangedStorageEvent umsConnectionChangedStorageEvent = storageManager.new UmsConnectionChangedStorageEvent(bl);
            Handler handler = this.mHandler;
            Message message = umsConnectionChangedStorageEvent.getMessage();
            boolean bl2 = handler.sendMessage(message);
        }

        void sendStorageStateChanged(String string2, String string3, String string4) {
            StorageManager storageManager = StorageManager.this;
            StorageStateChangedStorageEvent storageStateChangedStorageEvent = storageManager.new StorageStateChangedStorageEvent(string2, string3, string4);
            Handler handler = this.mHandler;
            Message message = storageStateChangedStorageEvent.getMessage();
            boolean bl = handler.sendMessage(message);
        }
    }

    private class StorageStateChangedStorageEvent
    extends StorageEvent {
        public String newState;
        public String oldState;
        public String path;

        public StorageStateChangedStorageEvent(String string2, String string3, String string4) {
            super(2);
            this.path = string2;
            this.oldState = string3;
            this.newState = string4;
        }
    }

    private class UmsConnectionChangedStorageEvent
    extends StorageEvent {
        public boolean available;

        public UmsConnectionChangedStorageEvent(boolean bl) {
            super(1);
            this.available = bl;
        }
    }

    private class StorageEvent {
        static final int EVENT_OBB_STATE_CHANGED = 3;
        static final int EVENT_STORAGE_STATE_CHANGED = 2;
        static final int EVENT_UMS_CONNECTION_CHANGED = 1;
        private Message mMessage;

        public StorageEvent(int n) {
            Message message;
            this.mMessage = message = Message.obtain();
            this.mMessage.what = n;
            this.mMessage.obj = this;
        }

        public Message getMessage() {
            return this.mMessage;
        }
    }

    private class ObbStateChangedStorageEvent
    extends StorageEvent {
        public final String path;
        public final int state;

        public ObbStateChangedStorageEvent(String string2, int n) {
            super(3);
            this.path = string2;
            this.state = n;
        }
    }

    private class ObbListenerDelegate {
        private final Handler mHandler;
        private final WeakReference<OnObbStateChangeListener> mObbEventListenerRef;
        private final int nonce;

        ObbListenerDelegate(OnObbStateChangeListener onObbStateChangeListener) {
            Handler handler;
            int n;
            this.nonce = n = StorageManager.this.getNextNonce();
            WeakReference<OnObbStateChangeListener> weakReference = new WeakReference<OnObbStateChangeListener>(onObbStateChangeListener);
            this.mObbEventListenerRef = weakReference;
            Looper looper = StorageManager.this.mTgtLooper;
            this.mHandler = handler = new Handler(looper){

                @Override
                public void handleMessage(Message message) {
                    OnObbStateChangeListener onObbStateChangeListener = ObbListenerDelegate.this.getListener();
                    if (onObbStateChangeListener == null) {
                        return;
                    }
                    StorageEvent storageEvent = (StorageEvent)message.obj;
                    if (message.what == 3) {
                        ObbStateChangedStorageEvent obbStateChangedStorageEvent = (ObbStateChangedStorageEvent)storageEvent;
                        String string2 = obbStateChangedStorageEvent.path;
                        int n = obbStateChangedStorageEvent.state;
                        onObbStateChangeListener.onObbStateChange(string2, n);
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("Unsupported event ");
                    int n = message.what;
                    String string3 = stringBuilder.append(n).toString();
                    int n2 = Log.e(StorageManager.TAG, string3);
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        OnObbStateChangeListener getListener() {
            if (this.mObbEventListenerRef != null) return (OnObbStateChangeListener)this.mObbEventListenerRef.get();
            return null;
        }

        void sendObbStateChanged(String string2, int n) {
            StorageManager storageManager = StorageManager.this;
            ObbStateChangedStorageEvent obbStateChangedStorageEvent = storageManager.new ObbStateChangedStorageEvent(string2, n);
            Handler handler = this.mHandler;
            Message message = obbStateChangedStorageEvent.getMessage();
            boolean bl = handler.sendMessage(message);
        }
    }

    private class ObbActionListener
    extends IObbActionListener.Stub {
        private SparseArray<ObbListenerDelegate> mListeners;

        private ObbActionListener() {
            SparseArray sparseArray = new SparseArray();
            this.mListeners = sparseArray;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int addListener(OnObbStateChangeListener onObbStateChangeListener) {
            StorageManager storageManager = StorageManager.this;
            ObbListenerDelegate obbListenerDelegate = storageManager.new ObbListenerDelegate(onObbStateChangeListener);
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                SparseArray<ObbListenerDelegate> sparseArray2 = this.mListeners;
                int n = obbListenerDelegate.nonce;
                sparseArray2.put(n, obbListenerDelegate);
                return obbListenerDelegate.nonce;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onObbResult(String string2, int n, int n2) throws RemoteException {
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            // MONITORENTER : sparseArray
            ObbListenerDelegate obbListenerDelegate = this.mListeners.get(n);
            if (obbListenerDelegate != null) {
                this.mListeners.remove(n);
            }
            // MONITOREXIT : sparseArray
            if (obbListenerDelegate == null) {
                return;
            }
            obbListenerDelegate.sendObbStateChanged(string2, n2);
        }
    }

    private class MountServiceBinderListener
    extends IMountServiceListener.Stub {
        private MountServiceBinderListener() {
        }

        @Override
        public void onStorageStateChanged(String string2, String string3, String string4) {
            int n = StorageManager.this.mListeners.size();
            int n2 = 0;
            while (n2 < n) {
                ((ListenerDelegate)StorageManager.this.mListeners.get(n2)).sendStorageStateChanged(string2, string3, string4);
                ++n2;
            }
            return;
        }

        @Override
        public void onUsbMassStorageConnectionChanged(boolean bl) {
            int n = StorageManager.this.mListeners.size();
            int n2 = 0;
            while (n2 < n) {
                ((ListenerDelegate)StorageManager.this.mListeners.get(n2)).sendShareAvailabilityChanged(bl);
                ++n2;
            }
            return;
        }
    }
}

