/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.provider.ContactsContract;
import android.util.Log;
import android.widget.ImageView;
import com.android.internal.telephony.CallerInfo;
import com.android.internal.telephony.Connection;
import java.io.InputStream;

public class ContactsAsyncHelper
extends Handler {
    private static final boolean DBG = false;
    private static final int DEFAULT_TOKEN = 255;
    private static final int EVENT_LOAD_IMAGE = 1;
    private static final String LOG_TAG = "ContactsAsyncHelper";
    private static ContactsAsyncHelper sInstance = new ContactsAsyncHelper();
    private static Handler sThreadHandler;

    private ContactsAsyncHelper() {
        HandlerThread handlerThread = new HandlerThread("ContactsAsyncWorker");
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        sThreadHandler = new WorkerHandler(looper);
    }

    public static final void updateImageViewWithContactPhotoAsync(Context context, ImageView imageView, Uri uri, int n) {
        OnImageLoadCompleteListener onImageLoadCompleteListener = null;
        Object var5_5 = null;
        Context context2 = context;
        ImageView imageView2 = imageView;
        Uri uri2 = uri;
        int n2 = n;
        ContactsAsyncHelper.updateImageViewWithContactPhotoAsync(null, -1, onImageLoadCompleteListener, var5_5, context2, imageView2, uri2, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void updateImageViewWithContactPhotoAsync(CallerInfo callerInfo, int n, OnImageLoadCompleteListener onImageLoadCompleteListener, Object object, Context context, ImageView imageView, Uri uri, int n2) {
        if (uri == null) {
            imageView.setVisibility(0);
            imageView.setImageResource(n2);
            return;
        }
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.cookie = object;
        workerArgs.context = context;
        workerArgs.view = imageView;
        workerArgs.uri = uri;
        workerArgs.defaultResource = n2;
        workerArgs.listener = onImageLoadCompleteListener;
        workerArgs.info = callerInfo;
        Message message = sThreadHandler.obtainMessage(n);
        message.arg1 = 1;
        message.obj = workerArgs;
        if (n2 != -1) {
            imageView.setVisibility(0);
            imageView.setImageResource(n2);
        } else {
            imageView.setVisibility(4);
        }
        boolean bl = sThreadHandler.sendMessage(message);
    }

    public static final void updateImageViewWithContactPhotoAsync(CallerInfo callerInfo, Context context, ImageView imageView, Uri uri, int n) {
        CallerInfo callerInfo2 = callerInfo;
        Object var6_6 = null;
        Context context2 = context;
        ImageView imageView2 = imageView;
        Uri uri2 = uri;
        int n2 = n;
        ContactsAsyncHelper.updateImageViewWithContactPhotoAsync(callerInfo2, -1, null, var6_6, context2, imageView2, uri2, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        WorkerArgs workerArgs = (WorkerArgs)message.obj;
        switch (message.arg1) {
            default: {
                return;
            }
            case 1: 
        }
        boolean bl = false;
        if (workerArgs.result != null) {
            workerArgs.view.setVisibility(0);
            ImageView imageView = workerArgs.view;
            Drawable drawable2 = (Drawable)workerArgs.result;
            imageView.setImageDrawable(drawable2);
            if (workerArgs.info != null) {
                Drawable drawable3;
                CallerInfo callerInfo = workerArgs.info;
                callerInfo.cachedPhoto = drawable3 = (Drawable)workerArgs.result;
            }
            bl = true;
        } else if (workerArgs.defaultResource != -1) {
            workerArgs.view.setVisibility(0);
            ImageView imageView = workerArgs.view;
            int n = workerArgs.defaultResource;
            imageView.setImageResource(n);
        }
        if (workerArgs.info != null) {
            workerArgs.info.isCachedPhotoCurrent = true;
        }
        if (workerArgs.listener == null) {
            return;
        }
        OnImageLoadCompleteListener onImageLoadCompleteListener = workerArgs.listener;
        int n = message.what;
        Object object = workerArgs.cookie;
        ImageView imageView = workerArgs.view;
        onImageLoadCompleteListener.onImageLoadComplete(n, object, imageView, bl);
    }

    private class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            Object object;
            int n;
            WorkerArgs workerArgs = (WorkerArgs)message.obj;
            switch (message.arg1) {
                default: {
                    break;
                }
                case 1: {
                    InputStream inputStream = null;
                    try {
                        InputStream inputStream2;
                        ContentResolver contentResolver = workerArgs.context.getContentResolver();
                        Uri uri = workerArgs.uri;
                        inputStream = inputStream2 = ContactsContract.Contacts.openContactPhotoInputStream(contentResolver, uri);
                    }
                    catch (Exception exception) {
                        int n2 = Log.e(ContactsAsyncHelper.LOG_TAG, "Error opening photo input stream", exception);
                    }
                    if (inputStream != null) {
                        String string2 = workerArgs.uri.toString();
                        Drawable drawable2 = Drawable.createFromStream(inputStream, string2);
                        workerArgs.result = drawable2;
                        break;
                    }
                    workerArgs.result = null;
                }
            }
            ContactsAsyncHelper contactsAsyncHelper = ContactsAsyncHelper.this;
            int n3 = message.what;
            Message message2 = contactsAsyncHelper.obtainMessage(n3);
            message2.arg1 = n = message.arg1;
            message2.obj = object = message.obj;
            message2.sendToTarget();
        }
    }

    public static class ImageTracker {
        public static final int DISPLAY_DEFAULT = 254;
        public static final int DISPLAY_IMAGE = 255;
        public static final int DISPLAY_UNDEFINED;
        private int displayMode = 0;
        private CallerInfo mCurrentCallerInfo = null;

        public int getPhotoState() {
            return this.displayMode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Uri getPhotoUri() {
            if (this.mCurrentCallerInfo == null) return null;
            Uri uri = ContactsContract.Contacts.CONTENT_URI;
            long l = this.mCurrentCallerInfo.person_id;
            return ContentUris.withAppendedId(uri, l);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isDifferentImageRequest(CallerInfo callerInfo) {
            if (this.mCurrentCallerInfo == callerInfo) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isDifferentImageRequest(Connection connection) {
            if (connection == null) {
                if (this.mCurrentCallerInfo == null) return false;
                return true;
            }
            Object object = connection.getUserData();
            boolean bl = true;
            if (!(object instanceof CallerInfo)) return bl;
            CallerInfo callerInfo = (CallerInfo)object;
            bl = this.isDifferentImageRequest(callerInfo);
            return bl;
        }

        public void setPhotoRequest(CallerInfo callerInfo) {
            this.mCurrentCallerInfo = callerInfo;
        }

        public void setPhotoState(int n) {
            this.displayMode = n;
        }
    }

    private static final class WorkerArgs {
        public Context context;
        public Object cookie;
        public int defaultResource;
        public CallerInfo info;
        public OnImageLoadCompleteListener listener;
        public Object result;
        public Uri uri;
        public ImageView view;

        private WorkerArgs() {
        }
    }

    public static interface OnImageLoadCompleteListener {
        public void onImageLoadComplete(int var1, Object var2, ImageView var3, boolean var4);
    }
}

