/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import android.text.TextUtils;
import android.text.format.Time;

public class EventRecurrence {
    public static final int DAILY = 4;
    public static final int FR = 0x200000;
    public static final int HOURLY = 3;
    public static final int MINUTELY = 2;
    public static final int MO = 131072;
    public static final int MONTHLY = 6;
    public static final int SA = 0x400000;
    public static final int SECONDLY = 1;
    public static final int SU = 65536;
    public static final int TH = 0x100000;
    public static final int TU = 262144;
    public static final int WE = 524288;
    public static final int WEEKLY = 5;
    public static final int YEARLY = 7;
    public int[] byday;
    public int bydayCount;
    public int[] bydayNum;
    public int[] byhour;
    public int byhourCount;
    public int[] byminute;
    public int byminuteCount;
    public int[] bymonth;
    public int bymonthCount;
    public int[] bymonthday;
    public int bymonthdayCount;
    public int[] bysecond;
    public int bysecondCount;
    public int[] bysetpos;
    public int bysetposCount;
    public int[] byweekno;
    public int byweeknoCount;
    public int[] byyearday;
    public int byyeardayCount;
    public int count;
    public int freq;
    public int interval;
    public Time startDate;
    public String until;
    public int wkst = 131072;

    private void appendByDay(StringBuilder stringBuilder, int n) {
        int n2 = this.bydayNum[n];
        if (n2 != 0) {
            StringBuilder stringBuilder2 = stringBuilder.append(n2);
        }
        String string2 = EventRecurrence.day2String(this.byday[n]);
        StringBuilder stringBuilder3 = stringBuilder.append(string2);
    }

    private static void appendNumbers(StringBuilder stringBuilder, String string2, int n, int[] nArray) {
        if (n <= 0) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        n += -1;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            StringBuilder stringBuilder3 = stringBuilder.append(n2);
            StringBuilder stringBuilder4 = stringBuilder.append(",");
        }
        int n3 = nArray[n];
        StringBuilder stringBuilder5 = stringBuilder.append(n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int calendarDay2Day(int n) {
        switch (n) {
            default: {
                String string2 = "bad day of week: " + n;
                throw new RuntimeException(string2);
            }
            case 1: {
                return 65536;
            }
            case 2: {
                return 131072;
            }
            case 3: {
                return 262144;
            }
            case 4: {
                return 524288;
            }
            case 5: {
                return 0x100000;
            }
            case 6: {
                return 0x200000;
            }
            case 7: 
        }
        return 0x400000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int day2CalendarDay(int n) {
        switch (n) {
            default: {
                String string2 = "bad day of week: " + n;
                throw new RuntimeException(string2);
            }
            case 65536: {
                return 1;
            }
            case 131072: {
                return 2;
            }
            case 262144: {
                return 3;
            }
            case 524288: {
                return 4;
            }
            case 0x100000: {
                return 5;
            }
            case 0x200000: {
                return 6;
            }
            case 0x400000: 
        }
        return 7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String day2String(int n) {
        switch (n) {
            default: {
                String string2 = "bad day argument: " + n;
                throw new IllegalArgumentException(string2);
            }
            case 65536: {
                return "SU";
            }
            case 131072: {
                return "MO";
            }
            case 262144: {
                return "TU";
            }
            case 524288: {
                return "WE";
            }
            case 0x100000: {
                return "TH";
            }
            case 0x200000: {
                return "FR";
            }
            case 0x400000: 
        }
        return "SA";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int day2TimeDay(int n) {
        switch (n) {
            default: {
                String string2 = "bad day of week: " + n;
                throw new RuntimeException(string2);
            }
            case 65536: {
                return 0;
            }
            case 131072: {
                return 1;
            }
            case 262144: {
                return 2;
            }
            case 524288: {
                return 3;
            }
            case 0x100000: {
                return 4;
            }
            case 0x200000: {
                return 5;
            }
            case 0x400000: 
        }
        return 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int timeDay2Day(int n) {
        switch (n) {
            default: {
                String string2 = "bad day of week: " + n;
                throw new RuntimeException(string2);
            }
            case 0: {
                return 65536;
            }
            case 1: {
                return 131072;
            }
            case 2: {
                return 262144;
            }
            case 3: {
                return 524288;
            }
            case 4: {
                return 0x100000;
            }
            case 5: {
                return 0x200000;
            }
            case 6: 
        }
        return 0x400000;
    }

    public native void parse(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean repeatsMonthlyOnDayCount() {
        if (this.freq != 6) {
            return false;
        }
        if (this.bydayCount != 1) return false;
        if (this.bymonthdayCount == 0) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean repeatsOnEveryWeekDay() {
        if (this.freq != 5) {
            return false;
        }
        int n = this.bydayCount;
        if (n != 5) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.byday[n2];
            if (n3 == 65536) return false;
            if (n3 == 0x400000) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setStartDate(Time time) {
        this.startDate = time;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("FREQ=");
        switch (this.freq) {
            case 1: {
                StringBuilder stringBuilder3 = stringBuilder.append("SECONDLY");
                break;
            }
            case 2: {
                StringBuilder stringBuilder4 = stringBuilder.append("MINUTELY");
                break;
            }
            case 3: {
                StringBuilder stringBuilder5 = stringBuilder.append("HOURLY");
                break;
            }
            case 4: {
                StringBuilder stringBuilder6 = stringBuilder.append("DAILY");
                break;
            }
            case 5: {
                StringBuilder stringBuilder7 = stringBuilder.append("WEEKLY");
                break;
            }
            case 6: {
                StringBuilder stringBuilder8 = stringBuilder.append("MONTHLY");
                break;
            }
            case 7: {
                StringBuilder stringBuilder9 = stringBuilder.append("YEARLY");
            }
        }
        if (!TextUtils.isEmpty(this.until)) {
            StringBuilder stringBuilder10 = stringBuilder.append(";UNTIL=");
            String string2 = this.until;
            StringBuilder stringBuilder11 = stringBuilder.append(string2);
        }
        if (this.count != 0) {
            StringBuilder stringBuilder12 = stringBuilder.append(";COUNT=");
            int n = this.count;
            StringBuilder stringBuilder13 = stringBuilder.append(n);
        }
        if (this.interval != 0) {
            StringBuilder stringBuilder14 = stringBuilder.append(";INTERVAL=");
            int n = this.interval;
            StringBuilder stringBuilder15 = stringBuilder.append(n);
        }
        if (this.wkst != 0) {
            StringBuilder stringBuilder16 = stringBuilder.append(";WKST=");
            String string3 = EventRecurrence.day2String(this.wkst);
            StringBuilder stringBuilder17 = stringBuilder.append(string3);
        }
        int n = this.bysecondCount;
        int[] nArray = this.bysecond;
        EventRecurrence.appendNumbers(stringBuilder, ";BYSECOND=", n, nArray);
        int n2 = this.byminuteCount;
        int[] nArray2 = this.byminute;
        EventRecurrence.appendNumbers(stringBuilder, ";BYMINUTE=", n2, nArray2);
        int n3 = this.byhourCount;
        int[] nArray3 = this.byhour;
        EventRecurrence.appendNumbers(stringBuilder, ";BYSECOND=", n3, nArray3);
        int n4 = this.bydayCount;
        if (n4 > 0) {
            StringBuilder stringBuilder18 = stringBuilder.append(";BYDAY=");
            n4 += -1;
            for (int i = 0; i < n4; ++i) {
                this.appendByDay(stringBuilder, i);
                StringBuilder stringBuilder19 = stringBuilder.append(",");
            }
            this.appendByDay(stringBuilder, n4);
        }
        int n5 = this.bymonthdayCount;
        int[] nArray4 = this.bymonthday;
        EventRecurrence.appendNumbers(stringBuilder, ";BYMONTHDAY=", n5, nArray4);
        int n6 = this.byyeardayCount;
        int[] nArray5 = this.byyearday;
        EventRecurrence.appendNumbers(stringBuilder, ";BYYEARDAY=", n6, nArray5);
        int n7 = this.byweeknoCount;
        int[] nArray6 = this.byweekno;
        EventRecurrence.appendNumbers(stringBuilder, ";BYWEEKNO=", n7, nArray6);
        int n8 = this.bymonthCount;
        int[] nArray7 = this.bymonth;
        EventRecurrence.appendNumbers(stringBuilder, ";BYMONTH=", n8, nArray7);
        int n9 = this.bysetposCount;
        int[] nArray8 = this.bysetpos;
        EventRecurrence.appendNumbers(stringBuilder, ";BYSETPOS=", n9, nArray8);
        return stringBuilder.toString();
    }

    public static class InvalidFormatException
    extends RuntimeException {
        InvalidFormatException(String string2) {
            super(string2);
        }
    }
}

