/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ICalendar {
    private static final String TAG = "Sync";

    private ICalendar() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Parameter extractParameter(ParserState parserState) throws FormatException {
        String string2 = parserState.line;
        int n = string2.length();
        int n2 = -1;
        while (true) {
            int n3;
            if (parserState.index >= n) {
                String string3 = "Expected ':' before end of line in " + string2;
                throw new FormatException(string3);
            }
            int n4 = parserState.index;
            char c = string2.charAt(n4);
            if (c == ':') {
                return null;
            }
            if (c == ';') {
                Parameter parameter = new Parameter();
                int n5 = parserState.index;
            } else if (c == '=') {
                n2 = parserState.index;
                String string4 = "Expected ';' before '=' in " + string2;
                throw new FormatException(string4);
            }
            parserState.index = n3 = parserState.index + 1;
        }
    }

    private static String extractValue(ParserState parserState) throws FormatException {
        int n;
        int n2;
        int n3 = parserState.index;
        String string2 = parserState.line;
        int n4 = string2.length();
        if (n3 >= n4 || string2.charAt(n2 = parserState.index) != ':') {
            String string3 = "Expected ':' before end of line in " + string2;
            throw new FormatException(string3);
        }
        int n5 = parserState.index + 1;
        String string4 = string2.substring(n5);
        parserState.index = n = string2.length() - 1;
        return string4;
    }

    private static String normalizeText(String string2) {
        return string2.replaceAll("\r\n", "\n").replaceAll("\r", "\n").replaceAll("\n ", "");
    }

    public static Component parseCalendar(String string2) throws FormatException {
        String string3;
        Component component = ICalendar.parseComponent(null, string2);
        if (component == null || !"VCALENDAR".equals(string3 = component.getName())) {
            throw new FormatException("Expected VCALENDAR");
        }
        return component;
    }

    public static Component parseComponent(Component component, String string2) throws FormatException {
        String string3 = ICalendar.normalizeText(string2);
        return ICalendar.parseComponentImpl(component, string3);
    }

    public static Component parseComponent(String string2) throws FormatException {
        return ICalendar.parseComponent(null, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Component parseComponentImpl(Component component, String string2) throws FormatException {
        Component component2 = component;
        ParserState parserState = new ParserState();
        parserState.index = 0;
        String[] stringArray = string2.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            try {
                Component component3;
                component2 = component3 = ICalendar.parseLine(string3, parserState, component2);
                if (component == null) {
                    component = component2;
                }
            }
            catch (FormatException formatException) {}
            ++n2;
        }
        return component;
    }

    public static Component parseEvent(String string2) throws FormatException {
        String string3;
        Component component = ICalendar.parseComponent(null, string2);
        if (component == null || !"VEVENT".equals(string3 = component.getName())) {
            throw new FormatException("Expected VEVENT");
        }
        return component;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Component parseLine(String string2, ParserState parserState, Component component) throws FormatException {
        String string3;
        parserState.line = string2;
        int n = parserState.line.length();
        char c = '\u0000';
        parserState.index = 0;
        while (true) {
            int n2;
            int n3;
            if (parserState.index >= n || (c = string2.charAt(n3 = parserState.index)) == ';' || c == ':') {
                int n4 = parserState.index;
                string3 = string2.substring(0, n4);
                if (component != null || "BEGIN".equals(string3)) break;
                throw new FormatException("Expected BEGIN");
            }
            parserState.index = n2 = parserState.index + 1;
        }
        if ("BEGIN".equals(string3)) {
            String string4 = ICalendar.extractValue(parserState);
            Component component2 = new Component(string4, component);
            if (component == null) return component2;
            component.addChild(component2);
            return component2;
        }
        if ("END".equals(string3)) {
            String string5 = ICalendar.extractValue(parserState);
            if (component != null) {
                String string6 = component.getName();
                if (string5.equals(string6)) return component.getParent();
            }
            String string7 = "Unexpected END " + string5;
            throw new FormatException(string7);
        }
        Property property = new Property(string3);
        if (c == ';') {
            Parameter parameter;
            while ((parameter = ICalendar.extractParameter(parserState)) != null) {
                property.addParameter(parameter);
            }
        }
        String string8 = ICalendar.extractValue(parserState);
        property.setValue(string8);
        component.addProperty(property);
        return component;
    }

    private static final class ParserState {
        public int index;
        public String line;

        private ParserState() {
        }
    }

    public static class Parameter {
        public String name;
        public String value;

        public Parameter() {
        }

        public Parameter(String string2, String string3) {
            this.name = string2;
            this.value = string3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            String string2 = this.name;
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            StringBuilder stringBuilder3 = stringBuilder.append("=");
            String string3 = this.value;
            StringBuilder stringBuilder4 = stringBuilder.append(string3);
        }
    }

    public static class Property {
        public static final String DTEND = "DTEND";
        public static final String DTSTART = "DTSTART";
        public static final String DURATION = "DURATION";
        public static final String EXDATE = "EXDATE";
        public static final String EXRULE = "EXRULE";
        public static final String RDATE = "RDATE";
        public static final String RRULE = "RRULE";
        private final String mName;
        private LinkedHashMap<String, ArrayList<Parameter>> mParamsMap;
        private String mValue;

        public Property(String string2) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            this.mParamsMap = linkedHashMap;
            this.mName = string2;
        }

        public Property(String string2, String string3) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            this.mParamsMap = linkedHashMap;
            this.mName = string2;
            this.mValue = string3;
        }

        public void addParameter(Parameter parameter) {
            LinkedHashMap<String, ArrayList<Parameter>> linkedHashMap = this.mParamsMap;
            String string2 = parameter.name;
            ArrayList<Parameter> arrayList = linkedHashMap.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                LinkedHashMap<String, ArrayList<Parameter>> linkedHashMap2 = this.mParamsMap;
                String string3 = parameter.name;
                ArrayList<Parameter> arrayList2 = linkedHashMap2.put(string3, arrayList);
            }
            boolean bl = arrayList.add(parameter);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Parameter getFirstParameter(String string2) {
            ArrayList<Parameter> arrayList = this.mParamsMap.get(string2);
            if (arrayList == null) return null;
            if (arrayList.size() != 0) return arrayList.get(0);
            return null;
        }

        public String getName() {
            return this.mName;
        }

        public Set<String> getParameterNames() {
            return this.mParamsMap.keySet();
        }

        public List<Parameter> getParameters(String string2) {
            return this.mParamsMap.get(string2);
        }

        public String getValue() {
            return this.mValue;
        }

        public void setValue(String string2) {
            this.mValue = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            String string2 = this.mName;
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            for (String string3 : this.getParameterNames()) {
                for (Parameter parameter : this.getParameters(string3)) {
                    StringBuilder stringBuilder3 = stringBuilder.append(";");
                    parameter.toString(stringBuilder);
                }
            }
            StringBuilder stringBuilder4 = stringBuilder.append(":");
            String string4 = this.mValue;
            StringBuilder stringBuilder5 = stringBuilder.append(string4);
        }
    }

    public static class Component {
        private static final String BEGIN = "BEGIN";
        private static final String END = "END";
        private static final String NEWLINE = "\n";
        public static final String VALARM = "VALARM";
        public static final String VCALENDAR = "VCALENDAR";
        public static final String VEVENT = "VEVENT";
        public static final String VFREEBUSY = "VFREEBUSY";
        public static final String VJOURNAL = "VJOURNAL";
        public static final String VTIMEZONE = "VTIMEZONE";
        public static final String VTODO = "VTODO";
        private LinkedList<Component> mChildren = null;
        private final String mName;
        private final Component mParent;
        private final LinkedHashMap<String, ArrayList<Property>> mPropsMap;

        public Component(String string2, Component component) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            this.mPropsMap = linkedHashMap;
            this.mName = string2;
            this.mParent = component;
        }

        public void addChild(Component component) {
            boolean bl = this.getOrCreateChildren().add(component);
        }

        public void addProperty(Property property) {
            String string2 = property.getName();
            ArrayList<Property> arrayList = this.mPropsMap.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                ArrayList<Property> arrayList2 = this.mPropsMap.put(string2, arrayList);
            }
            boolean bl = arrayList.add(property);
        }

        public List<Component> getComponents() {
            return this.mChildren;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Property getFirstProperty(String string2) {
            List list = this.mPropsMap.get(string2);
            if (list == null) return null;
            if (list.size() != 0) return (Property)list.get(0);
            return null;
        }

        public String getName() {
            return this.mName;
        }

        protected LinkedList<Component> getOrCreateChildren() {
            if (this.mChildren == null) {
                LinkedList linkedList = new LinkedList();
                this.mChildren = linkedList;
            }
            return this.mChildren;
        }

        public Component getParent() {
            return this.mParent;
        }

        public List<Property> getProperties(String string2) {
            return this.mPropsMap.get(string2);
        }

        public Set<String> getPropertyNames() {
            return this.mPropsMap.keySet();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            StringBuilder stringBuilder2 = stringBuilder.append(NEWLINE);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            StringBuilder stringBuilder2 = stringBuilder.append(BEGIN);
            StringBuilder stringBuilder3 = stringBuilder.append(":");
            String string2 = this.mName;
            StringBuilder stringBuilder4 = stringBuilder.append(string2);
            StringBuilder stringBuilder5 = stringBuilder.append(NEWLINE);
            for (String string3 : this.getPropertyNames()) {
                Iterator<Property> iterator = this.getProperties(string3).iterator();
                while (iterator.hasNext()) {
                    iterator.next().toString(stringBuilder);
                    StringBuilder stringBuilder6 = stringBuilder.append(NEWLINE);
                }
            }
            if (this.mChildren != null) {
                Iterator<String> iterator = this.mChildren.iterator();
                while (iterator.hasNext()) {
                    ((Component)((Object)iterator.next())).toString(stringBuilder);
                    StringBuilder stringBuilder7 = stringBuilder.append(NEWLINE);
                }
            }
            StringBuilder stringBuilder8 = stringBuilder.append(END);
            StringBuilder stringBuilder9 = stringBuilder.append(":");
            String string4 = this.mName;
            StringBuilder stringBuilder10 = stringBuilder.append(string4);
        }
    }

    public static class FormatException
    extends Exception {
        public FormatException() {
        }

        public FormatException(String string2) {
            super(string2);
        }

        public FormatException(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }
}

