/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import android.content.ContentValues;
import android.database.Cursor;
import android.pim.EventRecurrence;
import android.pim.ICalendar;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class RecurrenceSet {
    private static final String FOLDING_SEPARATOR = "\n ";
    private static final Pattern FOLD_RE;
    private static final Pattern IGNORABLE_ICAL_WHITESPACE_RE;
    private static final String RULE_SEPARATOR = "\n";
    private static final String TAG = "CalendarProvider";
    public long[] exdates = null;
    public EventRecurrence[] exrules = null;
    public long[] rdates = null;
    public EventRecurrence[] rrules = null;

    static {
        IGNORABLE_ICAL_WHITESPACE_RE = Pattern.compile("(?:\\r\\n?|\\n)[ \t]");
        FOLD_RE = Pattern.compile(".{75}");
    }

    public RecurrenceSet(ContentValues contentValues) throws EventRecurrence.InvalidFormatException {
        String string2 = contentValues.getAsString("rrule");
        String string3 = contentValues.getAsString("rdate");
        String string4 = contentValues.getAsString("exrule");
        String string5 = contentValues.getAsString("exdate");
        this.init(string2, string3, string4, string5);
    }

    public RecurrenceSet(Cursor cursor) throws EventRecurrence.InvalidFormatException {
        int n = cursor.getColumnIndex("rrule");
        int n2 = cursor.getColumnIndex("rdate");
        int n3 = cursor.getColumnIndex("exrule");
        int n4 = cursor.getColumnIndex("exdate");
        String string2 = cursor.getString(n);
        String string3 = cursor.getString(n2);
        String string4 = cursor.getString(n3);
        String string5 = cursor.getString(n4);
        this.init(string2, string3, string4, string5);
    }

    public RecurrenceSet(String string2, String string3, String string4, String string5) throws EventRecurrence.InvalidFormatException {
        this.init(string2, string3, string4, string5);
    }

    private static void addPropertiesForRuleStr(ICalendar.Component component, String string2, String string3) {
        if (TextUtils.isEmpty(string3)) {
            return;
        }
        String[] stringArray = RecurrenceSet.getRuleStrings(string3);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string4 = stringArray[n2];
            ICalendar.Property property = new ICalendar.Property(string2);
            property.setValue(string4);
            component.addProperty(property);
            ++n2;
        }
        return;
    }

    private static void addPropertyForDateStr(ICalendar.Component component, String string2, String string3) {
        if (TextUtils.isEmpty(string3)) {
            return;
        }
        ICalendar.Property property = new ICalendar.Property(string2);
        String string4 = null;
        int n = string3.indexOf(";");
        if (n != -1) {
            string4 = string3.substring(0, n);
            int n2 = n + 1;
            string3 = string3.substring(n2);
        }
        if (!TextUtils.isEmpty(string4)) {
            ICalendar.Parameter parameter = new ICalendar.Parameter("TZID", string4);
            property.addParameter(parameter);
        }
        property.setValue(string3);
        component.addProperty(property);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String computeDuration(Time time, ICalendar.Component object) {
        Object object2 = ((ICalendar.Component)object).getFirstProperty("DURATION");
        if (object2 != null) {
            return object2.getValue();
        }
        if ((object = ((ICalendar.Component)object).getFirstProperty("DTEND")) == null) {
            return "+P0S";
        }
        ICalendar.Parameter parameter = ((ICalendar.Property)object).getFirstParameter("TZID");
        String string2 = parameter == null ? time.timezone : parameter.value;
        Time time2 = new Time(string2);
        String string3 = ((ICalendar.Property)object).getValue();
        boolean bl = time2.parse(string3);
        long l = time2.toMillis(false);
        long l2 = time.toMillis(false);
        object2 = (l - l2) / 1000L;
        if (!time.allDay) return "P" + (long)object2 + "S";
        if (object2 % 86400L != 0L) return "P" + (long)object2 + "S";
        StringBuilder stringBuilder = new StringBuilder().append("P");
        reference var15_12 = object2 / 86400L;
        return stringBuilder.append((long)var15_12).append("D").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String extractDates(ICalendar.Property property) {
        if (property == null) {
            return null;
        }
        ICalendar.Parameter parameter = property.getFirstParameter("TZID");
        if (parameter == null) return property.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = parameter.value;
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(";");
        String string3 = property.getValue();
        return stringBuilder2.append(string3).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String flattenProperties(ICalendar.Component component, String string2) {
        List<ICalendar.Property> list = component.getProperties(string2);
        if (list == null) return null;
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0).getValue();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Iterator<ICalendar.Property> iterator = component.getProperties(string2).iterator();
        while (iterator.hasNext()) {
            ICalendar.Property property = iterator.next();
            if (bl) {
                bl = false;
            } else {
                StringBuilder stringBuilder2 = stringBuilder.append(RULE_SEPARATOR);
            }
            String string3 = property.getValue();
            StringBuilder stringBuilder3 = stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static String fold(String string2) {
        return FOLD_RE.matcher(string2).replaceAll("$0\r\n ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getRuleStrings(String string2) {
        if (string2 == null) {
            return new String[0];
        }
        String[] stringArray = RecurrenceSet.unfold(string2).split(RULE_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3;
            stringArray[n2] = string3 = RecurrenceSet.fold(stringArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    private void init(String string2, String string3, String string4, String string5) throws EventRecurrence.InvalidFormatException {
        int n;
        if (TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3)) {
            return;
        }
        if (!TextUtils.isEmpty(string2)) {
            int n2;
            String[] stringArray = string2.split(RULE_SEPARATOR);
            EventRecurrence[] eventRecurrenceArray = new EventRecurrence[stringArray.length];
            this.rrules = eventRecurrenceArray;
            for (n = 0; n < (n2 = stringArray.length); ++n) {
                EventRecurrence eventRecurrence = new EventRecurrence();
                String string6 = stringArray[n];
                eventRecurrence.parse(string6);
                this.rrules[n] = eventRecurrence;
            }
        }
        if (!TextUtils.isEmpty(string3)) {
            long[] lArray = RecurrenceSet.parseRecurrenceDates(string3);
            this.rdates = lArray;
        }
        if (!TextUtils.isEmpty(string4)) {
            int n3;
            String[] stringArray = string4.split(RULE_SEPARATOR);
            EventRecurrence[] eventRecurrenceArray = new EventRecurrence[stringArray.length];
            this.exrules = eventRecurrenceArray;
            for (n = 0; n < (n3 = stringArray.length); ++n) {
                EventRecurrence eventRecurrence = new EventRecurrence();
                eventRecurrence.parse(string4);
                this.exrules[n] = eventRecurrence;
            }
        }
        if (TextUtils.isEmpty(string5)) {
            return;
        }
        long[] lArray = RecurrenceSet.parseRecurrenceDates(string5);
        this.exdates = lArray;
    }

    public static long[] parseRecurrenceDates(String string2) {
        int n;
        String string3 = "UTC";
        int n2 = string2.indexOf(";");
        if (n2 != -1) {
            string3 = string2.substring(0, n2);
            int n3 = n2 + 1;
            string2 = string2.substring(n3);
        }
        Time time = new Time(string3);
        String[] stringArray = string2.split(",");
        int n4 = n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            long l;
            String string4 = stringArray[i];
            boolean bl = time.parse(string4);
            n4[i] = l = time.toMillis(false);
            time.timezone = string3;
        }
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean populateComponent(ContentValues contentValues, ICalendar.Component component) {
        Time time;
        long l = 65535L;
        if (contentValues.containsKey("dtstart")) {
            l = contentValues.getAsLong("dtstart");
        }
        String string2 = contentValues.getAsString("duration");
        String string3 = contentValues.getAsString("eventTimezone");
        String string4 = contentValues.getAsString("rrule");
        String string5 = contentValues.getAsString("rdate");
        String string6 = contentValues.getAsString("exrule");
        String string7 = contentValues.getAsString("exdate");
        Integer n = contentValues.getAsInteger("allDay");
        boolean bl = n != null ? n == 1 : false;
        if (l == 65535L) return false;
        if (TextUtils.isEmpty(string2)) return false;
        if (TextUtils.isEmpty(string4) && TextUtils.isEmpty(string5)) {
            return false;
        }
        ICalendar.Property property = new ICalendar.Property("DTSTART");
        if (!TextUtils.isEmpty(string3)) {
            if (!bl) {
                ICalendar.Parameter parameter = new ICalendar.Parameter("TZID", string3);
                property.addParameter(parameter);
            }
            time = new Time(string3);
        } else {
            time = new Time("UTC");
        }
        time.set(l);
        if (bl) {
            ICalendar.Parameter parameter = new ICalendar.Parameter("VALUE", "DATE");
            property.addParameter(parameter);
            time.allDay = true;
            time.hour = 0;
            time.minute = 0;
            time.second = 0;
        }
        String string8 = time.format2445();
        property.setValue(string8);
        component.addProperty(property);
        ICalendar.Property property2 = new ICalendar.Property("DURATION");
        property2.setValue(string2);
        component.addProperty(property2);
        RecurrenceSet.addPropertiesForRuleStr(component, "RRULE", string4);
        RecurrenceSet.addPropertyForDateStr(component, "RDATE", string5);
        RecurrenceSet.addPropertiesForRuleStr(component, "EXRULE", string6);
        RecurrenceSet.addPropertyForDateStr(component, "EXDATE", string7);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean populateComponent(Cursor cursor, ICalendar.Component component) {
        Object object = cursor.getColumnIndex("dtstart");
        int n = cursor.getColumnIndex("duration");
        int n2 = cursor.getColumnIndex("eventTimezone");
        int n3 = cursor.getColumnIndex("rrule");
        int n4 = cursor.getColumnIndex("rdate");
        int n5 = cursor.getColumnIndex("exrule");
        int n6 = cursor.getColumnIndex("exdate");
        int n7 = cursor.getColumnIndex("allDay");
        long l = 65535L;
        if (!cursor.isNull((int)object)) {
            l = cursor.getLong((int)object);
        }
        String string2 = cursor.getString(n);
        String string3 = cursor.getString(n2);
        String string4 = cursor.getString(n3);
        String string5 = cursor.getString(n4);
        String string6 = cursor.getString(n5);
        String string7 = cursor.getString(n6);
        boolean bl = cursor.getInt(n7) == 1;
        if (l == 65535L) return false;
        if (TextUtils.isEmpty(string2)) return false;
        if (TextUtils.isEmpty(string4) && TextUtils.isEmpty(string5)) {
            return false;
        }
        ICalendar.Property property = new ICalendar.Property("DTSTART");
        if (!TextUtils.isEmpty(string3)) {
            if (!bl) {
                ICalendar.Parameter parameter = new ICalendar.Parameter("TZID", string3);
                property.addParameter(parameter);
            }
            object = new Time(string3);
        } else {
            object = new Time("UTC");
        }
        ((Time)object).set(l);
        if (bl) {
            ICalendar.Parameter parameter = new ICalendar.Parameter("VALUE", "DATE");
            property.addParameter(parameter);
            ((Time)object).allDay = true;
            ((Time)object).hour = 0;
            ((Time)object).minute = 0;
            ((Time)object).second = 0;
        }
        String string8 = ((Time)object).format2445();
        property.setValue(string8);
        component.addProperty(property);
        ICalendar.Property property2 = new ICalendar.Property("DURATION");
        property2.setValue(string2);
        component.addProperty(property2);
        RecurrenceSet.addPropertiesForRuleStr(component, "RRULE", string4);
        RecurrenceSet.addPropertyForDateStr(component, "RDATE", string5);
        RecurrenceSet.addPropertiesForRuleStr(component, "EXRULE", string6);
        RecurrenceSet.addPropertyForDateStr(component, "EXDATE", (String)bl);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean populateContentValues(ICalendar.Component component, ContentValues contentValues) {
        ICalendar.Property property = component.getFirstProperty("DTSTART");
        String string2 = property.getValue();
        ICalendar.Parameter parameter = property.getFirstParameter("TZID");
        String string3 = parameter == null ? null : parameter.value;
        String string4 = parameter == null ? "UTC" : string3;
        Time time = new Time(string4);
        boolean bl = time.parse(string2);
        boolean bl2 = time.allDay;
        String string5 = bl || bl2 ? "UTC" : string3;
        String string6 = RecurrenceSet.computeDuration(time, component);
        String string7 = RecurrenceSet.flattenProperties(component, "RRULE");
        String string8 = RecurrenceSet.extractDates(component.getFirstProperty("RDATE"));
        String string9 = RecurrenceSet.flattenProperties(component, "EXRULE");
        String string10 = RecurrenceSet.extractDates(component.getFirstProperty("EXDATE"));
        if (TextUtils.isEmpty(string2) || TextUtils.isEmpty(string6) || TextUtils.isEmpty(string7) && TextUtils.isEmpty(string8)) {
            StringBuilder stringBuilder = new StringBuilder().append("Recurrence missing DTSTART, DTEND/DURATION, or RRULE/RDATE: ");
            String string11 = component.toString();
            String string12 = stringBuilder.append(string11).toString();
            int n = Log.d(TAG, string12);
            return false;
        }
        if (bl2) {
            time.timezone = "UTC";
        }
        long l = time.toMillis(false);
        Long l2 = l;
        contentValues.put("dtstart", l2);
        if (l == 65535L) {
            StringBuilder stringBuilder = new StringBuilder().append("DTSTART is out of range: ");
            String string13 = component.toString();
            String string14 = stringBuilder.append(string13).toString();
            int n = Log.d(TAG, string14);
            return false;
        }
        contentValues.put("rrule", string7);
        contentValues.put("rdate", string8);
        contentValues.put("exrule", string9);
        contentValues.put("exdate", string10);
        contentValues.put("eventTimezone", string5);
        contentValues.put("duration", string6);
        String string15 = "allDay";
        int n = bl2 ? 1 : 0;
        Integer n2 = n;
        contentValues.put(string15, n2);
        return true;
    }

    public static String unfold(String string2) {
        return IGNORABLE_ICAL_WHITESPACE_RE.matcher(string2).replaceAll("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasRecurrence() {
        if (this.rrules != null) return true;
        if (this.rdates == null) return false;
        return true;
    }
}

