/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentValues;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardUtils;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Base64;
import android.util.CharsetUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VCardBuilder {
    public static final int DEFAULT_EMAIL_TYPE = 3;
    public static final int DEFAULT_PHONE_TYPE = 1;
    public static final int DEFAULT_POSTAL_TYPE = 1;
    private static final String LOG_TAG = "VCardBuilder";
    private static final String SHIFT_JIS = "SHIFT_JIS";
    private static final String VCARD_DATA_PUBLIC = "PUBLIC";
    private static final String VCARD_DATA_SEPARATOR = ":";
    private static final String VCARD_DATA_VCARD = "VCARD";
    private static final String VCARD_END_OF_LINE = "\r\n";
    private static final String VCARD_ITEM_SEPARATOR = ";";
    private static final String VCARD_PARAM_ENCODING_BASE64_AS_B = "ENCODING=B";
    private static final String VCARD_PARAM_ENCODING_BASE64_V21 = "ENCODING=BASE64";
    private static final String VCARD_PARAM_ENCODING_QP = "ENCODING=QUOTED-PRINTABLE";
    private static final String VCARD_PARAM_EQUAL = "=";
    private static final String VCARD_PARAM_SEPARATOR = ";";
    private static final String VCARD_WS = " ";
    private static final Set<String> sAllowedAndroidPropertySet;
    private static final Map<Integer, Integer> sPostalTypePriorityMap;
    private final boolean mAppendTypeParamName;
    private StringBuilder mBuilder;
    private final String mCharset;
    private boolean mEndAppended;
    private final boolean mIsDoCoMo;
    private final boolean mIsJapaneseMobilePhone;
    private final boolean mIsV30OrV40;
    private final boolean mNeedsToConvertPhoneticString;
    private final boolean mOnlyOneNoteFieldIsAvailable;
    private final boolean mRefrainsQPToNameProperties;
    private final boolean mShouldAppendCharsetParam;
    private final boolean mShouldUseQuotedPrintable;
    private final boolean mUsesAndroidProperty;
    private final boolean mUsesDefactProperty;
    private final String mVCardCharsetParameter;
    private final int mVCardType;

    static {
        String[] stringArray = new String[]{"vnd.android.cursor.item/nickname", "vnd.android.cursor.item/contact_event", "vnd.android.cursor.item/relation"};
        List<String> list = Arrays.asList(stringArray);
        sAllowedAndroidPropertySet = Collections.unmodifiableSet(new HashSet<String>(list));
        Map<Integer, Integer> map = sPostalTypePriorityMap = new HashMap<Integer, Integer>();
        Integer n = 1;
        Integer n2 = 0;
        Integer n3 = map.put(n, n2);
        Map<Integer, Integer> map2 = sPostalTypePriorityMap;
        Integer n4 = 2;
        Integer n5 = 1;
        Integer n6 = map2.put(n4, n5);
        Map<Integer, Integer> map3 = sPostalTypePriorityMap;
        Integer n7 = 3;
        Integer n8 = 2;
        Integer n9 = map3.put(n7, n8);
        Map<Integer, Integer> map4 = sPostalTypePriorityMap;
        Integer n10 = 0;
        Integer n11 = 3;
        Integer n12 = map4.put(n10, n11);
    }

    public VCardBuilder(int n) {
        this(n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VCardBuilder(int n, String string2) {
        block18: {
            block15: {
                block17: {
                    block16: {
                        boolean bl;
                        boolean bl2;
                        boolean bl3;
                        boolean bl4;
                        boolean bl5;
                        boolean bl6;
                        boolean bl7;
                        boolean bl8;
                        boolean bl9;
                        this.mVCardType = n;
                        if (VCardConfig.isVersion40(n)) {
                            int n2 = Log.w(LOG_TAG, "Should not use vCard 4.0 when building vCard. It is not officially published yet.");
                        }
                        boolean bl10 = VCardConfig.isVersion30(n) || VCardConfig.isVersion40(n);
                        this.mIsV30OrV40 = bl10;
                        this.mShouldUseQuotedPrintable = bl9 = VCardConfig.shouldUseQuotedPrintable(n);
                        this.mIsDoCoMo = bl8 = VCardConfig.isDoCoMo(n);
                        this.mIsJapaneseMobilePhone = bl7 = VCardConfig.needsToConvertPhoneticString(n);
                        this.mOnlyOneNoteFieldIsAvailable = bl6 = VCardConfig.onlyOneNoteFieldIsAvailable(n);
                        this.mUsesAndroidProperty = bl5 = VCardConfig.usesAndroidSpecificProperty(n);
                        this.mUsesDefactProperty = bl4 = VCardConfig.usesDefactProperty(n);
                        this.mRefrainsQPToNameProperties = bl3 = VCardConfig.shouldRefrainQPToNameProperties(n);
                        this.mAppendTypeParamName = bl2 = VCardConfig.appendTypeParamName(n);
                        this.mNeedsToConvertPhoneticString = bl = VCardConfig.needsToConvertPhoneticString(n);
                        boolean bl11 = !VCardConfig.isVersion30(n) || !"UTF-8".equalsIgnoreCase(string2);
                        this.mShouldAppendCharsetParam = bl11;
                        if (!VCardConfig.isDoCoMo(n)) break block15;
                        if (SHIFT_JIS.equalsIgnoreCase(string2)) break block16;
                        String string3 = "The charset \"" + string2 + "\" is used while " + SHIFT_JIS + " is needed to be used.";
                        int n3 = Log.w(LOG_TAG, string3);
                        if (TextUtils.isEmpty(string2)) {
                            this.mCharset = SHIFT_JIS;
                            break block17;
                        } else {
                            try {
                                String string4;
                                string2 = string4 = CharsetUtils.charsetForVendor(string2).name();
                            }
                            catch (UnsupportedCharsetException unsupportedCharsetException) {
                                String string5 = "Career-specific \"" + string2 + "\" was not found (as usual). " + "Use it as is.";
                                int n4 = Log.i(LOG_TAG, string5);
                            }
                            this.mCharset = string2;
                        }
                        break block17;
                    }
                    if (this.mIsDoCoMo) {
                        try {
                            String string6;
                            string2 = string6 = CharsetUtils.charsetForVendor(SHIFT_JIS, "docomo").name();
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            int n5 = Log.e(LOG_TAG, "DoCoMo-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                            string2 = SHIFT_JIS;
                        }
                    } else {
                        try {
                            String string7;
                            string2 = string7 = CharsetUtils.charsetForVendor(SHIFT_JIS).name();
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            int n6 = Log.e(LOG_TAG, "Career-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                            string2 = SHIFT_JIS;
                        }
                    }
                    this.mCharset = string2;
                }
                this.mVCardCharsetParameter = "CHARSET=SHIFT_JIS";
                break block18;
            }
            if (TextUtils.isEmpty(string2)) {
                int n7 = Log.i(LOG_TAG, "Use the charset \"UTF-8\" for export.");
                this.mCharset = "UTF-8";
                this.mVCardCharsetParameter = "CHARSET=UTF-8";
            } else {
                String string8;
                try {
                    String string9;
                    string2 = string9 = CharsetUtils.charsetForVendor(string2).name();
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    String string10 = "Career-specific \"" + string2 + "\" was not found (as usual). " + "Use it as is.";
                    int n8 = Log.i(LOG_TAG, string10);
                }
                this.mCharset = string2;
                this.mVCardCharsetParameter = string8 = "CHARSET=" + string2;
            }
        }
        this.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    private VCardBuilder appendNamePropertiesV40(List<ContentValues> list) {
        if (this.mIsDoCoMo || this.mNeedsToConvertPhoneticString) {
            int n = Log.w(LOG_TAG, "Invalid flag is used in vCard 4.0 construction. Ignored.");
        }
        if (list == null || list.isEmpty()) {
            VCardBuilder vCardBuilder = this;
            String string2 = "FN";
            String string3 = "";
            vCardBuilder.appendLine(string2, string3);
            return this;
        }
        ContentValues contentValues = this.getPrimaryContentValue(list);
        String string4 = contentValues.getAsString("data3");
        String string5 = contentValues.getAsString("data5");
        String string6 = contentValues.getAsString("data2");
        String string7 = contentValues.getAsString("data4");
        String string8 = contentValues.getAsString("data6");
        String string9 = contentValues.getAsString("data1");
        if (TextUtils.isEmpty(string4) && TextUtils.isEmpty(string6) && TextUtils.isEmpty(string5) && TextUtils.isEmpty(string7) && TextUtils.isEmpty(string8)) {
            if (TextUtils.isEmpty(string9)) {
                VCardBuilder vCardBuilder = this;
                String string10 = "FN";
                String string11 = "";
                vCardBuilder.appendLine(string10, string11);
                return this;
            }
            String string12 = string9;
        }
        String string13 = contentValues.getAsString("data9");
        String string14 = contentValues.getAsString("data8");
        String string15 = contentValues.getAsString("data7");
        VCardBuilder vCardBuilder = this;
        String string16 = string4;
        String string17 = vCardBuilder.escapeCharacters(string16);
        VCardBuilder vCardBuilder2 = this;
        String string18 = string6;
        String string19 = vCardBuilder2.escapeCharacters(string18);
        VCardBuilder vCardBuilder3 = this;
        String string20 = string5;
        String string21 = vCardBuilder3.escapeCharacters(string20);
        VCardBuilder vCardBuilder4 = this;
        String string22 = string7;
        String string23 = vCardBuilder4.escapeCharacters(string22);
        VCardBuilder vCardBuilder5 = this;
        String string24 = string8;
        String string25 = vCardBuilder5.escapeCharacters(string24);
        StringBuilder stringBuilder = this.mBuilder.append("N");
        if (!(TextUtils.isEmpty(string13) && TextUtils.isEmpty(string14) && TextUtils.isEmpty(string15))) {
            StringBuilder stringBuilder2 = this.mBuilder.append(";");
            StringBuilder stringBuilder3 = new StringBuilder();
            VCardBuilder vCardBuilder6 = this;
            String string26 = string13;
            String string27 = vCardBuilder6.escapeCharacters(string26);
            StringBuilder stringBuilder4 = stringBuilder3.append(string27).append(';');
            VCardBuilder vCardBuilder7 = this;
            String string28 = string15;
            String string29 = vCardBuilder7.escapeCharacters(string28);
            StringBuilder stringBuilder5 = stringBuilder4.append(string29).append(';');
            VCardBuilder vCardBuilder8 = this;
            String string30 = string14;
            String string31 = vCardBuilder8.escapeCharacters(string30);
            String string32 = stringBuilder5.append(string31).toString();
            StringBuilder stringBuilder6 = this.mBuilder.append("SORT-AS=");
            String string33 = VCardUtils.toStringAsV40ParamValue(string32);
            StringBuilder stringBuilder7 = stringBuilder6.append(string33);
        }
        StringBuilder stringBuilder8 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
        StringBuilder stringBuilder9 = this.mBuilder.append(string17);
        StringBuilder stringBuilder10 = this.mBuilder.append(";");
        StringBuilder stringBuilder11 = this.mBuilder.append(string19);
        StringBuilder stringBuilder12 = this.mBuilder.append(";");
        StringBuilder stringBuilder13 = this.mBuilder.append(string21);
        StringBuilder stringBuilder14 = this.mBuilder.append(";");
        StringBuilder stringBuilder15 = this.mBuilder.append(string23);
        StringBuilder stringBuilder16 = this.mBuilder.append(";");
        StringBuilder stringBuilder17 = this.mBuilder;
        String string34 = string25;
        StringBuilder stringBuilder18 = stringBuilder17.append(string34);
        StringBuilder stringBuilder19 = this.mBuilder.append(VCARD_END_OF_LINE);
        if (TextUtils.isEmpty(string9)) {
            int n = Log.w(LOG_TAG, "DISPLAY_NAME is empty.");
            String string35 = VCardUtils.constructNameFromElements(VCardConfig.getNameOrderType(this.mVCardType), string4, string5, string6, string7, string8);
            VCardBuilder vCardBuilder9 = this;
            String string36 = string35;
            String string37 = vCardBuilder9.escapeCharacters(string36);
            VCardBuilder vCardBuilder10 = this;
            String string38 = "FN";
            String string39 = string37;
            vCardBuilder10.appendLine(string38, string39);
        } else {
            VCardBuilder vCardBuilder11 = this;
            String string40 = string9;
            String string41 = vCardBuilder11.escapeCharacters(string40);
            StringBuilder stringBuilder20 = this.mBuilder.append("FN");
            StringBuilder stringBuilder21 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
            StringBuilder stringBuilder22 = this.mBuilder.append(string41);
            StringBuilder stringBuilder23 = this.mBuilder.append(VCARD_END_OF_LINE);
        }
        VCardBuilder vCardBuilder12 = this;
        ContentValues contentValues2 = contentValues;
        vCardBuilder12.appendPhoneticNameFields(contentValues2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendPhoneticNameFields(ContentValues contentValues) {
        String[] stringArray;
        boolean bl;
        String string2;
        String string3;
        String string4;
        String string5 = contentValues.getAsString("data9");
        String string6 = contentValues.getAsString("data8");
        String string7 = contentValues.getAsString("data7");
        if (this.mNeedsToConvertPhoneticString) {
            string4 = VCardUtils.toHalfWidthString(string5);
            string3 = VCardUtils.toHalfWidthString(string6);
            string2 = VCardUtils.toHalfWidthString(string7);
        } else {
            string4 = string5;
            string3 = string6;
            string2 = string7;
        }
        if (TextUtils.isEmpty(string4) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string2)) {
            if (!this.mIsDoCoMo) {
                return;
            }
            StringBuilder stringBuilder = this.mBuilder.append("SOUND");
            StringBuilder stringBuilder2 = this.mBuilder.append(";");
            StringBuilder stringBuilder3 = this.mBuilder.append("X-IRMC-N");
            StringBuilder stringBuilder4 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
            StringBuilder stringBuilder5 = this.mBuilder.append(";");
            StringBuilder stringBuilder6 = this.mBuilder.append(";");
            StringBuilder stringBuilder7 = this.mBuilder.append(";");
            StringBuilder stringBuilder8 = this.mBuilder.append(";");
            StringBuilder stringBuilder9 = this.mBuilder.append(VCARD_END_OF_LINE);
            return;
        }
        if (!VCardConfig.isVersion40(this.mVCardType)) {
            if (VCardConfig.isVersion30(this.mVCardType)) {
                String[] stringArray2;
                String string8 = VCardUtils.constructNameFromElements(this.mVCardType, string4, string3, string2);
                StringBuilder stringBuilder = this.mBuilder.append("SORT-STRING");
                if (VCardConfig.isVersion30(this.mVCardType) && this.shouldAppendCharsetParam(stringArray2 = new String[]{string8})) {
                    StringBuilder stringBuilder10 = this.mBuilder.append(";");
                    StringBuilder stringBuilder11 = this.mBuilder;
                    String string9 = this.mVCardCharsetParameter;
                    StringBuilder stringBuilder12 = stringBuilder11.append(string9);
                }
                StringBuilder stringBuilder13 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
                StringBuilder stringBuilder14 = this.mBuilder;
                String string10 = this.escapeCharacters(string8);
                StringBuilder stringBuilder15 = stringBuilder14.append(string10);
                StringBuilder stringBuilder16 = this.mBuilder.append(VCARD_END_OF_LINE);
            } else if (this.mIsJapaneseMobilePhone) {
                String string11;
                String string12;
                String string13;
                String[] stringArray3;
                String[] stringArray4;
                String[] stringArray5;
                StringBuilder stringBuilder = this.mBuilder.append("SOUND");
                StringBuilder stringBuilder17 = this.mBuilder.append(";");
                StringBuilder stringBuilder18 = this.mBuilder.append("X-IRMC-N");
                boolean bl2 = !this.mRefrainsQPToNameProperties && (!VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray5 = new String[]{string4}) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray4 = new String[]{string3}) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray3 = new String[]{string2}));
                if (bl2) {
                    string13 = this.encodeQuotedPrintable(string4);
                    string12 = this.encodeQuotedPrintable(string3);
                    string11 = this.encodeQuotedPrintable(string2);
                } else {
                    string13 = this.escapeCharacters(string4);
                    string12 = this.escapeCharacters(string3);
                    string11 = this.escapeCharacters(string2);
                }
                String[] stringArray6 = new String[]{string13, string12, string11};
                if (this.shouldAppendCharsetParam(stringArray6)) {
                    StringBuilder stringBuilder19 = this.mBuilder.append(";");
                    StringBuilder stringBuilder20 = this.mBuilder;
                    String string14 = this.mVCardCharsetParameter;
                    StringBuilder stringBuilder21 = stringBuilder20.append(string14);
                }
                StringBuilder stringBuilder22 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
                boolean bl3 = true;
                if (!TextUtils.isEmpty(string13)) {
                    StringBuilder stringBuilder23 = this.mBuilder.append(string13);
                    bl3 = false;
                }
                if (!TextUtils.isEmpty(string12)) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        StringBuilder stringBuilder24 = this.mBuilder.append(' ');
                    }
                    StringBuilder stringBuilder25 = this.mBuilder.append(string12);
                }
                if (!TextUtils.isEmpty(string11)) {
                    if (!bl3) {
                        StringBuilder stringBuilder26 = this.mBuilder.append(' ');
                    }
                    StringBuilder stringBuilder27 = this.mBuilder.append(string11);
                }
                StringBuilder stringBuilder28 = this.mBuilder.append(";");
                StringBuilder stringBuilder29 = this.mBuilder.append(";");
                StringBuilder stringBuilder30 = this.mBuilder.append(";");
                StringBuilder stringBuilder31 = this.mBuilder.append(";");
                StringBuilder stringBuilder32 = this.mBuilder.append(VCARD_END_OF_LINE);
            }
        }
        int n = Log.d("@@@", "hoge");
        if (!this.mUsesDefactProperty) {
            return;
        }
        if (!TextUtils.isEmpty(string2)) {
            String[] stringArray7;
            bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray7 = new String[]{string2});
            String string15 = bl ? this.encodeQuotedPrintable(string2) : this.escapeCharacters(string2);
            StringBuilder stringBuilder = this.mBuilder.append("X-PHONETIC-FIRST-NAME");
            String[] stringArray8 = new String[]{string2};
            if (this.shouldAppendCharsetParam(stringArray8)) {
                StringBuilder stringBuilder33 = this.mBuilder.append(";");
                StringBuilder stringBuilder34 = this.mBuilder;
                String string16 = this.mVCardCharsetParameter;
                StringBuilder stringBuilder35 = stringBuilder34.append(string16);
            }
            if (bl) {
                StringBuilder stringBuilder36 = this.mBuilder.append(";");
                StringBuilder stringBuilder37 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            StringBuilder stringBuilder38 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
            StringBuilder stringBuilder39 = this.mBuilder.append(string15);
            StringBuilder stringBuilder40 = this.mBuilder.append(VCARD_END_OF_LINE);
        }
        if (!TextUtils.isEmpty(string3)) {
            String[] stringArray9;
            bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray9 = new String[]{string3});
            String string17 = bl ? this.encodeQuotedPrintable(string3) : this.escapeCharacters(string3);
            StringBuilder stringBuilder = this.mBuilder.append("X-PHONETIC-MIDDLE-NAME");
            String[] stringArray10 = new String[]{string3};
            if (this.shouldAppendCharsetParam(stringArray10)) {
                StringBuilder stringBuilder41 = this.mBuilder.append(";");
                StringBuilder stringBuilder42 = this.mBuilder;
                String string18 = this.mVCardCharsetParameter;
                StringBuilder stringBuilder43 = stringBuilder42.append(string18);
            }
            if (bl) {
                StringBuilder stringBuilder44 = this.mBuilder.append(";");
                StringBuilder stringBuilder45 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            StringBuilder stringBuilder46 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
            StringBuilder stringBuilder47 = this.mBuilder.append(string17);
            StringBuilder stringBuilder48 = this.mBuilder.append(VCARD_END_OF_LINE);
        }
        if (TextUtils.isEmpty(string4)) {
            return;
        }
        bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray = new String[]{string4});
        String string19 = bl ? this.encodeQuotedPrintable(string4) : this.escapeCharacters(string4);
        StringBuilder stringBuilder = this.mBuilder.append("X-PHONETIC-LAST-NAME");
        String[] stringArray11 = new String[]{string4};
        if (this.shouldAppendCharsetParam(stringArray11)) {
            StringBuilder stringBuilder49 = this.mBuilder.append(";");
            StringBuilder stringBuilder50 = this.mBuilder;
            String string20 = this.mVCardCharsetParameter;
            StringBuilder stringBuilder51 = stringBuilder50.append(string20);
        }
        if (bl) {
            StringBuilder stringBuilder52 = this.mBuilder.append(";");
            StringBuilder stringBuilder53 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        StringBuilder stringBuilder54 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
        StringBuilder stringBuilder55 = this.mBuilder.append(string19);
        StringBuilder stringBuilder56 = this.mBuilder.append(VCARD_END_OF_LINE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendPostalsForDoCoMo(List<ContentValues> list) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        ContentValues contentValues = null;
        for (ContentValues contentValues2 : list) {
            Integer n3;
            Integer n4;
            int n5;
            if (contentValues2 == null || (n5 = (n4 = sPostalTypePriorityMap.get(n3 = contentValues2.getAsInteger("data2"))) != null ? n4 : Integer.MAX_VALUE) >= n) continue;
            n = n5;
            n2 = n3;
            contentValues = contentValues2;
            if (n5 != 0) continue;
        }
        if (contentValues == null) {
            int n6 = Log.w(LOG_TAG, "Should not come here. Must have at least one postal data.");
            return;
        }
        String string2 = contentValues.getAsString("data3");
        this.appendPostalLine(n2, string2, contentValues, false, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendPostalsForGeneric(List<ContentValues> list) {
        Iterator<ContentValues> iterator = list.iterator();
        while (iterator.hasNext()) {
            ContentValues contentValues = iterator.next();
            if (contentValues == null) continue;
            Integer n = contentValues.getAsInteger("data2");
            int n2 = n != null ? n : 1;
            String string2 = contentValues.getAsString("data3");
            Integer n3 = contentValues.getAsInteger("is_primary");
            boolean bl = n3 != null ? n3 > 0 : false;
            this.appendPostalLine(n2, string2, contentValues, bl, false);
        }
        return;
    }

    private void appendTypeParameter(String string2) {
        StringBuilder stringBuilder = this.mBuilder;
        this.appendTypeParameter(stringBuilder, string2);
    }

    private void appendTypeParameter(StringBuilder stringBuilder, String string2) {
        if (VCardConfig.isVersion40(this.mVCardType) || (VCardConfig.isVersion30(this.mVCardType) || this.mAppendTypeParamName) && !this.mIsDoCoMo) {
            StringBuilder stringBuilder2 = stringBuilder.append("TYPE").append(VCARD_PARAM_EQUAL);
        }
        StringBuilder stringBuilder3 = stringBuilder.append(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendTypeParameters(List<String> list) {
        boolean bl = true;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (VCardConfig.isVersion30(this.mVCardType)) {
                String string3 = VCardUtils.toStringAsV30ParamValue(string2);
                if (TextUtils.isEmpty(string3)) continue;
                if (bl) {
                    bl = false;
                } else {
                    StringBuilder stringBuilder = this.mBuilder.append(";");
                }
                this.appendTypeParameter(string3);
                continue;
            }
            if (!VCardUtils.isV21Word(string2)) continue;
            if (bl) {
                bl = false;
            } else {
                StringBuilder stringBuilder = this.mBuilder.append(";");
            }
            this.appendTypeParameter(string2);
        }
        return;
    }

    private void appendUncommonPhoneType(StringBuilder stringBuilder, Integer n) {
        if (this.mIsDoCoMo) {
            StringBuilder stringBuilder2 = stringBuilder.append("VOICE");
            return;
        }
        String string2 = VCardUtils.getPhoneTypeString(n);
        if (string2 != null) {
            this.appendTypeParameter(string2);
            return;
        }
        String string3 = "Unknown or unsupported (by vCard) Phone type: " + n;
        int n2 = Log.e(LOG_TAG, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsNonEmptyName(ContentValues contentValues) {
        String string2 = contentValues.getAsString("data3");
        String string3 = contentValues.getAsString("data5");
        String string4 = contentValues.getAsString("data2");
        String string5 = contentValues.getAsString("data4");
        String string6 = contentValues.getAsString("data6");
        String string7 = contentValues.getAsString("data9");
        String string8 = contentValues.getAsString("data8");
        String string9 = contentValues.getAsString("data7");
        String string10 = contentValues.getAsString("data1");
        if (!TextUtils.isEmpty(string2)) return true;
        if (!TextUtils.isEmpty(string3)) return true;
        if (!TextUtils.isEmpty(string4)) return true;
        if (!TextUtils.isEmpty(string5)) return true;
        if (!TextUtils.isEmpty(string6)) return true;
        if (!TextUtils.isEmpty(string7)) return true;
        if (!TextUtils.isEmpty(string8)) return true;
        if (!TextUtils.isEmpty(string9)) return true;
        if (TextUtils.isEmpty(string10)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String encodeQuotedPrintable(String string2) {
        byte[] byArray;
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        try {
            byte[] byArray2;
            String string3 = this.mCharset;
            byArray = byArray2 = string2.getBytes(string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StringBuilder stringBuilder2 = new StringBuilder().append("Charset ");
            String string4 = this.mCharset;
            String string5 = stringBuilder2.append(string4).append(" cannot be used. ").append("Try default charset").toString();
            int n3 = Log.e(LOG_TAG, string5);
            byArray = string2.getBytes();
        }
        int n4;
        while (n < (n4 = byArray.length)) {
            Object[] objectArray = new Object[1];
            Byte by = byArray[n];
            objectArray[0] = by;
            String string6 = String.format("=%02X", objectArray);
            StringBuilder stringBuilder3 = stringBuilder.append(string6);
            ++n;
            if ((n2 += 3) < 67) continue;
            StringBuilder stringBuilder4 = stringBuilder.append("=\r\n");
            n2 = 0;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String escapeCharacters(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                default: {
                    StringBuilder stringBuilder2 = stringBuilder.append(c);
                    break;
                }
                case ';': {
                    StringBuilder stringBuilder3 = stringBuilder.append('\\');
                    StringBuilder stringBuilder4 = stringBuilder.append(';');
                    break;
                }
                case '\r': {
                    if (n2 + 1 < n && string2.charAt(n2) == '\n') break;
                }
                case '\n': {
                    StringBuilder stringBuilder5 = stringBuilder.append("\\n");
                    break;
                }
                case '\\': {
                    if (this.mIsV30OrV40) {
                        StringBuilder stringBuilder6 = stringBuilder.append("\\\\");
                        break;
                    }
                }
                case '<': 
                case '>': {
                    if (this.mIsDoCoMo) {
                        StringBuilder stringBuilder7 = stringBuilder.append('\\');
                        StringBuilder stringBuilder8 = stringBuilder.append(c);
                        break;
                    }
                    StringBuilder stringBuilder9 = stringBuilder.append(c);
                    break;
                }
                case ',': {
                    if (this.mIsV30OrV40) {
                        StringBuilder stringBuilder10 = stringBuilder.append("\\,");
                        break;
                    }
                    StringBuilder stringBuilder11 = stringBuilder.append(c);
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ContentValues getPrimaryContentValue(List<ContentValues> list) {
        ContentValues contentValues = null;
        ContentValues contentValues2 = null;
        Iterator<ContentValues> iterator = list.iterator();
        while (true) {
            ContentValues contentValues3;
            block6: {
                block5: {
                    if (!iterator.hasNext()) break block5;
                    contentValues3 = iterator.next();
                    if (contentValues3 == null) continue;
                    Integer n = contentValues3.getAsInteger("is_super_primary");
                    if (n == null || n <= 0) break block6;
                    contentValues = contentValues3;
                }
                if (contentValues != null) return contentValues;
                if (contentValues2 == null) break;
                return contentValues2;
            }
            if (contentValues != null) continue;
            Integer n = contentValues3.getAsInteger("is_primary");
            if (n != null && n > 0 && this.containsNonEmptyName(contentValues3)) {
                contentValues = contentValues3;
                continue;
            }
            if (contentValues2 != null || !this.containsNonEmptyName(contentValues3)) continue;
            contentValues2 = contentValues3;
        }
        int n = Log.e(LOG_TAG, "All ContentValues given from database is empty.");
        return new ContentValues();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldAppendCharsetParam(String ... stringArray) {
        if (!this.mShouldAppendCharsetParam) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            String[] stringArray3 = new String[]{string2};
            if (!VCardUtils.containsOnlyPrintableAscii(stringArray3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<String> splitAndTrimPhoneNumbers(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (Character.isDigit(c) || c == '+') {
                StringBuilder stringBuilder2 = stringBuilder.append(c);
                continue;
            }
            if (c != ';' && c != '\n' || stringBuilder.length() <= 0) continue;
            String string3 = stringBuilder.toString();
            boolean bl = arrayList.add(string3);
            stringBuilder = new StringBuilder();
        }
        if (stringBuilder.length() > 0) {
            String string4 = stringBuilder.toString();
            boolean bl = arrayList.add(string4);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private PostalStruct tryConstructPostalStruct(ContentValues contentValues) {
        StringBuilder stringBuilder;
        String string2;
        String[] stringArray;
        PostalStruct postalStruct;
        String string3;
        ContentValues contentValues2;
        String string4;
        String string5;
        ContentValues contentValues3;
        String string6;
        String string7;
        ContentValues contentValues4;
        String string8;
        String string9;
        ContentValues contentValues5;
        String string10;
        String string11;
        ContentValues contentValues6;
        String string12;
        String string13;
        ContentValues contentValues7;
        String string14;
        ContentValues contentValues8 = contentValues;
        String string15 = "data5";
        String string16 = contentValues8.getAsString(string15);
        String[] stringArray2 = new String[]{string16, string14 = (contentValues7 = contentValues).getAsString(string13 = "data6"), string12 = (contentValues6 = contentValues).getAsString(string11 = "data4"), string10 = (contentValues5 = contentValues).getAsString(string9 = "data7"), string8 = (contentValues4 = contentValues).getAsString(string7 = "data8"), string6 = (contentValues3 = contentValues).getAsString(string5 = "data9"), string4 = (contentValues2 = contentValues).getAsString(string3 = "data10")};
        if (!VCardUtils.areAllEmpty(stringArray2)) {
            String string17;
            String string18;
            String string19;
            String string20;
            String string21;
            String string22;
            String string23;
            boolean bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray2);
            boolean bl2 = !VCardUtils.containsOnlyPrintableAscii(stringArray2);
            if (TextUtils.isEmpty(string10)) {
                string23 = TextUtils.isEmpty(string14) ? "" : string14;
            } else if (TextUtils.isEmpty(string14)) {
                string23 = string10;
            } else {
                StringBuilder stringBuilder2 = new StringBuilder();
                String string24 = string10;
                StringBuilder stringBuilder3 = stringBuilder2.append(string24).append(VCARD_WS);
                String string25 = string14;
                string23 = stringBuilder3.append(string25).toString();
            }
            if (bl) {
                VCardBuilder vCardBuilder = this;
                String string26 = string16;
                string22 = vCardBuilder.encodeQuotedPrintable(string26);
                VCardBuilder vCardBuilder2 = this;
                String string27 = string12;
                string21 = vCardBuilder2.encodeQuotedPrintable(string27);
                VCardBuilder vCardBuilder3 = this;
                String string28 = string23;
                string20 = vCardBuilder3.encodeQuotedPrintable(string28);
                VCardBuilder vCardBuilder4 = this;
                String string29 = string8;
                string19 = vCardBuilder4.encodeQuotedPrintable(string29);
                VCardBuilder vCardBuilder5 = this;
                String string30 = string6;
                string18 = vCardBuilder5.encodeQuotedPrintable(string30);
                VCardBuilder vCardBuilder6 = this;
                String string31 = string4;
                string17 = vCardBuilder6.encodeQuotedPrintable(string31);
            } else {
                VCardBuilder vCardBuilder = this;
                String string32 = string16;
                string22 = vCardBuilder.escapeCharacters(string32);
                VCardBuilder vCardBuilder7 = this;
                String string33 = string12;
                string21 = vCardBuilder7.escapeCharacters(string33);
                VCardBuilder vCardBuilder8 = this;
                String string34 = string23;
                string20 = vCardBuilder8.escapeCharacters(string34);
                VCardBuilder vCardBuilder9 = this;
                String string35 = string8;
                string19 = vCardBuilder9.escapeCharacters(string35);
                VCardBuilder vCardBuilder10 = this;
                String string36 = string6;
                string18 = vCardBuilder10.escapeCharacters(string36);
                VCardBuilder vCardBuilder11 = this;
                String string37 = string4;
                string17 = vCardBuilder11.escapeCharacters(string37);
                VCardBuilder vCardBuilder12 = this;
                String string38 = string14;
                String string39 = vCardBuilder12.escapeCharacters(string38);
            }
            StringBuilder stringBuilder4 = new StringBuilder();
            StringBuilder stringBuilder5 = stringBuilder4.append(string22);
            StringBuilder stringBuilder6 = stringBuilder4;
            String string40 = ";";
            StringBuilder stringBuilder7 = stringBuilder6.append(string40);
            StringBuilder stringBuilder8 = stringBuilder4;
            String string41 = ";";
            StringBuilder stringBuilder9 = stringBuilder8.append(string41);
            StringBuilder stringBuilder10 = stringBuilder4.append(string21);
            StringBuilder stringBuilder11 = stringBuilder4;
            String string42 = ";";
            StringBuilder stringBuilder12 = stringBuilder11.append(string42);
            StringBuilder stringBuilder13 = stringBuilder4.append(string20);
            StringBuilder stringBuilder14 = stringBuilder4;
            String string43 = ";";
            StringBuilder stringBuilder15 = stringBuilder14.append(string43);
            StringBuilder stringBuilder16 = stringBuilder4.append(string19);
            StringBuilder stringBuilder17 = stringBuilder4;
            String string44 = ";";
            StringBuilder stringBuilder18 = stringBuilder17.append(string44);
            StringBuilder stringBuilder19 = stringBuilder4.append(string18);
            StringBuilder stringBuilder20 = stringBuilder4;
            String string45 = ";";
            StringBuilder stringBuilder21 = stringBuilder20.append(string45);
            StringBuilder stringBuilder22 = stringBuilder4.append(string17);
            String string46 = stringBuilder4.toString();
            PostalStruct postalStruct2 = postalStruct;
            boolean bl3 = bl;
            boolean bl4 = bl2;
            String string47 = string46;
            postalStruct2(bl3, bl4, string47);
            return postalStruct;
        }
        ContentValues contentValues9 = contentValues;
        String string48 = "data1";
        String string49 = contentValues9.getAsString(string48);
        if (TextUtils.isEmpty(string49)) {
            return null;
        }
        boolean bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray = new String[]{string49});
        String[] stringArray3 = new String[]{string49};
        boolean bl5 = !VCardUtils.containsOnlyPrintableAscii(stringArray3);
        if (bl) {
            VCardBuilder vCardBuilder = this;
            String string50 = string49;
            string2 = vCardBuilder.encodeQuotedPrintable(string50);
        } else {
            VCardBuilder vCardBuilder = this;
            String string51 = string49;
            string2 = vCardBuilder.escapeCharacters(string51);
        }
        StringBuilder stringBuilder23 = stringBuilder = new StringBuilder();
        String string52 = ";";
        StringBuilder stringBuilder24 = stringBuilder23.append(string52);
        StringBuilder stringBuilder25 = stringBuilder.append(string2);
        StringBuilder stringBuilder26 = stringBuilder;
        String string53 = ";";
        StringBuilder stringBuilder27 = stringBuilder26.append(string53);
        StringBuilder stringBuilder28 = stringBuilder;
        String string54 = ";";
        StringBuilder stringBuilder29 = stringBuilder28.append(string54);
        StringBuilder stringBuilder30 = stringBuilder;
        String string55 = ";";
        StringBuilder stringBuilder31 = stringBuilder30.append(string55);
        StringBuilder stringBuilder32 = stringBuilder;
        String string56 = ";";
        StringBuilder stringBuilder33 = stringBuilder32.append(string56);
        StringBuilder stringBuilder34 = stringBuilder;
        String string57 = ";";
        StringBuilder stringBuilder35 = stringBuilder34.append(string57);
        String string58 = stringBuilder.toString();
        PostalStruct postalStruct3 = postalStruct;
        boolean bl6 = bl;
        boolean bl7 = bl5;
        String string59 = string58;
        postalStruct3(bl6, bl7, string59);
        return postalStruct;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendAndroidSpecificProperty(String string2, ContentValues contentValues) {
        if (!sAllowedAndroidPropertySet.contains(string2)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= 15; ++i) {
            String string3 = "data" + i;
            String string4 = contentValues.getAsString(string3);
            if (string4 == null) {
                string4 = "";
            }
            boolean bl = arrayList.add(string4);
        }
        boolean bl = this.mShouldAppendCharsetParam && !VCardUtils.containsOnlyNonCrLfPrintableAscii(arrayList);
        boolean bl2 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(arrayList);
        StringBuilder stringBuilder = this.mBuilder.append("X-ANDROID-CUSTOM");
        if (bl) {
            StringBuilder stringBuilder2 = this.mBuilder.append(";");
            StringBuilder stringBuilder3 = this.mBuilder;
            String string5 = this.mVCardCharsetParameter;
            StringBuilder stringBuilder4 = stringBuilder3.append(string5);
        }
        if (bl2) {
            StringBuilder stringBuilder5 = this.mBuilder.append(";");
            StringBuilder stringBuilder6 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        StringBuilder stringBuilder7 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
        StringBuilder stringBuilder8 = this.mBuilder.append(string2);
        Iterator iterator = arrayList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                StringBuilder stringBuilder9 = this.mBuilder.append(VCARD_END_OF_LINE);
                return;
            }
            String string6 = (String)iterator.next();
            String string7 = bl2 ? this.encodeQuotedPrintable(string6) : this.escapeCharacters(string6);
            StringBuilder stringBuilder10 = this.mBuilder.append(";");
            StringBuilder stringBuilder11 = this.mBuilder.append(string7);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendEmailLine(int n, String string2, String string3, boolean bl) {
        String string4;
        switch (n) {
            default: {
                String string5 = "Unknown Email type: " + n;
                int n2 = Log.e(LOG_TAG, string5);
                string4 = null;
                break;
            }
            case 0: {
                if (VCardUtils.isMobilePhoneLabel(string2)) {
                    string4 = "CELL";
                    break;
                }
                if (!TextUtils.isEmpty(string2)) {
                    String[] stringArray = new String[]{string2};
                    if (VCardUtils.containsOnlyAlphaDigitHyphen(stringArray)) {
                        string4 = "X-" + string2;
                        break;
                    }
                }
                string4 = null;
                break;
            }
            case 1: {
                string4 = "HOME";
                break;
            }
            case 2: {
                string4 = "WORK";
                break;
            }
            case 3: {
                string4 = null;
                break;
            }
            case 4: {
                string4 = "CELL";
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            boolean bl2 = arrayList.add("PREF");
        }
        if (!TextUtils.isEmpty(string4)) {
            boolean bl3 = arrayList.add(string4);
        }
        this.appendLineWithCharsetAndQPDetection("EMAIL", arrayList, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendEmails(List<ContentValues> list) {
        boolean bl = false;
        if (list != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (ContentValues contentValues : list) {
                String string2 = contentValues.getAsString("data1");
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if (TextUtils.isEmpty(string2)) continue;
                Integer n = contentValues.getAsInteger("data2");
                int n2 = n != null ? n : 3;
                String string3 = contentValues.getAsString("data3");
                Integer n3 = contentValues.getAsInteger("is_primary");
                boolean bl2 = n3 != null ? n3 > 0 : false;
                bl = true;
                if (hashSet.contains(string2)) continue;
                boolean bl3 = hashSet.add(string2);
                this.appendEmailLine(n2, string3, string2, bl2);
            }
        }
        if (!bl && this.mIsDoCoMo) {
            this.appendEmailLine(1, "", "", false);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendEvents(List<ContentValues> list) {
        if (list == null) return this;
        String string2 = null;
        String string3 = null;
        for (ContentValues contentValues : list) {
            if (contentValues == null) continue;
            Integer n = contentValues.getAsInteger("data2");
            int n2 = n != null ? n : 2;
            if (n2 == 3) {
                String string4 = contentValues.getAsString("data1");
                if (string4 == null) continue;
                Integer n3 = contentValues.getAsInteger("is_super_primary");
                boolean bl = n3 != null ? n3 > 0 : false;
                if (bl) {
                    string2 = string4;
                    break;
                }
                Integer n4 = contentValues.getAsInteger("is_primary");
                boolean bl2 = n4 != null ? n4 > 0 : false;
                if (bl2) {
                    string2 = string4;
                    continue;
                }
                if (string3 != null) continue;
                string3 = string4;
                continue;
            }
            if (!this.mUsesAndroidProperty) continue;
            this.appendAndroidSpecificProperty("vnd.android.cursor.item/contact_event", contentValues);
        }
        if (string2 != null) {
            String string5 = string2.trim();
            this.appendLineWithCharsetAndQPDetection("BDAY", string5);
            return this;
        }
        if (string3 == null) return this;
        String string6 = string3.trim();
        this.appendLineWithCharsetAndQPDetection("BDAY", string6);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendIms(List<ContentValues> list) {
        if (list != null) {
            for (ContentValues contentValues : list) {
                Integer n;
                String string2;
                String string3;
                Integer n2 = contentValues.getAsInteger("data5");
                if (n2 == null || (string3 = VCardUtils.getPropertyNameForIm(n2)) == null) continue;
                String string4 = contentValues.getAsString("data1");
                if (string4 != null) {
                    string4 = string4.trim();
                }
                if (TextUtils.isEmpty(string4)) continue;
                Integer n3 = contentValues.getAsInteger("data2");
                int n4 = n3 != null ? n3 : 3;
                switch (n4) {
                    default: {
                        string2 = null;
                        break;
                    }
                    case 1: {
                        string2 = "HOME";
                        break;
                    }
                    case 2: {
                        string2 = "WORK";
                        break;
                    }
                    case 0: {
                        String string5 = contentValues.getAsString("data3");
                        string2 = string5 != null ? "X-" + string5 : null;
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                if (!TextUtils.isEmpty(string2)) {
                    boolean bl = arrayList.add(string2);
                }
                boolean bl = (n = contentValues.getAsInteger("is_primary")) != null ? n > 0 : false;
                if (bl) {
                    boolean bl2 = arrayList.add("PREF");
                }
                this.appendLineWithCharsetAndQPDetection(string3, arrayList, string4);
            }
        }
        return this;
    }

    public void appendLine(String string2, String string3) {
        this.appendLine(string2, string3, false, false);
    }

    public void appendLine(String string2, String string3, boolean bl, boolean bl2) {
        VCardBuilder vCardBuilder = this;
        String string4 = string2;
        String string5 = string3;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        vCardBuilder.appendLine(string4, null, string5, bl3, bl4);
    }

    public void appendLine(String string2, List<String> list) {
        this.appendLine(string2, list, false, false);
    }

    public void appendLine(String string2, List<String> list, String string3) {
        VCardBuilder vCardBuilder = this;
        String string4 = string2;
        List<String> list2 = list;
        String string5 = string3;
        boolean bl = false;
        vCardBuilder.appendLine(string4, list2, string5, false, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendLine(String string2, List<String> list, String string3, boolean bl, boolean bl2) {
        String string4;
        StringBuilder stringBuilder = this.mBuilder.append(string2);
        if (list != null && list.size() > 0) {
            StringBuilder stringBuilder2 = this.mBuilder.append(";");
            this.appendTypeParameters(list);
        }
        if (bl) {
            StringBuilder stringBuilder3 = this.mBuilder.append(";");
            StringBuilder stringBuilder4 = this.mBuilder;
            String string5 = this.mVCardCharsetParameter;
            StringBuilder stringBuilder5 = stringBuilder4.append(string5);
        }
        if (bl2) {
            StringBuilder stringBuilder6 = this.mBuilder.append(";");
            StringBuilder stringBuilder7 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            string4 = this.encodeQuotedPrintable(string3);
        } else {
            string4 = this.escapeCharacters(string3);
        }
        StringBuilder stringBuilder8 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
        StringBuilder stringBuilder9 = this.mBuilder.append(string4);
        StringBuilder stringBuilder10 = this.mBuilder.append(VCARD_END_OF_LINE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendLine(String string2, List<String> list, List<String> list2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = this.mBuilder.append(string2);
        if (list != null && list.size() > 0) {
            StringBuilder stringBuilder2 = this.mBuilder.append(";");
            this.appendTypeParameters(list);
        }
        if (bl) {
            StringBuilder stringBuilder3 = this.mBuilder.append(";");
            StringBuilder stringBuilder4 = this.mBuilder;
            String string3 = this.mVCardCharsetParameter;
            StringBuilder stringBuilder5 = stringBuilder4.append(string3);
        }
        if (bl2) {
            StringBuilder stringBuilder6 = this.mBuilder.append(";");
            StringBuilder stringBuilder7 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        StringBuilder stringBuilder8 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
        boolean bl3 = true;
        Iterator<String> iterator = list2.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                StringBuilder stringBuilder9 = this.mBuilder.append(VCARD_END_OF_LINE);
                return;
            }
            String string4 = iterator.next();
            String string5 = bl2 ? this.encodeQuotedPrintable(string4) : this.escapeCharacters(string4);
            if (bl3) {
                bl3 = false;
            } else {
                StringBuilder stringBuilder10 = this.mBuilder.append(";");
            }
            StringBuilder stringBuilder11 = this.mBuilder.append(string5);
        }
    }

    public void appendLine(String string2, List<String> list, boolean bl, boolean bl2) {
        VCardBuilder vCardBuilder = this;
        String string3 = string2;
        List<String> list2 = list;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        vCardBuilder.appendLine(string3, null, list2, bl3, bl4);
    }

    public void appendLineWithCharsetAndQPDetection(String string2, String string3) {
        this.appendLineWithCharsetAndQPDetection(string2, null, string3);
    }

    public void appendLineWithCharsetAndQPDetection(String string2, List<String> list) {
        this.appendLineWithCharsetAndQPDetection(string2, null, list);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendLineWithCharsetAndQPDetection(String string2, List<String> list, String string3) {
        String[] stringArray;
        String[] stringArray2 = new String[]{string3};
        boolean bl = !VCardUtils.containsOnlyPrintableAscii(stringArray2);
        boolean bl2 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray = new String[]{string3});
        VCardBuilder vCardBuilder = this;
        String string4 = string2;
        List<String> list2 = list;
        String string5 = string3;
        vCardBuilder.appendLine(string4, list2, string5, bl, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendLineWithCharsetAndQPDetection(String string2, List<String> list, List<String> list2) {
        boolean bl = this.mShouldAppendCharsetParam && !VCardUtils.containsOnlyNonCrLfPrintableAscii(list2);
        boolean bl2 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(list2);
        VCardBuilder vCardBuilder = this;
        String string3 = string2;
        List<String> list3 = list;
        List<String> list4 = list2;
        vCardBuilder.appendLine(string3, list3, list4, bl, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendNameProperties(List<ContentValues> list) {
        if (VCardConfig.isVersion40(this.mVCardType)) {
            return this.appendNamePropertiesV40(list);
        }
        if (list == null || list.isEmpty()) {
            if (VCardConfig.isVersion30(this.mVCardType)) {
                VCardBuilder vCardBuilder = this;
                String string2 = "N";
                String string3 = "";
                vCardBuilder.appendLine(string2, string3);
                VCardBuilder vCardBuilder2 = this;
                String string4 = "FN";
                String string5 = "";
                vCardBuilder2.appendLine(string4, string5);
                return this;
            } else {
                if (!this.mIsDoCoMo) return this;
                VCardBuilder vCardBuilder = this;
                String string6 = "N";
                String string7 = "";
                vCardBuilder.appendLine(string6, string7);
            }
            return this;
        }
        ContentValues contentValues = this.getPrimaryContentValue(list);
        String string8 = contentValues.getAsString("data3");
        String string9 = contentValues.getAsString("data5");
        String string10 = contentValues.getAsString("data2");
        String string11 = contentValues.getAsString("data4");
        String string12 = contentValues.getAsString("data6");
        String string13 = contentValues.getAsString("data1");
        if (!TextUtils.isEmpty(string8) || !TextUtils.isEmpty(string10)) {
            String string14;
            String string15;
            String string16;
            String string17;
            String string18;
            String string19;
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            String[] stringArray4;
            String[] stringArray5;
            String[] stringArray6;
            String[] stringArray7 = new String[]{string8, string10, string9, string11, string12};
            VCardBuilder vCardBuilder = this;
            String[] stringArray8 = stringArray7;
            boolean bl = vCardBuilder.shouldAppendCharsetParam(stringArray8);
            boolean bl2 = !this.mRefrainsQPToNameProperties && (!VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray6 = new String[]{string8}) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray5 = new String[]{string10}) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray4 = new String[]{string9}) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray3 = new String[]{string11}) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray2 = new String[]{string12}));
            String string20 = !TextUtils.isEmpty(string13) ? string13 : VCardUtils.constructNameFromElements(VCardConfig.getNameOrderType(this.mVCardType), string8, string9, string10, string11, string12);
            String[] stringArray9 = new String[]{string20};
            VCardBuilder vCardBuilder3 = this;
            String[] stringArray10 = stringArray9;
            boolean bl3 = vCardBuilder3.shouldAppendCharsetParam(stringArray10);
            boolean bl4 = !this.mRefrainsQPToNameProperties && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray = new String[]{string20});
            if (bl2) {
                VCardBuilder vCardBuilder4 = this;
                String string21 = string8;
                string19 = vCardBuilder4.encodeQuotedPrintable(string21);
                VCardBuilder vCardBuilder5 = this;
                String string22 = string10;
                string18 = vCardBuilder5.encodeQuotedPrintable(string22);
                VCardBuilder vCardBuilder6 = this;
                String string23 = string9;
                string17 = vCardBuilder6.encodeQuotedPrintable(string23);
                VCardBuilder vCardBuilder7 = this;
                String string24 = string11;
                string16 = vCardBuilder7.encodeQuotedPrintable(string24);
                VCardBuilder vCardBuilder8 = this;
                String string25 = string12;
                string15 = vCardBuilder8.encodeQuotedPrintable(string25);
            } else {
                VCardBuilder vCardBuilder9 = this;
                String string26 = string8;
                string19 = vCardBuilder9.escapeCharacters(string26);
                VCardBuilder vCardBuilder10 = this;
                String string27 = string10;
                string18 = vCardBuilder10.escapeCharacters(string27);
                VCardBuilder vCardBuilder11 = this;
                String string28 = string9;
                string17 = vCardBuilder11.escapeCharacters(string28);
                VCardBuilder vCardBuilder12 = this;
                String string29 = string11;
                string16 = vCardBuilder12.escapeCharacters(string29);
                VCardBuilder vCardBuilder13 = this;
                String string30 = string12;
                string15 = vCardBuilder13.escapeCharacters(string30);
            }
            if (bl4) {
                VCardBuilder vCardBuilder14 = this;
                String string31 = string20;
                string14 = vCardBuilder14.encodeQuotedPrintable(string31);
            } else {
                VCardBuilder vCardBuilder15 = this;
                String string32 = string20;
                string14 = vCardBuilder15.escapeCharacters(string32);
            }
            StringBuilder stringBuilder = this.mBuilder.append("N");
            if (this.mIsDoCoMo) {
                if (bl) {
                    StringBuilder stringBuilder2 = this.mBuilder.append(";");
                    StringBuilder stringBuilder3 = this.mBuilder;
                    String string33 = this.mVCardCharsetParameter;
                    StringBuilder stringBuilder4 = stringBuilder3.append(string33);
                }
                if (bl2) {
                    StringBuilder stringBuilder5 = this.mBuilder.append(";");
                    StringBuilder stringBuilder6 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
                }
                StringBuilder stringBuilder7 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
                StringBuilder stringBuilder8 = this.mBuilder;
                String string34 = string20;
                StringBuilder stringBuilder9 = stringBuilder8.append(string34);
                StringBuilder stringBuilder10 = this.mBuilder.append(";");
                StringBuilder stringBuilder11 = this.mBuilder.append(";");
                StringBuilder stringBuilder12 = this.mBuilder.append(";");
                StringBuilder stringBuilder13 = this.mBuilder.append(";");
            } else {
                if (bl) {
                    StringBuilder stringBuilder14 = this.mBuilder.append(";");
                    StringBuilder stringBuilder15 = this.mBuilder;
                    String string35 = this.mVCardCharsetParameter;
                    StringBuilder stringBuilder16 = stringBuilder15.append(string35);
                }
                if (bl2) {
                    StringBuilder stringBuilder17 = this.mBuilder.append(";");
                    StringBuilder stringBuilder18 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
                }
                StringBuilder stringBuilder19 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
                StringBuilder stringBuilder20 = this.mBuilder.append(string19);
                StringBuilder stringBuilder21 = this.mBuilder.append(";");
                StringBuilder stringBuilder22 = this.mBuilder.append(string18);
                StringBuilder stringBuilder23 = this.mBuilder.append(";");
                StringBuilder stringBuilder24 = this.mBuilder.append(string17);
                StringBuilder stringBuilder25 = this.mBuilder.append(";");
                StringBuilder stringBuilder26 = this.mBuilder;
                String string36 = string16;
                StringBuilder stringBuilder27 = stringBuilder26.append(string36);
                StringBuilder stringBuilder28 = this.mBuilder.append(";");
                StringBuilder stringBuilder29 = this.mBuilder;
                String string37 = string15;
                StringBuilder stringBuilder30 = stringBuilder29.append(string37);
            }
            StringBuilder stringBuilder31 = this.mBuilder.append(VCARD_END_OF_LINE);
            StringBuilder stringBuilder32 = this.mBuilder.append("FN");
            if (bl3) {
                StringBuilder stringBuilder33 = this.mBuilder.append(";");
                StringBuilder stringBuilder34 = this.mBuilder;
                String string38 = this.mVCardCharsetParameter;
                StringBuilder stringBuilder35 = stringBuilder34.append(string38);
            }
            if (bl4) {
                StringBuilder stringBuilder36 = this.mBuilder.append(";");
                StringBuilder stringBuilder37 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            StringBuilder stringBuilder38 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
            StringBuilder stringBuilder39 = this.mBuilder.append(string14);
            StringBuilder stringBuilder40 = this.mBuilder.append(VCARD_END_OF_LINE);
        } else if (!TextUtils.isEmpty(string13)) {
            String string39;
            String[] stringArray;
            boolean bl = !this.mRefrainsQPToNameProperties && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray = new String[]{string13});
            if (bl) {
                VCardBuilder vCardBuilder = this;
                String string40 = string13;
                string39 = vCardBuilder.encodeQuotedPrintable(string40);
            } else {
                VCardBuilder vCardBuilder = this;
                String string41 = string13;
                string39 = vCardBuilder.escapeCharacters(string41);
            }
            StringBuilder stringBuilder = this.mBuilder.append("N");
            String[] stringArray11 = new String[]{string13};
            VCardBuilder vCardBuilder = this;
            String[] stringArray12 = stringArray11;
            if (vCardBuilder.shouldAppendCharsetParam(stringArray12)) {
                StringBuilder stringBuilder41 = this.mBuilder.append(";");
                StringBuilder stringBuilder42 = this.mBuilder;
                String string42 = this.mVCardCharsetParameter;
                StringBuilder stringBuilder43 = stringBuilder42.append(string42);
            }
            if (bl) {
                StringBuilder stringBuilder44 = this.mBuilder.append(";");
                StringBuilder stringBuilder45 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            StringBuilder stringBuilder46 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
            StringBuilder stringBuilder47 = this.mBuilder.append(string39);
            StringBuilder stringBuilder48 = this.mBuilder.append(";");
            StringBuilder stringBuilder49 = this.mBuilder.append(";");
            StringBuilder stringBuilder50 = this.mBuilder.append(";");
            StringBuilder stringBuilder51 = this.mBuilder.append(";");
            StringBuilder stringBuilder52 = this.mBuilder.append(VCARD_END_OF_LINE);
            StringBuilder stringBuilder53 = this.mBuilder.append("FN");
            VCardBuilder vCardBuilder16 = this;
            String[] stringArray13 = new String[]{string13};
            String[] stringArray14 = stringArray13;
            if (vCardBuilder16.shouldAppendCharsetParam(stringArray14)) {
                StringBuilder stringBuilder54 = this.mBuilder.append(";");
                StringBuilder stringBuilder55 = this.mBuilder;
                String string43 = this.mVCardCharsetParameter;
                StringBuilder stringBuilder56 = stringBuilder55.append(string43);
            }
            StringBuilder stringBuilder57 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
            StringBuilder stringBuilder58 = this.mBuilder.append(string39);
            StringBuilder stringBuilder59 = this.mBuilder.append(VCARD_END_OF_LINE);
        } else if (VCardConfig.isVersion30(this.mVCardType)) {
            VCardBuilder vCardBuilder = this;
            String string44 = "N";
            String string45 = "";
            vCardBuilder.appendLine(string44, string45);
            VCardBuilder vCardBuilder17 = this;
            String string46 = "FN";
            String string47 = "";
            vCardBuilder17.appendLine(string46, string47);
        } else if (this.mIsDoCoMo) {
            VCardBuilder vCardBuilder = this;
            String string48 = "N";
            String string49 = "";
            vCardBuilder.appendLine(string48, string49);
        }
        VCardBuilder vCardBuilder = this;
        ContentValues contentValues2 = contentValues;
        vCardBuilder.appendPhoneticNameFields(contentValues2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendNickNames(List<ContentValues> list) {
        block8: {
            boolean bl;
            block7: {
                block6: {
                    if (!this.mIsV30OrV40) break block6;
                    bl = false;
                    break block7;
                }
                if (!this.mUsesAndroidProperty) break block8;
                bl = true;
            }
            if (list != null) {
                for (ContentValues contentValues : list) {
                    String string2 = contentValues.getAsString("data1");
                    if (TextUtils.isEmpty(string2)) continue;
                    if (bl) {
                        this.appendAndroidSpecificProperty("vnd.android.cursor.item/nickname", contentValues);
                        continue;
                    }
                    this.appendLineWithCharsetAndQPDetection("NICKNAME", string2);
                }
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public VCardBuilder appendNotes(List<ContentValues> list) {
        if (list == null) return this;
        if (this.mOnlyOneNoteFieldIsAvailable) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            Iterator<ContentValues> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getAsString("data1");
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.length() <= 0) continue;
                if (bl) {
                    bl = false;
                } else {
                    StringBuilder stringBuilder2 = stringBuilder.append('\n');
                }
                StringBuilder stringBuilder3 = stringBuilder.append(string2);
            }
            String string3 = stringBuilder.toString();
            String[] stringArray2 = new String[]{string3};
            boolean bl2 = !VCardUtils.containsOnlyPrintableAscii(stringArray2);
            boolean bl3 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray = new String[]{string3});
            this.appendLine("NOTE", string3, bl2, bl3);
            return this;
        }
        Iterator<ContentValues> iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            String string4 = iterator.next().getAsString("data1");
            if (TextUtils.isEmpty(string4)) continue;
            String[] stringArray3 = new String[]{string4};
            boolean bl = !VCardUtils.containsOnlyPrintableAscii(stringArray3);
            boolean bl4 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray = new String[]{string4});
            this.appendLine("NOTE", string4, bl, bl4);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendOrganizations(List<ContentValues> list) {
        if (list != null) {
            for (ContentValues contentValues : list) {
                String[] stringArray;
                String[] stringArray2;
                String string2;
                String string3;
                String string4 = contentValues.getAsString("data1");
                if (string4 != null) {
                    string4 = string4.trim();
                }
                if ((string3 = contentValues.getAsString("data5")) != null) {
                    string3 = string3.trim();
                }
                if ((string2 = contentValues.getAsString("data4")) != null) {
                    string2 = string2.trim();
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (!TextUtils.isEmpty(string4)) {
                    StringBuilder stringBuilder2 = stringBuilder.append(string4);
                }
                if (!TextUtils.isEmpty(string3)) {
                    if (stringBuilder.length() > 0) {
                        StringBuilder stringBuilder3 = stringBuilder.append(';');
                    }
                    StringBuilder stringBuilder4 = stringBuilder.append(string3);
                }
                String string5 = stringBuilder.toString();
                String string6 = "ORG";
                String[] stringArray3 = new String[]{string5};
                boolean bl = !VCardUtils.containsOnlyPrintableAscii(stringArray3);
                boolean bl2 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray2 = new String[]{string5});
                this.appendLine(string6, string5, bl, bl2);
                if (TextUtils.isEmpty(string2)) continue;
                String string7 = "TITLE";
                String[] stringArray4 = new String[]{string2};
                bl = !VCardUtils.containsOnlyPrintableAscii(stringArray4);
                bl2 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray = new String[]{string2});
                this.appendLine(string7, string2, bl, bl2);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendPhones(List<ContentValues> list) {
        boolean bl = false;
        if (list != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator<ContentValues> iterator = list.iterator();
            while (iterator.hasNext()) {
                int n;
                ContentValues contentValues;
                ContentValues contentValues2 = contentValues = iterator.next();
                String string2 = "data2";
                Integer n2 = contentValues2.getAsInteger(string2);
                ContentValues contentValues3 = contentValues;
                String string3 = "data3";
                String string4 = contentValues3.getAsString(string3);
                ContentValues contentValues4 = contentValues;
                String string5 = "is_primary";
                Integer n3 = contentValues4.getAsInteger(string5);
                boolean bl2 = n3 != null ? n3 > 0 : false;
                ContentValues contentValues5 = contentValues;
                String string6 = "data1";
                String string7 = contentValues5.getAsString(string6);
                if (string7 != null) {
                    string7 = string7.trim();
                }
                if (TextUtils.isEmpty(string7)) continue;
                int n4 = n2 != null ? n2 : 1;
                int n5 = n4;
                if (n5 == (n = 6) || VCardConfig.refrainPhoneNumberFormatting(this.mVCardType)) {
                    bl = true;
                    HashSet<String> hashSet2 = hashSet;
                    String string8 = string7;
                    if (hashSet2.contains(string8)) continue;
                    HashSet<String> hashSet3 = hashSet;
                    String string9 = string7;
                    boolean bl3 = hashSet3.add(string9);
                    Integer n6 = n4;
                    VCardBuilder vCardBuilder = this;
                    Integer n7 = n6;
                    String string10 = string4;
                    String string11 = string7;
                    boolean bl4 = bl2;
                    vCardBuilder.appendTelLine(n7, string10, string11, bl4);
                    continue;
                }
                VCardBuilder vCardBuilder = this;
                String string12 = string7;
                List<String> list2 = vCardBuilder.splitAndTrimPhoneNumbers(string12);
                if (list2.isEmpty()) continue;
                bl = true;
                Iterator<String> iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    HashSet<String> hashSet4 = hashSet;
                    String string13 = iterator2.next();
                    String string14 = string13;
                    if (hashSet4.contains(string14)) continue;
                    int n8 = VCardUtils.getPhoneNumberFormat(this.mVCardType);
                    String string15 = PhoneNumberUtils.formatNumber(string13, n8);
                    HashSet<String> hashSet5 = hashSet;
                    String string16 = string13;
                    boolean bl5 = hashSet5.add(string16);
                    Integer n9 = n4;
                    VCardBuilder vCardBuilder2 = this;
                    Integer n10 = n9;
                    String string17 = string4;
                    String string18 = string15;
                    boolean bl6 = bl2;
                    vCardBuilder2.appendTelLine(n10, string17, string18, bl6);
                }
            }
        }
        if (!bl && this.mIsDoCoMo) {
            Integer n = 1;
            VCardBuilder vCardBuilder = this;
            Integer n11 = n;
            String string19 = "";
            String string20 = "";
            boolean bl7 = false;
            vCardBuilder.appendTelLine(n11, string19, string20, bl7);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendPhotoLine(String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("PHOTO");
        StringBuilder stringBuilder3 = stringBuilder.append(";");
        if (this.mIsV30OrV40) {
            StringBuilder stringBuilder4 = stringBuilder.append(VCARD_PARAM_ENCODING_BASE64_AS_B);
        } else {
            StringBuilder stringBuilder5 = stringBuilder.append(VCARD_PARAM_ENCODING_BASE64_V21);
        }
        StringBuilder stringBuilder6 = stringBuilder.append(";");
        this.appendTypeParameter(stringBuilder, string3);
        StringBuilder stringBuilder7 = stringBuilder.append(VCARD_DATA_SEPARATOR);
        StringBuilder stringBuilder8 = stringBuilder.append(string2);
        String string4 = stringBuilder.toString();
        StringBuilder stringBuilder9 = new StringBuilder();
        int n = 0;
        int n2 = string4.length();
        int n3 = VCARD_END_OF_LINE.length();
        int n4 = 75 - n3;
        int n5 = VCARD_WS.length();
        int n6 = n4 - n5;
        int n7 = n4;
        int n8 = 0;
        while (true) {
            if (n8 >= n2) {
                StringBuilder stringBuilder10 = this.mBuilder;
                String string5 = stringBuilder9.toString();
                StringBuilder stringBuilder11 = stringBuilder10.append(string5);
                StringBuilder stringBuilder12 = this.mBuilder.append(VCARD_END_OF_LINE);
                StringBuilder stringBuilder13 = this.mBuilder.append(VCARD_END_OF_LINE);
                return;
            }
            char c = string4.charAt(n8);
            StringBuilder stringBuilder14 = stringBuilder9.append(c);
            if (++n > n7) {
                StringBuilder stringBuilder15 = stringBuilder9.append(VCARD_END_OF_LINE);
                StringBuilder stringBuilder16 = stringBuilder9.append(VCARD_WS);
                n7 = n6;
            }
            ++n8;
        }
    }

    public VCardBuilder appendPhotos(List<ContentValues> list) {
        if (list != null) {
            for (ContentValues contentValues : list) {
                byte[] byArray;
                if (contentValues == null || (byArray = contentValues.getAsByteArray("data15")) == null) continue;
                String string2 = VCardUtils.guessImageType(byArray);
                if (string2 == null) {
                    int n = Log.d(LOG_TAG, "Unknown photo type. Ignored.");
                    continue;
                }
                byte[] byArray2 = Base64.encode(byArray, 2);
                String string3 = new String(byArray2);
                if (TextUtils.isEmpty(string3)) continue;
                this.appendPhotoLine(string3, string2);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendPostalLine(int n, String string2, ContentValues contentValues, boolean bl, boolean bl2) {
        String string3;
        boolean bl3;
        boolean bl4;
        PostalStruct postalStruct = this.tryConstructPostalStruct(contentValues);
        if (postalStruct == null) {
            if (!bl2) {
                return;
            }
            bl4 = false;
            bl3 = false;
            string3 = "";
        } else {
            bl4 = postalStruct.reallyUseQuotedPrintable;
            bl3 = postalStruct.appendCharset;
            string3 = postalStruct.addressData;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            boolean bl5 = arrayList.add("PREF");
        }
        switch (n) {
            default: {
                String string4 = "Unknown StructuredPostal type: " + n;
                int n2 = Log.e(LOG_TAG, string4);
                break;
            }
            case 1: {
                boolean bl6 = arrayList.add("HOME");
                break;
            }
            case 2: {
                boolean bl7 = arrayList.add("WORK");
            }
            case 3: {
                break;
            }
            case 0: {
                if (TextUtils.isEmpty(string2)) break;
                String[] stringArray = new String[]{string2};
                if (!VCardUtils.containsOnlyAlphaDigitHyphen(stringArray)) break;
                String string5 = "X-" + string2;
                boolean bl8 = arrayList.add(string5);
            }
        }
        StringBuilder stringBuilder = this.mBuilder.append("ADR");
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder2 = this.mBuilder.append(";");
            this.appendTypeParameters(arrayList);
        }
        if (bl3) {
            StringBuilder stringBuilder3 = this.mBuilder.append(";");
            StringBuilder stringBuilder4 = this.mBuilder;
            String string6 = this.mVCardCharsetParameter;
            StringBuilder stringBuilder5 = stringBuilder4.append(string6);
        }
        if (bl4) {
            StringBuilder stringBuilder6 = this.mBuilder.append(";");
            StringBuilder stringBuilder7 = this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        StringBuilder stringBuilder8 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
        StringBuilder stringBuilder9 = this.mBuilder.append(string3);
        StringBuilder stringBuilder10 = this.mBuilder.append(VCARD_END_OF_LINE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VCardBuilder appendPostals(List<ContentValues> list) {
        if (list == null || list.isEmpty()) {
            if (this.mIsDoCoMo) {
                StringBuilder stringBuilder = this.mBuilder.append("ADR");
                StringBuilder stringBuilder2 = this.mBuilder.append(";");
                StringBuilder stringBuilder3 = this.mBuilder.append("HOME");
                StringBuilder stringBuilder4 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
                StringBuilder stringBuilder5 = this.mBuilder.append(VCARD_END_OF_LINE);
            }
            return this;
        }
        if (this.mIsDoCoMo) {
            this.appendPostalsForDoCoMo(list);
            return this;
        }
        this.appendPostalsForGeneric(list);
        return this;
    }

    public VCardBuilder appendRelation(List<ContentValues> list) {
        if (this.mUsesAndroidProperty && list != null) {
            for (ContentValues contentValues : list) {
                if (contentValues == null) continue;
                this.appendAndroidSpecificProperty("vnd.android.cursor.item/relation", contentValues);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendTelLine(Integer n, String string2, String string3, boolean bl) {
        StringBuilder stringBuilder = this.mBuilder.append("TEL");
        StringBuilder stringBuilder2 = this.mBuilder.append(";");
        int n2 = n == null ? 7 : n;
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n2) {
            case 1: {
                String[] stringArray = new String[]{"HOME"};
                List<String> list = Arrays.asList(stringArray);
                boolean bl2 = arrayList.addAll(list);
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"WORK"};
                List<String> list = Arrays.asList(stringArray);
                boolean bl3 = arrayList.addAll(list);
                break;
            }
            case 5: {
                String[] stringArray = new String[]{"HOME", "FAX"};
                List<String> list = Arrays.asList(stringArray);
                boolean bl4 = arrayList.addAll(list);
                break;
            }
            case 4: {
                String[] stringArray = new String[]{"WORK", "FAX"};
                List<String> list = Arrays.asList(stringArray);
                boolean bl5 = arrayList.addAll(list);
                break;
            }
            case 2: {
                boolean bl6 = arrayList.add("CELL");
                break;
            }
            case 6: {
                if (this.mIsDoCoMo) {
                    boolean bl7 = arrayList.add("VOICE");
                    break;
                }
                boolean bl8 = arrayList.add("PAGER");
                break;
            }
            case 7: {
                boolean bl9 = arrayList.add("VOICE");
                break;
            }
            case 9: {
                boolean bl10 = arrayList.add("CAR");
                break;
            }
            case 10: {
                boolean bl11 = arrayList.add("WORK");
                bl = true;
                break;
            }
            case 11: {
                boolean bl12 = arrayList.add("ISDN");
                break;
            }
            case 12: {
                bl = true;
                break;
            }
            case 13: {
                boolean bl13 = arrayList.add("FAX");
                break;
            }
            case 15: {
                boolean bl14 = arrayList.add("TLX");
                break;
            }
            case 17: {
                String[] stringArray = new String[]{"WORK", "CELL"};
                List<String> list = Arrays.asList(stringArray);
                boolean bl15 = arrayList.addAll(list);
                break;
            }
            case 18: {
                boolean bl16 = arrayList.add("WORK");
                if (this.mIsDoCoMo) {
                    boolean bl17 = arrayList.add("VOICE");
                    break;
                }
                boolean bl18 = arrayList.add("PAGER");
                break;
            }
            case 20: {
                boolean bl19 = arrayList.add("MSG");
                break;
            }
            case 0: {
                if (TextUtils.isEmpty(string2)) {
                    boolean bl20 = arrayList.add("VOICE");
                    break;
                }
                if (VCardUtils.isMobilePhoneLabel(string2)) {
                    boolean bl21 = arrayList.add("CELL");
                    break;
                }
                if (this.mIsV30OrV40) {
                    boolean bl22 = arrayList.add(string2);
                    break;
                }
                String string4 = string2.toUpperCase();
                if (VCardUtils.isValidInV21ButUnknownToContactsPhoteType(string4)) {
                    boolean bl23 = arrayList.add(string4);
                    break;
                }
                String[] stringArray = new String[]{string2};
                if (!VCardUtils.containsOnlyAlphaDigitHyphen(stringArray)) break;
                String string5 = "X-" + string2;
                boolean bl24 = arrayList.add(string5);
            }
        }
        if (bl) {
            boolean bl25 = arrayList.add("PREF");
        }
        if (arrayList.isEmpty()) {
            StringBuilder stringBuilder3 = this.mBuilder;
            Integer n3 = n2;
            this.appendUncommonPhoneType(stringBuilder3, n3);
        } else {
            this.appendTypeParameters(arrayList);
        }
        StringBuilder stringBuilder4 = this.mBuilder.append(VCARD_DATA_SEPARATOR);
        StringBuilder stringBuilder5 = this.mBuilder.append(string3);
        StringBuilder stringBuilder6 = this.mBuilder.append(VCARD_END_OF_LINE);
    }

    public VCardBuilder appendWebsites(List<ContentValues> list) {
        if (list != null) {
            Iterator<ContentValues> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getAsString("data1");
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if (TextUtils.isEmpty(string2)) continue;
                this.appendLineWithCharsetAndQPDetection("URL", string2);
            }
        }
        return this;
    }

    public void clear() {
        StringBuilder stringBuilder;
        this.mBuilder = stringBuilder = new StringBuilder();
        this.mEndAppended = false;
        this.appendLine("BEGIN", VCARD_DATA_VCARD);
        if (VCardConfig.isVersion40(this.mVCardType)) {
            this.appendLine("VERSION", "4.0");
            return;
        }
        if (VCardConfig.isVersion30(this.mVCardType)) {
            this.appendLine("VERSION", "3.0");
            return;
        }
        if (!VCardConfig.isVersion21(this.mVCardType)) {
            int n = Log.w(LOG_TAG, "Unknown vCard version detected.");
        }
        this.appendLine("VERSION", "2.1");
    }

    public String toString() {
        if (!this.mEndAppended) {
            if (this.mIsDoCoMo) {
                this.appendLine("X-CLASS", VCARD_DATA_PUBLIC);
                this.appendLine("X-REDUCTION", "");
                this.appendLine("X-NO", "");
                this.appendLine("X-DCM-HMN-MODE", "");
            }
            this.appendLine("END", VCARD_DATA_VCARD);
            this.mEndAppended = true;
        }
        return this.mBuilder.toString();
    }

    private static class PostalStruct {
        final String addressData;
        final boolean appendCharset;
        final boolean reallyUseQuotedPrintable;

        public PostalStruct(boolean bl, boolean bl2, String string2) {
            this.reallyUseQuotedPrintable = bl;
            this.appendCharset = bl2;
            this.addressData = string2;
        }
    }
}

