/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.pim.vcard.VCardBuilder;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.exception.VCardException;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.util.CharsetUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VCardComposer {
    public static final Uri CONTACTS_TEST_CONTENT_URI;
    public static final String FAILURE_REASON_FAILED_TO_GET_DATABASE_INFO = "Failed to get database information";
    public static final String FAILURE_REASON_NOT_INITIALIZED = "The vCard composer object is not correctly initialized";
    public static final String FAILURE_REASON_NO_ENTRY = "There's no exportable in the database";
    public static final String FAILURE_REASON_UNSUPPORTED_URI = "The Uri vCard composer received is not supported by the composer.";
    private static final String LOG_TAG = "VCardComposer";
    public static final String NO_ERROR = "No error";
    private static final String SHIFT_JIS = "SHIFT_JIS";
    private static final String UTF_8 = "UTF-8";
    public static final String VCARD_TEST_AUTHORITY = "com.android.unit_tests.vcard";
    public static final Uri VCARD_TEST_AUTHORITY_URI;
    public static final String VCARD_TYPE_STRING_DOCOMO = "docomo";
    private static final String[] sContactsProjection;
    private static final Map<Integer, String> sImMap;
    private final boolean mCareHandlerErrors;
    private final String mCharset;
    private final ContentResolver mContentResolver;
    private final Context mContext;
    private Cursor mCursor;
    private String mErrorReason;
    private final List<OneEntryHandler> mHandlerList;
    private int mIdColumn;
    private final boolean mIsDoCoMo;
    private boolean mTerminateIsCalled;
    private final int mVCardType;

    static {
        VCARD_TEST_AUTHORITY_URI = Uri.parse("content://com.android.unit_tests.vcard");
        CONTACTS_TEST_CONTENT_URI = Uri.withAppendedPath(VCARD_TEST_AUTHORITY_URI, "contacts");
        Map<Integer, String> map = sImMap = new HashMap<Integer, String>();
        Integer n = 0;
        String string2 = map.put(n, "X-AIM");
        Map<Integer, String> map2 = sImMap;
        Integer n2 = 1;
        String string3 = map2.put(n2, "X-MSN");
        Map<Integer, String> map3 = sImMap;
        Integer n3 = 2;
        String string4 = map3.put(n3, "X-YAHOO");
        Map<Integer, String> map4 = sImMap;
        Integer n4 = 6;
        String string5 = map4.put(n4, "X-ICQ");
        Map<Integer, String> map5 = sImMap;
        Integer n5 = 7;
        String string6 = map5.put(n5, "X-JABBER");
        Map<Integer, String> map6 = sImMap;
        Integer n6 = 3;
        String string7 = map6.put(n6, "X-SKYPE-USERNAME");
        String[] stringArray = new String[]{"_id"};
        sContactsProjection = stringArray;
    }

    public VCardComposer(Context context) {
        int n = VCardConfig.VCARD_TYPE_DEFAULT;
        this(context, n, null, true);
    }

    public VCardComposer(Context context, int n) {
        this(context, n, null, true);
    }

    public VCardComposer(Context context, int n, String string2) {
        this(context, n, string2, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VCardComposer(Context context, int n, String string2, boolean bl) {
        block17: {
            block15: {
                block16: {
                    boolean bl2;
                    ContentResolver contentResolver;
                    this.mErrorReason = NO_ERROR;
                    this.mContext = context;
                    this.mVCardType = n;
                    this.mCareHandlerErrors = bl;
                    this.mContentResolver = contentResolver = context.getContentResolver();
                    this.mIsDoCoMo = bl2 = VCardConfig.isDoCoMo(n);
                    ArrayList<OneEntryHandler> arrayList = new ArrayList<OneEntryHandler>();
                    this.mHandlerList = arrayList;
                    if (TextUtils.isEmpty(string2)) {
                        string2 = UTF_8;
                    }
                    boolean bl3 = !VCardConfig.isVersion30(n) || !UTF_8.equalsIgnoreCase(string2);
                    if (!this.mIsDoCoMo && !bl3) break block15;
                    if (!SHIFT_JIS.equalsIgnoreCase(string2)) break block16;
                    if (this.mIsDoCoMo) {
                        try {
                            String string3;
                            string2 = string3 = CharsetUtils.charsetForVendor(SHIFT_JIS, VCARD_TYPE_STRING_DOCOMO).name();
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            int n2 = Log.e(LOG_TAG, "DoCoMo-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                        }
                    } else {
                        try {
                            String string4;
                            String string5 = string4 = CharsetUtils.charsetForVendor(SHIFT_JIS).name();
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            int n3 = Log.e(LOG_TAG, "Career-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                        }
                    }
                    this.mCharset = string2;
                    break block17;
                }
                String string6 = "The charset \"" + string2 + "\" is used while " + SHIFT_JIS + " is needed to be used.";
                int n4 = Log.w(LOG_TAG, string6);
                if (TextUtils.isEmpty(string2)) {
                    this.mCharset = SHIFT_JIS;
                    break block17;
                } else {
                    try {
                        String string7;
                        string2 = string7 = CharsetUtils.charsetForVendor(string2).name();
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        String string8 = "Career-specific \"" + string2 + "\" was not found (as usual). " + "Use it as is.";
                        int n5 = Log.i(LOG_TAG, string8);
                    }
                    this.mCharset = string2;
                }
                break block17;
            }
            if (TextUtils.isEmpty(string2)) {
                this.mCharset = UTF_8;
            } else {
                try {
                    String string9;
                    string2 = string9 = CharsetUtils.charsetForVendor(string2).name();
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    String string10 = "Career-specific \"" + string2 + "\" was not found (as usual). " + "Use it as is.";
                    int n6 = Log.i(LOG_TAG, string10);
                }
                this.mCharset = string2;
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("Use the charset \"");
        String string11 = this.mCharset;
        String string12 = stringBuilder.append(string11).append("\"").toString();
        int n7 = Log.d(LOG_TAG, string12);
    }

    public VCardComposer(Context context, int n, boolean bl) {
        this(context, n, null, bl);
    }

    static /* synthetic */ String access$102(VCardComposer vCardComposer, String string2) {
        vCardComposer.mErrorReason = string2;
        return string2;
    }

    /*
     * Exception decompiling
     */
    private String createOneEntryInternal(String var1_1, Method var2_2) throws VCardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [7 : 222->497)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addHandler(OneEntryHandler oneEntryHandler) {
        if (oneEntryHandler == null) {
            return;
        }
        boolean bl = this.mHandlerList.add(oneEntryHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String buildVCard(Map<String, List<ContentValues>> map) {
        if (map == null) {
            int n = Log.e(LOG_TAG, "The given map is null. Ignore and return empty String");
            return "";
        }
        int n = this.mVCardType;
        String string2 = this.mCharset;
        VCardBuilder vCardBuilder = new VCardBuilder(n, string2);
        List<ContentValues> list = map.get("vnd.android.cursor.item/name");
        VCardBuilder vCardBuilder2 = vCardBuilder.appendNameProperties(list);
        List<ContentValues> list2 = map.get("vnd.android.cursor.item/nickname");
        VCardBuilder vCardBuilder3 = vCardBuilder2.appendNickNames(list2);
        List<ContentValues> list3 = map.get("vnd.android.cursor.item/phone_v2");
        VCardBuilder vCardBuilder4 = vCardBuilder3.appendPhones(list3);
        List<ContentValues> list4 = map.get("vnd.android.cursor.item/email_v2");
        VCardBuilder vCardBuilder5 = vCardBuilder4.appendEmails(list4);
        List<ContentValues> list5 = map.get("vnd.android.cursor.item/postal-address_v2");
        VCardBuilder vCardBuilder6 = vCardBuilder5.appendPostals(list5);
        List<ContentValues> list6 = map.get("vnd.android.cursor.item/organization");
        VCardBuilder vCardBuilder7 = vCardBuilder6.appendOrganizations(list6);
        List<ContentValues> list7 = map.get("vnd.android.cursor.item/website");
        VCardBuilder vCardBuilder8 = vCardBuilder7.appendWebsites(list7);
        if ((this.mVCardType & 0x800000) == 0) {
            List<ContentValues> list8 = map.get("vnd.android.cursor.item/photo");
            VCardBuilder vCardBuilder9 = vCardBuilder.appendPhotos(list8);
        }
        List<ContentValues> list9 = map.get("vnd.android.cursor.item/note");
        VCardBuilder vCardBuilder10 = vCardBuilder.appendNotes(list9);
        List<ContentValues> list10 = map.get("vnd.android.cursor.item/contact_event");
        VCardBuilder vCardBuilder11 = vCardBuilder10.appendEvents(list10);
        List<ContentValues> list11 = map.get("vnd.android.cursor.item/im");
        VCardBuilder vCardBuilder12 = vCardBuilder11.appendIms(list11);
        List<ContentValues> list12 = map.get("vnd.android.cursor.item/relation");
        VCardBuilder vCardBuilder13 = vCardBuilder12.appendRelation(list12);
        return vCardBuilder.toString();
    }

    public boolean createOneEntry() {
        return this.createOneEntry(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createOneEntry(Method method) {
        String string2;
        block12: {
            Iterator<OneEntryHandler> iterator;
            block13: {
                boolean bl;
                if (this.mCursor == null || this.mCursor.isAfterLast()) {
                    this.mErrorReason = FAILURE_REASON_NOT_INITIALIZED;
                    return false;
                }
                try {
                    if (this.mIdColumn >= 0) {
                        String string3;
                        Cursor cursor = this.mCursor;
                        int n = this.mIdColumn;
                        String string4 = cursor.getString(n);
                        string2 = string3 = this.createOneEntryInternal(string4, method);
                        boolean bl2 = this.mCursor.moveToNext();
                        if (!this.mCareHandlerErrors) break block12;
                        int n2 = this.mHandlerList.size();
                        ArrayList arrayList = new ArrayList(n2);
                        iterator = this.mHandlerList.iterator();
                        break block13;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("Incorrect mIdColumn: ");
                    int n = this.mIdColumn;
                    String string5 = stringBuilder.append(n).toString();
                    int n3 = Log.e(LOG_TAG, string5);
                    bl = true;
                    return bl;
                }
                catch (VCardException vCardException) {
                    StringBuilder stringBuilder = new StringBuilder().append("VCardException has been thrown: ");
                    String string6 = vCardException.getMessage();
                    String string7 = stringBuilder.append(string6).toString();
                    int n = Log.e(LOG_TAG, string7);
                    bl = false;
                    return bl;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    int n = Log.e(LOG_TAG, "OutOfMemoryError occured. Ignore the entry.");
                    System.gc();
                    bl = true;
                    return bl;
                }
            }
            do {
                if (!iterator.hasNext()) return true;
            } while (iterator.next().onEntryCreated(string2));
            return false;
            finally {
                boolean bl = this.mCursor.moveToNext();
            }
        }
        Iterator<OneEntryHandler> iterator = this.mHandlerList.iterator();
        while (iterator.hasNext()) {
            boolean bl = iterator.next().onEntryCreated(string2);
        }
        return true;
    }

    public void finalize() {
        if (this.mTerminateIsCalled) {
            return;
        }
        int n = Log.w(LOG_TAG, "terminate() is not called yet. We call it in finalize() step.");
        this.terminate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCount() {
        if (this.mCursor != null) return this.mCursor.getCount();
        int n = Log.w(LOG_TAG, "This object is not ready yet.");
        return 0;
    }

    public String getErrorReason() {
        return this.mErrorReason;
    }

    public boolean init() {
        return this.init(null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean init(Uri uri, String string2, String[] stringArray, String string3) {
        Cursor cursor;
        if (uri == null) {
            return false;
        }
        if (this.mCareHandlerErrors) {
            int n = this.mHandlerList.size();
            ArrayList arrayList = new ArrayList(n);
            Iterator<OneEntryHandler> iterator = this.mHandlerList.iterator();
            while (iterator.hasNext()) {
                Context context;
                OneEntryHandler oneEntryHandler = iterator.next();
                if (oneEntryHandler.onInit(context = this.mContext)) continue;
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onTerminate();
                }
                return false;
            }
        } else {
            for (OneEntryHandler oneEntryHandler : this.mHandlerList) {
                Context context = this.mContext;
                boolean bl = oneEntryHandler.onInit(context);
            }
        }
        if (!ContactsContract.Contacts.CONTENT_URI.equals(uri) && !CONTACTS_TEST_CONTENT_URI.equals(uri)) {
            this.mErrorReason = FAILURE_REASON_UNSUPPORTED_URI;
            return false;
        }
        String[] stringArray2 = sContactsProjection;
        ContentResolver contentResolver = this.mContentResolver;
        Uri uri2 = uri;
        String string4 = string2;
        String[] stringArray3 = stringArray;
        String string5 = string3;
        this.mCursor = cursor = contentResolver.query(uri2, stringArray2, string4, stringArray3, string5);
        if (this.mCursor == null) {
            this.mErrorReason = FAILURE_REASON_FAILED_TO_GET_DATABASE_INFO;
            return false;
        }
        if (this.getCount() != 0 && this.mCursor.moveToFirst()) {
            int n;
            this.mIdColumn = n = this.mCursor.getColumnIndex("_id");
            return true;
        }
        try {
            this.mCursor.close();
            return false;
        }
        catch (SQLiteException sQLiteException) {
            StringBuilder stringBuilder = new StringBuilder().append("SQLiteException on Cursor#close(): ");
            String string6 = sQLiteException.getMessage();
            String string7 = stringBuilder.append(string6).toString();
            int n = Log.e(LOG_TAG, string7);
        }
        return false;
        finally {
            this.mCursor = null;
            this.mErrorReason = FAILURE_REASON_NO_ENTRY;
            return false;
        }
    }

    public boolean init(String string2, String[] stringArray) {
        Uri uri = ContactsContract.Contacts.CONTENT_URI;
        return this.init(uri, string2, stringArray, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAfterLast() {
        if (this.mCursor != null) return this.mCursor.isAfterLast();
        int n = Log.w(LOG_TAG, "This object is not ready yet.");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void terminate() {
        Iterator<OneEntryHandler> iterator = this.mHandlerList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onTerminate();
        }
        if (this.mCursor != null) {
            try {
                this.mCursor.close();
            }
            catch (SQLiteException sQLiteException) {
                StringBuilder stringBuilder = new StringBuilder().append("SQLiteException on Cursor#close(): ");
                String string2 = sQLiteException.getMessage();
                String string3 = stringBuilder.append(string2).toString();
                int n = Log.e(LOG_TAG, string3);
            }
            this.mCursor = null;
        }
        this.mTerminateIsCalled = true;
    }

    public final class HandlerForOutputStream
    implements OneEntryHandler {
        private static final String LOG_TAG = "VCardComposer.HandlerForOutputStream";
        private boolean mOnTerminateIsCalled = false;
        private final OutputStream mOutputStream;
        private Writer mWriter;

        public HandlerForOutputStream(OutputStream outputStream) {
            this.mOutputStream = outputStream;
        }

        public void closeOutputStream() {
            try {
                this.mWriter.close();
                return;
            }
            catch (IOException iOException) {
                int n = Log.w(LOG_TAG, "IOException is thrown during close(). Ignoring.");
                return;
            }
        }

        public void finalize() {
            if (this.mOnTerminateIsCalled) {
                return;
            }
            this.onTerminate();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onEntryCreated(String string2) {
            try {
                this.mWriter.write(string2);
                return true;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("IOException occurred during exportOneContactData: ");
                String string3 = iOException.getMessage();
                String string4 = stringBuilder.append(string3).toString();
                int n = Log.e(LOG_TAG, string4);
                VCardComposer vCardComposer = VCardComposer.this;
                StringBuilder stringBuilder2 = new StringBuilder().append("IOException occurred: ");
                String string5 = iOException.getMessage();
                String string6 = stringBuilder2.append(string5).toString();
                String string7 = VCardComposer.access$102(vCardComposer, string6);
                return false;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onInit(Context context) {
            try {
                OutputStream outputStream = this.mOutputStream;
                String string2 = VCardComposer.this.mCharset;
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string2);
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                this.mWriter = bufferedWriter;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                StringBuilder stringBuilder = new StringBuilder().append("Unsupported charset: ");
                String string3 = VCardComposer.this.mCharset;
                String string4 = stringBuilder.append(string3).toString();
                int n = Log.e(LOG_TAG, string4);
                VCardComposer vCardComposer = VCardComposer.this;
                StringBuilder stringBuilder2 = new StringBuilder().append("Encoding is not supported (usually this does not happen!): ");
                String string5 = VCardComposer.this.mCharset;
                String string6 = stringBuilder2.append(string5).toString();
                String string7 = VCardComposer.access$102(vCardComposer, string6);
                return false;
            }
            if (!VCardComposer.this.mIsDoCoMo) return true;
            try {
                Writer writer = this.mWriter;
                String string8 = VCardComposer.this.createOneEntryInternal("-1", null);
                writer.write(string8);
            }
            catch (VCardException vCardException) {
                StringBuilder stringBuilder = new StringBuilder().append("VCardException has been thrown during on Init(): ");
                String string9 = vCardException.getMessage();
                String string10 = stringBuilder.append(string9).toString();
                int n = Log.e(LOG_TAG, string10);
                return false;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("IOException occurred during exportOneContactData: ");
                String string11 = iOException.getMessage();
                String string12 = stringBuilder.append(string11).toString();
                int n = Log.e(LOG_TAG, string12);
                VCardComposer vCardComposer = VCardComposer.this;
                StringBuilder stringBuilder3 = new StringBuilder().append("IOException occurred: ");
                String string13 = iOException.getMessage();
                String string14 = stringBuilder3.append(string13).toString();
                String string15 = VCardComposer.access$102(vCardComposer, string14);
                return false;
            }
            return true;
        }

        @Override
        public void onTerminate() {
            this.mOnTerminateIsCalled = true;
            if (this.mWriter == null) {
                return;
            }
            try {
                this.mWriter.flush();
                if (this.mOutputStream != null && this.mOutputStream instanceof FileOutputStream) {
                    ((FileOutputStream)this.mOutputStream).getFD().sync();
                }
                return;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("IOException during closing the output stream: ");
                String string2 = iOException.getMessage();
                String string3 = stringBuilder.append(string2).toString();
                int n = Log.d(LOG_TAG, string3);
                return;
            }
            finally {
                this.closeOutputStream();
            }
        }
    }

    public static interface OneEntryHandler {
        public boolean onEntryCreated(String var1);

        public boolean onInit(Context var1);

        public void onTerminate();
    }
}

