/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VCardConfig {
    public static final String DEFAULT_EXPORT_CHARSET = "UTF-8";
    public static final String DEFAULT_IMPORT_CHARSET = "UTF-8";
    public static final String DEFAULT_INTERMEDIATE_CHARSET = "ISO-8859-1";
    public static final int FLAG_APPEND_TYPE_PARAM = 0x4000000;
    public static final int FLAG_CONVERT_PHONETIC_NAME_STRINGS = 0x8000000;
    private static final int FLAG_DOCOMO = 0x20000000;
    public static final int FLAG_REFRAIN_IMAGE_EXPORT = 0x800000;
    public static final int FLAG_REFRAIN_PHONE_NUMBER_FORMATTING = 0x2000000;
    public static final int FLAG_REFRAIN_QP_TO_NAME_PROPERTIES = 0x10000000;
    public static final int FLAG_TORELATE_NEST = 0x1000000;
    private static final int FLAG_USE_ANDROID_PROPERTY = Integer.MIN_VALUE;
    private static final int FLAG_USE_DEFACT_PROPERTY = 0x40000000;
    static final int LOG_LEVEL = 0;
    static final int LOG_LEVEL_NONE = 0;
    static final int LOG_LEVEL_PERFORMANCE_MEASUREMENT = 1;
    static final int LOG_LEVEL_SHOW_WARNING = 2;
    static final int LOG_LEVEL_VERBOSE = 3;
    private static final String LOG_TAG = "VCardConfig";
    public static final int NAME_ORDER_DEFAULT = 0;
    public static final int NAME_ORDER_EUROPE = 4;
    public static final int NAME_ORDER_JAPANESE = 8;
    private static final int NAME_ORDER_MASK = 12;
    public static int VCARD_TYPE_DEFAULT = 0;
    public static final int VCARD_TYPE_DOCOMO = 0x38000008;
    static final String VCARD_TYPE_DOCOMO_STR = "docomo";
    public static final int VCARD_TYPE_UNKNOWN = 0;
    public static final int VCARD_TYPE_V21_EUROPE = -1073741820;
    static final String VCARD_TYPE_V21_EUROPE_STR = "v21_europe";
    public static final int VCARD_TYPE_V21_GENERIC = -1073741824;
    static String VCARD_TYPE_V21_GENERIC_STR = "v21_generic";
    public static final int VCARD_TYPE_V21_JAPANESE = -1073741816;
    public static final int VCARD_TYPE_V21_JAPANESE_MOBILE = 0x18000008;
    static final String VCARD_TYPE_V21_JAPANESE_MOBILE_STR = "v21_japanese_mobile";
    static final String VCARD_TYPE_V21_JAPANESE_STR = "v21_japanese_utf8";
    public static final int VCARD_TYPE_V30_EUROPE = -1073741819;
    static final String VCARD_TYPE_V30_EUROPE_STR = "v30_europe";
    public static final int VCARD_TYPE_V30_GENERIC = -1073741823;
    static final String VCARD_TYPE_V30_GENERIC_STR = "v30_generic";
    public static final int VCARD_TYPE_V30_JAPANESE = -1073741815;
    static final String VCARD_TYPE_V30_JAPANESE_STR = "v30_japanese_utf8";
    public static final int VCARD_TYPE_V40_GENERIC = -1073741822;
    static final String VCARD_TYPE_V40_GENERIC_STR = "v40_generic";
    public static final int VERSION_21 = 0;
    public static final int VERSION_30 = 1;
    public static final int VERSION_40 = 2;
    public static final int VERSION_MASK = 3;
    private static final Set<Integer> sJapaneseMobileTypeSet;
    private static final Map<String, Integer> sVCardTypeMap;

    static {
        VCARD_TYPE_DEFAULT = -1073741824;
        Map<String, Integer> map = sVCardTypeMap = new HashMap<String, Integer>();
        String string2 = VCARD_TYPE_V21_GENERIC_STR;
        Integer n = -1073741824;
        Integer n2 = map.put(string2, n);
        Map<String, Integer> map2 = sVCardTypeMap;
        Integer n3 = -1073741823;
        Integer n4 = map2.put(VCARD_TYPE_V30_GENERIC_STR, n3);
        Map<String, Integer> map3 = sVCardTypeMap;
        Integer n5 = -1073741820;
        Integer n6 = map3.put(VCARD_TYPE_V21_EUROPE_STR, n5);
        Map<String, Integer> map4 = sVCardTypeMap;
        Integer n7 = -1073741819;
        Integer n8 = map4.put(VCARD_TYPE_V30_EUROPE_STR, n7);
        Map<String, Integer> map5 = sVCardTypeMap;
        Integer n9 = -1073741816;
        Integer n10 = map5.put(VCARD_TYPE_V21_JAPANESE_STR, n9);
        Map<String, Integer> map6 = sVCardTypeMap;
        Integer n11 = -1073741815;
        Integer n12 = map6.put(VCARD_TYPE_V30_JAPANESE_STR, n11);
        Map<String, Integer> map7 = sVCardTypeMap;
        Integer n13 = 0x18000008;
        Integer n14 = map7.put(VCARD_TYPE_V21_JAPANESE_MOBILE_STR, n13);
        Map<String, Integer> map8 = sVCardTypeMap;
        Integer n15 = 0x38000008;
        Integer n16 = map8.put(VCARD_TYPE_DOCOMO_STR, n15);
        Set<Integer> set = sJapaneseMobileTypeSet = new HashSet<Integer>();
        Integer n17 = -1073741816;
        boolean bl = set.add(n17);
        Set<Integer> set2 = sJapaneseMobileTypeSet;
        Integer n18 = -1073741815;
        boolean bl2 = set2.add(n18);
        Set<Integer> set3 = sJapaneseMobileTypeSet;
        Integer n19 = 0x18000008;
        boolean bl3 = set3.add(n19);
        Set<Integer> set4 = sJapaneseMobileTypeSet;
        Integer n20 = 0x38000008;
        boolean bl4 = set4.add(n20);
    }

    private VCardConfig() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean appendTypeParamName(int n) {
        if (VCardConfig.isVersion30(n)) return true;
        if ((0x4000000 & n) == 0) return false;
        return true;
    }

    public static int getNameOrderType(int n) {
        return n & 0xC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getVCardTypeFromString(String string2) {
        String string3 = string2.toLowerCase();
        if (sVCardTypeMap.containsKey(string3)) {
            return sVCardTypeMap.get(string3);
        }
        if ("default".equalsIgnoreCase(string2)) {
            return VCARD_TYPE_DEFAULT;
        }
        String string4 = "Unknown vCard type String: \"" + string2 + "\"";
        int n = Log.e(LOG_TAG, string4);
        return VCARD_TYPE_DEFAULT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDoCoMo(int n) {
        if ((0x20000000 & n) == 0) return false;
        return true;
    }

    public static boolean isJapaneseDevice(int n) {
        Set<Integer> set = sJapaneseMobileTypeSet;
        Integer n2 = n;
        return set.contains(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVersion21(int n) {
        if ((n & 3) != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVersion30(int n) {
        if ((n & 3) != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVersion40(int n) {
        if ((n & 3) != 2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean needsToConvertPhoneticString(int n) {
        if ((0x8000000 & n) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean onlyOneNoteFieldIsAvailable(int n) {
        if (n != 0x38000008) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean refrainPhoneNumberFormatting(int n) {
        if ((0x2000000 & n) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldRefrainQPToNameProperties(int n) {
        if (!VCardConfig.shouldUseQuotedPrintable(n)) return true;
        if ((0x10000000 & n) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldUseQuotedPrintable(int n) {
        if (VCardConfig.isVersion30(n)) return false;
        return true;
    }

    public static boolean showPerformanceLog() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean usesAndroidSpecificProperty(int n) {
        if ((Integer.MIN_VALUE & n) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean usesDefactProperty(int n) {
        if ((0x40000000 & n) == 0) return false;
        return true;
    }
}

