/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.accounts.Account;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardUtils;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VCardEntry {
    private static final String ACCOUNT_TYPE_GOOGLE = "com.google";
    private static final int DEFAULT_ORGANIZATION_TYPE = 1;
    private static final String GOOGLE_MY_CONTACTS_GROUP = "System Group: My Contacts";
    private static final String LOG_TAG = "VCardEntry";
    private static final List<String> sEmptyList;
    private static final Map<String, Integer> sImMap;
    private final Account mAccount;
    private List<List<String>> mAndroidCustomPropertyList;
    private String mAnniversary;
    private String mBirthday;
    private String mDisplayName;
    private List<EmailData> mEmailList;
    private String mFamilyName;
    private String mFormattedName;
    private String mGivenName;
    private List<ImData> mImList;
    private String mMiddleName;
    private List<String> mNickNameList;
    private List<String> mNoteList;
    private List<OrganizationData> mOrganizationList;
    private List<PhoneData> mPhoneList;
    private String mPhoneticFamilyName;
    private String mPhoneticFullName;
    private String mPhoneticGivenName;
    private String mPhoneticMiddleName;
    private List<PhotoData> mPhotoList;
    private List<PostalData> mPostalList;
    private String mPrefix;
    private String mSuffix;
    private final int mVCardType;
    private List<String> mWebsiteList;

    static {
        Map<String, Integer> map = sImMap = new HashMap<String, Integer>();
        Integer n = 0;
        Integer n2 = map.put("X-AIM", n);
        Map<String, Integer> map2 = sImMap;
        Integer n3 = 1;
        Integer n4 = map2.put("X-MSN", n3);
        Map<String, Integer> map3 = sImMap;
        Integer n5 = 2;
        Integer n6 = map3.put("X-YAHOO", n5);
        Map<String, Integer> map4 = sImMap;
        Integer n7 = 6;
        Integer n8 = map4.put("X-ICQ", n7);
        Map<String, Integer> map5 = sImMap;
        Integer n9 = 7;
        Integer n10 = map5.put("X-JABBER", n9);
        Map<String, Integer> map6 = sImMap;
        Integer n11 = 3;
        Integer n12 = map6.put("X-SKYPE-USERNAME", n11);
        Map<String, Integer> map7 = sImMap;
        Integer n13 = 5;
        Integer n14 = map7.put("X-GOOGLE-TALK", n13);
        Map<String, Integer> map8 = sImMap;
        Integer n15 = 5;
        Integer n16 = map8.put("X-GOOGLE TALK", n15);
        sEmptyList = Collections.unmodifiableList(new ArrayList(0));
    }

    public VCardEntry() {
        this(-1073741824);
    }

    public VCardEntry(int n) {
        this(n, null);
    }

    public VCardEntry(int n, Account account) {
        this.mVCardType = n;
        this.mAccount = account;
    }

    private void addEmail(int n, String string2, String string3, boolean bl) {
        if (this.mEmailList == null) {
            ArrayList<EmailData> arrayList = new ArrayList<EmailData>();
            this.mEmailList = arrayList;
        }
        List<EmailData> list = this.mEmailList;
        EmailData emailData = new EmailData(n, string2, string3, bl);
        boolean bl2 = list.add(emailData);
    }

    private void addIm(int n, String string2, int n2, String string3, boolean bl) {
        if (this.mImList == null) {
            ArrayList<ImData> arrayList = new ArrayList<ImData>();
            this.mImList = arrayList;
        }
        List<ImData> list = this.mImList;
        int n3 = n;
        String string4 = string2;
        int n4 = n2;
        String string5 = string3;
        boolean bl2 = bl;
        ImData imData = new ImData(n3, string4, n4, string5, bl2);
        boolean bl3 = list.add(imData);
    }

    private void addNewOrganization(int n, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.mOrganizationList == null) {
            ArrayList<OrganizationData> arrayList = new ArrayList<OrganizationData>();
            this.mOrganizationList = arrayList;
        }
        List<OrganizationData> list = this.mOrganizationList;
        int n2 = n;
        String string6 = string2;
        String string7 = string3;
        String string8 = string4;
        String string9 = string5;
        boolean bl2 = bl;
        OrganizationData organizationData = new OrganizationData(n2, string6, string7, string8, string9, bl2);
        boolean bl3 = list.add(organizationData);
    }

    private void addNickName(String string2) {
        if (this.mNickNameList == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.mNickNameList = arrayList;
        }
        boolean bl = this.mNickNameList.add(string2);
    }

    private void addNote(String string2) {
        if (this.mNoteList == null) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            this.mNoteList = arrayList;
        }
        boolean bl = this.mNoteList.add(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addPhone(int n, String string2, String string3, boolean bl) {
        String string4;
        if (this.mPhoneList == null) {
            ArrayList<PhoneData> arrayList = new ArrayList<PhoneData>();
            this.mPhoneList = arrayList;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = string2.trim();
        if (n == 6 || VCardConfig.refrainPhoneNumberFormatting(this.mVCardType)) {
            string4 = string5;
        } else {
            int n2 = string5.length();
            for (int i = 0; i < n2; ++i) {
                char c = string5.charAt(i);
                if (('0' > c || c > '9') && (i != 0 || c != '+')) continue;
                StringBuilder stringBuilder2 = stringBuilder.append(c);
            }
            int n3 = VCardUtils.getPhoneNumberFormat(this.mVCardType);
            string4 = PhoneNumberUtils.formatNumber(stringBuilder.toString(), n3);
        }
        PhoneData phoneData = new PhoneData(n, string4, string3, bl);
        boolean bl2 = this.mPhoneList.add(phoneData);
    }

    private void addPhotoBytes(String string2, byte[] byArray, boolean bl) {
        if (this.mPhotoList == null) {
            ArrayList<PhotoData> arrayList = new ArrayList<PhotoData>(1);
            this.mPhotoList = arrayList;
        }
        PhotoData photoData = new PhotoData(0, null, byArray, bl);
        boolean bl2 = this.mPhotoList.add(photoData);
    }

    private void addPostal(int n, List<String> list, String string2, boolean bl) {
        if (this.mPostalList == null) {
            ArrayList<PostalData> arrayList = new ArrayList<PostalData>(0);
            this.mPostalList = arrayList;
        }
        List<PostalData> list2 = this.mPostalList;
        PostalData postalData = new PostalData(n, list, string2, bl);
        boolean bl2 = list2.add(postalData);
    }

    public static VCardEntry buildFromResolver(ContentResolver contentResolver) {
        Uri uri = ContactsContract.Contacts.CONTENT_URI;
        return VCardEntry.buildFromResolver(contentResolver, uri);
    }

    public static VCardEntry buildFromResolver(ContentResolver contentResolver, Uri uri) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String buildSinglePhoneticNameFromSortAsParam(Map<String, Collection<String>> map) {
        Collection<String> collection = map.get("SORT-AS");
        if (collection == null) return null;
        if (collection.size() == 0) return null;
        if (collection.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder().append("Incorrect multiple SORT_AS parameters detected: ");
            String string2 = Arrays.toString(collection.toArray());
            String string3 = stringBuilder.append(string2).toString();
            int n = Log.w(LOG_TAG, string3);
        }
        String string4 = collection.iterator().next();
        int n = this.mVCardType;
        List<String> list = VCardUtils.constructListFromValue(string4, n);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string5 = iterator.next();
            StringBuilder stringBuilder2 = stringBuilder.append(string5);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void constructDisplayName() {
        if (!TextUtils.isEmpty(this.mFormattedName)) {
            String string2;
            this.mDisplayName = string2 = this.mFormattedName;
        } else if (!TextUtils.isEmpty(this.mFamilyName) || !TextUtils.isEmpty(this.mGivenName)) {
            String string3;
            int n = this.mVCardType;
            String string4 = this.mFamilyName;
            String string5 = this.mMiddleName;
            String string6 = this.mGivenName;
            String string7 = this.mPrefix;
            String string8 = this.mSuffix;
            this.mDisplayName = string3 = VCardUtils.constructNameFromElements(n, string4, string5, string6, string7, string8);
        } else if (!TextUtils.isEmpty(this.mPhoneticFamilyName) || !TextUtils.isEmpty(this.mPhoneticGivenName)) {
            String string9;
            int n = this.mVCardType;
            String string10 = this.mPhoneticFamilyName;
            String string11 = this.mPhoneticMiddleName;
            String string12 = this.mPhoneticGivenName;
            this.mDisplayName = string9 = VCardUtils.constructNameFromElements(n, string10, string11, string12);
        } else if (this.mEmailList != null && this.mEmailList.size() > 0) {
            String string13;
            this.mDisplayName = string13 = this.mEmailList.get((int)0).data;
        } else if (this.mPhoneList != null && this.mPhoneList.size() > 0) {
            String string14;
            this.mDisplayName = string14 = this.mPhoneList.get((int)0).data;
        } else if (this.mPostalList != null && this.mPostalList.size() > 0) {
            String string15;
            PostalData postalData = this.mPostalList.get(0);
            int n = this.mVCardType;
            this.mDisplayName = string15 = postalData.getFormattedAddress(n);
        } else if (this.mOrganizationList != null && this.mOrganizationList.size() > 0) {
            String string16;
            this.mDisplayName = string16 = this.mOrganizationList.get(0).getFormattedString();
        }
        if (this.mDisplayName != null) {
            return;
        }
        this.mDisplayName = "";
    }

    private void handleAndroidCustomProperty(List<String> list) {
        if (this.mAndroidCustomPropertyList == null) {
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
            this.mAndroidCustomPropertyList = arrayList;
        }
        boolean bl = this.mAndroidCustomPropertyList.add(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleNProperty(List<String> list, Map<String, Collection<String>> map) {
        String string2;
        block9: {
            String string3;
            this.tryHandleSortAsName(map);
            if (list == null) {
                return;
            }
            int n = list.size();
            if (n < 1) {
                return;
            }
            if (n > 5) {
                n = 5;
            }
            switch (n) {
                default: {
                    break block9;
                }
                case 5: {
                    String string4;
                    this.mSuffix = string4 = list.get(4);
                }
                case 4: {
                    String string5;
                    this.mPrefix = string5 = list.get(3);
                }
                case 3: {
                    String string6;
                    this.mMiddleName = string6 = list.get(2);
                    break;
                }
                case 2: 
            }
            this.mGivenName = string3 = list.get(1);
        }
        this.mFamilyName = string2 = list.get(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOrgValue(int n, List<String> list, Map<String, Collection<String>> map, boolean bl) {
        boolean bl2;
        OrganizationData organizationData;
        String string2;
        String string3;
        String string4;
        block10: {
            StringBuilder stringBuilder;
            VCardEntry vCardEntry = this;
            Map<String, Collection<String>> map2 = map;
            string4 = vCardEntry.buildSinglePhoneticNameFromSortAsParam(map2);
            if (list == null) {
                list = sEmptyList;
            }
            int n2 = list.size();
            switch (n2) {
                default: {
                    List<String> list2 = list;
                    int n3 = 0;
                    string3 = list2.get(n3);
                    stringBuilder = new StringBuilder();
                    int n4 = 1;
                    while (n4 < n2) {
                        if (n4 > 1) {
                            StringBuilder stringBuilder2 = stringBuilder.append(' ');
                        }
                        List<String> list3 = list;
                        int n5 = n4++;
                        String string5 = list3.get(n5);
                        StringBuilder stringBuilder3 = stringBuilder;
                        String string6 = string5;
                        StringBuilder stringBuilder4 = stringBuilder3.append(string6);
                    }
                    break;
                }
                case 0: {
                    string3 = "";
                    string2 = null;
                    break block10;
                }
                case 1: {
                    List<String> list4 = list;
                    int n6 = 0;
                    string3 = list4.get(n6);
                    string2 = null;
                    break block10;
                }
            }
            string2 = stringBuilder.toString();
        }
        if (this.mOrganizationList == null) {
            VCardEntry vCardEntry = this;
            int n7 = n;
            boolean bl3 = bl;
            vCardEntry.addNewOrganization(n7, string3, string2, null, string4, bl3);
            return;
        }
        Iterator<OrganizationData> iterator = this.mOrganizationList.iterator();
        do {
            if (!iterator.hasNext()) {
                VCardEntry vCardEntry = this;
                int n8 = n;
                boolean bl4 = bl;
                vCardEntry.addNewOrganization(n8, string3, string2, null, string4, bl4);
                return;
            }
            organizationData = iterator.next();
        } while (organizationData.companyName != null || organizationData.departmentName != null);
        organizationData.companyName = string3;
        organizationData.departmentName = string2;
        organizationData.isPrimary = bl2 = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handlePhoneticNameFromSound(List<String> list) {
        String string2;
        block17: {
            String string3;
            int n;
            block14: {
                String string4;
                int n2;
                String[] stringArray;
                if (!TextUtils.isEmpty(this.mPhoneticFamilyName)) {
                    return;
                }
                if (!TextUtils.isEmpty(this.mPhoneticMiddleName)) {
                    return;
                }
                if (!TextUtils.isEmpty(this.mPhoneticGivenName)) {
                    return;
                }
                if (list == null) {
                    return;
                }
                n = list.size();
                if (n < 1) {
                    return;
                }
                if (n > 3) {
                    n = 3;
                }
                if (list.get(0).length() <= 0) break block14;
                boolean bl = true;
                int n3 = 1;
                while (true) {
                    block16: {
                        block15: {
                            if (n3 >= n) break block15;
                            if (list.get(n3).length() <= 0) break block16;
                            bl = false;
                        }
                        if (bl) {
                            String string5;
                            String string6;
                            String string7;
                            stringArray = list.get(0).split(" ");
                            n2 = stringArray.length;
                            if (n2 != 3) break;
                            this.mPhoneticFamilyName = string7 = stringArray[0];
                            this.mPhoneticMiddleName = string6 = stringArray[1];
                            this.mPhoneticGivenName = string5 = stringArray[2];
                            return;
                        }
                        break block14;
                    }
                    ++n3;
                }
                if (n2 == 2) {
                    String string8;
                    String string9;
                    this.mPhoneticFamilyName = string9 = stringArray[0];
                    this.mPhoneticGivenName = string8 = stringArray[1];
                    return;
                }
                this.mPhoneticFullName = string4 = list.get(0);
                return;
            }
            switch (n) {
                default: {
                    break block17;
                }
                case 3: {
                    String string10;
                    this.mPhoneticMiddleName = string10 = list.get(2);
                    break;
                }
                case 2: 
            }
            this.mPhoneticGivenName = string3 = list.get(1);
        }
        this.mPhoneticFamilyName = string2 = list.get(0);
    }

    private void handleTitleValue(String string2) {
        if (this.mOrganizationList == null) {
            VCardEntry vCardEntry = this;
            String string3 = null;
            String string4 = string2;
            String string5 = null;
            vCardEntry.addNewOrganization(1, null, string3, string4, string5, false);
            return;
        }
        for (OrganizationData organizationData : this.mOrganizationList) {
            if (organizationData.titleName != null) continue;
            organizationData.titleName = string2;
            return;
        }
        VCardEntry vCardEntry = this;
        String string6 = null;
        String string7 = string2;
        String string8 = null;
        vCardEntry.addNewOrganization(1, null, string6, string7, string8, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String listToString(List<String> list) {
        int n = list.size();
        if (n > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                int n3 = n - 1;
                if (n2 >= n3) continue;
                StringBuilder stringBuilder3 = stringBuilder.append(";");
            }
            return stringBuilder.toString();
        }
        if (n != 1) return "";
        return list.get(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean nameFieldsAreEmpty() {
        if (!TextUtils.isEmpty(this.mFamilyName)) return false;
        if (!TextUtils.isEmpty(this.mMiddleName)) return false;
        if (!TextUtils.isEmpty(this.mGivenName)) return false;
        if (!TextUtils.isEmpty(this.mPrefix)) return false;
        if (!TextUtils.isEmpty(this.mSuffix)) return false;
        if (!TextUtils.isEmpty(this.mFormattedName)) return false;
        if (!TextUtils.isEmpty(this.mPhoneticFamilyName)) return false;
        if (!TextUtils.isEmpty(this.mPhoneticMiddleName)) return false;
        if (!TextUtils.isEmpty(this.mPhoneticGivenName)) return false;
        if (!TextUtils.isEmpty(this.mPhoneticFullName)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void tryHandleSortAsName(Map<String, Collection<String>> map) {
        String string2;
        List<String> list;
        block12: {
            String string3;
            int n;
            String string4;
            int n2;
            Collection<String> collection;
            if (VCardConfig.isVersion30(this.mVCardType)) {
                if (!TextUtils.isEmpty(this.mPhoneticFamilyName)) {
                    return;
                }
                if (!TextUtils.isEmpty(this.mPhoneticMiddleName)) {
                    return;
                }
                if (!TextUtils.isEmpty(this.mPhoneticGivenName)) {
                    return;
                }
            }
            if ((collection = map.get("SORT-AS")) == null) {
                return;
            }
            if (collection.size() == 0) {
                return;
            }
            if (collection.size() > 1) {
                StringBuilder stringBuilder = new StringBuilder().append("Incorrect multiple SORT_AS parameters detected: ");
                String string5 = Arrays.toString(collection.toArray());
                String string6 = stringBuilder.append(string5).toString();
                int n3 = Log.w(LOG_TAG, string6);
            }
            if ((n2 = (list = VCardUtils.constructListFromValue(string4 = collection.iterator().next(), n = this.mVCardType)).size()) > 3) {
                n2 = 3;
            }
            switch (n2) {
                default: {
                    break block12;
                }
                case 3: {
                    String string7;
                    this.mPhoneticMiddleName = string7 = list.get(2);
                    break;
                }
                case 2: 
            }
            this.mPhoneticGivenName = string3 = list.get(1);
        }
        this.mPhoneticFamilyName = string2 = list.get(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addProperty(Property property) {
        int n;
        boolean bl;
        int n2;
        String string2;
        block53: {
            Iterator iterator;
            block54: {
                boolean bl2;
                String string3;
                byte[] byArray;
                block50: {
                    Iterator iterator2;
                    block51: {
                        boolean bl3;
                        String string4;
                        int n3;
                        block47: {
                            Iterator iterator3;
                            block48: {
                                boolean bl4;
                                String string5;
                                int n4;
                                List list;
                                block44: {
                                    Iterator iterator4;
                                    block45: {
                                        String string6;
                                        block52: {
                                            Map map;
                                            block49: {
                                                String string7;
                                                Collection collection;
                                                String string8;
                                                String string9;
                                                block46: {
                                                    block43: {
                                                        String string10;
                                                        String string11;
                                                        string6 = property.mPropertyName;
                                                        map = property.mParameterMap;
                                                        list = property.mPropertyValueList;
                                                        byArray = property.mPropertyBytes;
                                                        if (list.size() == 0) {
                                                            return;
                                                        }
                                                        VCardEntry vCardEntry = this;
                                                        List list2 = list;
                                                        string2 = vCardEntry.listToString(list2).trim();
                                                        String string12 = string6;
                                                        String string13 = "VERSION";
                                                        if (string12.equals(string13)) {
                                                            return;
                                                        }
                                                        String string14 = string6;
                                                        String string15 = "FN";
                                                        if (string14.equals(string15)) {
                                                            String string16;
                                                            this.mFormattedName = string16 = string2;
                                                            return;
                                                        }
                                                        String string17 = string6;
                                                        String string18 = "NAME";
                                                        if (string17.equals(string18) && this.mFormattedName == null) {
                                                            String string19;
                                                            this.mFormattedName = string19 = string2;
                                                            return;
                                                        }
                                                        String string20 = string6;
                                                        String string21 = "N";
                                                        if (string20.equals(string21)) {
                                                            VCardEntry vCardEntry2 = this;
                                                            List list3 = list;
                                                            Map map2 = map;
                                                            vCardEntry2.handleNProperty(list3, map2);
                                                            return;
                                                        }
                                                        String string22 = string6;
                                                        String string23 = "SORT-STRING";
                                                        if (string22.equals(string23)) {
                                                            String string24;
                                                            this.mPhoneticFullName = string24 = string2;
                                                            return;
                                                        }
                                                        String string25 = string6;
                                                        String string26 = "NICKNAME";
                                                        if (string25.equals(string26) || (string11 = string6).equals(string10 = "X-NICKNAME")) {
                                                            VCardEntry vCardEntry3 = this;
                                                            String string27 = string2;
                                                            vCardEntry3.addNickName(string27);
                                                            return;
                                                        }
                                                        String string28 = string6;
                                                        String string29 = "SOUND";
                                                        if (string28.equals(string29)) {
                                                            Collection collection2 = (Collection)map.get("TYPE");
                                                            if (collection2 == null) {
                                                                return;
                                                            }
                                                            Collection collection3 = collection2;
                                                            String string30 = "X-IRMC-N";
                                                            if (!collection3.contains(string30)) {
                                                                return;
                                                            }
                                                            int n5 = this.mVCardType;
                                                            List<String> list4 = VCardUtils.constructListFromValue(string2, n5);
                                                            VCardEntry vCardEntry4 = this;
                                                            List<String> list5 = list4;
                                                            vCardEntry4.handlePhoneticNameFromSound(list5);
                                                            return;
                                                        }
                                                        String string31 = string6;
                                                        String string32 = "ADR";
                                                        if (!string31.equals(string32)) break block43;
                                                        boolean bl5 = true;
                                                        iterator4 = list.iterator();
                                                        while (iterator4.hasNext()) {
                                                            if (((String)iterator4.next()).length() <= 0) continue;
                                                            bl5 = false;
                                                            break;
                                                        }
                                                        if (bl5) {
                                                            return;
                                                        }
                                                        n4 = -1;
                                                        string5 = "";
                                                        bl4 = false;
                                                        Collection collection4 = (Collection)map.get("TYPE");
                                                        if (collection4 == null) break block44;
                                                        iterator4 = collection4.iterator();
                                                        break block45;
                                                    }
                                                    String string33 = string6;
                                                    String string34 = "EMAIL";
                                                    if (!string33.equals(string34)) break block46;
                                                    n3 = -1;
                                                    string4 = null;
                                                    bl3 = false;
                                                    Collection collection5 = (Collection)map.get("TYPE");
                                                    if (collection5 == null) break block47;
                                                    iterator3 = collection5.iterator();
                                                    break block48;
                                                }
                                                String string35 = string6;
                                                String string36 = "ORG";
                                                if (string35.equals(string36)) {
                                                    boolean bl6 = false;
                                                    Collection collection6 = (Collection)map.get("TYPE");
                                                    if (collection6 != null) {
                                                        for (String string37 : collection6) {
                                                            String string38;
                                                            if (!string37.equals(string38 = "PREF")) continue;
                                                        }
                                                    }
                                                    VCardEntry vCardEntry = this;
                                                    int n6 = 1;
                                                    List list6 = list;
                                                    Map map3 = map;
                                                    boolean bl7 = bl6;
                                                    vCardEntry.handleOrgValue(n6, list6, map3, bl7);
                                                    return;
                                                }
                                                String string39 = string6;
                                                String string40 = "TITLE";
                                                if (string39.equals(string40)) {
                                                    VCardEntry vCardEntry = this;
                                                    String string41 = string2;
                                                    vCardEntry.handleTitleValue(string41);
                                                    return;
                                                }
                                                String string42 = string6;
                                                String string43 = "ROLE";
                                                if (string42.equals(string43)) {
                                                    return;
                                                }
                                                String string44 = string6;
                                                String string45 = "PHOTO";
                                                if (!string44.equals(string45) && !(string9 = string6).equals(string8 = "LOGO")) break block49;
                                                Collection collection7 = (Collection)map.get("VALUE");
                                                if (collection7 != null && (collection = collection7).contains(string7 = "URL")) {
                                                    return;
                                                }
                                                Collection collection8 = (Collection)map.get("TYPE");
                                                string3 = null;
                                                bl2 = false;
                                                if (collection8 == null) break block50;
                                                iterator2 = collection8.iterator();
                                                break block51;
                                            }
                                            String string46 = string6;
                                            String string47 = "TEL";
                                            if (string46.equals(string47)) {
                                                String string48;
                                                Collection collection;
                                                String string49;
                                                int n7;
                                                String string50;
                                                Collection collection9 = (Collection)map.get("TYPE");
                                                Collection collection10 = collection9;
                                                Object object = VCardUtils.getPhoneTypeFromStrings(collection10, string50 = string2);
                                                if (object instanceof Integer) {
                                                    n7 = (Integer)object;
                                                    string49 = null;
                                                } else {
                                                    n7 = 0;
                                                    string49 = object.toString();
                                                }
                                                boolean bl8 = collection9 != null && (collection = collection9).contains(string48 = "PREF");
                                                VCardEntry vCardEntry = this;
                                                int n8 = n7;
                                                String string51 = string2;
                                                String string52 = string49;
                                                boolean bl9 = bl8;
                                                vCardEntry.addPhone(n8, string51, string52, bl9);
                                                return;
                                            }
                                            String string53 = string6;
                                            String string54 = "X-SKYPE-PSTNNUMBER";
                                            if (string53.equals(string54)) {
                                                String string55;
                                                Collection collection;
                                                Collection collection11 = (Collection)map.get("TYPE");
                                                boolean bl10 = collection11 != null && (collection = collection11).contains(string55 = "PREF");
                                                VCardEntry vCardEntry = this;
                                                int n9 = 7;
                                                String string56 = string2;
                                                String string57 = null;
                                                boolean bl11 = bl10;
                                                vCardEntry.addPhone(n9, string56, string57, bl11);
                                                return;
                                            }
                                            Map<String, Integer> map4 = sImMap;
                                            String string58 = string6;
                                            if (!map4.containsKey(string58)) break block52;
                                            Map<String, Integer> map5 = sImMap;
                                            String string59 = string6;
                                            n2 = map5.get(string59);
                                            bl = false;
                                            n = -1;
                                            Collection collection = (Collection)map.get("TYPE");
                                            if (collection == null) break block53;
                                            iterator = collection.iterator();
                                            break block54;
                                        }
                                        String string60 = string6;
                                        String string61 = "NOTE";
                                        if (string60.equals(string61)) {
                                            VCardEntry vCardEntry = this;
                                            String string62 = string2;
                                            vCardEntry.addNote(string62);
                                            return;
                                        }
                                        String string63 = string6;
                                        String string64 = "URL";
                                        if (string63.equals(string64)) {
                                            if (this.mWebsiteList == null) {
                                                ArrayList<String> arrayList = new ArrayList<String>(1);
                                                this.mWebsiteList = arrayList;
                                            }
                                            boolean bl12 = this.mWebsiteList.add(string2);
                                            return;
                                        }
                                        String string65 = string6;
                                        String string66 = "BDAY";
                                        if (string65.equals(string66)) {
                                            String string67;
                                            this.mBirthday = string67 = string2;
                                            return;
                                        }
                                        String string68 = string6;
                                        String string69 = "ANNIVERSARY";
                                        if (string68.equals(string69)) {
                                            String string70;
                                            this.mAnniversary = string70 = string2;
                                            return;
                                        }
                                        String string71 = string6;
                                        String string72 = "X-PHONETIC-FIRST-NAME";
                                        if (string71.equals(string72)) {
                                            String string73;
                                            this.mPhoneticGivenName = string73 = string2;
                                            return;
                                        }
                                        String string74 = string6;
                                        String string75 = "X-PHONETIC-MIDDLE-NAME";
                                        if (string74.equals(string75)) {
                                            String string76;
                                            this.mPhoneticMiddleName = string76 = string2;
                                            return;
                                        }
                                        String string77 = string6;
                                        String string78 = "X-PHONETIC-LAST-NAME";
                                        if (string77.equals(string78)) {
                                            String string79;
                                            this.mPhoneticFamilyName = string79 = string2;
                                            return;
                                        }
                                        String string80 = string6;
                                        String string81 = "X-ANDROID-CUSTOM";
                                        if (!string80.equals(string81)) {
                                            return;
                                        }
                                        int n10 = this.mVCardType;
                                        List<String> list7 = VCardUtils.constructListFromValue(string2, n10);
                                        VCardEntry vCardEntry = this;
                                        List<String> list8 = list7;
                                        vCardEntry.handleAndroidCustomProperty(list8);
                                        return;
                                    }
                                    while (iterator4.hasNext()) {
                                        String string82;
                                        String string83;
                                        String string84;
                                        String string85;
                                        String string86;
                                        String string87;
                                        String string88;
                                        String string89 = ((String)iterator4.next()).toUpperCase();
                                        String string90 = string89;
                                        if (string90.equals(string88 = "PREF")) {
                                            bl4 = true;
                                            continue;
                                        }
                                        String string91 = string89;
                                        String string92 = "HOME";
                                        if (string91.equals(string92)) {
                                            n4 = 1;
                                            string5 = "";
                                            continue;
                                        }
                                        String string93 = string89;
                                        String string94 = "WORK";
                                        if (string93.equals(string94) || (string87 = string89).equalsIgnoreCase(string86 = "COMPANY")) {
                                            n4 = 2;
                                            string5 = "";
                                            continue;
                                        }
                                        String string95 = string89;
                                        String string96 = "PARCEL";
                                        if (string95.equals(string96) || (string85 = string89).equals(string84 = "DOM") || (string83 = string89).equals(string82 = "INTL")) continue;
                                        String string97 = string89;
                                        String string98 = "X-";
                                        if (string97.startsWith(string98) && n4 < 0) {
                                            String string99 = string89;
                                            int n11 = 2;
                                            string89 = string99.substring(n11);
                                        }
                                        n4 = 0;
                                        string5 = string89;
                                    }
                                }
                                if (n4 < 0) {
                                    n4 = 1;
                                }
                                VCardEntry vCardEntry = this;
                                int n12 = n4;
                                List list9 = list;
                                String string100 = string5;
                                boolean bl13 = bl4;
                                vCardEntry.addPostal(n12, list9, string100, bl13);
                                return;
                            }
                            while (iterator3.hasNext()) {
                                String string101;
                                String string102;
                                String string103;
                                String string104;
                                String string105;
                                String string106;
                                String string107;
                                String string108 = ((String)iterator3.next()).toUpperCase();
                                String string109 = string108;
                                if (string109.equals(string107 = "PREF") || (string106 = string108).equals(string105 = "HOME") || (string104 = string108).equals(string103 = "WORK") || (string102 = string108).equals(string101 = "CELL")) continue;
                                String string110 = string108;
                                String string111 = "X-";
                                if (string110.startsWith(string111) && n3 < 0) {
                                    String string112 = string108;
                                    int n13 = 2;
                                    string108 = string112.substring(n13);
                                }
                                String string113 = string108;
                            }
                        }
                        if (n3 < 0) {
                            // empty if block
                        }
                        VCardEntry vCardEntry = this;
                        int n14 = n3;
                        String string114 = string2;
                        String string115 = string4;
                        boolean bl14 = bl3;
                        vCardEntry.addEmail(n14, string114, string115, bl14);
                        return;
                    }
                    while (iterator2.hasNext()) {
                        String string116 = "PREF";
                        String string117 = (String)iterator2.next();
                        String string118 = string117;
                        if (string116.equals(string118) || string3 != null) continue;
                        string3 = string117;
                    }
                }
                VCardEntry vCardEntry = this;
                String string119 = string3;
                byte[] byArray2 = byArray;
                boolean bl15 = bl2;
                vCardEntry.addPhotoBytes(string119, byArray2, bl15);
                return;
            }
            while (iterator.hasNext()) {
                String string120;
                String string121;
                String string122;
                String string123;
                String string124;
                String string125 = (String)iterator.next();
                String string126 = string125;
                if (string126.equals(string124 = "PREF") || n >= 0 || (string123 = string125).equalsIgnoreCase(string122 = "HOME") || !(string121 = string125).equalsIgnoreCase(string120 = "WORK")) continue;
            }
        }
        if (n < 0) {
            // empty if block
        }
        this.addIm(n2, null, n, string2, bl);
    }

    public void consolidateFields() {
        String string2;
        this.constructDisplayName();
        if (this.mPhoneticFullName == null) {
            return;
        }
        this.mPhoneticFullName = string2 = this.mPhoneticFullName.trim();
    }

    public String getBirthday() {
        return this.mBirthday;
    }

    public String getDisplayName() {
        if (this.mDisplayName == null) {
            this.constructDisplayName();
        }
        return this.mDisplayName;
    }

    public final List<EmailData> getEmailList() {
        return this.mEmailList;
    }

    public String getFamilyName() {
        return this.mFamilyName;
    }

    public String getFullName() {
        return this.mFormattedName;
    }

    public String getGivenName() {
        return this.mGivenName;
    }

    public final List<ImData> getImList() {
        return this.mImList;
    }

    public String getMiddleName() {
        return this.mMiddleName;
    }

    public final List<String> getNickNameList() {
        return this.mNickNameList;
    }

    public final List<String> getNotes() {
        return this.mNoteList;
    }

    public final List<OrganizationData> getOrganizationList() {
        return this.mOrganizationList;
    }

    public final List<PhoneData> getPhoneList() {
        return this.mPhoneList;
    }

    public String getPhoneticFamilyName() {
        return this.mPhoneticFamilyName;
    }

    public String getPhoneticFullName() {
        return this.mPhoneticFullName;
    }

    public String getPhoneticGivenName() {
        return this.mPhoneticGivenName;
    }

    public String getPhoneticMiddleName() {
        return this.mPhoneticMiddleName;
    }

    public final List<PhotoData> getPhotoList() {
        return this.mPhotoList;
    }

    public final List<PostalData> getPostalList() {
        return this.mPostalList;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getSuffix() {
        return this.mSuffix;
    }

    public final List<String> getWebsiteList() {
        return this.mWebsiteList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIgnorable() {
        if (this.getDisplayName().length() != 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Uri pushIntoContentResolver(ContentResolver contentResolver) {
        String string2;
        ContentProviderOperation.Builder builder;
        ArrayList<ContentProviderOperation> arrayList;
        block54: {
            block53: {
                arrayList = new ArrayList<ContentProviderOperation>();
                builder = ContentProviderOperation.newInsert(ContactsContract.RawContacts.CONTENT_URI);
                string2 = null;
                if (this.mAccount == null) break block53;
                String string3 = this.mAccount.name;
                ContentProviderOperation.Builder builder2 = builder.withValue("account_name", string3);
                String string4 = this.mAccount.type;
                ContentProviderOperation.Builder builder3 = builder.withValue("account_type", string4);
                String string5 = this.mAccount.type;
                if (ACCOUNT_TYPE_GOOGLE.equals(string5)) {
                    Uri uri = ContactsContract.Groups.CONTENT_URI;
                    String[] stringArray = new String[]{"sourceid"};
                    String[] stringArray2 = new String[]{GOOGLE_MY_CONTACTS_GROUP};
                    Cursor cursor = contentResolver.query(uri, stringArray, "title=?", stringArray2, null);
                    if (cursor != null) {
                        try {
                            if (cursor.moveToFirst()) {
                                String string6;
                                string2 = string6 = cursor.getString(0);
                            }
                        }
                        catch (Throwable throwable) {
                            if (cursor == null) throw throwable;
                            cursor.close();
                            throw throwable;
                        }
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                break block54;
            }
            ContentProviderOperation.Builder builder4 = builder.withValue("account_name", null);
            ContentProviderOperation.Builder builder5 = builder.withValue("account_type", null);
        }
        ContentProviderOperation contentProviderOperation = builder.build();
        ArrayList<ContentProviderOperation> arrayList2 = arrayList;
        ContentProviderOperation contentProviderOperation2 = contentProviderOperation;
        boolean bl = arrayList2.add(contentProviderOperation2);
        if (!this.nameFieldsAreEmpty()) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            ContentProviderOperation.Builder builder6 = builder.withValueBackReference("raw_contact_id", 0);
            ContentProviderOperation.Builder builder7 = builder.withValue("mimetype", "vnd.android.cursor.item/name");
            String string7 = this.mGivenName;
            ContentProviderOperation.Builder builder8 = builder.withValue("data2", string7);
            String string8 = this.mFamilyName;
            ContentProviderOperation.Builder builder9 = builder.withValue("data3", string8);
            String string9 = this.mMiddleName;
            ContentProviderOperation.Builder builder10 = builder.withValue("data5", string9);
            String string10 = this.mPrefix;
            ContentProviderOperation.Builder builder11 = builder.withValue("data4", string10);
            String string11 = this.mSuffix;
            ContentProviderOperation.Builder builder12 = builder.withValue("data6", string11);
            if (!(TextUtils.isEmpty(this.mPhoneticGivenName) && TextUtils.isEmpty(this.mPhoneticFamilyName) && TextUtils.isEmpty(this.mPhoneticMiddleName))) {
                String string12 = this.mPhoneticGivenName;
                ContentProviderOperation.Builder builder13 = builder.withValue("data7", string12);
                String string13 = this.mPhoneticFamilyName;
                ContentProviderOperation.Builder builder14 = builder.withValue("data9", string13);
                String string14 = this.mPhoneticMiddleName;
                ContentProviderOperation.Builder builder15 = builder.withValue("data8", string14);
            } else if (!TextUtils.isEmpty(this.mPhoneticFullName)) {
                String string15 = this.mPhoneticFullName;
                ContentProviderOperation.Builder builder16 = builder.withValue("data7", string15);
            }
            String string16 = this.getDisplayName();
            ContentProviderOperation.Builder builder17 = builder.withValue("data1", string16);
            ContentProviderOperation contentProviderOperation3 = builder.build();
            ArrayList<ContentProviderOperation> arrayList3 = arrayList;
            ContentProviderOperation contentProviderOperation4 = contentProviderOperation3;
            boolean bl2 = arrayList3.add(contentProviderOperation4);
        }
        if (this.mNickNameList != null && this.mNickNameList.size() > 0) {
            for (String string17 : this.mNickNameList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                ContentProviderOperation.Builder builder18 = builder.withValueBackReference("raw_contact_id", 0);
                ContentProviderOperation.Builder builder19 = builder.withValue("mimetype", "vnd.android.cursor.item/nickname");
                Integer n = 1;
                ContentProviderOperation.Builder builder20 = builder.withValue("data2", n);
                ContentProviderOperation.Builder builder21 = builder;
                String string18 = "data1";
                String string19 = string17;
                ContentProviderOperation.Builder builder22 = builder21.withValue(string18, string19);
                ContentProviderOperation contentProviderOperation5 = builder.build();
                ArrayList<ContentProviderOperation> arrayList4 = arrayList;
                ContentProviderOperation contentProviderOperation6 = contentProviderOperation5;
                boolean bl3 = arrayList4.add(contentProviderOperation6);
            }
        }
        if (this.mPhoneList != null) {
            for (PhoneData phoneData : this.mPhoneList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                ContentProviderOperation.Builder builder23 = builder.withValueBackReference("raw_contact_id", 0);
                ContentProviderOperation.Builder builder24 = builder.withValue("mimetype", "vnd.android.cursor.item/phone_v2");
                Integer n = phoneData.type;
                ContentProviderOperation.Builder builder25 = builder.withValue("data2", n);
                if (phoneData.type == 0) {
                    String string20 = phoneData.label;
                    ContentProviderOperation.Builder builder26 = builder.withValue("data3", string20);
                }
                String string21 = phoneData.data;
                ContentProviderOperation.Builder builder27 = builder.withValue("data1", string21);
                if (phoneData.isPrimary) {
                    Integer n2 = 1;
                    ContentProviderOperation.Builder builder28 = builder.withValue("is_primary", n2);
                }
                ContentProviderOperation contentProviderOperation7 = builder.build();
                ArrayList<ContentProviderOperation> arrayList5 = arrayList;
                ContentProviderOperation contentProviderOperation8 = contentProviderOperation7;
                boolean bl4 = arrayList5.add(contentProviderOperation8);
            }
        }
        if (this.mOrganizationList != null) {
            for (OrganizationData organizationData : this.mOrganizationList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                ContentProviderOperation.Builder builder29 = builder.withValueBackReference("raw_contact_id", 0);
                ContentProviderOperation.Builder builder30 = builder.withValue("mimetype", "vnd.android.cursor.item/organization");
                Integer n = organizationData.type;
                ContentProviderOperation.Builder builder31 = builder.withValue("data2", n);
                if (organizationData.companyName != null) {
                    String string22 = organizationData.companyName;
                    ContentProviderOperation.Builder builder32 = builder.withValue("data1", string22);
                }
                if (organizationData.departmentName != null) {
                    String string23 = organizationData.departmentName;
                    ContentProviderOperation.Builder builder33 = builder.withValue("data5", string23);
                }
                if (organizationData.titleName != null) {
                    String string24 = organizationData.titleName;
                    ContentProviderOperation.Builder builder34 = builder.withValue("data4", string24);
                }
                if (organizationData.phoneticName != null) {
                    String string25 = organizationData.phoneticName;
                    ContentProviderOperation.Builder builder35 = builder.withValue("data8", string25);
                }
                if (organizationData.isPrimary) {
                    Integer n3 = 1;
                    ContentProviderOperation.Builder builder36 = builder.withValue("is_primary", n3);
                }
                ContentProviderOperation contentProviderOperation9 = builder.build();
                ArrayList<ContentProviderOperation> arrayList6 = arrayList;
                ContentProviderOperation contentProviderOperation10 = contentProviderOperation9;
                boolean bl5 = arrayList6.add(contentProviderOperation10);
            }
        }
        if (this.mEmailList != null) {
            for (EmailData emailData : this.mEmailList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                ContentProviderOperation.Builder builder37 = builder.withValueBackReference("raw_contact_id", 0);
                ContentProviderOperation.Builder builder38 = builder.withValue("mimetype", "vnd.android.cursor.item/email_v2");
                Integer n = emailData.type;
                ContentProviderOperation.Builder builder39 = builder.withValue("data2", n);
                if (emailData.type == 0) {
                    String string26 = emailData.label;
                    ContentProviderOperation.Builder builder40 = builder.withValue("data3", string26);
                }
                String string27 = emailData.data;
                ContentProviderOperation.Builder builder41 = builder.withValue("data1", string27);
                if (emailData.isPrimary) {
                    Integer n4 = 1;
                    ContentProviderOperation.Builder builder42 = builder.withValue("is_primary", n4);
                }
                ContentProviderOperation contentProviderOperation11 = builder.build();
                ArrayList<ContentProviderOperation> arrayList7 = arrayList;
                ContentProviderOperation contentProviderOperation12 = contentProviderOperation11;
                boolean bl6 = arrayList7.add(contentProviderOperation12);
            }
        }
        if (this.mPostalList != null) {
            for (PostalData postalData : this.mPostalList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                int n = this.mVCardType;
                ContentProviderOperation.Builder builder43 = builder;
                PostalData postalData2 = postalData;
                VCardUtils.insertStructuredPostalDataUsingContactsStruct(n, builder43, postalData2);
                ContentProviderOperation contentProviderOperation13 = builder.build();
                ArrayList<ContentProviderOperation> arrayList8 = arrayList;
                ContentProviderOperation contentProviderOperation14 = contentProviderOperation13;
                boolean bl7 = arrayList8.add(contentProviderOperation14);
            }
        }
        if (this.mImList != null) {
            for (ImData imData : this.mImList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                ContentProviderOperation.Builder builder44 = builder.withValueBackReference("raw_contact_id", 0);
                ContentProviderOperation.Builder builder45 = builder.withValue("mimetype", "vnd.android.cursor.item/im");
                Integer n = imData.type;
                ContentProviderOperation.Builder builder46 = builder.withValue("data2", n);
                Integer n5 = imData.protocol;
                ContentProviderOperation.Builder builder47 = builder.withValue("data5", n5);
                String string28 = imData.data;
                ContentProviderOperation.Builder builder48 = builder.withValue("data1", string28);
                if (imData.protocol == -1) {
                    String string29 = imData.customProtocol;
                    ContentProviderOperation.Builder builder49 = builder.withValue("data6", string29);
                }
                if (imData.isPrimary) {
                    Integer n6 = 1;
                    ContentProviderOperation.Builder builder50 = builder.withValue("is_primary", n6);
                }
                ContentProviderOperation contentProviderOperation15 = builder.build();
                ArrayList<ContentProviderOperation> arrayList9 = arrayList;
                ContentProviderOperation contentProviderOperation16 = contentProviderOperation15;
                boolean bl8 = arrayList9.add(contentProviderOperation16);
            }
        }
        if (this.mNoteList != null) {
            for (String string30 : this.mNoteList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                ContentProviderOperation.Builder builder51 = builder.withValueBackReference("raw_contact_id", 0);
                ContentProviderOperation.Builder builder52 = builder.withValue("mimetype", "vnd.android.cursor.item/note");
                ContentProviderOperation.Builder builder53 = builder;
                String string31 = "data1";
                String string32 = string30;
                ContentProviderOperation.Builder builder54 = builder53.withValue(string31, string32);
                ContentProviderOperation contentProviderOperation17 = builder.build();
                ArrayList<ContentProviderOperation> arrayList10 = arrayList;
                ContentProviderOperation contentProviderOperation18 = contentProviderOperation17;
                boolean bl9 = arrayList10.add(contentProviderOperation18);
            }
        }
        if (this.mPhotoList != null) {
            for (PhotoData photoData : this.mPhotoList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                ContentProviderOperation.Builder builder55 = builder.withValueBackReference("raw_contact_id", 0);
                ContentProviderOperation.Builder builder56 = builder.withValue("mimetype", "vnd.android.cursor.item/photo");
                byte[] byArray = photoData.photoBytes;
                ContentProviderOperation.Builder builder57 = builder.withValue("data15", byArray);
                if (photoData.isPrimary) {
                    Integer n = 1;
                    ContentProviderOperation.Builder builder58 = builder.withValue("is_primary", n);
                }
                ContentProviderOperation contentProviderOperation19 = builder.build();
                ArrayList<ContentProviderOperation> arrayList11 = arrayList;
                ContentProviderOperation contentProviderOperation20 = contentProviderOperation19;
                boolean bl10 = arrayList11.add(contentProviderOperation20);
            }
        }
        if (this.mWebsiteList != null) {
            for (String string33 : this.mWebsiteList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                ContentProviderOperation.Builder builder59 = builder.withValueBackReference("raw_contact_id", 0);
                ContentProviderOperation.Builder builder60 = builder.withValue("mimetype", "vnd.android.cursor.item/website");
                ContentProviderOperation.Builder builder61 = builder;
                String string34 = "data1";
                String string35 = string33;
                ContentProviderOperation.Builder builder62 = builder61.withValue(string34, string35);
                Integer n = 1;
                ContentProviderOperation.Builder builder63 = builder.withValue("data2", n);
                ContentProviderOperation contentProviderOperation21 = builder.build();
                ArrayList<ContentProviderOperation> arrayList12 = arrayList;
                ContentProviderOperation contentProviderOperation22 = contentProviderOperation21;
                boolean bl11 = arrayList12.add(contentProviderOperation22);
            }
        }
        if (!TextUtils.isEmpty(this.mBirthday)) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            ContentProviderOperation.Builder builder64 = builder.withValueBackReference("raw_contact_id", 0);
            ContentProviderOperation.Builder builder65 = builder.withValue("mimetype", "vnd.android.cursor.item/contact_event");
            String string36 = this.mBirthday;
            ContentProviderOperation.Builder builder66 = builder.withValue("data1", string36);
            Integer n = 3;
            ContentProviderOperation.Builder builder67 = builder.withValue("data2", n);
            ContentProviderOperation contentProviderOperation23 = builder.build();
            ArrayList<ContentProviderOperation> arrayList13 = arrayList;
            ContentProviderOperation contentProviderOperation24 = contentProviderOperation23;
            boolean bl12 = arrayList13.add(contentProviderOperation24);
        }
        if (!TextUtils.isEmpty(this.mAnniversary)) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            ContentProviderOperation.Builder builder68 = builder.withValueBackReference("raw_contact_id", 0);
            ContentProviderOperation.Builder builder69 = builder.withValue("mimetype", "vnd.android.cursor.item/contact_event");
            String string37 = this.mAnniversary;
            ContentProviderOperation.Builder builder70 = builder.withValue("data1", string37);
            Integer n = 1;
            ContentProviderOperation.Builder builder71 = builder.withValue("data2", n);
            ContentProviderOperation contentProviderOperation25 = builder.build();
            ArrayList<ContentProviderOperation> arrayList14 = arrayList;
            ContentProviderOperation contentProviderOperation26 = contentProviderOperation25;
            boolean bl13 = arrayList14.add(contentProviderOperation26);
        }
        if (this.mAndroidCustomPropertyList != null) {
            for (List list : this.mAndroidCustomPropertyList) {
                void var191_191;
                int n;
                int n7 = list.size();
                int n8 = n7;
                if (n8 < (n = 2) || TextUtils.isEmpty((CharSequence)list.get(0))) continue;
                int n9 = n7;
                int n10 = 16;
                if (n9 > n10) {
                    List list2 = list.subList(0, 17);
                }
                int n11 = 0;
                for (String string38 : var191_191) {
                    if (n11 == 0) {
                        String string39 = string38;
                        builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                        ContentProviderOperation.Builder builder72 = builder.withValueBackReference("raw_contact_id", 0);
                        ContentProviderOperation.Builder builder73 = builder;
                        String string40 = "mimetype";
                        String string41 = string39;
                        ContentProviderOperation.Builder builder74 = builder73.withValue(string40, string41);
                    } else if (!TextUtils.isEmpty(string38)) {
                        String string42 = "data" + n11;
                        ContentProviderOperation.Builder builder75 = builder.withValue(string42, string38);
                    }
                    ++n11;
                }
                ContentProviderOperation contentProviderOperation27 = builder.build();
                ArrayList<ContentProviderOperation> arrayList15 = arrayList;
                ContentProviderOperation contentProviderOperation28 = contentProviderOperation27;
                boolean bl14 = arrayList15.add(contentProviderOperation28);
            }
        }
        if (string2 != null) {
            ContentProviderOperation.Builder builder76 = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            ContentProviderOperation.Builder builder77 = builder76.withValueBackReference("raw_contact_id", 0);
            ContentProviderOperation.Builder builder78 = builder76.withValue("mimetype", "vnd.android.cursor.item/group_membership");
            ContentProviderOperation.Builder builder79 = builder76;
            String string43 = "group_sourceid";
            String string44 = string2;
            ContentProviderOperation.Builder builder80 = builder79.withValue(string43, string44);
            ContentProviderOperation contentProviderOperation29 = builder76.build();
            ArrayList<ContentProviderOperation> arrayList16 = arrayList;
            ContentProviderOperation contentProviderOperation30 = contentProviderOperation29;
            boolean bl15 = arrayList16.add(contentProviderOperation30);
        }
        try {
            ContentResolver contentResolver2 = contentResolver;
            String string45 = "com.android.contacts";
            ArrayList<ContentProviderOperation> arrayList17 = arrayList;
            ContentProviderResult[] contentProviderResultArray = contentResolver2.applyBatch(string45, arrayList17);
            if (contentProviderResultArray == null) return null;
            if (contentProviderResultArray.length == 0) return null;
            if (contentProviderResultArray[0] == null) return null;
            return contentProviderResultArray[0].uri;
        }
        catch (RemoteException remoteException) {
            Object[] objectArray = new Object[2];
            String string46 = remoteException.toString();
            objectArray[0] = string46;
            String string47 = remoteException.getMessage();
            objectArray[1] = string47;
            String string48 = String.format("%s: %s", objectArray);
            int n = Log.e(LOG_TAG, string48);
            return null;
        }
        catch (OperationApplicationException operationApplicationException) {
            Object[] objectArray = new Object[2];
            String string49 = operationApplicationException.toString();
            objectArray[0] = string49;
            String string50 = operationApplicationException.getMessage();
            objectArray[1] = string50;
            String string51 = String.format("%s: %s", objectArray);
            int n = Log.e(LOG_TAG, string51);
            return null;
        }
    }

    static class Property {
        private Map<String, Collection<String>> mParameterMap;
        private byte[] mPropertyBytes;
        private String mPropertyName;
        private List<String> mPropertyValueList;

        Property() {
            HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
            this.mParameterMap = hashMap;
            ArrayList<String> arrayList = new ArrayList<String>();
            this.mPropertyValueList = arrayList;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void addParameter(String string2, String string3) {
            AbstractCollection abstractCollection;
            if (!this.mParameterMap.containsKey(string2)) {
                abstractCollection = string2.equals("TYPE") ? new HashSet<String>() : new ArrayList<String>();
                Collection<String> collection = this.mParameterMap.put(string2, abstractCollection);
            } else {
                abstractCollection = this.mParameterMap.get(string2);
            }
            boolean bl = abstractCollection.add((String)string3);
        }

        public void addToPropertyValueList(String string2) {
            boolean bl = this.mPropertyValueList.add(string2);
        }

        public void clear() {
            this.mPropertyName = null;
            this.mParameterMap.clear();
            this.mPropertyValueList.clear();
            this.mPropertyBytes = null;
        }

        public final Collection<String> getParameters(String string2) {
            return this.mParameterMap.get(string2);
        }

        public final List<String> getPropertyValueList() {
            return this.mPropertyValueList;
        }

        public void setPropertyBytes(byte[] byArray) {
            this.mPropertyBytes = byArray;
        }

        public void setPropertyName(String string2) {
            this.mPropertyName = string2;
        }
    }

    public static class PhotoData {
        public static final String FORMAT_FLASH = "SWF";
        public final String formatName;
        public final boolean isPrimary;
        public final byte[] photoBytes;
        public final int type;

        public PhotoData(int n, String string2, byte[] byArray, boolean bl) {
            this.type = n;
            this.formatName = string2;
            this.photoBytes = byArray;
            this.isPrimary = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            byte[] byArray;
            byte[] byArray2;
            if (!(object instanceof PhotoData)) {
                return false;
            }
            PhotoData photoData = (PhotoData)object;
            int n = this.type;
            int n2 = photoData.type;
            if (n == n2) return false;
            if (this.formatName == null) {
                if (photoData.formatName != null) return false;
            } else {
                String string2 = this.formatName;
                String string3 = photoData.formatName;
                if (!string2.equals(string3)) return false;
            }
            if (!Arrays.equals(byArray2 = this.photoBytes, byArray = photoData.photoBytes)) return false;
            boolean bl = this.isPrimary;
            boolean bl2 = photoData.isPrimary;
            if (bl == bl2) return false;
            return true;
        }

        public String toString() {
            Object[] objectArray = new Object[4];
            Integer n = this.type;
            objectArray[0] = n;
            String string2 = this.formatName;
            objectArray[1] = string2;
            Integer n2 = this.photoBytes.length;
            objectArray[2] = n2;
            Boolean bl = this.isPrimary;
            objectArray[3] = bl;
            return String.format("type: %d, format: %s: size: %d, isPrimary: %s", objectArray);
        }
    }

    public static class ImData {
        public final String customProtocol;
        public final String data;
        public final boolean isPrimary;
        public final int protocol;
        public final int type;

        public ImData(int n, String string2, int n2, String string3, boolean bl) {
            this.protocol = n;
            this.customProtocol = string2;
            this.type = n2;
            this.data = string3;
            this.isPrimary = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            boolean bl;
            boolean bl2;
            if (!(object instanceof ImData)) {
                return false;
            }
            ImData imData = (ImData)object;
            int n = this.type;
            int n2 = imData.type;
            if (n == n2) return false;
            int n3 = this.protocol;
            int n4 = imData.protocol;
            if (n3 == n4) return false;
            if (this.customProtocol != null) {
                String string2 = this.customProtocol;
                String string3 = imData.customProtocol;
                if (!string2.equals(string3)) return false;
            } else if (imData.customProtocol != null) return false;
            if (this.data != null) {
                String string4 = this.data;
                String string5 = imData.data;
                if (!string4.equals(string5)) return false;
            } else if (imData.data != null) return false;
            if ((bl2 = this.isPrimary) == (bl = imData.isPrimary)) return false;
            return true;
        }

        public String toString() {
            Object[] objectArray = new Object[5];
            Integer n = this.type;
            objectArray[0] = n;
            Integer n2 = this.protocol;
            objectArray[1] = n2;
            String string2 = this.customProtocol;
            objectArray[2] = string2;
            String string3 = this.data;
            objectArray[3] = string3;
            Boolean bl = this.isPrimary;
            objectArray[4] = bl;
            return String.format("type: %d, protocol: %d, custom_protcol: %s, data: %s, isPrimary: %s", objectArray);
        }
    }

    public static class OrganizationData {
        public String companyName;
        public String departmentName;
        public boolean isPrimary;
        public final String phoneticName;
        public String titleName;
        public final int type;

        public OrganizationData(int n, String string2, String string3, String string4, String string5, boolean bl) {
            this.type = n;
            this.companyName = string2;
            this.departmentName = string3;
            this.titleName = string4;
            this.phoneticName = string5;
            this.isPrimary = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof OrganizationData)) {
                return false;
            }
            OrganizationData organizationData = (OrganizationData)object;
            int n = this.type;
            int n2 = organizationData.type;
            if (n == n2) return false;
            String string2 = this.companyName;
            String string3 = organizationData.companyName;
            if (!TextUtils.equals(string2, string3)) return false;
            String string4 = this.departmentName;
            String string5 = organizationData.departmentName;
            if (!TextUtils.equals(string4, string5)) return false;
            String string6 = this.titleName;
            String string7 = organizationData.titleName;
            if (!TextUtils.equals(string6, string7)) return false;
            boolean bl = this.isPrimary;
            boolean bl2 = organizationData.isPrimary;
            if (bl == bl2) return false;
            return true;
        }

        public String getFormattedString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (!TextUtils.isEmpty(this.companyName)) {
                String string2 = this.companyName;
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
            }
            if (!TextUtils.isEmpty(this.departmentName)) {
                if (stringBuilder.length() > 0) {
                    StringBuilder stringBuilder3 = stringBuilder.append(", ");
                }
                String string3 = this.departmentName;
                StringBuilder stringBuilder4 = stringBuilder.append(string3);
            }
            if (!TextUtils.isEmpty(this.titleName)) {
                if (stringBuilder.length() > 0) {
                    StringBuilder stringBuilder5 = stringBuilder.append(", ");
                }
                String string4 = this.titleName;
                StringBuilder stringBuilder6 = stringBuilder.append(string4);
            }
            return stringBuilder.toString();
        }

        public String toString() {
            Object[] objectArray = new Object[5];
            Integer n = this.type;
            objectArray[0] = n;
            String string2 = this.companyName;
            objectArray[1] = string2;
            String string3 = this.departmentName;
            objectArray[2] = string3;
            String string4 = this.titleName;
            objectArray[3] = string4;
            Boolean bl = this.isPrimary;
            objectArray[4] = bl;
            return String.format("type: %d, company: %s, department: %s, title: %s, isPrimary: %s", objectArray);
        }
    }

    public static class PostalData {
        public static final int ADDR_MAX_DATA_SIZE = 7;
        public final String country;
        private final String[] dataArray;
        public final String extendedAddress;
        public boolean isPrimary;
        public final String label;
        public final String localty;
        public final String pobox;
        public final String postalCode;
        public final String region;
        public final String street;
        public final int type;

        /*
         * Enabled aggressive block sorting
         */
        public PostalData(int n, List<String> list, String string2, boolean bl) {
            int n2;
            block4: {
                this.type = n;
                String[] stringArray = new String[7];
                this.dataArray = stringArray;
                int n3 = list.size();
                if (n3 > 7) {
                    n3 = 7;
                }
                int n4 = 0;
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    this.dataArray[n4] = string3 = iterator.next();
                    if (++n4 < n3) continue;
                    n2 = n4;
                    break block4;
                }
                n2 = n4;
            }
            while (true) {
                if (n2 >= 7) {
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    String string9;
                    String string10;
                    this.pobox = string10 = this.dataArray[0];
                    this.extendedAddress = string9 = this.dataArray[1];
                    this.street = string8 = this.dataArray[2];
                    this.localty = string7 = this.dataArray[3];
                    this.region = string6 = this.dataArray[4];
                    this.postalCode = string5 = this.dataArray[5];
                    this.country = string4 = this.dataArray[6];
                    this.label = string2;
                    this.isPrimary = bl;
                    return;
                }
                String[] stringArray = this.dataArray;
                int n5 = n2 + 1;
                stringArray[n2] = null;
                n2 = n5;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            boolean bl2;
            if (!(object instanceof PostalData)) {
                return false;
            }
            PostalData postalData = (PostalData)object;
            Object[] objectArray = this.dataArray;
            Object[] objectArray2 = postalData.dataArray;
            if (!Arrays.equals(objectArray, objectArray2)) return false;
            int n = this.type;
            int n2 = postalData.type;
            if (n == n2) return false;
            if (this.type == 0) {
                String string2 = this.label;
                String string3 = postalData.label;
                if (string2 != string3) return false;
            }
            if ((bl2 = this.isPrimary) == (bl = postalData.isPrimary)) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String getFormattedAddress(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            if (!VCardConfig.isJapaneseDevice(n)) {
                for (int i = 0; i < 7; ++i) {
                    String string2 = this.dataArray[i];
                    if (TextUtils.isEmpty(string2)) continue;
                    StringBuilder stringBuilder2 = stringBuilder.append(string2);
                }
                return stringBuilder.toString().trim();
            }
            for (int i = 6; i >= 0; i += -1) {
                String string3 = this.dataArray[i];
                if (TextUtils.isEmpty(string3)) continue;
                if (!bl) {
                    StringBuilder stringBuilder3 = stringBuilder.append(' ');
                } else {
                    bl = false;
                }
                StringBuilder stringBuilder4 = stringBuilder.append(string3);
            }
            return stringBuilder.toString().trim();
        }

        public String toString() {
            Object[] objectArray = new Object[3];
            Integer n = this.type;
            objectArray[0] = n;
            String string2 = this.label;
            objectArray[1] = string2;
            Boolean bl = this.isPrimary;
            objectArray[2] = bl;
            return String.format("type: %d, label: %s, isPrimary: %s", objectArray);
        }
    }

    public static class EmailData {
        public final String data;
        public boolean isPrimary;
        public final String label;
        public final int type;

        public EmailData(int n, String string2, String string3, boolean bl) {
            this.type = n;
            this.data = string2;
            this.label = string3;
            this.isPrimary = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof EmailData)) {
                return false;
            }
            EmailData emailData = (EmailData)object;
            int n = this.type;
            int n2 = emailData.type;
            if (n == n2) return false;
            String string2 = this.data;
            String string3 = emailData.data;
            if (!string2.equals(string3)) return false;
            String string4 = this.label;
            String string5 = emailData.label;
            if (!string4.equals(string5)) return false;
            boolean bl = this.isPrimary;
            boolean bl2 = emailData.isPrimary;
            if (bl == bl2) return false;
            return true;
        }

        public String toString() {
            Object[] objectArray = new Object[4];
            Integer n = this.type;
            objectArray[0] = n;
            String string2 = this.data;
            objectArray[1] = string2;
            String string3 = this.label;
            objectArray[2] = string3;
            Boolean bl = this.isPrimary;
            objectArray[3] = bl;
            return String.format("type: %d, data: %s, label: %s, isPrimary: %s", objectArray);
        }
    }

    public static class PhoneData {
        public final String data;
        public boolean isPrimary;
        public final String label;
        public final int type;

        public PhoneData(int n, String string2, String string3, boolean bl) {
            this.type = n;
            this.data = string2;
            this.label = string3;
            this.isPrimary = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof PhoneData)) {
                return false;
            }
            PhoneData phoneData = (PhoneData)object;
            int n = this.type;
            int n2 = phoneData.type;
            if (n == n2) return false;
            String string2 = this.data;
            String string3 = phoneData.data;
            if (!string2.equals(string3)) return false;
            String string4 = this.label;
            String string5 = phoneData.label;
            if (!string4.equals(string5)) return false;
            boolean bl = this.isPrimary;
            boolean bl2 = phoneData.isPrimary;
            if (bl == bl2) return false;
            return true;
        }

        public String toString() {
            Object[] objectArray = new Object[4];
            Integer n = this.type;
            objectArray[0] = n;
            String string2 = this.data;
            objectArray[1] = string2;
            String string3 = this.label;
            objectArray[2] = string3;
            Boolean bl = this.isPrimary;
            objectArray[3] = bl;
            return String.format("type: %d, data: %s, label: %s, isPrimary: %s", objectArray);
        }
    }
}

