/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.accounts.Account;
import android.pim.vcard.VCardEntry;
import android.pim.vcard.VCardEntryHandler;
import android.pim.vcard.VCardInterpreter;
import android.pim.vcard.VCardUtils;
import android.text.TextUtils;
import android.util.Base64;
import android.util.CharsetUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class VCardEntryConstructor
implements VCardInterpreter {
    private static String LOG_TAG = "VCardEntryConstructor";
    private final Account mAccount;
    private VCardEntry.Property mCurrentProperty;
    private VCardEntry mCurrentVCardEntry;
    private final List<VCardEntryHandler> mEntryHandlers;
    private String mParamType;
    private final String mSourceCharset;
    private final boolean mStrictLineBreaking;
    private long mTimePushIntoContentResolver;
    private final int mVCardType;

    public VCardEntryConstructor() {
        this(-1073741824, null);
    }

    public VCardEntryConstructor(int n) {
        this(n, null, null, false);
    }

    public VCardEntryConstructor(int n, Account account) {
        this(n, account, null, false);
    }

    public VCardEntryConstructor(int n, Account account, String string2) {
        this(n, account, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardEntryConstructor(int n, Account account, String string2, boolean bl) {
        VCardEntry.Property property;
        this.mCurrentProperty = property = new VCardEntry.Property();
        ArrayList<VCardEntryHandler> arrayList = new ArrayList<VCardEntryHandler>();
        this.mEntryHandlers = arrayList;
        this.mSourceCharset = string2 != null ? string2 : "ISO-8859-1";
        this.mStrictLineBreaking = bl;
        this.mVCardType = n;
        this.mAccount = account;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String handleOneValue(String string2, String string3, String string4, String string5) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        if (string5 == null) return VCardUtils.convertStringCharset(string2, string3, string4);
        if (string5.equals("BASE64") || string5.equals("B")) {
            VCardEntry.Property property = this.mCurrentProperty;
            byte[] byArray = Base64.decode(string2.getBytes(), 0);
            property.setPropertyBytes(byArray);
            return string2;
        }
        if (string5.equals("QUOTED-PRINTABLE")) {
            boolean bl = this.mStrictLineBreaking;
            return VCardUtils.parseQuotedPrintable(string2, bl, string3, string4);
        }
        int n = Log.w(LOG_TAG, "Unknown encoding. Fall back to default.");
        return VCardUtils.convertStringCharset(string2, string3, string4);
    }

    public void addEntryHandler(VCardEntryHandler vCardEntryHandler) {
        boolean bl = this.mEntryHandlers.add(vCardEntryHandler);
    }

    public void clear() {
        VCardEntry.Property property;
        this.mCurrentVCardEntry = null;
        this.mCurrentProperty = property = new VCardEntry.Property();
    }

    @Override
    public void end() {
        Iterator<VCardEntryHandler> iterator = this.mEntryHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onEnd();
        }
        return;
    }

    @Override
    public void endEntry() {
        this.mCurrentVCardEntry.consolidateFields();
        for (VCardEntryHandler vCardEntryHandler : this.mEntryHandlers) {
            VCardEntry vCardEntry = this.mCurrentVCardEntry;
            vCardEntryHandler.onEntryCreated(vCardEntry);
        }
        this.mCurrentVCardEntry = null;
    }

    @Override
    public void endProperty() {
        VCardEntry vCardEntry = this.mCurrentVCardEntry;
        VCardEntry.Property property = this.mCurrentProperty;
        vCardEntry.addProperty(property);
    }

    @Override
    public void propertyGroup(String string2) {
    }

    @Override
    public void propertyName(String string2) {
        this.mCurrentProperty.setPropertyName(string2);
    }

    @Override
    public void propertyParamType(String string2) {
        if (this.mParamType != null) {
            int n = Log.e(LOG_TAG, "propertyParamType() is called more than once before propertyParamValue() is called");
        }
        this.mParamType = string2;
    }

    @Override
    public void propertyParamValue(String string2) {
        if (this.mParamType == null) {
            this.mParamType = "TYPE";
        }
        String[] stringArray = new String[]{string2};
        if (!VCardUtils.containsOnlyAlphaDigitHyphen(stringArray)) {
            String string3 = this.mSourceCharset;
            string2 = VCardUtils.convertStringCharset(string2, string3, "UTF-8");
        }
        VCardEntry.Property property = this.mCurrentProperty;
        String string4 = this.mParamType;
        property.addParameter(string4, string2);
        this.mParamType = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void propertyValues(List<String> list) {
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        Collection<String> collection = this.mCurrentProperty.getParameters("CHARSET");
        Collection<String> collection2 = this.mCurrentProperty.getParameters("ENCODING");
        String string2 = collection2 != null ? collection2.iterator().next() : null;
        String string3 = collection != null ? collection.iterator().next() : null;
        String string4 = CharsetUtils.nameForDefaultVendor(string3);
        if (TextUtils.isEmpty(string4)) {
            string4 = "UTF-8";
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string5 = iterator.next();
            VCardEntry.Property property = this.mCurrentProperty;
            String string6 = this.mSourceCharset;
            String string7 = this.handleOneValue(string5, string6, string4, string2);
            property.addToPropertyValueList(string7);
        }
        return;
    }

    public void showPerformanceInfo() {
        String string2 = LOG_TAG;
        StringBuilder stringBuilder = new StringBuilder().append("time for insert ContactStruct to database: ");
        long l = this.mTimePushIntoContentResolver;
        String string3 = stringBuilder.append(l).append(" ms").toString();
        int n = Log.d(string2, string3);
    }

    @Override
    public void start() {
        Iterator<VCardEntryHandler> iterator = this.mEntryHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
        return;
    }

    @Override
    public void startEntry() {
        VCardEntry vCardEntry;
        if (this.mCurrentVCardEntry != null) {
            int n = Log.e(LOG_TAG, "Nested VCard code is not supported now.");
        }
        int n = this.mVCardType;
        Account account = this.mAccount;
        this.mCurrentVCardEntry = vCardEntry = new VCardEntry(n, account);
    }

    @Override
    public void startProperty() {
        this.mCurrentProperty.clear();
    }
}

