/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardInterpreter;
import android.pim.vcard.VCardParser_V21;
import android.pim.vcard.VCardUtils;
import android.pim.vcard.exception.VCardAgentNotSupportedException;
import android.pim.vcard.exception.VCardException;
import android.pim.vcard.exception.VCardInvalidCommentLineException;
import android.pim.vcard.exception.VCardInvalidLineException;
import android.pim.vcard.exception.VCardNestedException;
import android.pim.vcard.exception.VCardVersionException;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class VCardParserImpl_V21 {
    private static final String DEFAULT_ENCODING = "8BIT";
    private static final String LOG_TAG = "VCardParserImpl_V21";
    private static final int STATE_GROUP_OR_PROPERTY_NAME = 0;
    private static final int STATE_PARAMS = 1;
    private static final int STATE_PARAMS_IN_DQUOTE = 2;
    protected boolean mCanceled;
    protected String mCurrentEncoding;
    protected final String mIntermediateCharset;
    protected VCardInterpreter mInterpreter;
    private int mNestCount;
    private String mPreviousLine;
    protected CustomBufferedReader mReader;
    private long mTimeEndProperty;
    private long mTimeHandleBase64;
    private long mTimeHandleMiscPropertyValue;
    private long mTimeHandleQuotedPrintable;
    private long mTimeParseAdrOrgN;
    private long mTimeParseItems;
    private long mTimeParseLineAndHandleGroup;
    private long mTimeParsePropertyValues;
    private long mTimeReadEndRecord;
    private long mTimeReadStartRecord;
    private long mTimeStartProperty;
    private long mTimeTotal;
    protected final Set<String> mUnknownTypeSet;
    protected final Set<String> mUnknownValueSet;

    public VCardParserImpl_V21() {
        int n = VCardConfig.VCARD_TYPE_DEFAULT;
        this(n);
    }

    public VCardParserImpl_V21(int n) {
        HashSet<String> hashSet = new HashSet<String>();
        this.mUnknownTypeSet = hashSet;
        HashSet<String> hashSet2 = new HashSet<String>();
        this.mUnknownValueSet = hashSet2;
        if ((0x1000000 & n) != 0) {
            this.mNestCount = 1;
        }
        this.mIntermediateCharset = "ISO-8859-1";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getQuotedPrintable(String string2) throws IOException, VCardException {
        String string3;
        if (!string2.trim().endsWith("=")) return string2;
        int n = string2.length() - 1;
        while (string2.charAt(n) != '=') {
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n + 1;
        String string4 = string2.substring(0, n2);
        StringBuilder stringBuilder2 = stringBuilder.append(string4);
        StringBuilder stringBuilder3 = stringBuilder.append("\r\n");
        while (true) {
            if ((string3 = this.getLine()) == null) {
                throw new VCardException("File ended during parsing a Quoted-Printable String");
            }
            if (!string3.trim().endsWith("=")) break;
            n = string3.length() - 1;
            while (string3.charAt(n) != '=') {
            }
            int n3 = n + 1;
            String string5 = string3.substring(0, n3);
            StringBuilder stringBuilder4 = stringBuilder.append(string5);
            StringBuilder stringBuilder5 = stringBuilder.append("\r\n");
        }
        StringBuilder stringBuilder6 = stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAsciiLetter(char c) {
        if (c >= 'a') {
            if (c <= 'z') return true;
        }
        if (c < 'A') return false;
        if (c > 'Z') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseOneVCard(boolean bl) throws IOException, VCardException {
        long l;
        long l2;
        long l3;
        boolean bl2 = false;
        if (bl && this.mNestCount > 0) {
            int n;
            for (int i = 0; i < (n = this.mNestCount); ++i) {
                if (!this.readBeginVCard(bl2)) {
                    return false;
                }
                bl2 = true;
            }
        }
        if (!this.readBeginVCard(bl2)) {
            return false;
        }
        long l4 = System.currentTimeMillis();
        this.mInterpreter.startEntry();
        long l5 = this.mTimeReadStartRecord;
        long l6 = System.currentTimeMillis() - l4;
        this.mTimeReadStartRecord = l3 = l5 + l6;
        long l7 = System.currentTimeMillis();
        this.parseItems();
        long l8 = this.mTimeParseItems;
        long l9 = System.currentTimeMillis() - l7;
        this.mTimeParseItems = l2 = l8 + l9;
        this.readEndVCard(true, false);
        long l10 = System.currentTimeMillis();
        this.mInterpreter.endEntry();
        long l11 = this.mTimeReadEndRecord;
        long l12 = System.currentTimeMillis() - l10;
        this.mTimeReadEndRecord = l = l11 + l12;
        return true;
    }

    private void showPerformanceInfo() {
        StringBuilder stringBuilder = new StringBuilder().append("Total parsing time:  ");
        long l = this.mTimeTotal;
        String string2 = stringBuilder.append(l).append(" ms").toString();
        int n = Log.d(LOG_TAG, string2);
        StringBuilder stringBuilder2 = new StringBuilder().append("Total readLine time: ");
        long l2 = this.mReader.getTotalmillisecond();
        String string3 = stringBuilder2.append(l2).append(" ms").toString();
        int n2 = Log.d(LOG_TAG, string3);
        StringBuilder stringBuilder3 = new StringBuilder().append("Time for handling the beggining of the record: ");
        long l3 = this.mTimeReadStartRecord;
        String string4 = stringBuilder3.append(l3).append(" ms").toString();
        int n3 = Log.d(LOG_TAG, string4);
        StringBuilder stringBuilder4 = new StringBuilder().append("Time for handling the end of the record: ");
        long l4 = this.mTimeReadEndRecord;
        String string5 = stringBuilder4.append(l4).append(" ms").toString();
        int n4 = Log.d(LOG_TAG, string5);
        StringBuilder stringBuilder5 = new StringBuilder().append("Time for parsing line, and handling group: ");
        long l5 = this.mTimeParseLineAndHandleGroup;
        String string6 = stringBuilder5.append(l5).append(" ms").toString();
        int n5 = Log.d(LOG_TAG, string6);
        StringBuilder stringBuilder6 = new StringBuilder().append("Time for parsing ADR, ORG, and N fields:");
        long l6 = this.mTimeParseAdrOrgN;
        String string7 = stringBuilder6.append(l6).append(" ms").toString();
        int n6 = Log.d(LOG_TAG, string7);
        StringBuilder stringBuilder7 = new StringBuilder().append("Time for parsing property values: ");
        long l7 = this.mTimeParsePropertyValues;
        String string8 = stringBuilder7.append(l7).append(" ms").toString();
        int n7 = Log.d(LOG_TAG, string8);
        StringBuilder stringBuilder8 = new StringBuilder().append("Time for handling normal property values: ");
        long l8 = this.mTimeHandleMiscPropertyValue;
        String string9 = stringBuilder8.append(l8).append(" ms").toString();
        int n8 = Log.d(LOG_TAG, string9);
        StringBuilder stringBuilder9 = new StringBuilder().append("Time for handling Quoted-Printable: ");
        long l9 = this.mTimeHandleQuotedPrintable;
        String string10 = stringBuilder9.append(l9).append(" ms").toString();
        int n9 = Log.d(LOG_TAG, string10);
        StringBuilder stringBuilder10 = new StringBuilder().append("Time for handling Base64: ");
        long l10 = this.mTimeHandleBase64;
        String string11 = stringBuilder10.append(l10).append(" ms").toString();
        int n10 = Log.d(LOG_TAG, string11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String unescapeCharacter(char c) {
        if (c == '\\') return String.valueOf(c);
        if (c == ';') return String.valueOf(c);
        if (c == ':') return String.valueOf(c);
        if (c != ',') return null;
        return String.valueOf(c);
    }

    public final void cancel() {
        this.mCanceled = true;
    }

    protected Set<String> getAvailableEncodingSet() {
        return VCardParser_V21.sAvailableEncoding;
    }

    protected String getBase64(String string2) throws IOException, VCardException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        while (true) {
            String string3;
            if ((string3 = this.getLine()) == null) {
                throw new VCardException("File ended during parsing BASE64 binary");
            }
            if (string3.length() == 0) {
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder3 = stringBuilder.append(string3);
        }
    }

    protected String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    protected Set<String> getKnownPropertyNameSet() {
        return VCardParser_V21.sKnownPropertyNameSet;
    }

    protected Set<String> getKnownTypeSet() {
        return VCardParser_V21.sKnownTypeSet;
    }

    protected Set<String> getKnownValueSet() {
        return VCardParser_V21.sKnownValueSet;
    }

    protected String getLine() throws IOException {
        return this.mReader.readLine();
    }

    protected String getNonEmptyLine() throws IOException, VCardException {
        String string2;
        do {
            if ((string2 = this.getLine()) != null) continue;
            throw new VCardException("Reached end of buffer.");
        } while (string2.trim().length() <= 0);
        return string2;
    }

    protected int getVersion() {
        return 0;
    }

    protected String getVersionString() {
        return "2.1";
    }

    protected void handleAgent(String string2) throws VCardException {
        if (!string2.toUpperCase().contains("BEGIN:VCARD")) {
            return;
        }
        throw new VCardAgentNotSupportedException("AGENT Property is not supported now.");
    }

    protected void handleAnyParam(String string2, String string3) {
        this.mInterpreter.propertyParamType(string2);
        this.mInterpreter.propertyParamValue(string3);
    }

    protected void handleCharset(String string2) {
        this.mInterpreter.propertyParamType("CHARSET");
        this.mInterpreter.propertyParamValue(string2);
    }

    protected void handleEncoding(String string2) throws VCardException {
        if (this.getAvailableEncodingSet().contains(string2) || string2.startsWith("X-")) {
            this.mInterpreter.propertyParamType("ENCODING");
            this.mInterpreter.propertyParamValue(string2);
            this.mCurrentEncoding = string2;
            return;
        }
        String string3 = "Unknown encoding \"" + string2 + "\"";
        throw new VCardException(string3);
    }

    protected void handleLanguage(String string2) throws VCardException {
        String[] stringArray = string2.split("-");
        if (stringArray.length != 2) {
            String string3 = "Invalid Language: \"" + string2 + "\"";
            throw new VCardException(string3);
        }
        String string4 = stringArray[0];
        int n = string4.length();
        for (int i = 0; i < n; ++i) {
            char c = string4.charAt(i);
            if (this.isAsciiLetter(c)) continue;
            String string5 = "Invalid Language: \"" + string2 + "\"";
            throw new VCardException(string5);
        }
        String string6 = stringArray[1];
        int n2 = string6.length();
        for (int i = 0; i < n2; ++i) {
            char c = string6.charAt(i);
            if (this.isAsciiLetter(c)) continue;
            String string7 = "Invalid Language: \"" + string2 + "\"";
            throw new VCardException(string7);
        }
        this.mInterpreter.propertyParamType("LANGUAGE");
        this.mInterpreter.propertyParamValue(string2);
    }

    protected void handleMultiplePropertyValue(String string2, String string3) throws IOException, VCardException {
        if (this.mCurrentEncoding.equalsIgnoreCase("QUOTED-PRINTABLE")) {
            string3 = this.getQuotedPrintable(string3);
        }
        VCardInterpreter vCardInterpreter = this.mInterpreter;
        int n = this.getVersion();
        List<String> list = VCardUtils.constructListFromValue(string3, n);
        vCardInterpreter.propertyValues(list);
    }

    protected void handleParamWithoutName(String string2) throws VCardException {
        this.handleType(string2);
    }

    protected void handleParams(String string2) throws VCardException {
        String[] stringArray = string2.split("=", 2);
        if (stringArray.length == 2) {
            String string3 = stringArray[0].trim().toUpperCase();
            String string4 = stringArray[1].trim();
            if (string3.equals("TYPE")) {
                this.handleType(string4);
                return;
            }
            if (string3.equals("VALUE")) {
                this.handleValue(string4);
                return;
            }
            if (string3.equals("ENCODING")) {
                this.handleEncoding(string4);
                return;
            }
            if (string3.equals("CHARSET")) {
                this.handleCharset(string4);
                return;
            }
            if (string3.equals("LANGUAGE")) {
                this.handleLanguage(string4);
                return;
            }
            if (string3.startsWith("X-")) {
                this.handleAnyParam(string3, string4);
                return;
            }
            String string5 = "Unknown type \"" + string3 + "\"";
            throw new VCardException(string5);
        }
        String string6 = stringArray[0];
        this.handleParamWithoutName(string6);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePropertyValue(String string2, String string3) throws IOException, VCardException {
        long l;
        String string4 = this.mCurrentEncoding.toUpperCase();
        if (string4.equals("QUOTED-PRINTABLE")) {
            long l2;
            long l3 = System.currentTimeMillis();
            VCardParserImpl_V21 vCardParserImpl_V21 = this;
            String string5 = string3;
            String string6 = vCardParserImpl_V21.getQuotedPrintable(string5);
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = arrayList.add(string6);
            this.mInterpreter.propertyValues(arrayList);
            long l4 = this.mTimeHandleQuotedPrintable;
            long l5 = System.currentTimeMillis() - l3;
            this.mTimeHandleQuotedPrintable = l2 = l4 + l5;
            return;
        }
        if (string4.equals("BASE64") || string4.equals("B")) {
            long l6;
            long l7 = System.currentTimeMillis();
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                VCardParserImpl_V21 vCardParserImpl_V21 = this;
                String string7 = string3;
                String string8 = vCardParserImpl_V21.getBase64(string7);
                boolean bl = arrayList.add(string8);
                this.mInterpreter.propertyValues(arrayList);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                int n = Log.e(LOG_TAG, "OutOfMemoryError happened during parsing BASE64 data!");
                this.mInterpreter.propertyValues(null);
            }
            long l8 = this.mTimeHandleBase64;
            long l9 = System.currentTimeMillis() - l7;
            this.mTimeHandleBase64 = l6 = l8 + l9;
            return;
        }
        if (!(string4.equals("7BIT") || string4.equals(DEFAULT_ENCODING) || string4.startsWith("X-"))) {
            Object[] objectArray = new Object[2];
            String string9 = this.mCurrentEncoding;
            objectArray[0] = string9;
            String string10 = this.getVersionString();
            objectArray[1] = string10;
            String string11 = String.format("The encoding \"%s\" is unsupported by vCard %s", objectArray);
            int n = Log.w(LOG_TAG, string11);
        }
        if (this.getVersion() == 0) {
            String string12;
            String string13;
            StringBuilder stringBuilder = null;
            while (!TextUtils.isEmpty(string13 = this.peekLine()) && string13.charAt(0) == ' ' && !"END:VCARD".contains(string12 = string13.toUpperCase())) {
                String string14 = this.getLine();
                if (stringBuilder == null) {
                    StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                    String string15 = string3;
                    StringBuilder stringBuilder3 = stringBuilder2.append(string15);
                }
                String string16 = string13.substring(1);
                StringBuilder stringBuilder4 = stringBuilder.append(string16);
            }
            if (stringBuilder != null) {
                string3 = stringBuilder.toString();
            }
        }
        long l10 = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        VCardParserImpl_V21 vCardParserImpl_V21 = this;
        String string17 = string3;
        String string18 = vCardParserImpl_V21.maybeUnescapeText(string17);
        boolean bl = arrayList.add(string18);
        this.mInterpreter.propertyValues(arrayList);
        long l11 = this.mTimeHandleMiscPropertyValue;
        long l12 = System.currentTimeMillis() - l10;
        this.mTimeHandleMiscPropertyValue = l = l11 + l12;
    }

    protected void handleType(String string2) {
        String string3;
        Set<String> set = this.getKnownTypeSet();
        if (!(set.contains(string3 = string2.toUpperCase()) || string2.startsWith("X-") || this.mUnknownTypeSet.contains(string2))) {
            boolean bl = this.mUnknownTypeSet.add(string2);
            Object[] objectArray = new Object[2];
            Integer n = this.getVersion();
            objectArray[0] = n;
            objectArray[1] = string2;
            String string4 = String.format("TYPE unsupported by %s: ", objectArray);
            int n2 = Log.w(LOG_TAG, string4);
        }
        this.mInterpreter.propertyParamType("TYPE");
        this.mInterpreter.propertyParamValue(string2);
    }

    protected void handleValue(String string2) {
        String string3;
        Set<String> set = this.getKnownValueSet();
        if (!(set.contains(string3 = string2.toUpperCase()) || string2.startsWith("X-") || this.mUnknownValueSet.contains(string2))) {
            boolean bl = this.mUnknownValueSet.add(string2);
            Object[] objectArray = new Object[2];
            Integer n = this.getVersion();
            objectArray[0] = n;
            objectArray[1] = string2;
            String string4 = String.format("The value unsupported by TYPE of %s: ", objectArray);
            int n2 = Log.w(LOG_TAG, string4);
        }
        this.mInterpreter.propertyParamType("VALUE");
        this.mInterpreter.propertyParamValue(string2);
    }

    protected boolean isValidPropertyName(String string2) {
        String string3;
        Set<String> set = this.getKnownPropertyNameSet();
        if (!(set.contains(string3 = string2.toUpperCase()) || string2.startsWith("X-") || this.mUnknownTypeSet.contains(string2))) {
            boolean bl = this.mUnknownTypeSet.add(string2);
            String string4 = "Property name unsupported by vCard 2.1: " + string2;
            int n = Log.w(LOG_TAG, string4);
        }
        return true;
    }

    protected String maybeUnescapeCharacter(char c) {
        return VCardParserImpl_V21.unescapeCharacter(c);
    }

    protected String maybeUnescapeText(String string2) {
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(InputStream inputStream, VCardInterpreter vCardInterpreter) throws IOException, VCardException {
        long l;
        CustomBufferedReader customBufferedReader;
        if (inputStream == null) {
            throw new NullPointerException("InputStream must not be null.");
        }
        String string2 = this.mIntermediateCharset;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
        this.mReader = customBufferedReader = new CustomBufferedReader(inputStreamReader);
        VCardInterpreter vCardInterpreter2 = vCardInterpreter != null ? vCardInterpreter : new EmptyInterpreter();
        this.mInterpreter = vCardInterpreter2;
        long l2 = System.currentTimeMillis();
        if (this.mInterpreter != null) {
            this.mInterpreter.start();
        }
        this.parseVCardFile();
        if (this.mInterpreter != null) {
            this.mInterpreter.end();
        }
        long l3 = this.mTimeTotal;
        long l4 = System.currentTimeMillis() - l2;
        this.mTimeTotal = l = l3 + l4;
        if (!VCardConfig.showPerformanceLog()) {
            return;
        }
        this.showPerformanceInfo();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseItem() throws IOException, VCardException {
        long l;
        this.mCurrentEncoding = DEFAULT_ENCODING;
        String string2 = this.getNonEmptyLine();
        long l2 = System.currentTimeMillis();
        String[] stringArray = this.separateLineAndHandleGroup(string2);
        if (stringArray == null) {
            return true;
        }
        if (stringArray.length != 2) {
            String string3 = "Invalid line \"" + string2 + "\"";
            throw new VCardInvalidLineException(string3);
        }
        String string4 = stringArray[0].toUpperCase();
        String string5 = stringArray[1];
        long l3 = this.mTimeParseLineAndHandleGroup;
        long l4 = System.currentTimeMillis() - l2;
        this.mTimeParseLineAndHandleGroup = l = l3 + l4;
        if (string4.equals("ADR") || string4.equals("ORG") || string4.equals("N")) {
            long l5;
            long l6 = System.currentTimeMillis();
            this.handleMultiplePropertyValue(string4, string5);
            long l7 = this.mTimeParseAdrOrgN;
            long l8 = System.currentTimeMillis() - l6;
            this.mTimeParseAdrOrgN = l5 = l7 + l8;
            return false;
        }
        if (string4.equals("AGENT")) {
            this.handleAgent(string5);
            return false;
        }
        if (this.isValidPropertyName(string4)) {
            long l9;
            String string6;
            if (string4.equals("BEGIN")) {
                if (string5.equals("VCARD")) {
                    throw new VCardNestedException("This vCard has nested vCard data in it.");
                }
                String string7 = "Unknown BEGIN type: " + string5;
                throw new VCardException(string7);
            }
            if (string4.equals("VERSION") && !string5.equals(string6 = this.getVersionString())) {
                StringBuilder stringBuilder = new StringBuilder().append("Incompatible version: ").append(string5).append(" != ");
                String string8 = this.getVersionString();
                String string9 = stringBuilder.append(string8).toString();
                throw new VCardVersionException(string9);
            }
            long l10 = System.currentTimeMillis();
            this.handlePropertyValue(string4, string5);
            long l11 = this.mTimeParsePropertyValues;
            long l12 = System.currentTimeMillis() - l10;
            this.mTimeParsePropertyValues = l9 = l11 + l12;
            return false;
        }
        String string10 = "Unknown property name: \"" + string4 + "\"";
        throw new VCardException(string10);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseItems() throws IOException, VCardException {
        long l;
        long l2 = System.currentTimeMillis();
        this.mInterpreter.startProperty();
        long l3 = this.mTimeStartProperty;
        long l4 = System.currentTimeMillis() - l2;
        this.mTimeStartProperty = l = l3 + l4;
        boolean bl = this.parseItem();
        if (!bl) {
            long l5;
            long l6 = System.currentTimeMillis();
            this.mInterpreter.endProperty();
            long l7 = this.mTimeEndProperty;
            long l8 = System.currentTimeMillis() - l6;
            this.mTimeEndProperty = l5 = l7 + l8;
        }
        while (!bl) {
            long l9;
            long l10;
            long l11 = System.currentTimeMillis();
            this.mInterpreter.startProperty();
            long l12 = this.mTimeStartProperty;
            long l13 = System.currentTimeMillis() - l11;
            this.mTimeStartProperty = l10 = l12 + l13;
            try {
                boolean bl2;
                bl = bl2 = this.parseItem();
            }
            catch (VCardInvalidCommentLineException vCardInvalidCommentLineException) {
                int n = Log.e(LOG_TAG, "Invalid line which looks like some comment was found. Ignored.");
                bl = false;
            }
            if (bl) continue;
            long l14 = System.currentTimeMillis();
            this.mInterpreter.endProperty();
            long l15 = this.mTimeEndProperty;
            long l16 = System.currentTimeMillis() - l14;
            this.mTimeEndProperty = l9 = l15 + l16;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parseVCardFile() throws IOException, VCardException {
        boolean bl = true;
        while (!this.mCanceled && this.parseOneVCard(bl)) {
            bl = false;
        }
        if (this.mNestCount <= 0) {
            return;
        }
        boolean bl2 = true;
        int n = 0;
        int n2;
        while (n < (n2 = this.mNestCount)) {
            this.readEndVCard(bl2, true);
            bl2 = false;
            ++n;
        }
        return;
    }

    protected String peekLine() throws IOException {
        return this.mReader.peekLine();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean readBeginVCard(boolean bl) throws IOException, VCardException {
        String string2;
        while ((string2 = this.getLine()) != null) {
            if (string2.trim().length() <= 0) continue;
            String[] stringArray = string2.split(":", 2);
            if (stringArray.length == 2 && stringArray[0].trim().equalsIgnoreCase("BEGIN") && stringArray[1].trim().equalsIgnoreCase("VCARD")) {
                return true;
            }
            if (!bl) {
                if (this.mNestCount > 0) {
                    this.mPreviousLine = string2;
                    return false;
                }
                String string3 = "Expected String \"BEGIN:VCARD\" did not come (Instead, \"" + string2 + "\" came)";
                throw new VCardException(string3);
            }
            if (!bl) throw new VCardException("Reached where must not be reached.");
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void readEndVCard(boolean var1_1, boolean var2_2) throws IOException, VCardException {
        do {
            block5: {
                block4: {
                    if (!var1_1) break block4;
                    var3_3 = this.mPreviousLine;
lbl4:
                    // 2 sources

                    while ((var4_4 = var3_3.split(":", 2)).length == 2 && var4_4[0].trim().equalsIgnoreCase("END") && var4_4[1].trim().equalsIgnoreCase("VCARD")) {
                        return;
                    }
                    break block5;
                }
                do {
                    if ((var3_3 = this.getLine()) != null) continue;
                    throw new VCardException("Expected END:VCARD was not found.");
                } while (var3_3.trim().length() <= 0);
                ** GOTO lbl4
            }
            if (!var2_2) {
                var5_5 = new StringBuilder().append("END:VCARD != \"");
                var6_6 = this.mPreviousLine;
                var7_7 = var5_5.append(var6_6).append("\"").toString();
                throw new VCardException(var7_7);
            }
            var1_1 = false;
        } while (var2_2);
    }

    /*
     * Unable to fully structure code
     */
    protected String[] separateLineAndHandleGroup(String var1_1) throws VCardException {
        var2_2 = new String[2];
        var3_3 = var1_1.length();
        if (var3_3 > 0 && var1_1.charAt(0) == '#') {
            throw new VCardInvalidCommentLineException();
        }
        var4_4 = 0;
        var5_5 = 0;
        block5: for (var6_6 = 0; var6_6 < var3_3; ++var6_6) {
            var7_7 = var1_1.charAt(var6_6);
            switch (var4_4) lbl-1000:
            // 7 sources

            {
                default: lbl-1000:
                // 3 sources

                {
                    continue block5;
                }
                case 0: {
                    if (var7_7 != ':') ** GOTO lbl32
                    var8_8 = var1_1.substring(var5_5, var6_6);
                    if (var8_8.equalsIgnoreCase("END")) {
                        this.mPreviousLine = var1_1;
                        var9_19 = null;
lbl19:
                        // 4 sources

                        return var9_19;
                    }
                    this.mInterpreter.propertyName(var8_8);
                    var2_2[0] = var8_8;
                    var10_20 = var3_3 - 1;
                    if (var6_6 >= var10_20) ** GOTO lbl30
                    var11_21 = var6_6 + 1;
                    var2_2[1] = var12_22 = var1_1.substring(var11_21);
lbl27:
                    // 2 sources

                    while (true) {
                        var9_19 = var2_2;
                        ** GOTO lbl19
                        break;
                    }
lbl30:
                    // 1 sources

                    var2_2[1] = "";
                    ** continue;
lbl32:
                    // 1 sources

                    if (var7_7 != '.') ** GOTO lbl41
                    var13_9 = var1_1.substring(var5_5, var6_6);
                    if (var13_9.length() != 0) ** GOTO lbl39
                    var14_10 = Log.w("VCardParserImpl_V21", "Empty group found. Ignoring.");
lbl36:
                    // 2 sources

                    while (true) {
                        var15_11 = var6_6 + 1;
                        ** GOTO lbl-1000
                        break;
                    }
lbl39:
                    // 1 sources

                    this.mInterpreter.propertyGroup(var13_9);
                    ** continue;
lbl41:
                    // 1 sources

                    if (var7_7 != ';') ** GOTO lbl-1000
                    var8_8 = var1_1.substring(var5_5, var6_6);
                    if (!var8_8.equalsIgnoreCase("END")) ** GOTO lbl47
                    this.mPreviousLine = var1_1;
                    var9_19 = null;
                    ** GOTO lbl19
lbl47:
                    // 1 sources

                    this.mInterpreter.propertyName(var8_8);
                    var2_2[0] = var8_8;
                    var16_12 = var6_6 + 1;
                    var4_4 = 1;
                    ** GOTO lbl-1000
                }
                case 1: {
                    if (var7_7 != '\"') ** GOTO lbl59
                    var17_13 = this.getVersionString();
                    if ("2.1".equalsIgnoreCase(var17_13)) {
                        var18_14 = Log.w("VCardParserImpl_V21", "Double-quoted params found in vCard 2.1. Silently allow it");
                    }
                    var4_4 = 2;
                    ** GOTO lbl-1000
lbl59:
                    // 1 sources

                    if (var7_7 != ';') ** GOTO lbl64
                    var19_15 = var1_1.substring(var5_5, var6_6);
                    this.handleParams(var19_15);
                    var20_16 = var6_6 + 1;
                    ** GOTO lbl-1000
lbl64:
                    // 1 sources

                    if (var7_7 != ':') ** GOTO lbl-1000
                    var21_23 = var1_1.substring(var5_5, var6_6);
                    this.handleParams(var21_23);
                    var22_24 = var3_3 - 1;
                    if (var6_6 < var22_24) {
                        var23_25 = var6_6 + 1;
                        var2_2[1] = var24_26 = var1_1.substring(var23_25);
lbl71:
                        // 2 sources

                        while (true) {
                            var9_19 = var2_2;
                            ** continue;
                            break;
                        }
                    }
                    var2_2[1] = "";
                    ** continue;
                }
                case 2: 
            }
            if (var7_7 != '\"') ** GOTO lbl-1000
            var25_17 = this.getVersionString();
            if ("2.1".equalsIgnoreCase(var25_17)) {
                var26_18 = Log.w("VCardParserImpl_V21", "Double-quoted params found in vCard 2.1. Silently allow it");
            }
            var4_4 = 1;
            ** continue;
        }
        var27_27 = "Invalid line: \"" + var1_1 + "\"";
        throw new VCardInvalidLineException(var27_27);
    }

    protected static final class CustomBufferedReader
    extends BufferedReader {
        private String mNextLine;
        private boolean mNextLineIsValid;
        private long mTime;

        public CustomBufferedReader(Reader reader) {
            super(reader);
        }

        public long getTotalmillisecond() {
            return this.mTime;
        }

        public String peekLine() throws IOException {
            if (!this.mNextLineIsValid) {
                long l;
                long l2 = System.currentTimeMillis();
                String string2 = super.readLine();
                long l3 = System.currentTimeMillis();
                long l4 = this.mTime;
                long l5 = l3 - l2;
                this.mTime = l = l4 + l5;
                this.mNextLine = string2;
                this.mNextLineIsValid = true;
            }
            return this.mNextLine;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String readLine() throws IOException {
            long l;
            if (this.mNextLineIsValid) {
                String string2 = this.mNextLine;
                this.mNextLine = null;
                this.mNextLineIsValid = false;
                return string2;
            }
            long l2 = System.currentTimeMillis();
            String string3 = super.readLine();
            long l3 = System.currentTimeMillis();
            long l4 = this.mTime;
            long l5 = l3 - l2;
            this.mTime = l = l4 + l5;
            return string3;
        }
    }

    private static final class EmptyInterpreter
    implements VCardInterpreter {
        private EmptyInterpreter() {
        }

        @Override
        public void end() {
        }

        @Override
        public void endEntry() {
        }

        @Override
        public void endProperty() {
        }

        @Override
        public void propertyGroup(String string2) {
        }

        @Override
        public void propertyName(String string2) {
        }

        @Override
        public void propertyParamType(String string2) {
        }

        @Override
        public void propertyParamValue(String string2) {
        }

        @Override
        public void propertyValues(List<String> list) {
        }

        @Override
        public void start() {
        }

        @Override
        public void startEntry() {
        }

        @Override
        public void startProperty() {
        }
    }
}

