/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.pim.vcard.VCardInterpreter;
import android.pim.vcard.VCardParserImpl_V21;
import android.pim.vcard.VCardParser_V30;
import android.pim.vcard.exception.VCardException;
import android.util.Log;
import java.io.IOException;
import java.util.Set;

class VCardParserImpl_V30
extends VCardParserImpl_V21 {
    private static final String LOG_TAG = "VCardParserImpl_V30";
    private boolean mEmittedAgentWarning = false;
    private String mPreviousLine;

    public VCardParserImpl_V30() {
    }

    public VCardParserImpl_V30(int n) {
        super(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void splitAndPutParamValue(String string2) {
        StringBuilder stringBuilder = null;
        boolean bl = false;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '\"') {
                if (bl) {
                    VCardInterpreter vCardInterpreter = this.mInterpreter;
                    String string3 = stringBuilder.toString();
                    vCardInterpreter.propertyParamValue(string3);
                    stringBuilder = null;
                    bl = false;
                    continue;
                }
                if (stringBuilder != null) {
                    if (stringBuilder.length() > 0) {
                        int n2 = Log.w(LOG_TAG, "Unexpected Dquote inside property.");
                    } else {
                        VCardInterpreter vCardInterpreter = this.mInterpreter;
                        String string4 = stringBuilder.toString();
                        vCardInterpreter.propertyParamValue(string4);
                    }
                }
                bl = true;
                continue;
            }
            if (c == ',' && !bl) {
                if (stringBuilder == null) {
                    String string5 = "Comma is used before actual string comes. (" + string2 + ")";
                    int n3 = Log.w(LOG_TAG, string5);
                    continue;
                }
                VCardInterpreter vCardInterpreter = this.mInterpreter;
                String string6 = stringBuilder.toString();
                vCardInterpreter.propertyParamValue(string6);
                stringBuilder = null;
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            StringBuilder stringBuilder2 = stringBuilder.append(c);
        }
        if (bl) {
            int n4 = Log.d(LOG_TAG, "Dangling Dquote.");
        }
        if (stringBuilder == null) {
            return;
        }
        if (stringBuilder.length() == 0) {
            int n5 = Log.w(LOG_TAG, "Unintended behavior. We must not see empty StringBuilder at the end of parameter value parsing.");
            return;
        }
        VCardInterpreter vCardInterpreter = this.mInterpreter;
        String string7 = stringBuilder.toString();
        vCardInterpreter.propertyParamValue(string7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String unescapeCharacter(char c) {
        if (c == 'n') return "\n";
        if (c != 'N') return String.valueOf(c);
        return "\n";
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescapeText(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c = string2.charAt(n2);
            if (c == '\\' && n2 < (n3 = n - 1)) {
                char c2;
                if ((c2 = string2.charAt(++n2)) == 'n' || c2 == 'N') {
                    StringBuilder stringBuilder2 = stringBuilder.append("\n");
                } else {
                    StringBuilder stringBuilder3 = stringBuilder.append(c2);
                }
            } else {
                StringBuilder stringBuilder4 = stringBuilder.append(c);
            }
            int n4 = n2 + 1;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getBase64(String string2) throws IOException, VCardException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        while (true) {
            String string3;
            if ((string3 = this.getLine()) == null) {
                throw new VCardException("File ended during parsing BASE64 binary");
            }
            if (string3.length() == 0) {
                return stringBuilder.toString();
            }
            if (!string3.startsWith(" ") && !string3.startsWith("\t")) {
                this.mPreviousLine = string3;
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder3 = stringBuilder.append(string3);
        }
    }

    @Override
    protected Set<String> getKnownPropertyNameSet() {
        return VCardParser_V30.sKnownPropertyNameSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getLine() throws IOException {
        if (this.mPreviousLine == null) return this.mReader.readLine();
        String string2 = this.mPreviousLine;
        this.mPreviousLine = null;
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getNonEmptyLine() throws IOException, VCardException {
        String string2;
        StringBuilder stringBuilder = null;
        while (true) {
            if ((string2 = this.mReader.readLine()) == null) {
                if (stringBuilder != null) {
                    return stringBuilder.toString();
                }
                if (this.mPreviousLine == null) throw new VCardException("Reached end of buffer.");
                String string3 = this.mPreviousLine;
                this.mPreviousLine = null;
                return string3;
            }
            if (string2.length() == 0) {
                if (stringBuilder != null) {
                    return stringBuilder.toString();
                }
                if (this.mPreviousLine == null) continue;
                String string4 = this.mPreviousLine;
                this.mPreviousLine = null;
                return string4;
            }
            if (string2.charAt(0) == ' ' || string2.charAt(0) == '\t') {
                if (stringBuilder != null) {
                    String string5 = string2.substring(1);
                    StringBuilder stringBuilder2 = stringBuilder.append(string5);
                    continue;
                }
                if (this.mPreviousLine == null) throw new VCardException("Space exists at the beginning of the line");
                stringBuilder = new StringBuilder();
                String string6 = this.mPreviousLine;
                StringBuilder stringBuilder3 = stringBuilder.append(string6);
                this.mPreviousLine = null;
                String string7 = string2.substring(1);
                StringBuilder stringBuilder4 = stringBuilder.append(string7);
                continue;
            }
            if (this.mPreviousLine != null) break;
            this.mPreviousLine = string2;
            if (stringBuilder != null) return stringBuilder.toString();
        }
        String string8 = this.mPreviousLine;
        this.mPreviousLine = string2;
        return string8;
    }

    @Override
    protected int getVersion() {
        return 1;
    }

    @Override
    protected String getVersionString() {
        return "3.0";
    }

    @Override
    protected void handleAgent(String string2) {
        if (this.mEmittedAgentWarning) {
            return;
        }
        int n = Log.w(LOG_TAG, "AGENT in vCard 3.0 is not supported yet. Ignore it");
        this.mEmittedAgentWarning = true;
    }

    @Override
    protected void handleAnyParam(String string2, String string3) {
        this.mInterpreter.propertyParamType(string2);
        this.splitAndPutParamValue(string3);
    }

    @Override
    protected void handleParamWithoutName(String string2) {
        this.handleType(string2);
    }

    @Override
    protected void handleParams(String string2) throws VCardException {
        try {
            super.handleParams(string2);
            return;
        }
        catch (VCardException vCardException) {
            String[] stringArray = string2.split("=", 2);
            if (stringArray.length == 2) {
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                this.handleAnyParam(string3, string4);
                return;
            }
            String string5 = "Unknown params value: " + string2;
            throw new VCardException(string5);
        }
    }

    @Override
    protected void handleType(String string2) {
        this.mInterpreter.propertyParamType("TYPE");
        this.splitAndPutParamValue(string2);
    }

    @Override
    protected String maybeUnescapeCharacter(char c) {
        return VCardParserImpl_V30.unescapeCharacter(c);
    }

    @Override
    protected String maybeUnescapeText(String string2) {
        return VCardParserImpl_V30.unescapeText(string2);
    }

    @Override
    protected boolean readBeginVCard(boolean bl) throws IOException, VCardException {
        return super.readBeginVCard(bl);
    }

    @Override
    protected void readEndVCard(boolean bl, boolean bl2) throws IOException, VCardException {
        super.readEndVCard(bl, bl2);
    }
}

