/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.pim.vcard.VCardInterpreter;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VCardSourceDetector
implements VCardInterpreter {
    private static Set<String> APPLE_SIGNS;
    private static Set<String> FOMA_SIGNS;
    private static Set<String> JAPANESE_MOBILE_PHONE_SIGNS;
    private static final String LOG_TAG = "VCardSourceDetector";
    private static final int PARSE_TYPE_APPLE = 1;
    private static final int PARSE_TYPE_DOCOMO_TORELATE_NEST = 3;
    private static final int PARSE_TYPE_MOBILE_PHONE_JP = 2;
    public static final int PARSE_TYPE_UNKNOWN = 0;
    private static final int PARSE_TYPE_WINDOWS_MOBILE_V65_JP = 4;
    private static String TYPE_FOMA_CHARSET_SIGN;
    private static Set<String> WINDOWS_MOBILE_PHONE_SIGNS;
    private boolean mNeedToParseCharset;
    private boolean mNeedToParseVersion = false;
    private int mParseType = 0;
    private String mSpecifiedCharset;
    private int mVersion = -1;

    static {
        String[] stringArray = new String[]{"X-PHONETIC-FIRST-NAME", "X-PHONETIC-MIDDLE-NAME", "X-PHONETIC-LAST-NAME", "X-ABADR", "X-ABUID"};
        List<String> list = Arrays.asList(stringArray);
        APPLE_SIGNS = new HashSet<String>(list);
        String[] stringArray2 = new String[]{"X-GNO", "X-GN", "X-REDUCTION"};
        List<String> list2 = Arrays.asList(stringArray2);
        JAPANESE_MOBILE_PHONE_SIGNS = new HashSet<String>(list2);
        String[] stringArray3 = new String[]{"X-MICROSOFT-ASST_TEL", "X-MICROSOFT-ASSISTANT", "X-MICROSOFT-OFFICELOC"};
        List<String> list3 = Arrays.asList(stringArray3);
        WINDOWS_MOBILE_PHONE_SIGNS = new HashSet<String>(list3);
        String[] stringArray4 = new String[]{"X-SD-VERN", "X-SD-FORMAT_VER", "X-SD-CATEGORIES", "X-SD-CLASS", "X-SD-DCREATED", "X-SD-DESCRIPTION"};
        List<String> list4 = Arrays.asList(stringArray4);
        FOMA_SIGNS = new HashSet<String>(list4);
        TYPE_FOMA_CHARSET_SIGN = "X-SD-CHAR_CODE";
    }

    @Override
    public void end() {
    }

    @Override
    public void endEntry() {
    }

    @Override
    public void endProperty() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getEstimatedCharset() {
        if (TextUtils.isEmpty(this.mSpecifiedCharset)) {
            return this.mSpecifiedCharset;
        }
        switch (this.mParseType) {
            default: {
                return null;
            }
            case 2: 
            case 3: 
            case 4: {
                return "SHIFT_JIS";
            }
            case 1: 
        }
        return "UTF-8";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getEstimatedType() {
        switch (this.mParseType) {
            default: {
                if (this.mVersion != 0) break;
                return -1073741824;
            }
            case 3: {
                return 956301320;
            }
            case 2: {
                return 0x18000008;
            }
        }
        if (this.mVersion == 1) {
            return -1073741823;
        }
        if (this.mVersion != 2) return 0;
        return -1073741822;
    }

    @Override
    public void propertyGroup(String string2) {
    }

    @Override
    public void propertyName(String string2) {
        if (string2.equalsIgnoreCase("VERSION")) {
            this.mNeedToParseVersion = true;
            return;
        }
        String string3 = TYPE_FOMA_CHARSET_SIGN;
        if (string2.equalsIgnoreCase(string3)) {
            this.mParseType = 3;
            this.mNeedToParseCharset = true;
            return;
        }
        if (this.mParseType != 0) {
            return;
        }
        if (WINDOWS_MOBILE_PHONE_SIGNS.contains(string2)) {
            this.mParseType = 4;
            return;
        }
        if (FOMA_SIGNS.contains(string2)) {
            this.mParseType = 3;
            return;
        }
        if (JAPANESE_MOBILE_PHONE_SIGNS.contains(string2)) {
            this.mParseType = 2;
            return;
        }
        if (!APPLE_SIGNS.contains(string2)) {
            return;
        }
        this.mParseType = 1;
    }

    @Override
    public void propertyParamType(String string2) {
    }

    @Override
    public void propertyParamValue(String string2) {
    }

    @Override
    public void propertyValues(List<String> list) {
        String string2;
        if (this.mNeedToParseVersion && list.size() > 0) {
            String string3 = list.get(0);
            if (string3.equals("2.1")) {
                this.mVersion = 0;
                return;
            }
            if (string3.equals("3.0")) {
                this.mVersion = 1;
                return;
            }
            if (string3.equals("4.0")) {
                this.mVersion = 2;
                return;
            }
            String string4 = "Invalid version string: " + string3;
            int n = Log.w(LOG_TAG, string4);
            return;
        }
        if (!this.mNeedToParseCharset) {
            return;
        }
        if (list.size() <= 0) {
            return;
        }
        this.mSpecifiedCharset = string2 = list.get(0);
    }

    @Override
    public void start() {
    }

    @Override
    public void startEntry() {
    }

    @Override
    public void startProperty() {
        this.mNeedToParseCharset = false;
        this.mNeedToParseVersion = false;
    }
}

