/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentProviderOperation;
import android.pim.vcard.JapaneseUtils;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardEntry;
import android.pim.vcard.VCardParser;
import android.pim.vcard.VCardParserImpl_V21;
import android.pim.vcard.VCardParserImpl_V30;
import android.pim.vcard.VCardParserImpl_V40;
import android.pim.vcard.VCardParser_V21;
import android.pim.vcard.VCardParser_V30;
import android.pim.vcard.VCardParser_V40;
import android.pim.vcard.exception.VCardException;
import android.text.TextUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.QuotedPrintableCodec;

public class VCardUtils {
    private static final String LOG_TAG = "VCardUtils";
    private static final int[] sEscapeIndicatorsV30;
    private static final int[] sEscapeIndicatorsV40;
    private static final Map<Integer, String> sKnownImPropNameMap_ItoS;
    private static final Map<String, Integer> sKnownPhoneTypeMap_StoI;
    private static final Map<Integer, String> sKnownPhoneTypesMap_ItoS;
    private static final Set<String> sMobilePhoneLabelSet;
    private static final Set<String> sPhoneTypesUnknownToContactsSet;
    private static final Set<Character> sUnAcceptableAsciiInV21WordSet;

    static {
        Character c;
        Character c2;
        Character c3;
        Character c4;
        Character c5;
        Character c6;
        sKnownPhoneTypesMap_ItoS = new HashMap<Integer, String>();
        sKnownPhoneTypeMap_StoI = new HashMap<String, Integer>();
        Map<Integer, String> map = sKnownPhoneTypesMap_ItoS;
        Integer n = 9;
        String string2 = map.put(n, "CAR");
        Map<String, Integer> map2 = sKnownPhoneTypeMap_StoI;
        Integer n2 = 9;
        Integer n3 = map2.put("CAR", n2);
        Map<Integer, String> map3 = sKnownPhoneTypesMap_ItoS;
        Integer n4 = 6;
        String string3 = map3.put(n4, "PAGER");
        Map<String, Integer> map4 = sKnownPhoneTypeMap_StoI;
        Integer n5 = 6;
        Integer n6 = map4.put("PAGER", n5);
        Map<Integer, String> map5 = sKnownPhoneTypesMap_ItoS;
        Integer n7 = 11;
        String string4 = map5.put(n7, "ISDN");
        Map<String, Integer> map6 = sKnownPhoneTypeMap_StoI;
        Integer n8 = 11;
        Integer n9 = map6.put("ISDN", n8);
        Map<String, Integer> map7 = sKnownPhoneTypeMap_StoI;
        Integer n10 = 1;
        Integer n11 = map7.put("HOME", n10);
        Map<String, Integer> map8 = sKnownPhoneTypeMap_StoI;
        Integer n12 = 3;
        Integer n13 = map8.put("WORK", n12);
        Map<String, Integer> map9 = sKnownPhoneTypeMap_StoI;
        Integer n14 = 2;
        Integer n15 = map9.put("CELL", n14);
        Map<String, Integer> map10 = sKnownPhoneTypeMap_StoI;
        Integer n16 = 7;
        Integer n17 = map10.put("OTHER", n16);
        Map<String, Integer> map11 = sKnownPhoneTypeMap_StoI;
        Integer n18 = 8;
        Integer n19 = map11.put("CALLBACK", n18);
        Map<String, Integer> map12 = sKnownPhoneTypeMap_StoI;
        Integer n20 = 10;
        Integer n21 = map12.put("COMPANY-MAIN", n20);
        Map<String, Integer> map13 = sKnownPhoneTypeMap_StoI;
        Integer n22 = 14;
        Integer n23 = map13.put("RADIO", n22);
        Map<String, Integer> map14 = sKnownPhoneTypeMap_StoI;
        Integer n24 = 16;
        Integer n25 = map14.put("TTY-TDD", n24);
        Map<String, Integer> map15 = sKnownPhoneTypeMap_StoI;
        Integer n26 = 19;
        Integer n27 = map15.put("ASSISTANT", n26);
        sPhoneTypesUnknownToContactsSet = new HashSet<String>();
        boolean bl = sPhoneTypesUnknownToContactsSet.add("MODEM");
        boolean bl2 = sPhoneTypesUnknownToContactsSet.add("MSG");
        boolean bl3 = sPhoneTypesUnknownToContactsSet.add("BBS");
        boolean bl4 = sPhoneTypesUnknownToContactsSet.add("VIDEO");
        Map<Integer, String> map16 = sKnownImPropNameMap_ItoS = new HashMap<Integer, String>();
        Integer n28 = 0;
        String string5 = map16.put(n28, "X-AIM");
        Map<Integer, String> map17 = sKnownImPropNameMap_ItoS;
        Integer n29 = 1;
        String string6 = map17.put(n29, "X-MSN");
        Map<Integer, String> map18 = sKnownImPropNameMap_ItoS;
        Integer n30 = 2;
        String string7 = map18.put(n30, "X-YAHOO");
        Map<Integer, String> map19 = sKnownImPropNameMap_ItoS;
        Integer n31 = 3;
        String string8 = map19.put(n31, "X-SKYPE-USERNAME");
        Map<Integer, String> map20 = sKnownImPropNameMap_ItoS;
        Integer n32 = 5;
        String string9 = map20.put(n32, "X-GOOGLE-TALK");
        Map<Integer, String> map21 = sKnownImPropNameMap_ItoS;
        Integer n33 = 6;
        String string10 = map21.put(n33, "X-ICQ");
        Map<Integer, String> map22 = sKnownImPropNameMap_ItoS;
        Integer n34 = 7;
        String string11 = map22.put(n34, "X-JABBER");
        Map<Integer, String> map23 = sKnownImPropNameMap_ItoS;
        Integer n35 = 4;
        String string12 = map23.put(n35, "X-QQ");
        Map<Integer, String> map24 = sKnownImPropNameMap_ItoS;
        Integer n36 = 8;
        String string13 = map24.put(n36, "X-NETMEETING");
        String[] stringArray = new String[]{"MOBILE", "\u643a\u5e2f\u96fb\u8a71", "\u643a\u5e2f", "\u30b1\u30a4\u30bf\u30a4", "\uff79\uff72\uff80\uff72"};
        List<String> list = Arrays.asList(stringArray);
        sMobilePhoneLabelSet = new HashSet<String>(list);
        Character c7 = Character.valueOf('[');
        Character[] characterArray = new Character[]{c7, c6 = Character.valueOf(']'), c5 = Character.valueOf('='), c4 = Character.valueOf(':'), c3 = Character.valueOf('.'), c2 = Character.valueOf(','), c = Character.valueOf(' ')};
        List<Character> list2 = Arrays.asList(characterArray);
        sUnAcceptableAsciiInV21WordSet = new HashSet<Character>(list2);
        sEscapeIndicatorsV30 = new int[]{58, 59, 44, 32};
        sEscapeIndicatorsV40 = new int[]{59, 58};
    }

    private VCardUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean areAllEmpty(String ... stringArray) {
        if (stringArray == null) {
            return true;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (!TextUtils.isEmpty(stringArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<String> constructListFromValue(String string2, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string2.length();
        int n3 = 0;
        while (true) {
            int n4;
            if (n3 >= n2) {
                String string3 = stringBuilder.toString();
                boolean bl = arrayList.add(string3);
                return arrayList;
            }
            char c = string2.charAt(n3);
            if (c == '\\' && n3 < (n4 = n2 - 1)) {
                String string4;
                int n5 = n3 + 1;
                char c2 = string2.charAt(n5);
                if (VCardConfig.isVersion40(n)) {
                    string4 = VCardParserImpl_V40.unescapeCharacter(c2);
                } else if (VCardConfig.isVersion30(n)) {
                    string4 = VCardParserImpl_V30.unescapeCharacter(c2);
                } else {
                    if (!VCardConfig.isVersion21(n)) {
                        int n6 = Log.w(LOG_TAG, "Unknown vCard type");
                    }
                    string4 = VCardParserImpl_V21.unescapeCharacter(c2);
                }
                if (string4 != null) {
                    StringBuilder stringBuilder2 = stringBuilder.append(string4);
                    ++n3;
                } else {
                    StringBuilder stringBuilder3 = stringBuilder.append(c);
                }
            } else if (c == ';') {
                String string5 = stringBuilder.toString();
                boolean bl = arrayList.add(string5);
                stringBuilder = new StringBuilder();
            } else {
                StringBuilder stringBuilder4 = stringBuilder.append(c);
            }
            int n7 = n3 + 1;
        }
    }

    public static String constructNameFromElements(int n, String string2, String string3, String string4) {
        int n2 = n;
        String string5 = string2;
        String string6 = string3;
        String string7 = string4;
        String string8 = null;
        return VCardUtils.constructNameFromElements(n2, string5, string6, string7, null, string8);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String constructNameFromElements(int n, String string2, String string3, String string4, String string5, String string6) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = VCardUtils.sortNameElements(n, string2, string3, string4);
        boolean bl = true;
        if (!TextUtils.isEmpty(string5)) {
            bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append(string5);
        }
        for (String string7 : stringArray) {
            if (TextUtils.isEmpty(string7)) continue;
            if (bl) {
                bl = false;
            } else {
                StringBuilder stringBuilder3 = stringBuilder.append(' ');
            }
            StringBuilder stringBuilder4 = stringBuilder.append(string7);
        }
        if (!TextUtils.isEmpty(string6)) {
            if (!bl) {
                StringBuilder stringBuilder5 = stringBuilder.append(' ');
            }
            StringBuilder stringBuilder6 = stringBuilder.append(string6);
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean containsOnlyAlphaDigitHyphen(Collection<String> var0) {
        if (var0 == null) {
            var1_1 = true;
lbl3:
            // 3 sources

            return var1_1;
        }
        for (String var3_3 : var0) {
            if (TextUtils.isEmpty(var3_3)) continue;
            var4_4 = var3_3.length();
            var5_5 = 0;
            while (var5_5 < var4_4) {
                block4: {
                    var6_6 = var3_3.codePointAt(var5_5);
                    if (97 <= var6_6 && var6_6 < 123 || 65 <= var6_6 && var6_6 < 91 || 48 <= var6_6 && var6_6 < 58 || var6_6 == 45) break block4;
                    var1_1 = false;
                    ** GOTO lbl3
                }
                var5_5 = var3_3.offsetByCodePoints(var5_5, 1);
            }
        }
        var1_1 = true;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsOnlyAlphaDigitHyphen(String ... stringArray) {
        if (stringArray != null) return VCardUtils.containsOnlyAlphaDigitHyphen(Arrays.asList(stringArray));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean containsOnlyNonCrLfPrintableAscii(Collection<String> var0) {
        if (var0 == null) {
            var1_1 = true;
lbl3:
            // 3 sources

            return var1_1;
        }
        for (String var3_3 : var0) {
            if (TextUtils.isEmpty(var3_3)) continue;
            var4_4 = var3_3.length();
            var5_5 = 0;
            while (var5_5 < var4_4) {
                block4: {
                    var6_6 = var3_3.codePointAt(var5_5);
                    if (32 <= var6_6 && var6_6 <= 126) break block4;
                    var1_1 = false;
                    ** GOTO lbl3
                }
                var5_5 = var3_3.offsetByCodePoints(var5_5, 1);
            }
        }
        var1_1 = true;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsOnlyNonCrLfPrintableAscii(String ... stringArray) {
        if (stringArray != null) return VCardUtils.containsOnlyNonCrLfPrintableAscii(Arrays.asList(stringArray));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsOnlyPrintableAscii(Collection<String> collection) {
        String string2;
        if (collection == null) {
            return true;
        }
        Iterator<String> iterator = collection.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (TextUtils.isEmpty(string2 = iterator.next()) || TextUtils.isPrintableAsciiOnly(string2));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsOnlyPrintableAscii(String ... stringArray) {
        if (stringArray != null) return VCardUtils.containsOnlyPrintableAscii(Arrays.asList(stringArray));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean containsOnlyWhiteSpaces(Collection<String> var0) {
        if (var0 == null) {
            var1_1 = true;
lbl3:
            // 3 sources

            return var1_1;
        }
        for (String var3_3 : var0) {
            if (TextUtils.isEmpty(var3_3)) continue;
            var4_4 = var3_3.length();
            var5_5 = 0;
            while (var5_5 < var4_4) {
                block4: {
                    if (Character.isWhitespace(var3_3.codePointAt(var5_5))) break block4;
                    var1_1 = false;
                    ** GOTO lbl3
                }
                var5_5 = var3_3.offsetByCodePoints(var5_5, 1);
            }
        }
        var1_1 = true;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsOnlyWhiteSpaces(String ... stringArray) {
        if (stringArray != null) return VCardUtils.containsOnlyWhiteSpaces(Arrays.asList(stringArray));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String convertStringCharset(String string2, String string3, String string4) {
        if (string3.equalsIgnoreCase(string4)) {
            return string2;
        }
        ByteBuffer byteBuffer = Charset.forName(string3).encode(string2);
        byte[] byArray = new byte[byteBuffer.remaining()];
        ByteBuffer byteBuffer2 = byteBuffer.get(byArray);
        try {
            return new String(byArray, string4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string5 = "Failed to encode: charset=" + string4;
            int n = Log.e(LOG_TAG, string5);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final VCardParser getAppropriateParser(int n) throws VCardException {
        void var1_2;
        if (VCardConfig.isVersion21(n)) {
            VCardParser_V21 vCardParser_V21 = new VCardParser_V21();
            return var1_2;
        }
        if (VCardConfig.isVersion30(n)) {
            VCardParser_V30 vCardParser_V30 = new VCardParser_V30();
            return var1_2;
        }
        if (!VCardConfig.isVersion40(n)) throw new VCardException("Version is not specified");
        VCardParser_V40 vCardParser_V40 = new VCardParser_V40();
        return var1_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getPhoneNumberFormat(int n) {
        if (!VCardConfig.isJapaneseDevice(n)) return 1;
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object getPhoneTypeFromStrings(Collection<String> collection, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        int n = -1;
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        if (collection != null) {
            for (String string3 : collection) {
                if (string3 == null) continue;
                if ((string3 = string3.toUpperCase()).equals("PREF")) {
                    bl2 = true;
                    continue;
                }
                if (string3.equals("FAX")) {
                    bl = true;
                    continue;
                }
                if (string3.startsWith("X-") && n < 0) {
                    string3 = string3.substring(2);
                }
                if (string3.length() == 0) continue;
                Integer n2 = sKnownPhoneTypeMap_StoI.get(string3);
                if (n2 != null) {
                    int n3;
                    int n4 = n2;
                    int n5 = string2.indexOf("@");
                    if ((n4 != 6 || n5 <= 0 || n5 >= (n3 = string2.length() - 1)) && n >= 0 && n != 0) continue;
                    n = n2;
                    continue;
                }
                if (n >= 0) continue;
                n = 0;
                object = string3;
            }
        }
        if (n < 0) {
            n = bl2 ? 12 : 1;
        }
        if (bl) {
            if (n == 1) {
                n = 5;
            } else if (n == 3) {
                n = 4;
            } else if (n == 7) {
                n = 13;
            }
        }
        if (n != 0) return n;
        return object;
    }

    public static String getPhoneTypeString(Integer n) {
        return sKnownPhoneTypesMap_ItoS.get(n);
    }

    public static String getPropertyNameForIm(int n) {
        Map<Integer, String> map = sKnownImPropNameMap_ItoS;
        Integer n2 = n;
        return map.get(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String guessImageType(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length >= 3 && byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70) {
            return "GIF";
        }
        if (byArray.length >= 4 && byArray[0] == 65417 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71) {
            return "PNG";
        }
        if (byArray.length < 2) return null;
        if (byArray[0] != -1) return null;
        if (byArray[1] != 65496) return null;
        return "JPEG";
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void insertStructuredPostalDataUsingContactsStruct(int n, ContentProviderOperation.Builder builder, VCardEntry.PostalData postalData) {
        String string2;
        ContentProviderOperation.Builder builder2 = builder.withValueBackReference("raw_contact_id", 0);
        ContentProviderOperation.Builder builder3 = builder.withValue("mimetype", "vnd.android.cursor.item/postal-address_v2");
        Integer n2 = postalData.type;
        ContentProviderOperation.Builder builder4 = builder.withValue("data2", n2);
        if (postalData.type == 0) {
            String string3 = postalData.label;
            ContentProviderOperation.Builder builder5 = builder.withValue("data3", string3);
        }
        if (TextUtils.isEmpty(postalData.street)) {
            string2 = TextUtils.isEmpty(postalData.extendedAddress) ? null : postalData.extendedAddress;
        } else if (TextUtils.isEmpty(postalData.extendedAddress)) {
            string2 = postalData.street;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = postalData.street;
            StringBuilder stringBuilder2 = stringBuilder.append(string4).append(" ");
            String string5 = postalData.extendedAddress;
            string2 = stringBuilder2.append(string5).toString();
        }
        String string6 = postalData.pobox;
        ContentProviderOperation.Builder builder6 = builder.withValue("data5", string6);
        ContentProviderOperation.Builder builder7 = builder.withValue("data4", string2);
        String string7 = postalData.localty;
        ContentProviderOperation.Builder builder8 = builder.withValue("data7", string7);
        String string8 = postalData.region;
        ContentProviderOperation.Builder builder9 = builder.withValue("data8", string8);
        String string9 = postalData.postalCode;
        ContentProviderOperation.Builder builder10 = builder.withValue("data9", string9);
        String string10 = postalData.country;
        ContentProviderOperation.Builder builder11 = builder.withValue("data10", string10);
        String string11 = postalData.getFormattedAddress(n);
        ContentProviderOperation.Builder builder12 = builder.withValue("data1", string11);
        if (!postalData.isPrimary) {
            return;
        }
        Integer n3 = 1;
        ContentProviderOperation.Builder builder13 = builder.withValue("is_primary", n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMobilePhoneLabel(String string2) {
        if ("_AUTO_CELL".equals(string2)) return true;
        if (!sMobilePhoneLabelSet.contains(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isV21Word(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return true;
        }
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string2.codePointAt(n2);
            if (32 > n3) return false;
            if (n3 > 126) return false;
            Set<Character> set = sUnAcceptableAsciiInV21WordSet;
            Character c = Character.valueOf((char)n3);
            if (set.contains(c)) {
                return false;
            }
            n2 = string2.offsetByCodePoints(n2, 1);
        }
        return true;
    }

    public static boolean isValidInV21ButUnknownToContactsPhoteType(String string2) {
        return sPhoneTypesUnknownToContactsSet.contains(string2);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static String parseQuotedPrintable(String var0, boolean var1_1, String var2_2, String var3_3) {
        block21: {
            var4_4 = new StringBuilder();
            var5_5 = var0.length();
            var6_6 = null;
            block6: while (var6_6 < var5_5) {
                var7_8 = var0.charAt((int)var6_6);
                if (var7_8 == '=' && var6_6 < (var8_9 = var5_5 - 1) && ((var10_11 = var0.charAt((int)(var9_10 = var6_6 + true))) == ' ' || var10_11 == '\t')) {
                    var11_12 = var4_4.append(var10_11);
                    var12_13 = var6_6 + true;
lbl9:
                    // 2 sources

                    while (true) {
                        var6_7 = var12_13 + true;
                        continue block6;
                        break;
                    }
                }
                var13_15 = var4_4.append(var7_8);
                var12_14 = var6_6;
                ** continue;
            }
            var14_16 = var4_4.toString();
            if (var1_1) {
                var15_17 = var14_16.split("\r\n");
lbl18:
                // 2 sources

                while (true) {
                    var16_33 = new StringBuilder();
                    for (Object var6_6 : var15_17) {
                        if (var6_6.endsWith("=")) {
                            var20_37 = var6_6.length() - 1;
                            var21_38 = var6_6.substring(0, var20_37);
                        }
                        var22_39 = var16_33.append((String)var6_6);
                    }
                    break block21;
                    break;
                }
            }
            var23_18 = new StringBuilder();
            var24_19 = var14_16.length();
            var6_6 = new ArrayList<E>();
            var4_4 = false;
            block10: while (var4_4 < var24_19) {
                block23: {
                    block22: {
                        var25_20 = var14_16.charAt((int)var4_4);
                        if (var25_20 == '\n') {
                            var26_21 = var23_18.toString();
                            var27_22 = var6_6.add(var26_21);
                            var23_18 = new StringBuilder();
                            var28_23 = var4_4;
lbl38:
                            // 3 sources

                            while (true) {
                                var29_24 = var28_23 + true;
                                continue block10;
                                break;
                            }
                        }
                        if (var25_20 != '\r') break block22;
                        var30_25 = var23_18.toString();
                        var31_26 = var6_6.add(var30_25);
                        var23_18 = new StringBuilder();
                        var32_27 = var24_19 - 1;
                        if (var4_4 >= var32_27 || var14_16.charAt((int)(var33_28 = var4_4 + true)) != '\n') break block23;
                        var28_23 = var4_4 + true;
                        ** GOTO lbl38
                    }
                    var34_29 = var23_18.append(var25_20);
                }
                var28_23 = var4_4;
                ** continue;
            }
            var35_30 = var23_18.toString();
            if (var35_30.length() > 0) {
                var36_31 = var6_6.add(var35_30);
            }
            var37_32 = new String[]{};
            var15_17 = var6_6.toArray(var37_32);
            ** while (true)
        }
        var38_40 = var16_33.toString();
        if (TextUtils.isEmpty(var38_40)) {
            var39_41 = Log.w("VCardUtils", "Given raw string is empty.");
        }
        try {
            var41_43 /* !! */  = var40_42 = var38_40.getBytes(var2_2);
        }
        catch (UnsupportedEncodingException var44_46) {
            var45_47 = "Failed to decode: " + var2_2;
            var46_48 = Log.w("VCardUtils", var45_47);
            var41_43 /* !! */  = var38_40.getBytes();
            ** continue;
        }
lbl66:
        // 2 sources

        while (true) {
            var42_44 = var40_42 = QuotedPrintableCodec.decodeQuotedPrintable((byte[])var41_43 /* !! */ );
lbl69:
            // 2 sources

            while (true) {
                var43_45 /* !! */  = var41_43 /* !! */  = (byte[])new String(var42_44, var3_3);
lbl72:
                // 2 sources

                return var43_45 /* !! */ ;
                break;
            }
            break;
        }
        catch (DecoderException var47_49) {
            var48_50 = Log.e("VCardUtils", "DecoderException is thrown.");
            var42_44 = var41_43 /* !! */ ;
            ** continue;
        }
        catch (UnsupportedEncodingException var49_51) {
            var50_52 = "Failed to encode: charset=" + var3_3;
            var51_53 = Log.e("VCardUtils", var50_52);
            var43_45 /* !! */  = (byte[])new String(var42_44);
            ** continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] sortNameElements(int n, String string2, String string3, String string4) {
        String[] stringArray = new String[3];
        switch (VCardConfig.getNameOrderType(n)) {
            default: {
                stringArray[0] = string4;
                stringArray[1] = string3;
                stringArray[2] = string2;
                return stringArray;
            }
            case 8: {
                String[] stringArray2 = new String[]{string2};
                if (VCardUtils.containsOnlyPrintableAscii(stringArray2)) {
                    String[] stringArray3 = new String[]{string4};
                    if (VCardUtils.containsOnlyPrintableAscii(stringArray3)) {
                        stringArray[0] = string4;
                        stringArray[1] = string3;
                        stringArray[2] = string2;
                        return stringArray;
                    }
                }
                stringArray[0] = string2;
                stringArray[1] = string3;
                stringArray[2] = string4;
                return stringArray;
            }
            case 4: 
        }
        stringArray[0] = string3;
        stringArray[1] = string4;
        stringArray[2] = string2;
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String toHalfWidthString(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            String string3 = JapaneseUtils.tryGetHalfWidthText(c);
            if (string3 != null) {
                StringBuilder stringBuilder2 = stringBuilder.append(string3);
            } else {
                StringBuilder stringBuilder3 = stringBuilder.append(c);
            }
            n2 = string2.offsetByCodePoints(n2, 1);
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String toStringAsParamValue(String var0, int[] var1_1) {
        block9: {
            block11: {
                block10: {
                    if (TextUtils.isEmpty(var0)) {
                        var0 = "";
                    }
                    var2_2 = new StringBuilder();
                    var3_3 = var0.length();
                    var4_4 = 0;
                    var5_5 = false;
                    block0: while (var4_4 < var3_3) {
                        var6_6 = var0.codePointAt(var4_4);
                        if (var6_6 < 32) break block9;
                        if (var6_6 == 34) {
                            var7_7 = var5_5;
lbl12:
                            // 3 sources

                            while (true) {
                                var4_4 = var0.offsetByCodePoints(var4_4, 1);
                                var5_5 = var7_7;
                                continue block0;
                                break;
                            }
                        }
                        var8_8 = var2_2.appendCodePoint(var6_6);
                        for (int var12_12 : var1_1) {
                            if (var6_6 == var12_12) continue;
                            var7_7 = true;
                            ** GOTO lbl12
                        }
                        break block9;
                    }
                    var13_13 = var2_2.toString();
                    if (var13_13.isEmpty()) break block10;
                    var14_14 = new String[]{var13_13};
                    if (!VCardUtils.containsOnlyWhiteSpaces(var14_14)) break block11;
                }
                var13_13 = "";
lbl28:
                // 3 sources

                return var13_13;
            }
            if (!var5_5) ** GOTO lbl28
            var13_13 = '\"' + var13_13 + '\"';
            ** while (true)
        }
        var7_7 = var5_5;
        ** while (true)
    }

    public static String toStringAsV30ParamValue(String string2) {
        int[] nArray = sEscapeIndicatorsV30;
        return VCardUtils.toStringAsParamValue(string2, nArray);
    }

    public static String toStringAsV40ParamValue(String string2) {
        int[] nArray = sEscapeIndicatorsV40;
        return VCardUtils.toStringAsParamValue(string2, nArray);
    }
}

