/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.Checkable;
import android.widget.TextView;
import com.android.internal.R;

public class CheckBoxPreference
extends Preference {
    private AccessibilityManager mAccessibilityManager;
    private boolean mChecked;
    private boolean mDisableDependentsState;
    private boolean mSendAccessibilityEventViewClickedType;
    private CharSequence mSummaryOff;
    private CharSequence mSummaryOn;

    public CheckBoxPreference(Context context) {
        this(context, null);
    }

    public CheckBoxPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842895);
    }

    public CheckBoxPreference(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        AccessibilityManager accessibilityManager;
        boolean bl;
        int[] nArray = R.styleable.CheckBoxPreference;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        String string2 = typedArray.getString(0);
        this.mSummaryOn = string2;
        String string3 = typedArray.getString(1);
        this.mSummaryOff = string3;
        this.mDisableDependentsState = bl = typedArray.getBoolean(2, false);
        typedArray.recycle();
        this.mAccessibilityManager = accessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
    }

    public boolean getDisableDependentsState() {
        return this.mDisableDependentsState;
    }

    public CharSequence getSummaryOff() {
        return this.mSummaryOff;
    }

    public CharSequence getSummaryOn() {
        return this.mSummaryOn;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onBindView(View view) {
        int n;
        CharSequence charSequence;
        TextView textView;
        super.onBindView(view);
        View view2 = view.findViewById(0x1020001);
        if (view2 != null && view2 instanceof Checkable) {
            Checkable checkable = (Checkable)((Object)view2);
            boolean bl = this.mChecked;
            checkable.setChecked(bl);
            if (this.mSendAccessibilityEventViewClickedType && this.mAccessibilityManager.isEnabled() && view2.isEnabled()) {
                this.mSendAccessibilityEventViewClickedType = false;
                AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain(1);
                view2.sendAccessibilityEventUnchecked(accessibilityEvent);
            }
        }
        if ((textView = (TextView)view.findViewById(0x1020010)) == null) {
            return;
        }
        boolean bl = true;
        if (this.mChecked && this.mSummaryOn != null) {
            CharSequence charSequence2 = this.mSummaryOn;
            textView.setText(charSequence2);
            bl = false;
        } else if (!this.mChecked && this.mSummaryOff != null) {
            CharSequence charSequence3 = this.mSummaryOff;
            textView.setText(charSequence3);
            bl = false;
        }
        if (bl && (charSequence = this.getSummary()) != null) {
            textView.setText(charSequence);
            bl = false;
        }
        int n2 = 8;
        if (!bl) {
            n2 = 0;
        }
        if (n2 != (n = textView.getVisibility())) {
            return;
        }
        textView.setVisibility(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onClick() {
        super.onClick();
        boolean bl = !this.isChecked();
        this.mSendAccessibilityEventViewClickedType = true;
        Boolean bl2 = bl;
        if (!this.callChangeListener(bl2)) {
            return;
        }
        this.setChecked(bl);
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getBoolean(n, false);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        boolean bl = savedState.checked;
        this.setChecked(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Parcelable onSaveInstanceState() {
        boolean bl;
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.checked = bl = this.isChecked();
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        boolean bl2;
        if (bl) {
            boolean bl3 = this.mChecked;
            bl2 = this.getPersistedBoolean(bl3);
        } else {
            bl2 = (Boolean)object;
        }
        this.setChecked(bl2);
    }

    public void setChecked(boolean bl) {
        if (this.mChecked != bl) {
            return;
        }
        this.mChecked = bl;
        boolean bl2 = this.persistBoolean(bl);
        boolean bl3 = this.shouldDisableDependents();
        this.notifyDependencyChange(bl3);
        this.notifyChanged();
    }

    public void setDisableDependentsState(boolean bl) {
        this.mDisableDependentsState = bl;
    }

    public void setSummaryOff(int n) {
        String string2 = this.getContext().getString(n);
        this.setSummaryOff(string2);
    }

    public void setSummaryOff(CharSequence charSequence) {
        this.mSummaryOff = charSequence;
        if (this.isChecked()) {
            return;
        }
        this.notifyChanged();
    }

    public void setSummaryOn(int n) {
        String string2 = this.getContext().getString(n);
        this.setSummaryOn(string2);
    }

    public void setSummaryOn(CharSequence charSequence) {
        this.mSummaryOn = charSequence;
        if (!this.isChecked()) {
            return;
        }
        this.notifyChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean shouldDisableDependents() {
        boolean bl;
        if (this.mDisableDependentsState) {
            bl = this.mChecked;
        } else {
            if (!this.mChecked) {
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (super.shouldDisableDependents()) return true;
        return false;
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean checked;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            super(parcel);
            boolean bl = parcel.readInt() == 1;
            this.checked = bl;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.checked ? 1 : 0;
            parcel.writeInt(n2);
        }
    }
}

