/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.android.internal.R;

public abstract class DialogPreference
extends Preference
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener,
PreferenceManager.OnActivityDestroyListener {
    private AlertDialog.Builder mBuilder;
    private Dialog mDialog;
    private Drawable mDialogIcon;
    private int mDialogLayoutResId;
    private CharSequence mDialogMessage;
    private CharSequence mDialogTitle;
    private CharSequence mNegativeButtonText;
    private CharSequence mPositiveButtonText;
    private int mWhichButtonClicked;

    public DialogPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010091);
    }

    public DialogPreference(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        Drawable drawable2;
        int[] nArray = R.styleable.DialogPreference;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        String string2 = typedArray.getString(0);
        this.mDialogTitle = string2;
        if (this.mDialogTitle == null) {
            CharSequence charSequence;
            this.mDialogTitle = charSequence = this.getTitle();
        }
        String string3 = typedArray.getString(1);
        this.mDialogMessage = string3;
        this.mDialogIcon = drawable2 = typedArray.getDrawable(2);
        String string4 = typedArray.getString(3);
        this.mPositiveButtonText = string4;
        String string5 = typedArray.getString(4);
        this.mNegativeButtonText = string5;
        int n3 = this.mDialogLayoutResId;
        this.mDialogLayoutResId = n2 = typedArray.getResourceId(5, n3);
        typedArray.recycle();
    }

    private void requestInputMethod(Dialog dialog) {
        dialog.getWindow().setSoftInputMode(21);
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public Drawable getDialogIcon() {
        return this.mDialogIcon;
    }

    public int getDialogLayoutResource() {
        return this.mDialogLayoutResId;
    }

    public CharSequence getDialogMessage() {
        return this.mDialogMessage;
    }

    public CharSequence getDialogTitle() {
        return this.mDialogTitle;
    }

    public CharSequence getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    public CharSequence getPositiveButtonText() {
        return this.mPositiveButtonText;
    }

    protected boolean needInputMethod() {
        return false;
    }

    @Override
    public void onActivityDestroy() {
        if (this.mDialog == null) {
            return;
        }
        if (!this.mDialog.isShowing()) {
            return;
        }
        this.mDialog.dismiss();
    }

    protected void onBindDialogView(View view) {
        View view2 = view.findViewById(16908299);
        if (view2 == null) {
            return;
        }
        CharSequence charSequence = this.getDialogMessage();
        int n = 8;
        if (!TextUtils.isEmpty(charSequence)) {
            if (view2 instanceof TextView) {
                ((TextView)view2).setText(charSequence);
            }
            n = 0;
        }
        if (view2.getVisibility() != n) {
            return;
        }
        view2.setVisibility(n);
    }

    @Override
    protected void onClick() {
        this.showDialog(null);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        this.mWhichButtonClicked = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected View onCreateDialogView() {
        if (this.mDialogLayoutResId == 0) {
            return null;
        }
        LayoutInflater layoutInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        int n = this.mDialogLayoutResId;
        return layoutInflater.inflate(n, null);
    }

    protected void onDialogClosed(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        this.getPreferenceManager().unregisterOnActivityDestroyListener(this);
        this.mDialog = null;
        boolean bl = this.mWhichButtonClicked == -1;
        this.onDialogClosed(bl);
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        if (!savedState.isDialogShowing) {
            return;
        }
        Bundle bundle = savedState.dialogBundle;
        this.showDialog(bundle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.mDialog == null) return parcelable;
        if (!this.mDialog.isShowing()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.isDialogShowing = true;
        savedState.dialogBundle = bundle = this.mDialog.onSaveInstanceState();
        return savedState;
    }

    public void setDialogIcon(int n) {
        Drawable drawable2;
        this.mDialogIcon = drawable2 = this.getContext().getResources().getDrawable(n);
    }

    public void setDialogIcon(Drawable drawable2) {
        this.mDialogIcon = drawable2;
    }

    public void setDialogLayoutResource(int n) {
        this.mDialogLayoutResId = n;
    }

    public void setDialogMessage(int n) {
        String string2 = this.getContext().getString(n);
        this.setDialogMessage(string2);
    }

    public void setDialogMessage(CharSequence charSequence) {
        this.mDialogMessage = charSequence;
    }

    public void setDialogTitle(int n) {
        String string2 = this.getContext().getString(n);
        this.setDialogTitle(string2);
    }

    public void setDialogTitle(CharSequence charSequence) {
        this.mDialogTitle = charSequence;
    }

    public void setNegativeButtonText(int n) {
        String string2 = this.getContext().getString(n);
        this.setNegativeButtonText(string2);
    }

    public void setNegativeButtonText(CharSequence charSequence) {
        this.mNegativeButtonText = charSequence;
    }

    public void setPositiveButtonText(int n) {
        String string2 = this.getContext().getString(n);
        this.setPositiveButtonText(string2);
    }

    public void setPositiveButtonText(CharSequence charSequence) {
        this.mPositiveButtonText = charSequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void showDialog(Bundle bundle) {
        AlertDialog.Builder builder;
        Context context = this.getContext();
        this.mWhichButtonClicked = -1;
        AlertDialog.Builder builder2 = new AlertDialog.Builder(context);
        CharSequence charSequence = this.mDialogTitle;
        AlertDialog.Builder builder3 = builder2.setTitle(charSequence);
        Drawable drawable2 = this.mDialogIcon;
        AlertDialog.Builder builder4 = builder3.setIcon(drawable2);
        CharSequence charSequence2 = this.mPositiveButtonText;
        AlertDialog.Builder builder5 = builder4.setPositiveButton(charSequence2, (DialogInterface.OnClickListener)this);
        CharSequence charSequence3 = this.mNegativeButtonText;
        this.mBuilder = builder = builder5.setNegativeButton(charSequence3, (DialogInterface.OnClickListener)this);
        View view = this.onCreateDialogView();
        if (view != null) {
            this.onBindDialogView(view);
            AlertDialog.Builder builder6 = this.mBuilder.setView(view);
        } else {
            AlertDialog.Builder builder7 = this.mBuilder;
            CharSequence charSequence4 = this.mDialogMessage;
            AlertDialog.Builder builder8 = builder7.setMessage(charSequence4);
        }
        AlertDialog.Builder builder9 = this.mBuilder;
        this.onPrepareDialogBuilder(builder9);
        this.getPreferenceManager().registerOnActivityDestroyListener(this);
        AlertDialog alertDialog = this.mBuilder.create();
        this.mDialog = alertDialog;
        if (bundle != null) {
            alertDialog.onRestoreInstanceState(bundle);
        }
        if (this.needInputMethod()) {
            this.requestInputMethod(alertDialog);
        }
        alertDialog.setOnDismissListener(this);
        alertDialog.show();
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        Bundle dialogBundle;
        boolean isDialogShowing;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            super(parcel);
            Bundle bundle;
            boolean bl = parcel.readInt() == 1;
            this.isDialogShowing = bl;
            this.dialogBundle = bundle = parcel.readBundle();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.isDialogShowing ? 1 : 0;
            parcel.writeInt(n2);
            Bundle bundle = this.dialogBundle;
            parcel.writeBundle(bundle);
        }
    }
}

