/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.EditText;

public class EditTextPreference
extends DialogPreference {
    private EditText mEditText;
    private String mText;

    public EditTextPreference(Context context) {
        this(context, null);
    }

    public EditTextPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842898);
    }

    public EditTextPreference(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        EditText editText;
        this.mEditText = editText = new EditText(context, attributeSet);
        this.mEditText.setId(16908291);
        this.mEditText.setEnabled(true);
    }

    public EditText getEditText() {
        return this.mEditText;
    }

    public String getText() {
        return this.mText;
    }

    @Override
    protected boolean needInputMethod() {
        return true;
    }

    protected void onAddEditTextToDialogView(View view, EditText editText) {
        ViewGroup viewGroup = (ViewGroup)view.findViewById(16908803);
        if (viewGroup == null) {
            return;
        }
        viewGroup.addView((View)editText, -1, -1);
    }

    @Override
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        EditText editText = this.mEditText;
        String string2 = this.getText();
        editText.setText(string2);
        ViewParent viewParent = editText.getParent();
        if (viewParent == view) {
            return;
        }
        if (viewParent != null) {
            ((ViewGroup)viewParent).removeView(editText);
        }
        this.onAddEditTextToDialogView(view, editText);
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl) {
            return;
        }
        String string2 = this.mEditText.getText().toString();
        if (!this.callChangeListener(string2)) {
            return;
        }
        this.setText(string2);
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getString(n);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        String string2 = savedState.text;
        this.setText(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Parcelable onSaveInstanceState() {
        String string2;
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.text = string2 = this.getText();
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        String string2;
        if (bl) {
            String string3 = this.mText;
            string2 = this.getPersistedString(string3);
        } else {
            string2 = (String)object;
        }
        this.setText(string2);
    }

    public void setText(String string2) {
        boolean bl = this.shouldDisableDependents();
        this.mText = string2;
        boolean bl2 = this.persistString(string2);
        boolean bl3 = this.shouldDisableDependents();
        if (bl3 != bl) {
            return;
        }
        this.notifyDependencyChange(bl3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldDisableDependents() {
        if (TextUtils.isEmpty(this.mText)) return true;
        if (!super.shouldDisableDependents()) return false;
        return true;
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        String text;

        public SavedState(Parcel parcel) {
            super(parcel);
            String string2;
            this.text = string2 = parcel.readString();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            String string2 = this.text;
            parcel.writeString(string2);
        }
    }
}

