/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class GenericInflater<T, P extends Parent> {
    private static final Class[] mConstructorSignature;
    private static final HashMap sConstructorMap;
    private final boolean DEBUG;
    private final Object[] mConstructorArgs;
    protected final Context mContext;
    private String mDefaultPackage;
    private Factory<T> mFactory;
    private boolean mFactorySet;

    static {
        Class[] classArray = new Class[]{Context.class, AttributeSet.class};
        mConstructorSignature = classArray;
        sConstructorMap = new HashMap();
    }

    protected GenericInflater(Context context) {
        this.DEBUG = false;
        Object[] objectArray = new Object[2];
        this.mConstructorArgs = objectArray;
        this.mContext = context;
    }

    protected GenericInflater(GenericInflater<T, P> genericInflater, Context context) {
        Factory<T> factory;
        this.DEBUG = false;
        Object[] objectArray = new Object[2];
        this.mConstructorArgs = objectArray;
        this.mContext = context;
        this.mFactory = factory = genericInflater.mFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final T createItemFromTag(XmlPullParser xmlPullParser, String string2, AttributeSet attributeSet) {
        T t;
        T t2;
        try {
            if (this.mFactory == null) {
                t2 = null;
            } else {
                Factory<T> factory = this.mFactory;
                Context context = this.mContext;
                t2 = factory.onCreateItem(string2, context, attributeSet);
            }
            if (t2 != null) return t2;
            int n = string2.indexOf(46);
            if (-1 != n) {
                t2 = this.onCreateItem(string2, attributeSet);
                return t2;
            }
            t = this.createItem(string2, null, attributeSet);
        }
        catch (InflateException inflateException) {
            throw inflateException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = attributeSet.getPositionDescription();
            String string4 = stringBuilder.append(string3).append(": Error inflating class ").append(string2).toString();
            InflateException inflateException = new InflateException(string4);
            Throwable throwable = inflateException.initCause(classNotFoundException);
            throw inflateException;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            String string5 = attributeSet.getPositionDescription();
            String string6 = stringBuilder.append(string5).append(": Error inflating class ").append(string2).toString();
            InflateException inflateException = new InflateException(string6);
            Throwable throwable = inflateException.initCause(exception);
            throw inflateException;
        }
        t2 = t;
        return t2;
    }

    private void rInflate(XmlPullParser xmlPullParser, T t, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getDepth();
        int n2;
        while ((n2 = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n) {
            if (n2 == 1) {
                return;
            }
            if (n2 != 2 || this.onCreateCustomFromTag(xmlPullParser, t, attributeSet)) continue;
            String string2 = xmlPullParser.getName();
            T t2 = this.createItemFromTag(xmlPullParser, string2, attributeSet);
            ((Parent)t).addItemFromInflater(t2);
            this.rInflate(xmlPullParser, t2, attributeSet);
        }
        return;
    }

    public abstract GenericInflater cloneInContext(Context var1);

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final T createItem(String var1_1, String var2_2, AttributeSet var3_3) throws ClassNotFoundException, InflateException {
        var4_4 = (Constructor<?>)GenericInflater.sConstructorMap.get(var1_1);
        if (var4_4 != null) ** GOTO lbl10
        try {
            var5_5 = this.mContext.getClassLoader();
            var6_6 = var2_2 != null ? var2_2 + var1_1 : var1_1;
            var7_7 = var5_5.loadClass(var6_6);
            var8_8 = GenericInflater.mConstructorSignature;
            var4_4 = var7_7.getConstructor(var8_8);
            var9_9 = GenericInflater.sConstructorMap.put(var1_1, var4_4);
lbl10:
            // 2 sources

            var10_10 = this.mConstructorArgs;
            var10_10[1] = var3_3;
            var11_11 = var4_4.newInstance(var10_10);
            return var11_11;
        }
        catch (NoSuchMethodException var12_12) {
            var14_14 = new StringBuilder();
            var15_15 = var3_3.getPositionDescription();
            var16_16 = var14_14.append(var15_15).append(": Error inflating class ");
            var17_17 = var2_2 != null ? var2_2 + var1_1 : var1_1;
            var18_18 = var16_16.append(var17_17).toString();
            var13_13 = new InflateException(var18_18);
            var19_19 = var13_13.initCause(var12_12);
            throw var13_13;
        }
        catch (ClassNotFoundException v0) {
            throw v0;
        }
        catch (Exception var20_20) {
            var21_21 = new StringBuilder();
            var22_22 = var3_3.getPositionDescription();
            var23_23 = var21_21.append(var22_22).append(": Error inflating class ");
            var24_24 = var4_4.getClass().getName();
            var25_25 = var23_23.append(var24_24).toString();
            var26_26 = new InflateException(var25_25);
            var27_27 = var26_26.initCause(var20_20);
            throw var26_26;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getDefaultPackage() {
        return this.mDefaultPackage;
    }

    public final Factory<T> getFactory() {
        return this.mFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T inflate(int n, P p) {
        boolean bl;
        if (p != null) {
            bl = true;
            return this.inflate(n, p, bl);
        }
        bl = false;
        return this.inflate(n, p, bl);
    }

    public T inflate(int n, P p, boolean bl) {
        T t;
        XmlResourceParser xmlResourceParser = this.getContext().getResources().getXml(n);
        try {
            T t2;
            t = t2 = this.inflate(xmlResourceParser, p, bl);
            xmlResourceParser.close();
        }
        catch (Throwable throwable) {
            xmlResourceParser.close();
            throw throwable;
        }
        return t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T inflate(XmlPullParser xmlPullParser, P p) {
        boolean bl;
        if (p != null) {
            bl = true;
            return this.inflate(xmlPullParser, p, bl);
        }
        bl = false;
        return this.inflate(xmlPullParser, p, bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T inflate(XmlPullParser xmlPullParser, P p, boolean bl) {
        Object[] objectArray = this.mConstructorArgs;
        synchronized (objectArray) {
            Parent parent;
            AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
            Object[] objectArray2 = this.mConstructorArgs;
            Context context = this.mContext;
            objectArray2[0] = context;
            P p2 = p;
            try {
                int n;
                while ((n = xmlPullParser.next()) != 2 && n != 1) {
                }
                if (n != 2) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = xmlPullParser.getPositionDescription();
                    String string3 = stringBuilder.append(string2).append(": No start tag found!").toString();
                    throw new InflateException(string3);
                }
            }
            catch (InflateException inflateException) {
                throw inflateException;
            }
            catch (XmlPullParserException xmlPullParserException) {
                String string4 = xmlPullParserException.getMessage();
                InflateException inflateException = new InflateException(string4);
                Throwable throwable = inflateException.initCause(xmlPullParserException);
                throw inflateException;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = xmlPullParser.getPositionDescription();
                StringBuilder stringBuilder2 = stringBuilder.append(string5).append(": ");
                String string6 = iOException.getMessage();
                String string7 = stringBuilder2.append(string6).toString();
                InflateException inflateException = new InflateException(string7);
                Throwable throwable = inflateException.initCause(iOException);
                throw inflateException;
            }
            {
                String string8 = xmlPullParser.getName();
                Parent parent2 = (Parent)this.createItemFromTag(xmlPullParser, string8, attributeSet);
                parent = this.onMergeRoots(p, bl, parent2);
                this.rInflate(xmlPullParser, parent, attributeSet);
            }
            return (T)parent;
        }
    }

    protected boolean onCreateCustomFromTag(XmlPullParser xmlPullParser, T t, AttributeSet attributeSet) throws XmlPullParserException {
        return false;
    }

    protected T onCreateItem(String string2, AttributeSet attributeSet) throws ClassNotFoundException {
        String string3 = this.mDefaultPackage;
        return this.createItem(string2, string3, attributeSet);
    }

    protected P onMergeRoots(P p, boolean bl, P p2) {
        return p2;
    }

    public void setDefaultPackage(String string2) {
        this.mDefaultPackage = string2;
    }

    public void setFactory(Factory<T> factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this inflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        if (this.mFactory == null) {
            this.mFactory = factory;
            return;
        }
        Factory<T> factory2 = this.mFactory;
        FactoryMerger<T> factoryMerger = new FactoryMerger<T>(factory, factory2);
        this.mFactory = factoryMerger;
    }

    private static class FactoryMerger<T>
    implements Factory<T> {
        private final Factory<T> mF1;
        private final Factory<T> mF2;

        FactoryMerger(Factory<T> factory, Factory<T> factory2) {
            this.mF1 = factory;
            this.mF2 = factory2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public T onCreateItem(String string2, Context context, AttributeSet attributeSet) {
            T t;
            T t2 = this.mF1.onCreateItem(string2, context, attributeSet);
            if (t2 != null) {
                t = t2;
                return t;
            }
            t = this.mF2.onCreateItem(string2, context, attributeSet);
            return t;
        }
    }

    public static interface Factory<T> {
        public T onCreateItem(String var1, Context var2, AttributeSet var3);
    }

    public static interface Parent<T> {
        public void addItemFromInflater(T var1);
    }
}

