/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.util.AttributeSet;
import com.android.internal.R;

public class ListPreference
extends DialogPreference {
    private int mClickedDialogEntryIndex;
    private CharSequence[] mEntries;
    private CharSequence[] mEntryValues;
    private String mValue;

    public ListPreference(Context context) {
        this(context, null);
    }

    public ListPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int[] nArray = R.styleable.ListPreference;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, 0, 0);
        CharSequence[] charSequenceArray = typedArray.getTextArray(0);
        this.mEntries = charSequenceArray;
        CharSequence[] charSequenceArray2 = typedArray.getTextArray(1);
        this.mEntryValues = charSequenceArray2;
        typedArray.recycle();
    }

    static /* synthetic */ int access$002(ListPreference listPreference, int n) {
        listPreference.mClickedDialogEntryIndex = n;
        return n;
    }

    private int getValueIndex() {
        String string2 = this.mValue;
        return this.findIndexOfValue(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int findIndexOfValue(String string2) {
        if (string2 == null) return -1;
        if (this.mEntryValues == null) return -1;
        int n = this.mEntryValues.length - 1;
        while (n >= 0) {
            if (this.mEntryValues[n].equals(string2)) {
                return n;
            }
            n += -1;
        }
        return -1;
    }

    public CharSequence[] getEntries() {
        return this.mEntries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getEntry() {
        int n = this.getValueIndex();
        if (n < 0) return null;
        if (this.mEntries == null) return null;
        return this.mEntries[n];
    }

    public CharSequence[] getEntryValues() {
        return this.mEntryValues;
    }

    public String getValue() {
        return this.mValue;
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl) {
            return;
        }
        if (this.mClickedDialogEntryIndex < 0) {
            return;
        }
        if (this.mEntryValues == null) {
            return;
        }
        CharSequence[] charSequenceArray = this.mEntryValues;
        int n = this.mClickedDialogEntryIndex;
        String string2 = ((Object)charSequenceArray[n]).toString();
        if (!this.callChangeListener(string2)) {
            return;
        }
        this.setValue(string2);
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getString(n);
    }

    @Override
    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        int n;
        super.onPrepareDialogBuilder(builder);
        if (this.mEntries == null || this.mEntryValues == null) {
            throw new IllegalStateException("ListPreference requires an entries array and an entryValues array.");
        }
        this.mClickedDialogEntryIndex = n = this.getValueIndex();
        CharSequence[] charSequenceArray = this.mEntries;
        int n2 = this.mClickedDialogEntryIndex;
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                int n2 = ListPreference.access$002(ListPreference.this, n);
                ListPreference.this.onClick(dialogInterface, -1);
                dialogInterface.dismiss();
            }
        };
        AlertDialog.Builder builder2 = builder.setSingleChoiceItems(charSequenceArray, n2, onClickListener);
        AlertDialog.Builder builder3 = builder.setPositiveButton(null, null);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        String string2 = savedState.value;
        this.setValue(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Parcelable onSaveInstanceState() {
        String string2;
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.value = string2 = this.getValue();
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        String string2;
        if (bl) {
            String string3 = this.mValue;
            string2 = this.getPersistedString(string3);
        } else {
            string2 = (String)object;
        }
        this.setValue(string2);
    }

    public void setEntries(int n) {
        CharSequence[] charSequenceArray = this.getContext().getResources().getTextArray(n);
        this.setEntries(charSequenceArray);
    }

    public void setEntries(CharSequence[] charSequenceArray) {
        this.mEntries = charSequenceArray;
    }

    public void setEntryValues(int n) {
        CharSequence[] charSequenceArray = this.getContext().getResources().getTextArray(n);
        this.setEntryValues(charSequenceArray);
    }

    public void setEntryValues(CharSequence[] charSequenceArray) {
        this.mEntryValues = charSequenceArray;
    }

    public void setValue(String string2) {
        this.mValue = string2;
        boolean bl = this.persistString(string2);
    }

    public void setValueIndex(int n) {
        if (this.mEntryValues == null) {
            return;
        }
        String string2 = ((Object)this.mEntryValues[n]).toString();
        this.setValue(string2);
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        String value;

        public SavedState(Parcel parcel) {
            super(parcel);
            String string2;
            this.value = string2 = parcel.readString();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            String string2 = this.value;
            parcel.writeString(string2);
        }
    }
}

