/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.widget.ListView;

public abstract class PreferenceActivity
extends ListActivity
implements PreferenceManager.OnPreferenceTreeClickListener {
    private static final int FIRST_REQUEST_CODE = 100;
    private static final int MSG_BIND_PREFERENCES = 0;
    private static final String PREFERENCES_TAG = "android:preferences";
    private Handler mHandler;
    private PreferenceManager mPreferenceManager;
    private Bundle mSavedInstanceState;

    public PreferenceActivity() {
        Handler handler;
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 0: 
                }
                PreferenceActivity.this.bindPreferences();
            }
        };
    }

    private void bindPreferences() {
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen == null) {
            return;
        }
        ListView listView = this.getListView();
        preferenceScreen.bind(listView);
        if (this.mSavedInstanceState == null) {
            return;
        }
        Bundle bundle = this.mSavedInstanceState;
        super.onRestoreInstanceState(bundle);
        this.mSavedInstanceState = null;
    }

    private PreferenceManager onCreatePreferenceManager() {
        PreferenceManager preferenceManager = new PreferenceManager(this, 100);
        preferenceManager.setOnPreferenceTreeClickListener(this);
        return preferenceManager;
    }

    private void postBindPreferences() {
        if (this.mHandler.hasMessages(0)) {
            return;
        }
        this.mHandler.obtainMessage(0).sendToTarget();
    }

    private void requirePreferenceManager() {
        if (this.mPreferenceManager != null) {
            return;
        }
        throw new RuntimeException("This should be called after super.onCreate.");
    }

    public void addPreferencesFromIntent(Intent intent) {
        this.requirePreferenceManager();
        PreferenceManager preferenceManager = this.mPreferenceManager;
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        PreferenceScreen preferenceScreen2 = preferenceManager.inflateFromIntent(intent, preferenceScreen);
        this.setPreferenceScreen(preferenceScreen2);
    }

    public void addPreferencesFromResource(int n) {
        this.requirePreferenceManager();
        PreferenceManager preferenceManager = this.mPreferenceManager;
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        PreferenceScreen preferenceScreen2 = preferenceManager.inflateFromResource(this, n, preferenceScreen);
        this.setPreferenceScreen(preferenceScreen2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Preference findPreference(CharSequence charSequence) {
        if (this.mPreferenceManager != null) return this.mPreferenceManager.findPreference(charSequence);
        return null;
    }

    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    public PreferenceScreen getPreferenceScreen() {
        return this.mPreferenceManager.getPreferenceScreen();
    }

    @Override
    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        this.mPreferenceManager.dispatchActivityResult(n, n2, intent);
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        this.postBindPreferences();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        PreferenceManager preferenceManager;
        super.onCreate(bundle);
        this.setContentView(17367116);
        this.mPreferenceManager = preferenceManager = this.onCreatePreferenceManager();
        this.getListView().setScrollBarStyle(0);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.mPreferenceManager.dispatchActivityDestroy();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        if (this.mPreferenceManager == null) {
            return;
        }
        this.mPreferenceManager.dispatchNewIntent(intent);
    }

    @Override
    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        return false;
    }

    @Override
    protected void onRestoreInstanceState(Bundle bundle) {
        PreferenceScreen preferenceScreen;
        Bundle bundle2 = bundle.getBundle(PREFERENCES_TAG);
        if (bundle2 != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            preferenceScreen.restoreHierarchyState(bundle2);
            this.mSavedInstanceState = bundle;
            return;
        }
        super.onRestoreInstanceState(bundle);
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        preferenceScreen.saveHierarchyState(bundle2);
        bundle.putBundle(PREFERENCES_TAG, bundle2);
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.mPreferenceManager.dispatchActivityStop();
    }

    public void setPreferenceScreen(PreferenceScreen preferenceScreen) {
        if (!this.mPreferenceManager.setPreferences(preferenceScreen)) {
            return;
        }
        if (preferenceScreen == null) {
            return;
        }
        this.postBindPreferences();
        CharSequence charSequence = this.getPreferenceScreen().getTitle();
        if (charSequence == null) {
            return;
        }
        this.setTitle(charSequence);
    }
}

