/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.preference.GenericInflater;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PreferenceGroup
extends Preference
implements GenericInflater.Parent<Preference> {
    private boolean mAttachedToActivity = false;
    private int mCurrentPreferenceOrder = 0;
    private boolean mOrderingAsAdded = true;
    private List<Preference> mPreferenceList;

    public PreferenceGroup(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public PreferenceGroup(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        boolean bl;
        ArrayList<Preference> arrayList = new ArrayList<Preference>();
        this.mPreferenceList = arrayList;
        int[] nArray = R.styleable.PreferenceGroup;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        boolean bl2 = this.mOrderingAsAdded;
        this.mOrderingAsAdded = bl = typedArray.getBoolean(0, bl2);
        typedArray.recycle();
    }

    private boolean removePreferenceInt(Preference preference) {
        synchronized (this) {
            preference.onPrepareForRemoval();
            boolean bl = this.mPreferenceList.remove(preference);
            return bl;
        }
    }

    @Override
    public void addItemFromInflater(Preference preference) {
        boolean bl = this.addPreference(preference);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addPreference(Preference preference) {
        int n;
        if (this.mPreferenceList.contains(preference)) {
            return true;
        }
        if (preference.getOrder() == Integer.MAX_VALUE) {
            if (this.mOrderingAsAdded) {
                int n2;
                int n3 = this.mCurrentPreferenceOrder;
                this.mCurrentPreferenceOrder = n2 = n3 + 1;
                preference.setOrder(n3);
            }
            if (preference instanceof PreferenceGroup) {
                PreferenceGroup preferenceGroup = (PreferenceGroup)preference;
                boolean bl = this.mOrderingAsAdded;
                preferenceGroup.setOrderingAsAdded(bl);
            }
        }
        if ((n = Collections.binarySearch(this.mPreferenceList, preference)) < 0) {
            n = n * -1 - 1;
        }
        if (!this.onPrepareAddPreference(preference)) {
            return false;
        }
        synchronized (this) {
            this.mPreferenceList.add(n, preference);
        }
        PreferenceManager preferenceManager = this.getPreferenceManager();
        preference.onAttachedToHierarchy(preferenceManager);
        if (this.mAttachedToActivity) {
            preference.onAttachedToActivity();
        }
        this.notifyHierarchyChanged();
        return true;
    }

    @Override
    protected void dispatchRestoreInstanceState(Bundle bundle) {
        super.dispatchRestoreInstanceState(bundle);
        int n = this.getPreferenceCount();
        int n2 = 0;
        while (n2 < n) {
            this.getPreference(n2).dispatchRestoreInstanceState(bundle);
            ++n2;
        }
        return;
    }

    @Override
    protected void dispatchSaveInstanceState(Bundle bundle) {
        super.dispatchSaveInstanceState(bundle);
        int n = this.getPreferenceCount();
        int n2 = 0;
        while (n2 < n) {
            this.getPreference(n2).dispatchSaveInstanceState(bundle);
            ++n2;
        }
        return;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Preference findPreference(CharSequence charSequence) {
        void var2_3;
        if (TextUtils.equals(this.getKey(), charSequence)) {
            PreferenceGroup preferenceGroup = this;
            return var2_3;
        }
        int n = this.getPreferenceCount();
        for (int i = 0; i < n; ++i) {
            Preference preference;
            Preference preference2 = this.getPreference(i);
            String string2 = preference2.getKey();
            if (string2 != null && string2.equals(charSequence)) {
                Preference preference3 = preference2;
                return var2_3;
            }
            if (!(preference2 instanceof PreferenceGroup) || (preference = ((PreferenceGroup)preference2).findPreference(charSequence)) == null) continue;
            Preference preference4 = preference;
            return var2_3;
        }
        return var2_3;
    }

    public Preference getPreference(int n) {
        return this.mPreferenceList.get(n);
    }

    public int getPreferenceCount() {
        return this.mPreferenceList.size();
    }

    protected boolean isOnSameScreenAsChildren() {
        return true;
    }

    public boolean isOrderingAsAdded() {
        return this.mOrderingAsAdded;
    }

    @Override
    protected void onAttachedToActivity() {
        super.onAttachedToActivity();
        this.mAttachedToActivity = true;
        int n = this.getPreferenceCount();
        int n2 = 0;
        while (n2 < n) {
            this.getPreference(n2).onAttachedToActivity();
            ++n2;
        }
        return;
    }

    protected boolean onPrepareAddPreference(Preference preference) {
        if (!super.isEnabled()) {
            preference.setEnabled(false);
        }
        return true;
    }

    @Override
    protected void onPrepareForRemoval() {
        super.onPrepareForRemoval();
        this.mAttachedToActivity = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAll() {
        synchronized (this) {
            List<Preference> list = this.mPreferenceList;
            int n = list.size() - 1;
            while (true) {
                if (n < 0) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 4] lbl6 : MonitorExitStatement: MONITOREXIT : this
                    this.notifyHierarchyChanged();
                    return;
                }
                Preference preference = list.get(0);
                boolean bl = this.removePreferenceInt(preference);
                n += -1;
            }
        }
    }

    public boolean removePreference(Preference preference) {
        boolean bl = this.removePreferenceInt(preference);
        this.notifyHierarchyChanged();
        return bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = this.getPreferenceCount();
        int n2 = 0;
        while (n2 < n) {
            this.getPreference(n2).setEnabled(bl);
            ++n2;
        }
        return;
    }

    public void setOrderingAsAdded(boolean bl) {
        this.mOrderingAsAdded = bl;
    }

    void sortPreferences() {
        synchronized (this) {
            Collections.sort(this.mPreferenceList);
            return;
        }
    }
}

