/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.os.Handler;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class PreferenceGroupAdapter
extends BaseAdapter
implements Preference.OnPreferenceChangeInternalListener {
    private static final String TAG = "PreferenceGroupAdapter";
    private Handler mHandler;
    private boolean mHasReturnedViewTypeCount;
    private volatile boolean mIsSyncing;
    private PreferenceGroup mPreferenceGroup;
    private ArrayList<PreferenceLayout> mPreferenceLayouts;
    private List<Preference> mPreferenceList;
    private Runnable mSyncRunnable;
    private PreferenceLayout mTempPreferenceLayout;

    public PreferenceGroupAdapter(PreferenceGroup preferenceGroup) {
        Runnable runnable;
        Handler handler;
        PreferenceLayout preferenceLayout;
        this.mTempPreferenceLayout = preferenceLayout = new PreferenceLayout();
        this.mHasReturnedViewTypeCount = false;
        this.mIsSyncing = false;
        this.mHandler = handler = new Handler();
        this.mSyncRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                PreferenceGroupAdapter.this.syncMyPreferences();
            }
        };
        this.mPreferenceGroup = preferenceGroup;
        this.mPreferenceGroup.setOnPreferenceChangeInternalListener(this);
        ArrayList<Preference> arrayList = new ArrayList<Preference>();
        this.mPreferenceList = arrayList;
        ArrayList arrayList2 = new ArrayList();
        this.mPreferenceLayouts = arrayList2;
        this.syncMyPreferences();
    }

    private void addPreferenceClassName(Preference preference) {
        PreferenceLayout preferenceLayout = this.createPreferenceLayout(preference, null);
        int n = Collections.binarySearch(this.mPreferenceLayouts, preferenceLayout);
        if (n >= 0) {
            return;
        }
        int n2 = n * -1 - 1;
        this.mPreferenceLayouts.add(n2, preferenceLayout);
    }

    /*
     * Enabled aggressive block sorting
     */
    private PreferenceLayout createPreferenceLayout(Preference preference, PreferenceLayout preferenceLayout) {
        PreferenceLayout preferenceLayout2 = preferenceLayout != null ? preferenceLayout : new PreferenceLayout();
        String string2 = preference.getClass().getName();
        String string3 = PreferenceLayout.access$202(preferenceLayout2, string2);
        int n = preference.getLayoutResource();
        int n2 = PreferenceLayout.access$302(preferenceLayout2, n);
        int n3 = preference.getWidgetLayoutResource();
        int n4 = PreferenceLayout.access$402(preferenceLayout2, n3);
        return preferenceLayout2;
    }

    private void flattenPreferenceGroup(List<Preference> list, PreferenceGroup preferenceGroup) {
        preferenceGroup.sortPreferences();
        int n = preferenceGroup.getPreferenceCount();
        int n2 = 0;
        while (n2 < n) {
            PreferenceGroup preferenceGroup2;
            Preference preference = preferenceGroup.getPreference(n2);
            boolean bl = list.add(preference);
            if (!this.mHasReturnedViewTypeCount && !preference.hasSpecifiedLayout()) {
                this.addPreferenceClassName(preference);
            }
            if (preference instanceof PreferenceGroup && (preferenceGroup2 = (PreferenceGroup)preference).isOnSameScreenAsChildren()) {
                this.flattenPreferenceGroup(list, preferenceGroup2);
            }
            preference.setOnPreferenceChangeInternalListener(this);
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncMyPreferences() {
        synchronized (this) {
            if (this.mIsSyncing) {
                return;
            }
            this.mIsSyncing = true;
        }
        int n = this.mPreferenceList.size();
        ArrayList<Preference> arrayList = new ArrayList<Preference>(n);
        PreferenceGroup preferenceGroup = this.mPreferenceGroup;
        this.flattenPreferenceGroup(arrayList, preferenceGroup);
        this.mPreferenceList = arrayList;
        this.notifyDataSetChanged();
        synchronized (this) {
            boolean bl;
            this.mIsSyncing = bl = false;
            this.notifyAll();
            return;
        }
    }

    @Override
    public boolean areAllItemsEnabled() {
        return false;
    }

    @Override
    public int getCount() {
        return this.mPreferenceList.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Preference getItem(int n) {
        if (n < 0) return null;
        int n2 = this.getCount();
        if (n < n2) return this.mPreferenceList.get(n);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getItemId(int n) {
        if (n < 0) return Long.MIN_VALUE;
        int n2 = this.getCount();
        if (n < n2) return this.getItem(n).getId();
        return Long.MIN_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getItemViewType(int n) {
        PreferenceLayout preferenceLayout;
        Preference preference;
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        if ((preference = this.getItem(n)).hasSpecifiedLayout()) {
            return -1;
        }
        PreferenceLayout preferenceLayout2 = this.mTempPreferenceLayout;
        this.mTempPreferenceLayout = preferenceLayout = this.createPreferenceLayout(preference, preferenceLayout2);
        ArrayList<PreferenceLayout> arrayList = this.mPreferenceLayouts;
        PreferenceLayout preferenceLayout3 = this.mTempPreferenceLayout;
        int n2 = Collections.binarySearch(arrayList, preferenceLayout3);
        if (n2 >= 0) return n2;
        return -1;
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        PreferenceLayout preferenceLayout;
        Preference preference = this.getItem(n);
        PreferenceLayout preferenceLayout2 = this.mTempPreferenceLayout;
        this.mTempPreferenceLayout = preferenceLayout = this.createPreferenceLayout(preference, preferenceLayout2);
        ArrayList<PreferenceLayout> arrayList = this.mPreferenceLayouts;
        PreferenceLayout preferenceLayout3 = this.mTempPreferenceLayout;
        if (Collections.binarySearch(arrayList, preferenceLayout3) < 0) {
            view = null;
        }
        return preference.getView(view, viewGroup);
    }

    @Override
    public int getViewTypeCount() {
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        int n = this.mPreferenceLayouts.size();
        return Math.max(1, n);
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEnabled(int n) {
        if (n < 0) return true;
        int n2 = this.getCount();
        if (n < n2) return this.getItem(n).isSelectable();
        return true;
    }

    @Override
    public void onPreferenceChange(Preference preference) {
        this.notifyDataSetChanged();
    }

    @Override
    public void onPreferenceHierarchyChange(Preference preference) {
        Handler handler = this.mHandler;
        Runnable runnable = this.mSyncRunnable;
        handler.removeCallbacks(runnable);
        Handler handler2 = this.mHandler;
        Runnable runnable2 = this.mSyncRunnable;
        boolean bl = handler2.post(runnable2);
    }

    private static class PreferenceLayout
    implements Comparable<PreferenceLayout> {
        private String name;
        private int resId;
        private int widgetResId;

        private PreferenceLayout() {
        }

        static /* synthetic */ String access$202(PreferenceLayout preferenceLayout, String string2) {
            preferenceLayout.name = string2;
            return string2;
        }

        static /* synthetic */ int access$302(PreferenceLayout preferenceLayout, int n) {
            preferenceLayout.resId = n;
            return n;
        }

        static /* synthetic */ int access$402(PreferenceLayout preferenceLayout, int n) {
            preferenceLayout.widgetResId = n;
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(PreferenceLayout preferenceLayout) {
            String string2 = this.name;
            String string3 = preferenceLayout.name;
            int n = string2.compareTo(string3);
            if (n != 0) return n;
            int n2 = this.resId;
            int n3 = preferenceLayout.resId;
            if (n2 != n3) {
                int n4 = this.widgetResId;
                int n5 = preferenceLayout.widgetResId;
                if (n4 != n5) {
                    return 0;
                }
                int n6 = this.widgetResId;
                int n7 = preferenceLayout.widgetResId;
                return n6 - n7;
            }
            int n8 = this.resId;
            int n9 = preferenceLayout.resId;
            return n8 - n9;
        }
    }
}

