/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.Intent;
import android.preference.GenericInflater;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.preference.PreferenceManager;
import android.util.AttributeSet;
import android.util.Log;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class PreferenceInflater
extends GenericInflater<Preference, PreferenceGroup> {
    private static final String INTENT_TAG_NAME = "intent";
    private static final String TAG = "PreferenceInflater";
    private PreferenceManager mPreferenceManager;

    public PreferenceInflater(Context context, PreferenceManager preferenceManager) {
        super(context);
        this.init(preferenceManager);
    }

    PreferenceInflater(GenericInflater<Preference, PreferenceGroup> genericInflater, PreferenceManager preferenceManager, Context context) {
        super(genericInflater, context);
        this.init(preferenceManager);
    }

    private void init(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        this.setDefaultPackage("android.preference.");
    }

    @Override
    public GenericInflater<Preference, PreferenceGroup> cloneInContext(Context context) {
        PreferenceManager preferenceManager = this.mPreferenceManager;
        return new PreferenceInflater(this, preferenceManager, context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean onCreateCustomFromTag(XmlPullParser xmlPullParser, Preference preference, AttributeSet attributeSet) throws XmlPullParserException {
        if (!xmlPullParser.getName().equals(INTENT_TAG_NAME)) {
            return false;
        }
        Intent intent = null;
        try {
            Intent intent2;
            intent = intent2 = Intent.parseIntent(this.getContext().getResources(), xmlPullParser, attributeSet);
        }
        catch (IOException iOException) {
            int n = Log.w(TAG, "Could not parse Intent.");
            int n2 = Log.w(TAG, iOException);
        }
        if (intent == null) return true;
        preference.setIntent(intent);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected PreferenceGroup onMergeRoots(PreferenceGroup preferenceGroup, boolean bl, PreferenceGroup preferenceGroup2) {
        if (preferenceGroup != null) return preferenceGroup;
        PreferenceManager preferenceManager = this.mPreferenceManager;
        preferenceGroup2.onAttachedToHierarchy(preferenceManager);
        return preferenceGroup2;
    }
}

